/*
 * Decompiled with CFR 0.152.
 */
package com.cavisson.jenkins;

import com.cavisson.jenkins.NetStormStopAction;
import hudson.model.ModelObject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class BuildActionStopTest
implements ModelObject {
    private static final transient Logger logger = Logger.getLogger(BuildActionStopTest.class.getName());
    private transient NetStormStopAction buildAction;
    private static Run<?, ?> currentBuild = null;
    private static int testrun = -1;
    public static String username = "";
    public static String portStr = "";

    BuildActionStopTest(NetStormStopAction buildAction, TaskListener listener) throws IOException {
        this.buildAction = buildAction;
        this.addPreviousBuildReportToExistingReport();
    }

    public BuildActionStopTest(int testRun, String userName, String portStr) {
        logger.log(Level.INFO, "NetStormStopAction: testRun = " + testRun + ", username = " + userName + ", portStr = " + portStr);
        testrun = testRun;
        username = userName;
        BuildActionStopTest.portStr = portStr;
        logger.log(Level.INFO, "NetStormStopAction: after testRun = " + testrun + ", username = " + username + ", portStr = " + BuildActionStopTest.portStr);
    }

    public String getDisplayName() {
        return "Stop";
    }

    public Run<?, ?> getBuild() {
        return this.buildAction.getBuild();
    }

    private void addPreviousBuildReportToExistingReport() {
        if (currentBuild == null) {
            currentBuild = this.getBuild();
        } else if (currentBuild != this.getBuild()) {
            currentBuild = null;
            return;
        }
        Run previousBuild = this.getBuild().getPreviousBuild();
        if (previousBuild == null) {
            return;
        }
        NetStormStopAction previousPerformanceAction = (NetStormStopAction)previousBuild.getAction(NetStormStopAction.class);
        if (previousPerformanceAction == null) {
            return;
        }
        BuildActionStopTest previousBuildActionResults = previousPerformanceAction.getBuildActionResultsDisplay();
        if (previousBuildActionResults == null) {
            return;
        }
    }

    @JavaScriptMethod
    public String stopRunningTest() {
        try {
            logger.log(Level.INFO, "stopRunningTest: after testRun = " + testrun + ", username = " + username + ", portStr = " + portStr);
            logger.log(Level.INFO, "stopRunningTest: going to wait");
            logger.log(Level.INFO, "stopRunningTest: get result = " + this.getBuild().getResult());
            Result result = this.getBuild().getResult();
            if (result != null) {
                return "Test run is not running";
            }
            while (testrun == -1) {
                Thread.sleep(5000L);
            }
            logger.log(Level.INFO, "stopRunningTest: wait is over");
            String str = "";
            URL url = new URL(portStr + "/ProductUI/productSummary/jenkinsService/stopTest?username=" + username + "&testrun=" + testrun);
            try {
                HttpURLConnection connectt = (HttpURLConnection)url.openConnection();
                connectt.setRequestMethod("GET");
                connectt.setRequestProperty("Accept", "application/json");
                if (connectt.getResponseCode() != 200) {
                    logger.log(Level.INFO, "stopRunningTest: Getting Error  = " + connectt.getResponseCode());
                }
                BufferedReader brr = new BufferedReader(new InputStreamReader(connectt.getInputStream()));
                String res = brr.readLine();
                logger.log(Level.INFO, "stopRunningTest res = " + res);
                if (res.startsWith("Unable to stop test")) {
                    str = res;
                } else if (res.equals("stopInProgress")) {
                    str = "Test is stopped successfully";
                } else if (res.equals("stopped")) {
                    str = "Test Run '" + testrun + "' is not running";
                } else if (res.equals("errorInStop")) {
                    str = "Unable to stop test";
                }
                logger.log(Level.INFO, "stopRunningTest: build status = " + connectt.getResponseCode());
                this.getBuild().setResult(Result.ABORTED);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Unknown exception in stopping test -", ex);
                return null;
            }
            testrun = -1;
            return str;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception: Unable to stop running test. Error -" + e);
            return null;
        }
    }
}

