/*
 * Decompiled with CFR 0.152.
 */
package com.cavisson.jenkins;

import com.cavisson.jenkins.LocalMessages;
import com.cavisson.jenkins.MetricData;
import com.cavisson.jenkins.MetricValues;
import com.cavisson.jenkins.NetStormBuildAction;
import com.cavisson.jenkins.NetStormReport;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.Graph;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.util.RelativeDateFormat;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class BuildActionResultsDisplay
implements ModelObject {
    private static final transient Logger logger = Logger.getLogger(BuildActionResultsDisplay.class.getName());
    private transient NetStormBuildAction buildAction;
    private static Run<?, ?> currentBuild = null;
    private NetStormReport currentReport;
    private boolean isNDE = false;

    BuildActionResultsDisplay(NetStormBuildAction buildAction, TaskListener listener, boolean isNDE) throws IOException {
        this.buildAction = buildAction;
        this.isNDE = isNDE;
        this.currentReport = this.buildAction.getNetStormReport();
        this.currentReport.setBuildAction(buildAction);
        this.addPreviousBuildReportToExistingReport();
    }

    public String getDisplayName() {
        if (this.isNDE) {
            return LocalMessages.ND_REPORT_DISPLAYNAME.toString();
        }
        return LocalMessages.REPORT_DISPLAYNAME.toString();
    }

    public Run<?, ?> getBuild() {
        return this.buildAction.getBuild();
    }

    public NetStormReport getNetStormReport() {
        return this.currentReport;
    }

    private void addPreviousBuildReportToExistingReport() {
        if (currentBuild == null) {
            currentBuild = this.getBuild();
        } else if (currentBuild != this.getBuild()) {
            currentBuild = null;
            return;
        }
        Run previousBuild = this.getBuild().getPreviousBuild();
        if (previousBuild == null) {
            return;
        }
        NetStormBuildAction previousPerformanceAction = (NetStormBuildAction)previousBuild.getAction(NetStormBuildAction.class);
        if (previousPerformanceAction == null) {
            return;
        }
        BuildActionResultsDisplay previousBuildActionResults = previousPerformanceAction.getBuildActionResultsDisplay();
        if (previousBuildActionResults == null) {
            return;
        }
        NetStormReport lastReport = previousBuildActionResults.getNetStormReport();
        this.getNetStormReport().setLastBuildReport(lastReport);
    }

    public void doSummarizerGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        String metricKey = request.getParameter("metricDataKey");
        final MetricData metricData = this.currentReport.getMetricByKey(metricKey);
        final MetricData metricDataBaseLine = this.currentReport.getMetricByKey(metricKey, "BASELINE");
        final MetricData metricDataPrevious = this.currentReport.getMetricByKey(metricKey, "PREVIOUS");
        logger.log(Level.INFO, "Test Report  = " + this.currentReport.getTestReport());
        logger.log(Level.INFO, "Base Line = " + metricDataBaseLine);
        logger.log(Level.INFO, "Previous Line = " + metricDataPrevious);
        final Date d = new Date();
        GraphImpl graph = new GraphImpl(metricKey, metricData.getFrequency()){

            @Override
            protected XYDataset createDataSet() {
                TimeSeries series1;
                long interval;
                TimeSeriesCollection dataset = new TimeSeriesCollection();
                TimeSeries series = new TimeSeries((Comparable)((Object)"Current Test"), Millisecond.class);
                long time = interval = (long)Integer.parseInt(metricData.getFrequency()) * 1000L;
                for (MetricValues value : metricData.getMetricValues()) {
                    if (BuildActionResultsDisplay.this.getTimeInMillisecondFormat(time, d) != null) {
                        series.add((RegularTimePeriod)BuildActionResultsDisplay.this.getTimeInMillisecondFormat(time, d), value.getValue());
                    }
                    time += interval;
                }
                dataset.addSeries(series);
                if (metricDataBaseLine != null) {
                    time = interval;
                    series1 = new TimeSeries((Comparable)((Object)"Base Line Test"), Millisecond.class);
                    for (MetricValues value : metricDataBaseLine.getMetricValues()) {
                        if (BuildActionResultsDisplay.this.getTimeInMillisecondFormat(time, d) != null) {
                            series1.add((RegularTimePeriod)BuildActionResultsDisplay.this.getTimeInMillisecondFormat(time, d), value.getValue());
                        }
                        time += interval;
                    }
                    dataset.addSeries(series1);
                }
                if (metricDataPrevious != null) {
                    time = interval;
                    series1 = new TimeSeries((Comparable)((Object)"Previous Test"), Millisecond.class);
                    for (MetricValues value : metricDataPrevious.getMetricValues()) {
                        if (BuildActionResultsDisplay.this.getTimeInMillisecondFormat(time, d) != null) {
                            series1.add((RegularTimePeriod)BuildActionResultsDisplay.this.getTimeInMillisecondFormat(time, d), value.getValue());
                        }
                        time += interval;
                    }
                    dataset.addSeries(series1);
                }
                return dataset;
            }
        };
        graph.doPng(request, response);
    }

    public Millisecond getTimeInMillisecondFormat(long time, Date startDate) {
        try {
            Date dateToday = startDate;
            Date newDate = new Date(dateToday.getTime() + time);
            int msec = (int)time % 1000;
            int sec = newDate.getSeconds();
            int minute = newDate.getMinutes();
            int hour = newDate.getHours();
            Millisecond elapsedMSecond = new Millisecond(msec, sec, minute, hour, newDate.getDate(), newDate.getMonth() + 1, newDate.getYear() + 1900);
            return elapsedMSecond;
        }
        catch (Exception e) {
            return null;
        }
    }

    private abstract class GraphImpl
    extends Graph {
        private final String graphTitle;
        private final String xLabel;

        protected GraphImpl(String metricKey, String frequency) {
            super(-1L, 400, 300);
            this.graphTitle = this.stripTitle(metricKey);
            this.xLabel = "Time in " + frequency + " secs";
        }

        private String stripTitle(String metricKey) {
            return metricKey;
        }

        protected abstract XYDataset createDataSet();

        protected JFreeChart createGraph() {
            XYDataset dataset = this.createDataSet();
            JFreeChart chart = ChartFactory.createTimeSeriesChart((String)this.graphTitle, (String)this.xLabel, (String)"", (XYDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
            XYPlot xyplot = chart.getXYPlot();
            DateAxis axis = (DateAxis)xyplot.getDomainAxis();
            RelativeDateFormat rdf = new RelativeDateFormat(new Date());
            rdf.setShowZeroDays(false);
            DecimalFormat numberFormat = new DecimalFormat("0");
            ((NumberFormat)numberFormat).setMinimumIntegerDigits(2);
            rdf.setSecondFormatter((NumberFormat)numberFormat);
            rdf.setHourSuffix(":");
            rdf.setMinuteSuffix(":");
            rdf.setSecondSuffix("");
            rdf.setNumberFormat((NumberFormat)numberFormat);
            axis.setDateFormatOverride((DateFormat)rdf);
            return chart;
        }
    }
}

