/*
 * Decompiled with CFR 0.152.
 */
package com.cavisson.jenkins;

import com.cavisson.jenkins.FieldValidator;
import com.cavisson.jenkins.NetstormStringParameterValue;
import hudson.Extension;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.regex.PatternSyntaxException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class NetstormTestParameterDefinition
extends ParameterDefinition {
    private static final long serialVersionUID = 1L;
    private String keyword;

    @DataBoundConstructor
    public NetstormTestParameterDefinition(String name, String keyword, String description) {
        super(name, description);
        this.keyword = keyword;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getRootUrl() {
        return Jenkins.getInstance().getRootUrl();
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        JSONObject paramModel = new JSONObject(false);
        String val = (String)jo.get("value");
        paramModel.put("value", (Object)(this.keyword + "_" + val));
        paramModel.put("name", jo.get("name"));
        NetstormStringParameterValue value = (NetstormStringParameterValue)((Object)req.bindJSON(NetstormStringParameterValue.class, paramModel));
        value.setDescription(this.getDescription());
        value.setKeyword(this.keyword);
        return value;
    }

    public ParameterValue createValue(StaplerRequest req) {
        String[] value = req.getParameterValues(this.getName());
        if (value == null || value.length < 1) {
            return this.getDefaultParameterValue();
        }
        return new NetstormStringParameterValue(this.getName(), value[0], this.keyword, this.getDescription());
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "NetStorm Test Parameter";
        }

        public FormValidation doCheckName(@QueryParameter String name) {
            return FieldValidator.validateUsername(name);
        }

        public FormValidation doValidate(@QueryParameter(value="keyword") String keyword, @QueryParameter(value="value") String value) {
            try {
                if (keyword != null && !keyword.equals("")) {
                    if (keyword.equals("NS_NUM_USERS")) {
                        try {
                            int i = Integer.parseInt(value);
                            if (i < 1) {
                                return FormValidation.error((String)"Users should be more then zero.");
                            }
                            return FormValidation.ok();
                        }
                        catch (Exception ex) {
                            return FormValidation.error((String)"Please give users as number");
                        }
                    }
                    if (keyword.equals("NS_SLA_CHANGE")) {
                        try {
                            double ex = Double.parseDouble(value);
                        }
                        catch (Exception e) {
                            return FormValidation.error((String)"SLA value should be numeric");
                        }
                    }
                    if (keyword.equals("NS_RAMP_UP_DURATION")) {
                        try {
                            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
                            try {
                                LocalTime localTime = LocalTime.parse(value, formatter);
                            }
                            catch (Exception e) {
                                return FormValidation.error((String)"Ramp up duration should be in HH:mm:ss format");
                            }
                        }
                        catch (Exception formatter) {
                            // empty catch block
                        }
                    }
                    if (keyword.equals("EMAIL_IDS_TO")) {
                        try {
                            if (value == null || value.equals("")) {
                                return FormValidation.error((String)"Email Ids list should be comma separated if having more than one Email id.");
                            }
                        }
                        catch (Exception e) {
                            return FormValidation.error((String)"Email Ids list should be comma separated if having more than one Email id.");
                        }
                    }
                    if (keyword.equals("EMAIL_IDS_CC")) {
                        try {
                            if (value == null || value.equals("")) {
                                return FormValidation.error((String)"Email Ids list should be comma separated if having more than one Email id.");
                            }
                        }
                        catch (Exception e) {
                            return FormValidation.error((String)"Email Ids list should be comma separated if having more than one Email id.");
                        }
                    }
                    if (keyword.equals("EMAIL_IDS_BCC")) {
                        try {
                            if (value == null || value.equals("")) {
                                return FormValidation.error((String)"Email Ids list should be comma separated if having more than one Email id.");
                            }
                        }
                        catch (Exception e) {
                            return FormValidation.error((String)"Email Ids list should be comma separated if having more than one Email id.");
                        }
                    }
                }
                return FormValidation.ok();
            }
            catch (PatternSyntaxException pse) {
                return FormValidation.error((String)("Invalid Keyword values expression [" + keyword + "]: " + pse.getDescription()));
            }
        }

        public ListBoxModel doFillKeywordItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("Total Users", "NS_NUM_USERS");
            model.add("Ramp up per second", "NS_RAMP_UP_SEC");
            model.add("Ramp up per minute", "NS_RAMP_UP_MIN");
            model.add("Ramp up per hour", "NS_RAMP_UP_HR");
            model.add("Duration", "NS_SESSION");
            model.add("Server/host", "NS_SERVER_HOST");
            model.add("SLA", "NS_SLA_CHANGE");
            model.add("Test Name", "NS_TNAME");
            model.add("Automate Script Path", "NS_AUTOSCRIPT");
            model.add("Ramp up duration", "NS_RAMP_UP_DURATION");
            model.add("Email Ids", "EMAIL_IDS_TO");
            model.add("Email Ids Cc", "EMAIL_IDS_CC");
            model.add("Email Ids Bcc", "EMAIL_IDS_BCC");
            return model;
        }
    }
}

