/*
 * Decompiled with CFR 0.152.
 */
package com.cavisson.jenkins;

import com.cavisson.jenkins.BaseConnection;
import com.cavisson.jenkins.FieldValidator;
import com.cavisson.jenkins.LocalMessages;
import com.cavisson.jenkins.NetStormBuilder;
import com.cavisson.jenkins.NetStormConnectionManager;
import com.cavisson.jenkins.NetStormDataCollector;
import com.cavisson.jenkins.NetStormReport;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class NetStormResultsPublisher
extends Recorder
implements SimpleBuildStep {
    private static final transient Logger logger = Logger.getLogger(NetStormResultsPublisher.class.getName());
    private static final String DEFAULT_USERNAME = "netstorm";
    private static final String DEFAULT_TEST_METRIC = "Average Transaction Response Time (Secs)";
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private String netstormUri = "";
    private String username = "";
    private Secret password;
    private String project = "";
    private String subProject = "";
    private String scenario = "";
    private JSONObject htmlTable = new JSONObject();
    private String htmlTablePath = null;
    private boolean durationReport = false;
    private String profile = "";
    private String timeout = "15";
    private final Boolean skipSSLCertCheck;
    private final Boolean skipSSLHostCheck;

    public void setUsername(String username) {
        this.username = username;
    }

    public Secret getPassword() {
        return this.password;
    }

    public void setPassword(Object password) {
        this.password = password instanceof Secret ? (Secret)password : (StringUtils.isEmpty((String)password.toString()) ? null : Secret.fromString((String)password.toString()));
    }

    public String getNetstormUri() {
        return this.netstormUri;
    }

    public void setNetstormUri(String netstormUri) {
        this.netstormUri = netstormUri;
    }

    public boolean isDurationReport() {
        return this.durationReport;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public void setDurationReport(boolean durationReport) {
        this.durationReport = durationReport;
    }

    public String getUsername() {
        return this.username;
    }

    public String getHtmlTablePath() {
        if (this.htmlTable != null && this.htmlTable.containsKey((Object)"htmlTablePath")) {
            this.htmlTablePath = (String)this.htmlTable.get("htmlTablePath");
        }
        return this.htmlTablePath;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getSubProject() {
        return this.subProject;
    }

    public void setSubProject(String subProject) {
        this.subProject = subProject;
    }

    public String getScenario() {
        return this.scenario;
    }

    public void setScenario(String scenario) {
        this.scenario = scenario;
    }

    public boolean isSkipSSLCertCheck() {
        return this.skipSSLCertCheck;
    }

    public boolean isSkipSSLHostCheck() {
        return this.skipSSLHostCheck;
    }

    @DataBoundConstructor
    public NetStormResultsPublisher(String netstormUri, String username, Object password, JSONObject htmlTable, String project, String subProject, String scenario, boolean durationReport, String profile, String timeout, boolean skipSSLCertCheck, boolean skipSSLHostCheck) {
        System.out.println(" getting constructor parmeter== " + netstormUri + ", username = " + username + ", project = " + project + ", subProject = " + subProject + ", timeout = " + timeout);
        logger.log(Level.FINE, "Cavisson-Plugin|duration check = " + durationReport + ", uri = " + netstormUri + ", profile -" + profile);
        this.setNetstormUri(netstormUri);
        this.setUsername(username);
        this.setPassword(password);
        this.setProject(project);
        this.setSubProject(subProject);
        this.setScenario(scenario);
        this.durationReport = durationReport;
        this.setDurationReport(durationReport);
        this.htmlTable = htmlTable;
        this.profile = profile;
        this.skipSSLCertCheck = skipSSLCertCheck;
        this.skipSSLHostCheck = skipSSLHostCheck;
        this.setTimeout(timeout);
    }

    NetStormResultsPublisher(String netstormUri, String username, String password, String htmlTable, JSONObject durationReport, String timeout, boolean skipSSLCertCheck, boolean skipSSLHostCheck) {
        System.out.println(" getting constructor parmeter== " + netstormUri + ", username = " + username);
        logger.log(Level.FINE, "Cavisson-Plugin|duration  repport = " + durationReport);
        this.setNetstormUri(netstormUri);
        this.setUsername(username);
        this.setPassword(password);
        this.setTimeout(timeout);
        this.skipSSLCertCheck = skipSSLCertCheck;
        this.skipSSLHostCheck = skipSSLHostCheck;
    }

    public void setArguments() {
        this.setProject(this.project);
        this.setSubProject(this.subProject);
        this.setScenario(this.scenario);
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(Run<?, ?> run, FilePath fp, Launcher lnchr, TaskListener taskListener) throws InterruptedException, IOException {
        Map env = run instanceof AbstractBuild ? ((AbstractBuild)run).getBuildVariables() : Collections.emptyMap();
        PrintStream logger = taskListener.getLogger();
        StringBuffer errMsg = new StringBuffer();
        NetStormConnectionManager connection = new NetStormConnectionManager(this.netstormUri, this.username, this.password, this.durationReport, Integer.parseInt(this.timeout), this.isSkipSSLCertCheck(), this.isSkipSSLHostCheck());
        logger.println("Verify connection to NetStorm interface ..." + this.durationReport);
        if (!connection.testNSConnection(errMsg)) {
            logger.println("Connection to netstorm unsuccessful, cannot to proceed to generate report.");
            logger.println("Error: " + errMsg);
            Result result = run.getResult();
            if (result != null && result.isBetterOrEqualTo(Result.UNSTABLE)) {
                run.setResult(Result.FAILURE);
            }
            return;
        }
        if (run.getResult() == Result.FAILURE || run.getResult() == Result.ABORTED) {
            return;
        }
        if (this.getHtmlTablePath() != null) {
            logger.println("Html Report Path set as - " + this.htmlTablePath);
        }
        if (run instanceof AbstractBuild) {
            Project buildProject = (Project)((AbstractBuild)run).getProject();
            List blist = buildProject.getBuilders();
            String testMode = "N";
            for (Builder currentBuilder : blist) {
                if (!(currentBuilder instanceof NetStormBuilder)) continue;
                testMode = ((NetStormBuilder)currentBuilder).getTestMode();
                if (testMode.equals("T")) {
                    System.out.println("((NetStormBuilder)currentBuilder).getProject() == " + ((NetStormBuilder)currentBuilder).getProject());
                    connection.setProject(((NetStormBuilder)currentBuilder).getProject());
                    connection.setSubProject(((NetStormBuilder)currentBuilder).getSubProject());
                    connection.setScenario(((NetStormBuilder)currentBuilder).getScenario());
                    connection.setProfile(((NetStormBuilder)currentBuilder).getProfile());
                    connection.setTimeout(Integer.parseInt(this.timeout));
                }
                break;
            }
        } else {
            System.out.println("project = " + this.project + ", subproject == " + this.subProject + ", scenario = " + this.scenario);
            connection.setProject(this.project);
            connection.setSubProject(this.subProject);
            connection.setScenario(this.scenario);
            connection.setProfile(this.profile);
        }
        logger.println("Connection successful, continue to fetch measurements from netstorm Controller ...");
        NetStormDataCollector dataCollector = new NetStormDataCollector(connection, run, Integer.parseInt(NetStormBuilder.getTestRunNumber()), "T", NetStormBuilder.getTestCycleNumber());
        try {
            NetStormReport report = dataCollector.createReportFromMeasurements(logger, fp);
            Result result = run.getResult();
            if (result != null && !result.equals(Result.UNSTABLE)) {
                boolean pdfUpload = this.dumpPdfInWorkspace(fp, connection);
                logger.println("Pdf Uploaded = " + pdfUpload);
                boolean bl = this.getHTMLReport(fp, connection);
            }
            run.setDisplayName(NetStormBuilder.getTestRunNumber());
            NetStormBuilder.setTestRunNumber("-1");
            if (result != null && result.equals(Result.UNSTABLE)) {
                logger.println("Error in fetching report.");
                return;
            }
            logger.println("Ready building NetStorm report");
        }
        catch (InterruptedException ie) {
            logger.println("Not able to create netstorm report.may be some configuration issue in running scenario." + ie);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            logger.println("Not able to create netstorm report.may be some configuration issue in running scenario." + e);
            return;
        }
    }

    private boolean dumpPdfInWorkspace(FilePath fp, NetStormConnectionManager connection) throws IOException, InterruptedException {
        String testRun = NetStormBuilder.getTestRunNumber();
        String dir = fp + "/TR" + testRun;
        logger.log(Level.FINE, "Cavisson-Plugin|Pdf directory" + dir);
        FilePath fz = new FilePath(fp.getChannel(), fp + "/TR" + testRun);
        fz.mkdirs();
        FilePath fk = new FilePath(fp.getChannel(), fz + "/testsuite_report_" + testRun + ".pdf");
        logger.log(Level.FINE, "Cavisson-Plugin|File path for pdf file = " + fk);
        try {
            String str = connection.getUrlString();
            URL urlForPdf = new URL(str + "/ProductUI/productSummary/jenkinsService/getPdfData");
            logger.log(Level.FINE, "Cavisson-Plugin|urlForPdf-" + urlForPdf);
            URLConnection connect = BaseConnection.getConnections(urlForPdf, this.isSkipSSLCertCheck(), this.isSkipSSLHostCheck());
            connect.setConnectTimeout(0);
            connect.setReadTimeout(0);
            ((HttpURLConnection)connect).setRequestMethod("POST");
            connect.setRequestProperty("Content-Type", "application/octet-stream");
            connect.setDoOutput(true);
            OutputStream outStream = connect.getOutputStream();
            outStream.write(testRun.getBytes());
            outStream.flush();
            if (((HttpURLConnection)connect).getResponseCode() == 200) {
                int bytesRead;
                logger.log(Level.FINE, "Cavisson-Plugin|response 200 OK");
                byte[] mybytearray = new byte[1024];
                InputStream is = connect.getInputStream();
                BufferedOutputStream bos = new BufferedOutputStream(fk.write());
                while ((bytesRead = is.read(mybytearray)) > 0) {
                    bos.write(mybytearray, 0, bytesRead);
                }
                bos.close();
                is.close();
            } else {
                logger.log(Level.FINE, "Cavisson-Plugin|ErrorCode-" + ((HttpURLConnection)connect).getResponseCode());
            }
            return true;
        }
        catch (InterruptedException ie) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception. InterruptedException -", ie);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception. IOException -", e);
            return false;
        }
        return false;
    }

    private boolean getHTMLReport(FilePath fp, NetStormConnectionManager connection) throws IOException, InterruptedException {
        String testRun = NetStormBuilder.getTestRunNumber();
        String zipFile = fp + "/TestSuiteReport.zip";
        FilePath fz = new FilePath(fp.getChannel(), zipFile);
        if (fz.exists()) {
            fz.delete();
            fz = new FilePath(fp.getChannel(), zipFile);
        }
        try {
            String str = connection.getUrlString();
            URL urlForHTMLReport = new URL(str + "/ProductUI/productSummary/jenkinsService/getHTMLReport");
            logger.log(Level.FINE, "Cavisson-Plugin|urlForPdf-" + urlForHTMLReport);
            URLConnection connect = BaseConnection.getConnections(urlForHTMLReport, this.isSkipSSLCertCheck(), this.isSkipSSLHostCheck());
            connect.setConnectTimeout(0);
            connect.setReadTimeout(0);
            ((HttpURLConnection)connect).setRequestMethod("POST");
            connect.setRequestProperty("Content-Type", "application/octet-stream");
            connect.setDoOutput(true);
            OutputStream outStream = connect.getOutputStream();
            outStream.write(testRun.getBytes());
            outStream.flush();
            if (((HttpURLConnection)connect).getResponseCode() == 200) {
                int bytesRead;
                logger.log(Level.FINE, "Cavisson-Plugin|response 200 OK");
                byte[] mybytearray = new byte[1024];
                InputStream is = connect.getInputStream();
                BufferedOutputStream bos = new BufferedOutputStream(fz.write());
                while ((bytesRead = is.read(mybytearray)) > 0) {
                    bos.write(mybytearray, 0, bytesRead);
                }
                bos.close();
                is.close();
            } else {
                logger.log(Level.FINE, "Cavisson-Plugin|ErrorCode-" + ((HttpURLConnection)connect).getResponseCode());
            }
            String destDir = fp + "/TestSuiteReport";
            FilePath dir = new FilePath(fp.getChannel(), destDir);
            if (dir.exists()) {
                dir.deleteRecursive();
            }
            dir.mkdirs();
            NetStormResultsPublisher.unzip(dir, fz);
            return true;
        }
        catch (InterruptedException ie) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception. InterruptedException -", ie);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in methid getHTMLreport. IOException -", e);
            return false;
        }
        return false;
    }

    private static void unzip(FilePath dir, FilePath zipFile) throws IOException, InterruptedException {
        try {
            InputStream in = zipFile.read();
            dir.unzipFrom(in);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Exception in unzipping file = " + e);
        }
    }

    private double calculateAverageBasedOnPreviousReports(List<NetStormReport> reports) {
        double calculatedSum = 0.0;
        int numberOfMeasurements = 0;
        for (NetStormReport report : reports) {
            double value = report.getAverageForMetric(DEFAULT_TEST_METRIC);
            if (!(value >= 0.0)) continue;
            calculatedSum += value;
            ++numberOfMeasurements;
        }
        double result = -1.0;
        if (numberOfMeasurements > 0) {
            result = calculatedSum / (double)numberOfMeasurements;
        }
        return result;
    }

    private List<NetStormReport> getListOfPreviousReports(Run build, long currentTimestamp) {
        ArrayList<NetStormReport> previousReports = new ArrayList<NetStormReport>();
        return previousReports;
    }

    public boolean isImportSelected() {
        return this.getHtmlTablePath() != null;
    }

    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return LocalMessages.PUBLISHER_DISPLAYNAME.toString();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDefaultUsername() {
            return NetStormResultsPublisher.DEFAULT_USERNAME;
        }

        public String getDefaultTestMetric() {
            return NetStormResultsPublisher.DEFAULT_TEST_METRIC;
        }

        public FormValidation doCheckNetstormUri(@QueryParameter String netstormUri) {
            return FieldValidator.validateURLConnectionString(netstormUri);
        }

        public FormValidation doCheckPassword(@QueryParameter String password) {
            return FieldValidator.validatePassword(password);
        }

        public FormValidation doCheckUsername(@QueryParameter String username) {
            return FieldValidator.validateUsername(username);
        }

        public FormValidation doCheckHtmlTablePath(@QueryParameter String htmlTablePath) {
            return FieldValidator.validateHtmlTablePath(htmlTablePath);
        }

        @POST
        public FormValidation doTestNetStormConnection(@QueryParameter(value="netstormUri") String netstormRestUri, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="skipSSLCertCheck") boolean skipSSLCertCheck, @QueryParameter(value="skipSSLHostCheck") boolean skipSSLHostCheck) {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            StringBuffer errMsg = new StringBuffer();
            if (FieldValidator.isEmptyField(netstormRestUri)) {
                FormValidation validationResult = FormValidation.error((String)"URL connection string cannot be empty and should start with http:// or https://");
                return validationResult;
            }
            if (!netstormRestUri.startsWith("http://") && !netstormRestUri.startsWith("https://")) {
                FormValidation validationResult = FormValidation.error((String)"URL connection st should start with http:// or https://");
                return validationResult;
            }
            if (FieldValidator.isEmptyField(username)) {
                FormValidation validationResult = FormValidation.error((String)"Please enter user name.");
                return validationResult;
            }
            if (FieldValidator.isEmptyField(password)) {
                FormValidation validationResult = FormValidation.error((String)"Please enter password.");
                return validationResult;
            }
            NetStormConnectionManager connection = new NetStormConnectionManager(netstormRestUri, username, Secret.fromString((String)password), false, 15, skipSSLCertCheck, skipSSLHostCheck);
            FormValidation validationResult = !connection.testNSConnection(errMsg) ? FormValidation.warning((String)("Connection to netstorm unsuccessful, due to: " + errMsg)) : FormValidation.ok((String)"Connection successful");
            return validationResult;
        }
    }
}

