/*
 * Decompiled with CFR 0.152.
 */
package com.cavisson.jenkins;

import com.cavisson.jenkins.MetricData;
import com.cavisson.jenkins.MetricValues;
import com.cavisson.jenkins.NetStormBuildAction;
import com.cavisson.jenkins.TestReport;
import hudson.model.Run;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetStormReport {
    private final Map<String, MetricData> keyedMetricDataMap = new LinkedHashMap<String, MetricData>();
    private final Map<String, MetricData> keyedMetricPreviousDataMap = new LinkedHashMap<String, MetricData>();
    private final Map<String, MetricData> keyedMetricBaseLineDataMap = new LinkedHashMap<String, MetricData>();
    private TestReport testReport;
    private TestReport testReportND;
    private final Long reportTimestamp;
    private String reportDurationInMinutes;
    private NetStormBuildAction buildAction;
    private NetStormReport lastBuildReport;
    private String customHTMLReport = "NA";
    private boolean isNDE = false;
    private boolean isIntegrated = false;
    private static final Logger logger = Logger.getLogger(NetStormReport.class.getName());

    public NetStormReport(Long timestamp, String durationInMinutes) {
        this.reportTimestamp = timestamp;
        this.reportDurationInMinutes = durationInMinutes;
    }

    public NetStormReport(Long timestamp, String durationInMinutes, boolean isNDE) {
        this.reportTimestamp = timestamp;
        this.reportDurationInMinutes = durationInMinutes;
        logger.log(Level.INFO, "Cavisson-Plugin|get name constructor duration    -" + durationInMinutes);
        this.isNDE = isNDE;
    }

    public TestReport getTestReport() {
        return this.testReport;
    }

    public void setTestReport(TestReport testReport) {
        this.testReport = testReport;
    }

    public TestReport getTestReportND() {
        return this.testReportND;
    }

    public void setTestReportND(TestReport testReport) {
        this.testReportND = testReport;
    }

    public void addMetrics(MetricData metrics) {
        this.keyedMetricDataMap.put(metrics.getMetricPath(), metrics);
    }

    public void addBaseLineMetrics(MetricData metrics) {
        this.keyedMetricBaseLineDataMap.put(metrics.getMetricPath(), metrics);
    }

    public void addPrevoiusMetrics(MetricData metrics) {
        this.keyedMetricPreviousDataMap.put(metrics.getMetricPath(), metrics);
    }

    public MetricData getMetricByKey(String metricKey, String type) {
        MetricData selectedMetric = null;
        selectedMetric = type.equals("BASELINE") ? this.keyedMetricBaseLineDataMap.get(metricKey) : this.keyedMetricPreviousDataMap.get(metricKey);
        return selectedMetric;
    }

    public MetricData getMetricByKey(String metricKey) {
        MetricData selectedMetric = this.keyedMetricDataMap.get(metricKey);
        if (selectedMetric == null) {
            throw new IllegalArgumentException("Provided Metric Key is not available, tried to select; " + metricKey);
        }
        return selectedMetric;
    }

    public List<MetricData> getMetricsListBasedOnType(String type) {
        if (type.equals("BASELINE")) {
            return new ArrayList<MetricData>(this.keyedMetricBaseLineDataMap.values());
        }
        return new ArrayList<MetricData>(this.keyedMetricPreviousDataMap.values());
    }

    public List<MetricData> getMetricsList() {
        return new ArrayList<MetricData>(this.keyedMetricDataMap.values());
    }

    public double getAverageForMetric(String metricKey) {
        try {
            MetricData selectedMetric = this.getMetricByKey(metricKey);
            double calculatedSum = 0.0;
            for (MetricValues value : selectedMetric.getMetricValues()) {
                calculatedSum += value.getValue();
            }
            int numberOfMeasurements = selectedMetric.getMetricValues().size();
            double result = -1.0;
            if (numberOfMeasurements > 0) {
                result = calculatedSum / (double)numberOfMeasurements;
            }
            return result;
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public double getMaxForMetric(String metricKey) {
        MetricData selectedMetric = this.getMetricByKey(metricKey);
        double max = -9.223372036854776E18;
        for (MetricValues value : selectedMetric.getMetricValues()) {
            max = Math.max(value.getMax(), max);
        }
        return max;
    }

    public double getMinForMetric(String metricKey) {
        MetricData selectedMetric = this.getMetricByKey(metricKey);
        double min = Double.MAX_VALUE;
        for (MetricValues value : selectedMetric.getMetricValues()) {
            min = Math.min(value.getMin(), min);
        }
        return min;
    }

    public String getName() {
        String description = this.getBuild().getDescription();
        String name = "";
        name = description != null && !"".equals(description.trim()) ? String.format("NetStorm Performance Report ( " + this.getBuild().getDescription() + " ) for time %s - with a duration of %s", new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date(this.reportTimestamp)), this.getReportDurationInMinutes()) : (!this.isNDE ? String.format("NetStorm Performance Report for time %s - with a duration of %s", new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date(this.reportTimestamp)), this.getReportDurationInMinutes()) : String.format("NetDiagnostics Performance Report for time %s - with a duration of %s", new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date(this.reportTimestamp)), this.reportDurationInMinutes));
        logger.log(Level.INFO, "Cavisson-Plugin|get name for report - " + name);
        return name;
    }

    public String getNameND() {
        String name = "";
        name = String.format("NetDiagnostics Performance Report for time %s ", this.getTestReportND().getCurrentDateTime());
        logger.log(Level.INFO, "Cavisson-Plugin|get name for report in Integrated - " + name);
        return name;
    }

    public long getTimestamp() {
        return this.reportTimestamp;
    }

    public Run<?, ?> getBuild() {
        return this.buildAction.getBuild();
    }

    NetStormBuildAction getBuildAction() {
        return this.buildAction;
    }

    void setBuildAction(NetStormBuildAction buildAction) {
        this.buildAction = buildAction;
    }

    public void setLastBuildReport(NetStormReport lastBuildReport) {
        this.lastBuildReport = lastBuildReport;
    }

    public String getCustomHTMLReport() {
        return this.customHTMLReport;
    }

    public void setCustomHTMLReport(String customHTMLReport) {
        try {
            if (!customHTMLReport.equals("NA")) {
                this.customHTMLReport = URLDecoder.decode(customHTMLReport, "UTF-8");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception. IOException -", e);
        }
    }

    public boolean isIntegrated() {
        return this.isIntegrated;
    }

    public void setIsIntegrated(boolean isIntegrated) {
        this.isIntegrated = isIntegrated;
    }

    public String getReportDurationInMinutes() {
        return this.reportDurationInMinutes;
    }

    public void setReportDurationInMinutes(String reportDurationInMinutes) {
        this.reportDurationInMinutes = reportDurationInMinutes;
    }
}

