/*
 * Decompiled with CFR 0.152.
 */
package com.cavisson.jenkins;

import com.cavisson.jenkins.LocalMessages;
import com.cavisson.jenkins.NetStormBuildAction;
import com.cavisson.jenkins.NetStormReport;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Run;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import hudson.util.RunList;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class NetStormProjectAction
implements Action {
    private static final Logger LOGGER = Logger.getLogger(NetStormProjectAction.class.getName());
    private static final long serialVersionUID = 1L;
    private static final String PLUGIN_NAME = "netstorm-dashboard";
    private final AbstractProject<?, ?> project;
    private final String mainMetricKey = "Average Transaction Response Time (Secs)";
    private final String[] allMetricKeys;

    public NetStormProjectAction(AbstractProject project, String[] allMetricKeys) {
        this.project = project;
        this.allMetricKeys = allMetricKeys;
    }

    public String getDisplayName() {
        return LocalMessages.PROJECTACTION_DISPLAYNAME.toString();
    }

    public String getUrlName() {
        return PLUGIN_NAME;
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public boolean isTrendVisibleOnProjectDashboard() {
        return this.getExistingReportsList().size() >= 1;
    }

    public List<String> getAvailableMetricKeys() {
        return Arrays.asList(this.allMetricKeys);
    }

    public void doSummarizerGraphMainMetric(StaplerRequest request, StaplerResponse response) throws IOException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        final Map<ChartUtil.NumberOnlyBuildLabel, Double> averagesFromReports = this.getAveragesFromAllReports(this.getExistingReportsList(), "Average Transaction Response Time (Secs)");
        GraphImpl graph = new GraphImpl("Average Transaction Response Time (Secs) Overall Graph"){

            @Override
            protected DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> createDataSet() {
                DataSetBuilder dataSetBuilder = new DataSetBuilder();
                for (ChartUtil.NumberOnlyBuildLabel label : averagesFromReports.keySet()) {
                    dataSetBuilder.add((Number)averagesFromReports.get(label), (Comparable)((Object)"Average Transaction Response Time (Secs)"), (Comparable)label);
                }
                return dataSetBuilder;
            }
        };
        graph.doPng(request, response);
    }

    public void doSummarizerGraphForMetric(StaplerRequest request, StaplerResponse response) throws IOException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        final String metricKey = request.getParameter("metricDataKey");
        final Map<ChartUtil.NumberOnlyBuildLabel, Double> averagesFromReports = this.getAveragesFromAllReports(this.getExistingReportsList(), metricKey);
        GraphImpl graph = new GraphImpl(metricKey + " Overall"){

            @Override
            protected DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> createDataSet() {
                DataSetBuilder dataSetBuilder = new DataSetBuilder();
                for (ChartUtil.NumberOnlyBuildLabel label : averagesFromReports.keySet()) {
                    dataSetBuilder.add((Number)averagesFromReports.get(label), (Comparable)((Object)metricKey), (Comparable)label);
                }
                return dataSetBuilder;
            }
        };
        graph.doPng(request, response);
    }

    private List<NetStormReport> getExistingReportsList() {
        ArrayList<NetStormReport> adReportList = new ArrayList<NetStormReport>();
        if (null == this.project) {
            return adReportList;
        }
        RunList builds = this.project.getBuilds();
        int endIndex = builds.size() - 1;
        if (builds.size() >= 10) {
            endIndex = 9;
        }
        for (int i = 0; i <= endIndex; ++i) {
            NetStormReport report;
            Run currentBuild = (Run)builds.get(i);
            NetStormBuildAction performanceBuildAction = (NetStormBuildAction)currentBuild.getAction(NetStormBuildAction.class);
            if (performanceBuildAction == null || (report = performanceBuildAction.getBuildActionResultsDisplay().getNetStormReport()) == null) continue;
            adReportList.add(report);
        }
        return adReportList;
    }

    private Map<ChartUtil.NumberOnlyBuildLabel, Double> getAveragesFromAllReports(List<NetStormReport> reports, String metricKey) {
        TreeMap<ChartUtil.NumberOnlyBuildLabel, Double> averages = new TreeMap<ChartUtil.NumberOnlyBuildLabel, Double>();
        for (NetStormReport report : reports) {
            double value = report.getAverageForMetric(metricKey);
            Run<?, ?> build = report.getBuild();
            if (!(value >= 0.0)) continue;
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(build);
            averages.put(label, value);
        }
        return averages;
    }

    private abstract class GraphImpl
    extends Graph {
        private final String graphTitle;

        protected GraphImpl(String metricKey) {
            super(-1L, 400, 300);
            this.graphTitle = this.stripTitle(metricKey);
        }

        private String stripTitle(String metricKey) {
            return metricKey.substring(metricKey.lastIndexOf("|") + 1);
        }

        protected abstract DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> createDataSet();

        protected JFreeChart createGraph() {
            CategoryDataset dataset = this.createDataSet().build();
            JFreeChart chart = ChartFactory.createLineChart((String)this.graphTitle, (String)"Build Number #", null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
            chart.setBackgroundPaint((Paint)Color.white);
            return chart;
        }
    }
}

