/*
 * Decompiled with CFR 0.152.
 */
package com.cavisson.jenkins;

import com.cavisson.jenkins.BaseConnection;
import com.cavisson.jenkins.BuildActionStopTest;
import com.cavisson.jenkins.BuildActionStopThread;
import com.cavisson.jenkins.MetricData;
import com.cavisson.jenkins.MetricDataContainer;
import com.cavisson.jenkins.MetricInfo;
import com.cavisson.jenkins.MetricLinkInfo;
import com.cavisson.jenkins.MetricVal;
import com.cavisson.jenkins.MetricValues;
import com.cavisson.jenkins.NetStormBuilder;
import com.cavisson.jenkins.PageDetail;
import com.cavisson.jenkins.ParameterDTO;
import com.cavisson.jenkins.ScalarVal;
import com.cavisson.jenkins.TestMetrics;
import com.cavisson.jenkins.TestReport;
import com.cavisson.jenkins.TransactionStats;
import hudson.FilePath;
import hudson.model.Result;
import hudson.model.Run;
import hudson.util.Secret;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import net.sf.json.JSONArray;
import net.sf.json.JSONSerializer;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class NetStormConnectionManager
extends BaseConnection {
    private final String URLConnectionString;
    private static final transient Logger logger = Logger.getLogger(NetStormConnectionManager.class.getName());
    private String servletName = "JenkinsServlet";
    private String username = "";
    private Secret password;
    private String project = "";
    private String subProject = "";
    private String scenario = "";
    private String testMode = "";
    private String duration;
    private String serverHost;
    private String vUsers;
    private String tName;
    private String rampUp;
    private String rampUpDuration;
    private String autoScript;
    private String htmlTablePath;
    private String baselineType;
    private String gitPull = "false";
    private long pollInterval;
    private String result;
    private String emailIdTo = "";
    private String emailIdCc = "";
    private String emailIdBcc = "";
    private String dataDir = "";
    private String err = "Authentication failure, please check whether username and password given correctly";
    private String pollURL;
    private String pollReportURL;
    private static int POLL_CONN_TIMEOUT = 60000;
    private static int POLL_REPEAT_TIME = 60000;
    private static int POLL_REPEAT_FOR_REPORT_TIME = 30000;
    private static int INITIAL_POLL_DELAY = 10000;
    private int testRun = -1;
    private String testCycleNum = "";
    private String scenarioName = "NA";
    private PrintStream consoleLogger = null;
    private net.sf.json.JSONObject resonseReportObj = null;
    private net.sf.json.JSONObject jkRule = null;
    private boolean durationPhase = false;
    private String profile = "";
    private String hiddenBox = "";
    private int timeout = -1;
    private boolean generateReport = true;
    private boolean doNotWaitforTestCompletion = false;
    List<String> testsuitelist = null;
    HashMap<String, ParameterDTO> testsuiteParameterDTO = null;
    private String job_id = "";
    private String errMsg = "";
    private boolean skipSSLCertValidation = false;
    private boolean skipSSLHostValidation = false;
    private HashMap<String, String> slaValueMap = new HashMap();

    public String getHtmlTablePath() {
        return this.htmlTablePath;
    }

    public void setHtmlTablePath(String htmlTablePath) {
        this.htmlTablePath = htmlTablePath;
    }

    public String getAutoScript() {
        return this.autoScript;
    }

    public void setAutoScript(String autoScript) {
        this.autoScript = autoScript;
    }

    public String gettName() {
        return this.tName;
    }

    public String getRampUp() {
        return this.rampUp;
    }

    public void settName(String tName) {
        this.tName = tName;
    }

    public void setRampUp(String rampUp) {
        this.rampUp = rampUp;
    }

    public String getBaselineType() {
        return this.baselineType;
    }

    public void setBaselineType(String baselineType) {
        this.baselineType = baselineType;
    }

    public void addSLAValue(String key, String value) {
        this.slaValueMap.put(key, value);
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public void setServerHost(String serverHost) {
        this.serverHost = serverHost;
    }

    public void setvUsers(String vUsers) {
        this.vUsers = vUsers;
    }

    public String getDuration() {
        return this.duration;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public String getvUsers() {
        return this.vUsers;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getSubProject() {
        return this.subProject;
    }

    public void setSubProject(String subProject) {
        this.subProject = subProject;
    }

    public String getScenario() {
        return this.scenario;
    }

    public void setScenario(String scenario) {
        this.scenario = scenario;
    }

    public net.sf.json.JSONObject getJkRule() {
        return this.jkRule;
    }

    public void setJkRule(net.sf.json.JSONObject jkRule) {
        this.jkRule = jkRule;
    }

    public long getPollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(long pollInterval) {
        this.pollInterval = pollInterval;
    }

    public String getRampUpDuration() {
        return this.rampUpDuration;
    }

    public void setRampUpDuration(String rampUpDuration) {
        this.rampUpDuration = rampUpDuration;
    }

    public String getGitPull() {
        return this.gitPull;
    }

    public void setGitPull(String gitPull) {
        this.gitPull = gitPull;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isGenerateReport() {
        return this.generateReport;
    }

    public void setGenerateReport(boolean generateReport) {
        this.generateReport = generateReport;
    }

    public String getEmailIdTo() {
        return this.emailIdTo;
    }

    public void setEmailIdTo(String emailIdTo) {
        this.emailIdTo = emailIdTo;
    }

    public String getEmailIdCc() {
        return this.emailIdCc;
    }

    public void setEmailIdCc(String emailIdCc) {
        this.emailIdCc = emailIdCc;
    }

    public String getEmailIdBcc() {
        return this.emailIdBcc;
    }

    public void setEmailIdBcc(String emailIdBcc) {
        this.emailIdBcc = emailIdBcc;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(String dataDir) {
        this.dataDir = dataDir;
    }

    public boolean isDoNotWaitforTestCompletion() {
        return this.doNotWaitforTestCompletion;
    }

    public void setDoNotWaitforTestCompletion(boolean doNotWaitforTestCompletion) {
        this.doNotWaitforTestCompletion = doNotWaitforTestCompletion;
    }

    public List<String> getTestsuitelist() {
        return this.testsuitelist;
    }

    public void setTestsuitelist(List<String> testsuitelist) {
        this.testsuitelist = testsuitelist;
    }

    public HashMap<String, ParameterDTO> getTestsuiteParameterDTO() {
        return this.testsuiteParameterDTO;
    }

    public void setTestsuiteParameterDTO(HashMap<String, ParameterDTO> testsuiteParameterDTO) {
        this.testsuiteParameterDTO = testsuiteParameterDTO;
    }

    public boolean isSkipSSLCertValidation() {
        return this.skipSSLCertValidation;
    }

    public void setSkipSSLCertValidation(boolean skipSSLCertValidation) {
        this.skipSSLCertValidation = skipSSLCertValidation;
    }

    public boolean isSkipSSLHostValidation() {
        return this.skipSSLHostValidation;
    }

    public void setSkipSSLHostValidation(boolean skipSSLHostValidation) {
        this.skipSSLHostValidation = skipSSLHostValidation;
    }

    public static void Sleep(long millisec) {
        try {
            Thread.sleep(millisec);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    public NetStormConnectionManager(String URLConnectionString, String username, Secret password, boolean durationPhase, int timeout) {
        logger.log(Level.FINE, "Cavisson-Plugin|NetstormConnectionManger constructor called with parameters with username:{0}", new Object[]{username});
        this.URLConnectionString = URLConnectionString;
        this.username = username;
        this.password = password;
        this.durationPhase = durationPhase;
        this.timeout = timeout;
    }

    public NetStormConnectionManager(String URLConnectionString, String username, Secret password, boolean durationPhase, int timeout, boolean skipSSLCertValidation, boolean skipSSLHostValidation) {
        logger.log(Level.FINE, "Cavisson-Plugin|NetstormConnectionManger constructor called with parameters with username:{0}", new Object[]{username});
        this.URLConnectionString = URLConnectionString;
        this.username = username;
        this.password = password;
        this.durationPhase = durationPhase;
        this.timeout = timeout;
        this.skipSSLCertValidation = skipSSLCertValidation;
        this.skipSSLHostValidation = skipSSLHostValidation;
    }

    public NetStormConnectionManager(String URLConnectionString, String username, Secret password, String project, String subProject, String scenario, String testMode, String baselineType, String pollInterval, String profile, String hiddenBox, boolean generateReport, boolean doNotWaitforTestCompletion, boolean skipSSLCertValidation, boolean skipSSLHostValidation, String ... gitPull) {
        logger.log(Level.FINE, "Cavisson-Plugin|NetstormConnectionManger constructor called with parameters with username:{0}, project:{2}, subProject:{3}, scenario:{4}, baselineTR:{5}", new Object[]{username, project, subProject, scenario, baselineType});
        this.URLConnectionString = URLConnectionString;
        this.username = username;
        this.project = project;
        this.subProject = subProject;
        this.scenario = scenario;
        this.testMode = testMode;
        this.baselineType = baselineType;
        this.password = password;
        this.pollInterval = Long.parseLong(pollInterval);
        this.profile = profile;
        this.hiddenBox = hiddenBox;
        this.gitPull = gitPull.length > 0 ? gitPull[0] : "false";
        this.generateReport = generateReport;
        this.doNotWaitforTestCompletion = doNotWaitforTestCompletion;
        this.skipSSLCertValidation = skipSSLCertValidation;
        this.skipSSLHostValidation = skipSSLHostValidation;
    }

    private boolean checkAndMakeConnection(String urlString, String servletPath, StringBuffer errMsg) {
        logger.log(Level.INFO, "Cavisson-Plugin|checkAndMakeConnection method called. with arguments restUrl : ", new Object[]{urlString});
        try {
            net.sf.json.JSONObject reqObj = new net.sf.json.JSONObject();
            reqObj.put("username", (Object)this.username);
            reqObj.put("password", (Object)this.password.getPlainText());
            reqObj.put("URLConnectionString", (Object)urlString);
            String str = this.getUrlString();
            URL url = new URL(str + "/ProductUI/productSummary/jenkinsService/validateUser");
            URLConnection conn = NetStormConnectionManager.getConnections(url, this.isSkipSSLCertValidation(), this.isSkipSSLHostValidation());
            ((HttpURLConnection)conn).setRequestMethod("POST");
            conn.setRequestProperty("Accept", "application/json");
            conn.setDoOutput(true);
            String json = reqObj.toString();
            OutputStream os = conn.getOutputStream();
            os.write(json.getBytes());
            os.flush();
            if (((HttpURLConnection)conn).getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + ((HttpURLConnection)conn).getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            this.setResult(br.readLine());
            return true;
        }
        catch (MalformedURLException e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in establishing connection. MalformedURLException -", e);
            return false;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in establishing connection. IOException -", e);
            errMsg.append("| SSL Handshake Failed | Error: \"" + e.getMessage() + "\". | ");
            return false;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in establishing connection.", e);
            return false;
        }
    }

    public net.sf.json.JSONObject checkGitConfiguration(String repoPath, String username, String password, String passPhrase) {
        try {
            logger.log(Level.INFO, "Cavisson-Plugin|checkGitConfiguration method called.");
            net.sf.json.JSONObject reqObj = new net.sf.json.JSONObject();
            String strr = this.getUrlString();
            URL urll = new URL(strr + "/ProductUI/productSummary/jenkinsService/getEncryptedStr?password=" + password + "&passPhrase=" + passPhrase);
            try {
                URLConnection connectt = NetStormConnectionManager.getConnections(urll, this.isSkipSSLCertValidation(), this.isSkipSSLHostValidation());
                connectt.setConnectTimeout(POLL_CONN_TIMEOUT);
                connectt.setReadTimeout(POLL_CONN_TIMEOUT);
                ((HttpURLConnection)connectt).setRequestMethod("GET");
                connectt.setRequestProperty("Accept", "application/json");
                if (((HttpURLConnection)connectt).getResponseCode() != 200) {
                    logger.log(Level.INFO, "Cavisson-Plugin|Getting Error code = " + ((HttpURLConnection)connectt).getResponseCode());
                }
                BufferedReader brr = new BufferedReader(new InputStreamReader(connectt.getInputStream()));
                String encryptRes = brr.readLine();
                net.sf.json.JSONObject encResponseObj = (net.sf.json.JSONObject)JSONSerializer.toJSON((Object)encryptRes);
                password = encResponseObj.get("password").toString();
                passPhrase = encResponseObj.get("passPhrase").toString();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in encrypting password and passphrase.", e);
            }
            reqObj.put("productType", (Object)"NS");
            reqObj.put("userName", (Object)this.username);
            reqObj.put("repoUrl", (Object)repoPath);
            reqObj.put("u", (Object)username);
            reqObj.put("p", (Object)"NA");
            reqObj.put("passType", (Object)"0");
            reqObj.put("passValue", (Object)password);
            reqObj.put("proxyIpPort", (Object)"NA");
            reqObj.put("validateSshkey", (Object)"false");
            String response = "";
            net.sf.json.JSONObject finalRes = new net.sf.json.JSONObject();
            String str = this.getUrlString();
            URL url = new URL(str + "/ProductUI/productSummary/gitRepositoryService/fetchBranch");
            URLConnection conn = NetStormConnectionManager.getConnections(url, this.isSkipSSLCertValidation(), this.isSkipSSLHostValidation());
            ((HttpURLConnection)conn).setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Accept", "application/json");
            conn.setDoOutput(true);
            String json = reqObj.toString();
            OutputStream os = conn.getOutputStream();
            os.write(json.getBytes());
            os.flush();
            if (((HttpURLConnection)conn).getResponseCode() != 200) {
                throw new RuntimeException("Failed in checkGitConfiguration : HTTP error code : " + ((HttpURLConnection)conn).getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String output = br.readLine();
            try {
                JSONObject jsonObj = (JSONObject)new JSONParser().parse(output);
                String status = (String)jsonObj.get((Object)"status");
                if (status != null && !status.isEmpty()) {
                    if (status.equals("pass")) {
                        finalRes.put("msg", (Object)"Git Configuration passed.");
                        finalRes.put("errMsg", (Object)"");
                    } else {
                        String mssg = (String)jsonObj.get((Object)"data");
                        finalRes.put("msg", (Object)mssg);
                        finalRes.put("errMsg", (Object)mssg);
                    }
                } else {
                    logger.log(Level.INFO, "Cavisson-Plugin|Git Configuration Response is null.");
                    finalRes = new net.sf.json.JSONObject();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in checking configuration.", e);
            }
            return finalRes;
        }
        catch (MalformedURLException e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in checking configuration. MalformedURLException -", e);
            return null;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in checking configuration. IOException -", e);
            return null;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in checking configuration.", e);
            return null;
        }
    }

    public String saveGitConfiguration(String repoPath, String username, String password, String passPhrase) {
        try {
            String line;
            String strr = this.getUrlString();
            URL urll = new URL(strr + "/ProductUI/productSummary/jenkinsService/getEncryptedStr?password=" + password + "&passPhrase=" + passPhrase);
            try {
                URLConnection connectt = NetStormConnectionManager.getConnections(urll, this.isSkipSSLCertValidation(), this.isSkipSSLHostValidation());
                connectt.setConnectTimeout(POLL_CONN_TIMEOUT);
                connectt.setReadTimeout(POLL_CONN_TIMEOUT);
                ((HttpURLConnection)connectt).setRequestMethod("GET");
                connectt.setRequestProperty("Accept", "application/json");
                if (((HttpURLConnection)connectt).getResponseCode() != 200) {
                    logger.log(Level.INFO, "Cavisson-Plugin|saveGitConfiguration: Getting Error code while encrypting  = " + ((HttpURLConnection)connectt).getResponseCode());
                }
                BufferedReader brr = new BufferedReader(new InputStreamReader(connectt.getInputStream()));
                String encryptRes = brr.readLine();
                net.sf.json.JSONObject encResponseObj = (net.sf.json.JSONObject)JSONSerializer.toJSON((Object)encryptRes);
                password = encResponseObj.get("password").toString();
                passPhrase = encResponseObj.get("passPhrase").toString();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cavisson-Plugin|saveGitConfiguration: Unknown exception in encrypting password and passphrase.", e);
            }
            net.sf.json.JSONObject saveParam = new net.sf.json.JSONObject();
            saveParam.put("GIT_HOST_branch", (Object)"main");
            saveParam.put("GIT_HOST_email", (Object)"NA");
            saveParam.put("GIT_HOST_fname", (Object)username);
            saveParam.put("GIT_HOST_enable", (Object)"true");
            saveParam.put("GIT_HOST_ip", (Object)"");
            saveParam.put("GIT_HOST_ssl", (Object)"true");
            saveParam.put("GIT_HOST_isSSLCertificateDisable", (Object)"false");
            saveParam.put("GIT_HOST_pass_phrase", (Object)passPhrase);
            saveParam.put("GIT_HOST_pwd", (Object)password);
            saveParam.put("GIT_HOST_url", (Object)repoPath);
            saveParam.put("GIT_HOST_uname", (Object)username);
            saveParam.put("SSH_KEY", (Object)"0");
            saveParam.put("VERSION_CONTROL", (Object)"1");
            saveParam.put("git_author", (Object)"");
            saveParam.put("git_email", (Object)"");
            saveParam.put("git_proxy", (Object)"");
            saveParam.put("git_url", (Object)repoPath);
            saveParam.put("git_user", (Object)username);
            saveParam.put("http_proxy", (Object)"");
            saveParam.put("https_proxy", (Object)"");
            saveParam.put("isSaveForFutureProfile", (Object)true);
            saveParam.put("operationMode", (Object)"0");
            saveParam.put("passphrase", (Object)passPhrase);
            saveParam.put("ssh_proxy", (Object)"");
            saveParam.put("useproxy", (Object)"false");
            saveParam.put("validateSshkey", (Object)"false");
            StringBuilder result = new StringBuilder();
            URL url = new URL(strr + "/DashboardServer/web/commons/setGitConfiguration?userName=" + this.username);
            URLConnection conn = NetStormConnectionManager.getConnections(url, this.isSkipSSLCertValidation(), this.isSkipSSLHostValidation());
            ((HttpURLConnection)conn).setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Accept", "application/json");
            conn.setDoOutput(true);
            String json = saveParam.toString();
            OutputStream os = conn.getOutputStream();
            os.write(json.getBytes());
            os.flush();
            if (((HttpURLConnection)conn).getResponseCode() != 200) {
                throw new RuntimeException("Failed in saveGitConfiguration : HTTP error code : " + ((HttpURLConnection)conn).getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = br.readLine()) != null) {
                result.append(line);
            }
            br.close();
            return result.toString();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in saveGitConfiguration method.", e);
            return null;
        }
    }

    public String getGitConfiguration() {
        try {
            logger.log(Level.INFO, "Cavisson-Plugin|getGitConfiguration: Method called.");
            String resMsg = "";
            StringBuffer errMsg = new StringBuffer();
            net.sf.json.JSONObject resObj = new net.sf.json.JSONObject();
            String str = this.getUrlString();
            URL urll = new URL(str + "/DashboardServer/web/commons/getGitConfiguration?userName=" + this.username + "&activeProfile=");
            try {
                URLConnection connectt = NetStormConnectionManager.getConnections(urll, this.isSkipSSLCertValidation(), this.isSkipSSLHostValidation());
                connectt.setConnectTimeout(POLL_CONN_TIMEOUT);
                connectt.setReadTimeout(POLL_CONN_TIMEOUT);
                ((HttpURLConnection)connectt).setRequestMethod("GET");
                if (((HttpURLConnection)connectt).getResponseCode() != 200) {
                    logger.log(Level.INFO, "Cavisson-Plugin|getGitConfiguration: Getting Error code while checking for git config  = " + ((HttpURLConnection)connectt).getResponseCode());
                }
                BufferedReader brr = new BufferedReader(new InputStreamReader(connectt.getInputStream()));
                resMsg = brr.readLine();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cavisson-Plugin|getGitConfiguration :Unknown exception in checking if git is configured -", e);
            }
            return resMsg;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|getGitConfiguration: Unknown exception in checking if git is configured -", e);
            return null;
        }
    }

    public String pullObjectsFromGit(String repoPath) {
        try {
            logger.log(Level.INFO, "Cavisson-Plugin|pullObjectsFromGit Method Called.");
            String res = "";
            String response = "";
            String str = this.getUrlString();
            try {
                String resMsg = this.getGitConfiguration();
                if (resMsg == null || resMsg.equals("") || resMsg.equals("notConfigured")) {
                    logger.log(Level.INFO, "Cavisson-Plugin|Git is not configured.");
                    response = res = "Git configuration is unavailable. Configure git repository first";
                    return res;
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in checking if git is configured -", e);
            }
            net.sf.json.JSONObject obj = new net.sf.json.JSONObject();
            obj.put("masterRepo", (Object)repoPath);
            obj.put("passType", (Object)"0");
            obj.put("passValue", (Object)"");
            obj.put("productType", (Object)"NS");
            obj.put("repoProject", (Object)"configuration");
            obj.put("userName", (Object)this.username);
            URL url = new URL(str + "/ProductUI/productSummary/gitRepositoryService/gitClone");
            URLConnection conn = NetStormConnectionManager.getConnections(url, this.isSkipSSLCertValidation(), this.isSkipSSLHostValidation());
            ((HttpURLConnection)conn).setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Accept", "application/json");
            conn.setDoOutput(true);
            String json = obj.toString();
            OutputStream os = conn.getOutputStream();
            os.write(json.getBytes());
            os.flush();
            if (((HttpURLConnection)conn).getResponseCode() != 200) {
                logger.log(Level.INFO, "Cavisson-Plugin|Getting Error code while git clonning  = " + ((HttpURLConnection)conn).getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String cloneRes = br.readLine();
            net.sf.json.JSONObject objreq = new net.sf.json.JSONObject();
            objreq.put("activeProfile", (Object)"");
            objreq.put("passType", (Object)"0");
            objreq.put("passValue", (Object)"");
            objreq.put("productType", (Object)"NS");
            objreq.put("repo", (Object)"configuration");
            objreq.put("userName", (Object)this.username);
            url = new URL(str + "/ProductUI/productSummary/gitRepositoryService/gitRefresh");
            URLConnection urlconn = NetStormConnectionManager.getConnections(url, this.isSkipSSLCertValidation(), this.isSkipSSLHostValidation());
            ((HttpURLConnection)urlconn).setRequestMethod("POST");
            urlconn.setRequestProperty("Content-Type", "application/json");
            urlconn.setRequestProperty("Accept", "application/json");
            urlconn.setDoOutput(true);
            String data = objreq.toString();
            OutputStream os1 = urlconn.getOutputStream();
            os1.write(data.getBytes());
            os1.flush();
            if (((HttpURLConnection)urlconn).getResponseCode() != 200) {
                logger.log(Level.INFO, "Cavisson-Plugin|Getting Error code while git clonning  = " + ((HttpURLConnection)urlconn).getResponseCode());
            }
            BufferedReader brreader = new BufferedReader(new InputStreamReader(urlconn.getInputStream()));
            response = brreader.readLine();
            return response;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in pullObjectsFromGit method.", e);
            return null;
        }
    }

    private void setDefaultSSLProperties(URLConnection urlConnection, StringBuffer errMsg) {
        try {
            if (urlConnection instanceof HttpsURLConnection) {
                HttpsURLConnection con = (HttpsURLConnection)urlConnection;
                con.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession sslSession) {
                        return true;
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public net.sf.json.JSONObject makeRequestObject(String type) {
        net.sf.json.JSONObject jsonRequest = new net.sf.json.JSONObject();
        if (type.equals("START_TEST")) {
            jsonRequest.put(JSONKeys.USERNAME.getValue(), (Object)this.username);
            jsonRequest.put(JSONKeys.PASSWORD.getValue(), (Object)this.password.getPlainText());
            jsonRequest.put(JSONKeys.URLCONNECTION.getValue(), (Object)this.getUrlString());
            jsonRequest.put(JSONKeys.OPERATION_TYPE.getValue(), (Object)OperationType.START_TEST.toString());
            jsonRequest.put(JSONKeys.PROJECT.getValue(), (Object)this.project);
            jsonRequest.put(JSONKeys.SUBPROJECT.getValue(), (Object)this.subProject);
            jsonRequest.put(JSONKeys.SCENARIO.getValue(), (Object)this.scenario);
            jsonRequest.put(JSONKeys.STATUS.getValue(), (Object)Boolean.FALSE);
            jsonRequest.put(JSONKeys.TESTMODE.getValue(), (Object)this.testMode);
            jsonRequest.put(JSONKeys.REPORT_STATUS.getValue(), (Object)"");
            jsonRequest.put(JSONKeys.BASELINE_TYPE.getValue(), (Object)this.baselineType);
            jsonRequest.put("workProfile", (Object)this.profile);
            jsonRequest.put("scriptHeaders", (Object)this.hiddenBox);
            jsonRequest.put("generateReport", (Object)Boolean.toString(this.generateReport));
            if (this.getDuration() != null && !this.getDuration().trim().equals("")) {
                jsonRequest.put("DURATION", (Object)this.getDuration());
            }
            if (this.getServerHost() != null && !this.getServerHost().trim().equals("")) {
                jsonRequest.put("SERVER_HOST", (Object)this.getServerHost());
            }
            if (this.getvUsers() != null && !this.getvUsers().trim().equals("")) {
                jsonRequest.put("VUSERS", (Object)this.getvUsers());
            }
            if (this.getRampUp() != null && !this.getRampUp().trim().equals("")) {
                jsonRequest.put("RAMP_UP", (Object)this.getRampUp());
            }
            if (this.getRampUpDuration() != null && !this.getRampUpDuration().trim().equals("")) {
                jsonRequest.put("RAMP_UP_DURATION", (Object)this.getRampUpDuration());
            }
            if (this.gettName() != null && !this.gettName().trim().equals("")) {
                jsonRequest.put("TNAME", (Object)this.gettName());
            }
            if (this.getAutoScript() != null && !this.getAutoScript().trim().equals("")) {
                jsonRequest.put("AUTOSCRIPT", (Object)this.getAutoScript());
            }
            if (this.getEmailIdTo() != null && !this.getEmailIdTo().trim().equals("")) {
                jsonRequest.put("EmailIdTo", (Object)this.getEmailIdTo());
            }
            if (this.getEmailIdCc() != null && !this.getEmailIdCc().trim().equals("")) {
                jsonRequest.put("EmailIdCc", (Object)this.getEmailIdCc());
            }
            if (this.getEmailIdBcc() != null && !this.getEmailIdBcc().trim().equals("")) {
                jsonRequest.put("EmailIdBcc", (Object)this.getEmailIdBcc());
            }
            if (this.getDataDir() != null && !this.getDataDir().trim().equals("")) {
                jsonRequest.put("DataDir", (Object)this.getDataDir());
            }
            if (this.slaValueMap.size() > 0) {
                JSONArray jsonArray = new JSONArray();
                Set<String> keyset = this.slaValueMap.keySet();
                for (String rule : keyset) {
                    net.sf.json.JSONObject jsonRule = new net.sf.json.JSONObject();
                    jsonRule.put(rule, (Object)this.slaValueMap.get(rule));
                    jsonArray.add((Object)jsonRule);
                }
                jsonRequest.put("SLA_CHANGES", (Object)jsonArray);
            }
        } else if (type.equals("START_MULTIPLE_TEST")) {
            String uniqueID;
            JSONArray testsuiteArray = new JSONArray();
            for (int i = 0; i < this.testsuitelist.size(); ++i) {
                net.sf.json.JSONObject obj;
                String[] prefix = this.testsuitelist.get(i).split("_");
                if (prefix.length > 1) {
                    obj = this.testsuiteParameterDTO.get(prefix[0]).testsuiteJson();
                    obj.put("scenario", (Object)this.testsuitelist.get(i));
                    obj.put("project", (Object)this.project);
                    obj.put("subproject", (Object)this.subProject);
                    obj.put("testmode", (Object)this.testMode);
                    obj.put("scriptHeaders", (Object)this.hiddenBox);
                    obj.put("baselineType", (Object)this.baselineType);
                    testsuiteArray.add((Object)obj);
                    continue;
                }
                obj = this.testsuiteParameterDTO.get(this.testsuitelist.get(i)).testsuiteJson();
                obj.put("scenario", (Object)this.testsuitelist.get(i));
                obj.put("project", (Object)this.project);
                obj.put("subproject", (Object)this.subProject);
                obj.put("testmode", (Object)this.testMode);
                obj.put("scriptHeaders", (Object)this.hiddenBox);
                obj.put("baselineType", (Object)this.baselineType);
                testsuiteArray.add((Object)obj);
            }
            jsonRequest.put(JSONKeys.USERNAME.getValue(), (Object)this.username);
            jsonRequest.put(JSONKeys.PASSWORD.getValue(), (Object)this.password.getPlainText());
            jsonRequest.put(JSONKeys.URLCONNECTION.getValue(), (Object)this.URLConnectionString);
            jsonRequest.put("scenario", (Object)testsuiteArray);
            jsonRequest.put("workProfile", (Object)this.profile);
            jsonRequest.put("generateReport", (Object)Boolean.toString(this.generateReport));
            this.job_id = uniqueID = UUID.randomUUID().toString();
            jsonRequest.put("JOB_ID", (Object)uniqueID);
        } else if (type.equals("TEST_CONNECTION")) {
            jsonRequest.put(JSONKeys.USERNAME.getValue(), (Object)this.username);
            jsonRequest.put(JSONKeys.PASSWORD.getValue(), (Object)this.password.getPlainText());
            jsonRequest.put(JSONKeys.OPERATION_TYPE.getValue(), (Object)OperationType.AUTHENTICATE_USER.toString());
            jsonRequest.put(JSONKeys.STATUS.getValue(), (Object)Boolean.FALSE);
        } else if (type.equals("GET_DATA")) {
            jsonRequest.put(JSONKeys.USERNAME.getValue(), (Object)this.username);
            jsonRequest.put(JSONKeys.PASSWORD.getValue(), (Object)this.password.getPlainText());
            jsonRequest.put(JSONKeys.OPERATION_TYPE.getValue(), (Object)OperationType.GETDATA.toString());
            jsonRequest.put(JSONKeys.STATUS.getValue(), (Object)Boolean.FALSE);
            jsonRequest.put(JSONKeys.URLCONNECTION.getValue(), (Object)this.URLConnectionString);
            if (this.getHtmlTablePath() != null && !"".equals(this.getHtmlTablePath())) {
                jsonRequest.put("REPORT_PATH", (Object)this.getHtmlTablePath());
            }
        } else if (type.equals("GET_PROJECT")) {
            jsonRequest.put(JSONKeys.USERNAME.getValue(), (Object)this.username);
            jsonRequest.put(JSONKeys.PASSWORD.getValue(), (Object)this.password.getPlainText());
            jsonRequest.put(JSONKeys.OPERATION_TYPE.getValue(), (Object)OperationType.GETPROJECT.toString());
            jsonRequest.put(JSONKeys.STATUS.getValue(), (Object)Boolean.FALSE);
            jsonRequest.put(JSONKeys.URLCONNECTION.getValue(), (Object)this.URLConnectionString);
            jsonRequest.put("workProfile", (Object)this.profile);
        } else if (type.equals("GET_SUBPROJECT")) {
            jsonRequest.put(JSONKeys.USERNAME.getValue(), (Object)this.username);
            jsonRequest.put(JSONKeys.PASSWORD.getValue(), (Object)this.password.getPlainText());
            jsonRequest.put(JSONKeys.PROJECT.getValue(), (Object)this.project);
            jsonRequest.put(JSONKeys.OPERATION_TYPE.getValue(), (Object)OperationType.GETSUBPROJECT.toString());
            jsonRequest.put(JSONKeys.STATUS.getValue(), (Object)Boolean.FALSE);
            jsonRequest.put(JSONKeys.URLCONNECTION.getValue(), (Object)this.URLConnectionString);
            jsonRequest.put("workProfile", (Object)this.profile);
        } else if (type.equals("GET_SCENARIOS")) {
            jsonRequest.put(JSONKeys.USERNAME.getValue(), (Object)this.username);
            jsonRequest.put(JSONKeys.PASSWORD.getValue(), (Object)this.password.getPlainText());
            jsonRequest.put(JSONKeys.PROJECT.getValue(), (Object)this.project);
            jsonRequest.put(JSONKeys.SUBPROJECT.getValue(), (Object)this.subProject);
            jsonRequest.put(JSONKeys.TESTMODE.getValue(), (Object)this.testMode);
            jsonRequest.put(JSONKeys.URLCONNECTION.getValue(), (Object)this.URLConnectionString);
            jsonRequest.put(JSONKeys.OPERATION_TYPE.getValue(), (Object)OperationType.GETSCENARIOS.toString());
            jsonRequest.put(JSONKeys.STATUS.getValue(), (Object)Boolean.FALSE);
            jsonRequest.put("workProfile", (Object)this.profile);
        }
        return jsonRequest;
    }

    public boolean testNSConnection(StringBuffer errMsg) {
        logger.log(Level.INFO, "Cavisson-Plugin|testNSConnection() Method called.");
        if (this.checkAndMakeConnection(this.URLConnectionString, this.servletName, errMsg)) {
            net.sf.json.JSONObject jsonResponse = (net.sf.json.JSONObject)JSONSerializer.toJSON((Object)this.getResult());
            if (jsonResponse == null) {
                logger.log(Level.INFO, "Cavisson-Plugin|Connection failure, please check whether Connection URI is specified correctly");
                errMsg.append("Connection failure, please check whether Connection URI is specified correctly");
                return false;
            }
            boolean status = (Boolean)jsonResponse.get(JSONKeys.STATUS.getValue());
            if (!jsonResponse.get(JSONKeys.ERROR_MSG.getValue()).equals("")) {
                this.err = (String)jsonResponse.get(JSONKeys.ERROR_MSG.getValue());
            }
            if (status) {
                logger.log(Level.INFO, "Cavisson-Plugin|Successfully Authenticated.");
                return true;
            }
            logger.log(Level.INFO, "Cavisson-Plugin|Authentication failure, please check whether username and password given correctly");
            errMsg.append(this.err);
        } else {
            logger.log(Level.INFO, "Cavisson-Plugin|Connection failure, please check whether Connection URI is specified correctly.");
            errMsg.append("Connection failure, please check whether Connection URI is specified correctly.");
        }
        return false;
    }

    public ArrayList<String> getProfileList(StringBuffer errMsg) {
        try {
            logger.log(Level.INFO, "Cavisson-Plugin|Going to Fetch profile list.");
            ArrayList<String> profiles = new ArrayList<String>();
            String str = this.getUrlString();
            URL url = new URL(str + "/DashboardServer/web/commons/getProfileList?userName=" + this.username);
            URLConnection conn = NetStormConnectionManager.getConnections(url, this.isSkipSSLCertValidation(), this.isSkipSSLHostValidation());
            ((HttpURLConnection)conn).setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
            conn.setRequestProperty("Content-Type", "application/json");
            if (((HttpURLConnection)conn).getResponseCode() != 200) {
                logger.log(Level.INFO, "Cavisson-Plugin|getting error in fetching profile list.");
                profiles = new ArrayList();
                return profiles;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(new GZIPInputStream(conn.getInputStream())));
            StringBuilder stb = new StringBuilder();
            String response = null;
            while ((response = br.readLine()) != null) {
                stb.append(response);
            }
            JSONArray arr = JSONArray.fromObject((Object)stb.toString());
            for (Object obj : arr) {
                String res = net.sf.json.JSONObject.fromObject(obj).get("profileName").toString();
                profiles.add(res);
            }
            return profiles;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Error getting profile list- " + e);
            return null;
        }
    }

    public ArrayList<String> getProjectList(StringBuffer errMsg, String activeProfile) {
        logger.log(Level.INFO, "Cavisson-Plugin|getProjectList method called.");
        logger.log(Level.INFO, "Cavisson-Plugin|activeProfile - " + activeProfile);
        try {
            logger.log(Level.INFO, "Cavisson-Plugin|Making connection to Netstorm with following request uri- " + this.URLConnectionString);
            logger.log(Level.INFO, "Cavisson-Plugin|Sending requets to get project list - " + this.URLConnectionString);
            net.sf.json.JSONObject jsonResponse = null;
            this.profile = activeProfile;
            net.sf.json.JSONObject jsonRequest = this.makeRequestObject("GET_PROJECT");
            try {
                String str = this.getUrlString();
                URL url = new URL(str + "/ProductUI/productSummary/jenkinsService/getProject");
                URLConnection conn = NetStormConnectionManager.getConnections(url, this.isSkipSSLCertValidation(), this.isSkipSSLHostValidation());
                ((HttpURLConnection)conn).setRequestMethod("POST");
                conn.setRequestProperty("Accept", "application/json");
                String json = jsonRequest.toString();
                conn.setDoOutput(true);
                OutputStream os = conn.getOutputStream();
                os.write(json.getBytes());
                os.flush();
                if (((HttpURLConnection)conn).getResponseCode() != 200) {
                    throw new RuntimeException("Failed : HTTP error code : " + ((HttpURLConnection)conn).getResponseCode());
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                this.setResult(br.readLine());
                jsonResponse = (net.sf.json.JSONObject)JSONSerializer.toJSON((Object)this.result);
            }
            catch (MalformedURLException e) {
                logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in establishing connection. MalformedURLException -", e);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in establishing connection. IOException -", e);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in establishing connection.", e);
            }
            if (jsonResponse != null && jsonResponse.get(JSONKeys.STATUS.getValue()) != null && jsonResponse.get(JSONKeys.GETPROJECT.getValue()) != null) {
                boolean status = (Boolean)jsonResponse.get(JSONKeys.STATUS.getValue());
                JSONArray projectJsonArray = (JSONArray)jsonResponse.get(JSONKeys.GETPROJECT.getValue());
                if (status) {
                    ArrayList<String> projectList = new ArrayList<String>();
                    for (int i = 0; i < projectJsonArray.size(); ++i) {
                        projectList.add((String)projectJsonArray.get(i));
                    }
                    return projectList;
                }
                logger.log(Level.INFO, "Cavisson-Plugin|Not able to fetch project list from - " + this.URLConnectionString);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Exception in getting project list ", ex);
        }
        return null;
    }

    public ArrayList<String> getSubProjectList(StringBuffer errMsg, String project, String activeProfile) {
        logger.log(Level.INFO, "Cavisson-Plugin|getSubProjectList method called.");
        try {
            logger.log(Level.INFO, "Cavisson-Plugin|Making connection to Netstorm with following request uri- " + this.URLConnectionString);
            this.project = project;
            this.profile = activeProfile;
            net.sf.json.JSONObject jsonResponse = null;
            net.sf.json.JSONObject jsonRequest = this.makeRequestObject("GET_SUBPROJECT");
            try {
                String str = this.getUrlString();
                URL url = new URL(str + "/ProductUI/productSummary/jenkinsService/getSubProject");
                logger.log(Level.INFO, "Cavisson-Plugin|getSubProjectList. method called. with arguments for metric  url" + url);
                URLConnection conn = NetStormConnectionManager.getConnections(url, this.isSkipSSLCertValidation(), this.isSkipSSLHostValidation());
                ((HttpURLConnection)conn).setRequestMethod("POST");
                conn.setRequestProperty("Accept", "application/json");
                String json = jsonRequest.toString();
                conn.setDoOutput(true);
                OutputStream os = conn.getOutputStream();
                os.write(json.getBytes());
                os.flush();
                if (((HttpURLConnection)conn).getResponseCode() != 200) {
                    throw new RuntimeException("Failed : HTTP error code : " + ((HttpURLConnection)conn).getResponseCode());
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                this.setResult(br.readLine());
                jsonResponse = (net.sf.json.JSONObject)JSONSerializer.toJSON((Object)this.result);
            }
            catch (MalformedURLException e) {
                logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in establishing connection. MalformedURLException -", e);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in establishing connection. IOException -", e);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in establishing connection.", e);
            }
            if (jsonResponse != null && jsonResponse.get(JSONKeys.STATUS.getValue()) != null && jsonResponse.get(JSONKeys.GETSUBPROJECT.getValue()) != null) {
                boolean status = (Boolean)jsonResponse.get(JSONKeys.STATUS.getValue());
                JSONArray subProjectJSONArray = (JSONArray)jsonResponse.get(JSONKeys.GETSUBPROJECT.getValue());
                if (status) {
                    ArrayList<String> subProjectList = new ArrayList<String>();
                    for (int i = 0; i < subProjectJSONArray.size(); ++i) {
                        subProjectList.add((String)subProjectJSONArray.get(i));
                    }
                    return subProjectList;
                }
                logger.log(Level.SEVERE, "Cavisson-Plugin|Not able to get sub project from - " + this.URLConnectionString);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Exception in getting getSubProjectList.", ex);
        }
        return null;
    }

    public ArrayList<String> getScenarioList(StringBuffer errMsg, String project, String subProject, String mode, String activeProfile) {
        logger.log(Level.INFO, "Cavisson-Plugin|getScenarioList method called.");
        try {
            logger.log(Level.INFO, "Cavisson-Plugin|Making connection to Netstorm with following request uri- " + this.URLConnectionString);
            this.project = project;
            this.subProject = subProject;
            this.testMode = mode;
            this.profile = activeProfile;
            net.sf.json.JSONObject jsonResponse = null;
            net.sf.json.JSONObject jsonRequest = this.makeRequestObject("GET_SCENARIOS");
            try {
                String str = this.getUrlString();
                URL url = new URL(str + "/ProductUI/productSummary/jenkinsService/getScenario");
                logger.log(Level.INFO, "Cavisson-Plugin|getScenarioList. method called. with arguments for metric  url = " + url);
                HttpURLConnection conn = (HttpURLConnection)NetStormConnectionManager.getConnections(url, this.isSkipSSLCertValidation(), this.isSkipSSLHostValidation());
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Accept", "application/json");
                String json = jsonRequest.toString();
                conn.setDoOutput(true);
                OutputStream os = conn.getOutputStream();
                os.write(json.getBytes());
                os.flush();
                if (conn.getResponseCode() != 200) {
                    throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                this.setResult(br.readLine());
                jsonResponse = (net.sf.json.JSONObject)JSONSerializer.toJSON((Object)this.result);
            }
            catch (MalformedURLException e) {
                logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in establishing connection. MalformedURLException -", e);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in establishing connection. IOException -", e);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in establishing connection.", e);
            }
            if (jsonResponse != null && jsonResponse.get(JSONKeys.STATUS.getValue()) != null && jsonResponse.get(JSONKeys.GETSCENARIOS.getValue()) != null) {
                boolean status = (Boolean)jsonResponse.get(JSONKeys.STATUS.getValue());
                JSONArray scenarioJSONArray = (JSONArray)jsonResponse.get(JSONKeys.GETSCENARIOS.getValue());
                if (status) {
                    ArrayList<String> scenarioList = new ArrayList<String>();
                    for (int i = 0; i < scenarioJSONArray.size(); ++i) {
                        scenarioList.add((String)scenarioJSONArray.get(i));
                    }
                    return scenarioList;
                }
                logger.log(Level.SEVERE, "Cavisson-Plugin|Not able to get scenarios from - " + this.URLConnectionString);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Exception in getting getScenario.", ex);
        }
        return null;
    }

    public HashMap startNetstormTest(StringBuffer errMsg, PrintStream consoleLogger, String repoPath, Run<?, ?> run) {
        logger.log(Level.INFO, "Cavisson-Plugin|Starting Netstorm Test on server with scenario or testsuite name: " + this.scenario);
        this.testRun = -1;
        this.consoleLogger = consoleLogger;
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
        resultMap.put("STATUS", false);
        try {
            logger.log(Level.FINE, "Cavisson-Plugin|Making connection to Netstorm with following request uri- " + this.URLConnectionString);
            consoleLogger.println("Making connection to Netstorm with following request uri- " + this.URLConnectionString);
            net.sf.json.JSONObject jsonResponse = null;
            net.sf.json.JSONObject jsonRequest = this.makeRequestObject("START_TEST");
            consoleLogger.println("Starting Test ... ");
            try {
                if (this.gitPull.equals("true")) {
                    logger.log(Level.FINE, "Cavisson-Plugin|Going to pull from GIT.");
                    consoleLogger.println("Starting Git pull ... ");
                    String res = this.pullObjectsFromGit(repoPath);
                    if (res != null && !res.isEmpty()) {
                        consoleLogger.println(res);
                    } else {
                        consoleLogger.println("GIT Pull was unsuccessful.");
                    }
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Cavisson-Plugin|Exception in pulling from Git - ", ex);
            }
            try {
                String str = this.getUrlString();
                URL url = new URL(str + "/ProductUI/productSummary/jenkinsService/startTest");
                URLConnection conn = NetStormConnectionManager.getConnections(url, this.isSkipSSLCertValidation(), this.isSkipSSLHostValidation());
                conn.setConnectTimeout(0);
                conn.setReadTimeout(0);
                ((HttpURLConnection)conn).setRequestMethod("POST");
                conn.setRequestProperty("Accept", "application/json");
                String json = jsonRequest.toString();
                conn.setDoOutput(true);
                OutputStream os = conn.getOutputStream();
                os.write(json.getBytes());
                os.flush();
                if (((HttpURLConnection)conn).getResponseCode() != 200) {
                    consoleLogger.println("Failed to Start Test with Error Code = " + ((HttpURLConnection)conn).getResponseCode());
                    logger.log(Level.INFO, "Cavisson-Plugin|Getting Error code = " + ((HttpURLConnection)conn).getResponseCode());
                    throw new RuntimeException("Failed : HTTP error code : " + ((HttpURLConnection)conn).getResponseCode());
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                this.setResult(br.readLine());
                jsonResponse = (net.sf.json.JSONObject)JSONSerializer.toJSON((Object)this.result);
                if (jsonResponse.containsKey((Object)"scenarioName")) {
                    this.scenarioName = jsonResponse.get("scenarioName").toString();
                }
                if (this.scenarioName == null || this.scenarioName.equals("NA")) {
                    consoleLogger.println("Getting Empty Response from server. Something went wrong.");
                }
                logger.log(Level.FINE, "Cavisson-Plugin|Here starting the thread for checking the running scenario of server.");
                this.pollURL = str + "/ProductUI/productSummary/jenkinsService/checkConnectionStatus";
                logger.log(Level.FINE, "Cavisson-Plugin|Testrun before polling = " + this.testRun);
                this.connectNSAndPollTestRun();
                jsonResponse.put("TESTRUN", (Object)(this.testRun + ""));
                jsonResponse.put("REPORT_STATUS", (Object)"");
                if (this.testMode.equals("T")) {
                    consoleLogger.println("Test Cycle Number - " + this.testCycleNum);
                }
                if (this.testRun == -1) {
                    logger.log(Level.INFO, "Cavisson-Plugin|Test is Failed .");
                    if (!this.scenario.equals("") && this.scenario != null && !this.scenario.equals("---Select Scenarios ---")) {
                        if (this.testMode.equals("N")) {
                            consoleLogger.println("Test is either not started or failed due to some error in the scenario.");
                        } else {
                            consoleLogger.println("Test is either not started or failed due to some error in the scenario. The test suite execution ended with status 'NetStorm Fail'.");
                        }
                    } else {
                        consoleLogger.println("Test is either not started or failed due to some reason");
                    }
                    return resultMap;
                }
                if (this.jkRule != null) {
                    this.createCheckRuleFile(str);
                }
                if (!this.doNotWaitforTestCompletion) {
                    logger.log(Level.INFO, "Cavisson-Plugin|Test is Ended. Now checking server response.");
                }
                this.parseTestResponseData(jsonResponse, resultMap, consoleLogger);
            }
            catch (MalformedURLException e) {
                logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in establishing connection. MalformedURLException -", e);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in establishing connection. IOException -", e);
                if (run != null) {
                    consoleLogger.println("Cavisson-Plugin|Unknown exception in establishing connection. IOException - " + e.getMessage());
                    run.setDescription(e.getMessage());
                    run.setResult(Result.FAILURE);
                    return resultMap;
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in establishing connection.", e);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Exception in closing connection.", ex);
            return resultMap;
        }
        return resultMap;
    }

    public HashMap startMultipleTest(StringBuffer errMsg, PrintStream consoleLogger, String repoPath) {
        logger.log(Level.INFO, "Cavisson-Plugin|Starting Test on server with scenario or testsuite name: " + this.testsuitelist.toString());
        this.consoleLogger = consoleLogger;
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
        resultMap.put("STATUS", false);
        try {
            logger.log(Level.FINE, "Cavisson-Plugin|Making connection to Netstorm with following request uri- " + this.URLConnectionString);
            consoleLogger.println("Making connection to Netstorm with following request uri- " + this.URLConnectionString);
            net.sf.json.JSONObject jsonResponse = null;
            net.sf.json.JSONObject jsonRequest = new net.sf.json.JSONObject();
            jsonRequest = this.makeRequestObject("START_MULTIPLE_TEST");
            consoleLogger.println("Job Id = " + this.job_id);
            consoleLogger.println("Starting Test ... ");
            try {
                if (this.gitPull.equals("true")) {
                    logger.log(Level.FINE, "Cavisson-Plugin|Going to pull from GIT.");
                    consoleLogger.println("Starting Git pull ... ");
                    String res = this.pullObjectsFromGit(repoPath);
                    if (res != null && !res.isEmpty()) {
                        consoleLogger.println(res);
                    } else {
                        consoleLogger.println("GIT Pull was unsuccessful.");
                    }
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Cavisson-Plugin|Exception in pulling from Git -", ex);
            }
            try {
                String str = this.getUrlString();
                URL url = new URL(str + "/ProductUI/productSummary/jenkinsService/startMultipleTest");
                URLConnection conn = NetStormConnectionManager.getConnections(url, this.isSkipSSLCertValidation(), this.isSkipSSLHostValidation());
                conn.setConnectTimeout(0);
                conn.setReadTimeout(0);
                ((HttpURLConnection)conn).setRequestMethod("POST");
                conn.setRequestProperty("Accept", "application/json");
                String json = jsonRequest.toString();
                conn.setDoOutput(true);
                OutputStream os = conn.getOutputStream();
                os.write(json.getBytes());
                os.flush();
                if (((HttpURLConnection)conn).getResponseCode() != 200) {
                    consoleLogger.println("Failed to Start Test with Error Code = " + ((HttpURLConnection)conn).getResponseCode());
                    logger.log(Level.INFO, "Cavisson-Plugin|Getting Error code = " + ((HttpURLConnection)conn).getResponseCode());
                    throw new RuntimeException("Failed : HTTP error code : " + ((HttpURLConnection)conn).getResponseCode());
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                this.setResult(br.readLine());
                jsonResponse = (net.sf.json.JSONObject)JSONSerializer.toJSON((Object)this.result);
                String portStr = this.getUrlString();
                new BuildActionStopThread(this.job_id, this.username, portStr);
                logger.log(Level.FINE, "Cavisson-Plugin|Here starting the thread for checking the running scenario of server.");
                this.pollURL = str + "/ProductUI/productSummary/jenkinsService/checkTestStatus";
                this.connectNSPollTestRun();
                jsonResponse.put("TESTRUN", (Object)(this.testRun + ""));
                jsonResponse.put("REPORT_STATUS", (Object)"");
                if (!this.errMsg.isEmpty()) {
                    jsonResponse.put("errMsg", (Object)this.errMsg);
                }
                if (this.testMode.equals("T")) {
                    consoleLogger.println("Test Cycle Number - " + this.testCycleNum);
                }
                if (this.testRun == -1) {
                    logger.log(Level.INFO, "Cavisson-Plugin|Test is Failed .");
                    if (!this.scenario.equals("") && this.scenario != null && !this.scenario.equals("---Select Scenarios ---")) {
                        if (this.testMode.equals("N")) {
                            consoleLogger.println("Test is either not started or failed due to some error in the scenario.");
                        } else {
                            consoleLogger.println("Test is either not started or failed due to some error in the scenario. The test suite execution ended with status 'NetStorm Fail'.");
                        }
                    } else {
                        consoleLogger.println("Test is either not started or failed due to some reason");
                    }
                    return resultMap;
                }
                if (this.jkRule != null) {
                    this.createCheckRuleFile(str);
                }
                if (!this.doNotWaitforTestCompletion) {
                    logger.log(Level.INFO, "Cavisson-Plugin|Test is Ended. Now checking server response.");
                }
                this.parseTestResponseData(jsonResponse, resultMap, consoleLogger);
            }
            catch (MalformedURLException e) {
                logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in establishing connection. MalformedURLException -", e);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in establishing connection. IOException -", e);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in establishing connection.", e);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Exception in closing connection.", ex);
            return resultMap;
        }
        return resultMap;
    }

    public void checkTestSuiteStatus(final PrintStream consoleLoger, final FilePath fp, final Run build) {
        try {
            logger.log(Level.INFO, "Cavisson-Plugin|Checking Testsuite execution is completed or not.");
            this.consoleLogger.println("Checking for testsuite execution status.");
            String str = this.getUrlString();
            final String url = str + "/ProductUI/productSummary/jenkinsService/checkTestSuiteStatus";
            Runnable pollTestRunState = new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean isTestSuiteRunning = true;
                        try {
                            NetStormConnectionManager.Sleep(30000L);
                        }
                        catch (Exception ex) {
                            logger.log(Level.SEVERE, "Error in initial sleep before polling.", ex);
                            build.setResult(Result.UNSTABLE);
                        }
                        logger.log(Level.FINE, "Cavisson-Plugin|Starting Polling to server.");
                        while (isTestSuiteRunning) {
                            try {
                                String pollURLWithArgs = url + "?testCycleNumber=" + NetStormConnectionManager.this.testCycleNum + "&testRun=" + NetStormConnectionManager.this.testRun;
                                URL url2 = new URL(pollURLWithArgs);
                                URLConnection conn = BaseConnection.getConnections(url2, NetStormConnectionManager.this.isSkipSSLCertValidation(), NetStormConnectionManager.this.isSkipSSLHostValidation());
                                conn.setConnectTimeout(POLL_CONN_TIMEOUT);
                                conn.setReadTimeout(POLL_CONN_TIMEOUT);
                                ((HttpURLConnection)conn).setRequestMethod("GET");
                                conn.setRequestProperty("Accept", "application/json");
                                if (((HttpURLConnection)conn).getResponseCode() != 200) {
                                    logger.log(Level.INFO, "Getting Error code on polling  = " + ((HttpURLConnection)conn).getResponseCode() + ". Retrying in next poll in 5 minutes.");
                                }
                                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                                String pollResString = br.readLine();
                                try {
                                    net.sf.json.JSONObject pollResponse = (net.sf.json.JSONObject)JSONSerializer.toJSON((Object)pollResString);
                                    String mssg = "";
                                    if (pollResponse.getString("mssg") != null && !pollResponse.getString("mssg").equals("")) {
                                        mssg = pollResponse.getString("mssg");
                                        consoleLoger.println(pollResponse.getString("mssg"));
                                    }
                                    if (pollResponse.getBoolean("status")) {
                                        isTestSuiteRunning = false;
                                    }
                                    if (mssg.startsWith("TestSuite is Executed Successfully.")) {
                                        boolean htmlReport;
                                        logger.log(Level.INFO, "Cavisson-Plugin|Testsuite is executed successfully. Now downloading report from server.");
                                        if (pollResponse.has("Report Status")) {
                                            String status = pollResponse.getString("Report Status");
                                            consoleLoger.println("Report Status = " + status);
                                            if (status.trim().equals("PASS")) {
                                                build.setResult(Result.SUCCESS);
                                            } else if (status.trim().equals("FAIL")) {
                                                build.setResult(Result.FAILURE);
                                            }
                                        }
                                        if (!(htmlReport = NetStormConnectionManager.this.getHTMLReport(fp))) {
                                            consoleLoger.println("Error in fetching report from server.");
                                        } else {
                                            consoleLoger.println("Successfully fetch the HTML report from server. Now fetching Pdf file.");
                                            boolean isPdfUploaded = NetStormConnectionManager.this.dumpPdfInWorkspace(fp);
                                            if (isPdfUploaded) {
                                                consoleLoger.println("Pdf File is Uploaded succesfully.");
                                            } else {
                                                consoleLoger.println("Error in Uploading Pdf File.");
                                            }
                                        }
                                    } else if (mssg.startsWith("TestSuite is Executed Completely.")) {
                                        build.setResult(Result.UNSTABLE);
                                    }
                                }
                                catch (Exception e) {
                                    logger.log(Level.SEVERE, "Cavisson-Plugin|Error in parsing polling response = " + pollResString, e);
                                    build.setResult(Result.UNSTABLE);
                                }
                                try {
                                    br.close();
                                }
                                catch (Exception e) {
                                    logger.log(Level.SEVERE, "Cavisson-Plugin|Error in closing stream inside polling thread.", e);
                                    build.setResult(Result.UNSTABLE);
                                }
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, "Cavisson-Plugin|Error in polling running testcycleNumber with interval. Retrying after 5 sec.", e);
                                build.setResult(Result.UNSTABLE);
                            }
                            try {
                                if (!isTestSuiteRunning) continue;
                                NetStormConnectionManager.Sleep(30000L);
                            }
                            catch (Exception ex) {
                                logger.log(Level.SEVERE, "Cavisson-Plugin|Error in polling connection in loop", ex);
                                build.setResult(Result.UNSTABLE);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Cavisson-Plugin|Error in polling running testRun with interval.", e);
                        build.setResult(Result.UNSTABLE);
                    }
                }
            };
            Thread pollTestRunThread = new Thread(pollTestRunState, "pollTestRunThread");
            ExecutorService threadExecutorService = Executors.newFixedThreadPool(1);
            threadExecutorService.execute(pollTestRunThread);
            threadExecutorService.shutdown();
            while (!threadExecutorService.isTerminated()) {
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in establishing connection.", e);
        }
    }

    private boolean dumpPdfInWorkspace(FilePath fp) {
        try {
            BufferedOutputStream bos;
            InputStream is;
            String testRun = NetStormBuilder.getTestRunNumber();
            String dir = fp + "/TR" + testRun;
            FilePath fz = new FilePath(fp.getChannel(), fp + "/TR" + testRun);
            fz.mkdirs();
            FilePath fk = new FilePath(fp.getChannel(), fz + "/testsuite_report_" + testRun + ".pdf");
            logger.log(Level.INFO, "Cavisson-Plugin|Downloading Pdf File from server on path = " + fk);
            String str = this.getUrlString();
            URL urlForPdf = new URL(str + "/ProductUI/productSummary/jenkinsService/getPdfData");
            URLConnection connect = NetStormConnectionManager.getConnections(urlForPdf, this.isSkipSSLCertValidation(), this.isSkipSSLHostValidation());
            connect.setConnectTimeout(0);
            connect.setReadTimeout(0);
            ((HttpURLConnection)connect).setRequestMethod("POST");
            connect.setRequestProperty("Content-Type", "application/octet-stream");
            connect.setDoOutput(true);
            OutputStream outStream = connect.getOutputStream();
            outStream.write(testRun.getBytes());
            outStream.flush();
            if (((HttpURLConnection)connect).getResponseCode() == 200) {
                int bytesRead;
                byte[] mybytearray = new byte[1024];
                is = connect.getInputStream();
                bos = new BufferedOutputStream(fk.write());
                while ((bytesRead = is.read(mybytearray)) > 0) {
                    bos.write(mybytearray, 0, bytesRead);
                }
            } else {
                logger.log(Level.INFO, "Cavisson-Plugin|ErrorCode while fetching pdf file from server - " + ((HttpURLConnection)connect).getResponseCode());
                return false;
            }
            bos.close();
            is.close();
            logger.log(Level.INFO, "Cavisson-Plugin|Successfully downloaded Pdf file.");
        }
        catch (InterruptedException ie) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception. IOException -", ie);
            Thread.currentThread().interrupt();
            return false;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception. IOException -", e);
            return false;
        }
        return true;
    }

    private boolean getHTMLReport(FilePath fp) {
        try {
            BufferedOutputStream bos;
            InputStream is;
            String testRun = NetStormBuilder.getTestRunNumber();
            String zipFile = fp + "/TestSuiteReport.zip";
            FilePath fz = new FilePath(fp.getChannel(), zipFile);
            logger.log(Level.INFO, "Cavisson-Plugin|Downloading Html Report from server on path =" + zipFile);
            if (fz.exists()) {
                fz.delete();
                fz = new FilePath(fp.getChannel(), zipFile);
            }
            net.sf.json.JSONObject jsonRequest = new net.sf.json.JSONObject();
            jsonRequest.put("testRun", (Object)testRun);
            jsonRequest.put("isNDE", (Object)false);
            String str = this.getUrlString();
            URL urlForHTMLReport = new URL(str + "/ProductUI/productSummary/jenkinsService/getHTMLReport");
            URLConnection connect = NetStormConnectionManager.getConnections(urlForHTMLReport, this.isSkipSSLCertValidation(), this.isSkipSSLHostValidation());
            connect.setConnectTimeout(0);
            connect.setReadTimeout(0);
            ((HttpURLConnection)connect).setRequestMethod("POST");
            connect.setRequestProperty("Content-Type", "application/octet-stream");
            connect.setDoOutput(true);
            OutputStream outStream = connect.getOutputStream();
            String json = jsonRequest.toString();
            outStream.write(json.getBytes());
            outStream.flush();
            if (((HttpURLConnection)connect).getResponseCode() == 200) {
                int bytesRead;
                byte[] mybytearray = new byte[1024];
                is = connect.getInputStream();
                bos = new BufferedOutputStream(fz.write());
                while ((bytesRead = is.read(mybytearray)) > 0) {
                    bos.write(mybytearray, 0, bytesRead);
                }
            } else {
                logger.log(Level.FINE, "ErrorCode-" + ((HttpURLConnection)connect).getResponseCode());
                logger.log(Level.FINE, "content type-" + connect.getContentType());
                return false;
            }
            bos.close();
            is.close();
            String destDir = fp + "/TestSuiteReport";
            FilePath dir = new FilePath(fp.getChannel(), destDir);
            if (dir.exists()) {
                dir.deleteRecursive();
            }
            dir.mkdirs();
            this.unzip(dir, fz);
            return true;
        }
        catch (InterruptedException ie) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception. IOException -", ie);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in methid getHTMLreport. IOException -", e);
            logger.log(Level.SEVERE, "Error in getHTMLReport.", e);
            return false;
        }
        return false;
    }

    private void unzip(FilePath dir, FilePath zipFile) throws IOException, InterruptedException {
        try {
            logger.log(Level.INFO, "Cavisson-Plugin|Unzipping Html directory to path = " + dir);
            InputStream in = zipFile.read();
            dir.unzipFrom(in);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Exception in unzipping file = " + e);
            logger.log(Level.SEVERE, "Error in getHTMLReport.", e);
        }
    }

    public void createCheckRuleFile(String restUrl) {
        try {
            logger.log(Level.FINE, "Cavisson-Plugin|createCheckRuleFile Method called with arguments - username :" + this.username + ", profile :" + this.profile);
            net.sf.json.JSONObject jsonRequest = new net.sf.json.JSONObject();
            jsonRequest.put(JSONKeys.PROJECT.getValue(), (Object)this.project);
            jsonRequest.put(JSONKeys.SUBPROJECT.getValue(), (Object)this.subProject);
            jsonRequest.put(JSONKeys.SCENARIO.getValue(), (Object)this.scenario);
            jsonRequest.put(JSONKeys.TEST_RUN.getValue(), (Object)(this.testRun + ""));
            jsonRequest.put(JSONKeys.CHECK_RULE.getValue(), (Object)this.jkRule);
            jsonRequest.put("username", (Object)this.username);
            jsonRequest.put("profile", (Object)this.profile);
            URL url = new URL(restUrl + "/ProductUI/productSummary/jenkinsService/createCheckProfile");
            URLConnection conn = NetStormConnectionManager.getConnections(url, this.isSkipSSLCertValidation(), this.isSkipSSLHostValidation());
            conn.setConnectTimeout(0);
            conn.setReadTimeout(0);
            ((HttpURLConnection)conn).setRequestMethod("POST");
            conn.setRequestProperty("Accept", "application/json");
            String json = jsonRequest.toString();
            conn.setDoOutput(true);
            OutputStream os = conn.getOutputStream();
            os.write(json.getBytes());
            os.flush();
            if (((HttpURLConnection)conn).getResponseCode() != 200) {
                this.consoleLogger.println("Failed to write check rule with Error Code = " + ((HttpURLConnection)conn).getResponseCode());
                logger.log(Level.FINE, "Cavisson-Plugin|Getting Error code = " + ((HttpURLConnection)conn).getResponseCode());
                throw new RuntimeException("Failed : HTTP error code : " + ((HttpURLConnection)conn).getResponseCode());
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception. IOException -", e);
        }
    }

    public void parseTestResponseData(net.sf.json.JSONObject jsonResponse, HashMap resultMap, PrintStream consoleLogger) {
        try {
            if (jsonResponse != null) {
                boolean status = false;
                if (jsonResponse.get(JSONKeys.STATUS.getValue()) != null && !(status = ((Boolean)jsonResponse.get(JSONKeys.STATUS.getValue())).booleanValue())) {
                    consoleLogger.println("Test is aborted.");
                }
                if (jsonResponse.get(JSONKeys.REPORT_STATUS.getValue()) != null) {
                    String string = (String)jsonResponse.get(JSONKeys.REPORT_STATUS.getValue());
                }
                if (jsonResponse.get(JSONKeys.TEST_RUN.getValue()) != null) {
                    String testRun = (String)jsonResponse.get(JSONKeys.TEST_RUN.getValue());
                    resultMap.put("STATUS", status);
                    resultMap.put("TESTRUN", testRun);
                    if (this.testMode.equals("T")) {
                        resultMap.put("TEST_CYCLE_NUMBER", this.testCycleNum);
                    }
                    if (jsonResponse.containsKey((Object)"ENV_NAME")) {
                        String envNames = "";
                        JSONArray envArr = (JSONArray)jsonResponse.get("ENV_NAME");
                        for (int i = 0; i < envArr.size(); ++i) {
                            envNames = i == 0 ? (String)envArr.get(i) : envNames + "," + (String)envArr.get(i);
                        }
                        resultMap.put("ENV_NAME", envNames);
                    }
                    if (!this.doNotWaitforTestCompletion) {
                        consoleLogger.println("Test is executed successfully.");
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Exception in parsing netstorm test start output.", ex);
        }
    }

    private void connectNSAndPollTestRun() {
        try {
            this.consoleLogger.println("Test Started. Now tracking TestRun based on running scenario.");
            Runnable pollTestRunState = new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean isTestRunning = true;
                        try {
                            NetStormConnectionManager.Sleep(NetStormConnectionManager.this.pollInterval * 1000L);
                        }
                        catch (Exception ex) {
                            logger.log(Level.SEVERE, "Cavisson-Plugin|Error in initial sleep before polling.", ex);
                        }
                        logger.log(Level.FINE, "Cavisson-Plugin|Starting Polling to server.");
                        while (isTestRunning) {
                            try {
                                logger.log(Level.FINE, "Cavisson-Plugin|Testrun number = " + NetStormConnectionManager.this.testRun);
                                String pollURLWithArgs = NetStormConnectionManager.this.pollURL + "?proSubProject=" + NetStormConnectionManager.this.scenarioName + "&testRun=" + NetStormConnectionManager.this.testRun;
                                URL url = new URL(pollURLWithArgs);
                                URLConnection conn = BaseConnection.getConnections(url, NetStormConnectionManager.this.isSkipSSLCertValidation(), NetStormConnectionManager.this.isSkipSSLHostValidation());
                                conn.setConnectTimeout(POLL_CONN_TIMEOUT);
                                conn.setReadTimeout(POLL_CONN_TIMEOUT);
                                ((HttpURLConnection)conn).setRequestMethod("GET");
                                conn.setRequestProperty("Accept", "application/json");
                                if (((HttpURLConnection)conn).getResponseCode() != 200) {
                                    logger.log(Level.INFO, "Cavisson-Plugin|Getting Error code on polling  = " + ((HttpURLConnection)conn).getResponseCode() + ". Retrying in next poll in 5 minutes.");
                                }
                                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                                String pollResString = br.readLine();
                                try {
                                    net.sf.json.JSONObject pollResponse = (net.sf.json.JSONObject)JSONSerializer.toJSON((Object)pollResString);
                                    if (pollResponse.has("testRun") && NetStormConnectionManager.this.testRun <= 0) {
                                        NetStormConnectionManager.this.testRun = Integer.parseInt(pollResponse.getString("testRun"));
                                        if (!NetStormConnectionManager.this.doNotWaitforTestCompletion) {
                                            NetStormConnectionManager.this.consoleLogger.println("Test Run - " + NetStormConnectionManager.this.testRun);
                                        }
                                        int stopTR = -1;
                                        stopTR = Integer.parseInt(pollResponse.getString("testRun"));
                                        String portStr = NetStormConnectionManager.this.getUrlString();
                                        new BuildActionStopTest(stopTR, NetStormConnectionManager.this.username, portStr);
                                        NetStormConnectionManager.this.consoleLogger.println("Test In Progress...");
                                    }
                                    if (pollResponse.getBoolean("status")) {
                                        isTestRunning = false;
                                    }
                                    NetStormConnectionManager.this.testCycleNum = pollResponse.getString("testCycleNumber");
                                    if (NetStormConnectionManager.this.doNotWaitforTestCompletion && NetStormConnectionManager.this.testRun > 0) {
                                        isTestRunning = false;
                                    }
                                }
                                catch (Exception e) {
                                    logger.log(Level.SEVERE, "Cavisson-Plugin|Error in parsing polling response = " + pollResString, e);
                                }
                                try {
                                    br.close();
                                }
                                catch (Exception e) {
                                    logger.log(Level.SEVERE, "Cavisson-Plugin|Error in closing stream inside polling thread.", e);
                                }
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, "Cavisson-Plugin|Error in polling running testRun with interval. Retrying after 5 sec.", e);
                            }
                            try {
                                if (NetStormConnectionManager.this.testRun > 0) {
                                    NetStormConnectionManager.this.pollInterval = 60L;
                                }
                                if (!isTestRunning) continue;
                                NetStormConnectionManager.Sleep(NetStormConnectionManager.this.pollInterval * 1000L);
                            }
                            catch (Exception ex) {
                                logger.log(Level.SEVERE, "Cavisson-Plugin|Error in polling connection in loop", ex);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Cavisson-Plugin|Error in polling running testRun with interval.", e);
                    }
                }
            };
            Thread pollTestRunThread = new Thread(pollTestRunState, "pollTestRunThread");
            ExecutorService threadExecutorService = Executors.newFixedThreadPool(1);
            threadExecutorService.execute(pollTestRunThread);
            threadExecutorService.shutdown();
            while (!threadExecutorService.isTerminated()) {
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Error in polling running testRun.", e);
        }
    }

    private void connectNSPollTestRun() {
        try {
            this.consoleLogger.println("Test Started. Now tracking TestRun based on running scenario.");
            Runnable pollTestRunState = new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean isTestRunning = true;
                        try {
                            NetStormConnectionManager.Sleep(NetStormConnectionManager.this.pollInterval * 1000L);
                        }
                        catch (Exception ex) {
                            logger.log(Level.SEVERE, "Cavisson-Plugin|Error in initial sleep before polling.", ex);
                        }
                        logger.log(Level.FINE, "Cavisson-Plugin|Starting Polling to server.");
                        while (isTestRunning) {
                            try {
                                String pollURLWithArgs = NetStormConnectionManager.this.pollURL + "?JOB_ID=" + NetStormConnectionManager.this.job_id + "&testMode=" + NetStormConnectionManager.this.testMode + "&testRun=" + NetStormConnectionManager.this.testRun + "&testCycleNum=" + NetStormConnectionManager.this.testCycleNum;
                                URL url = new URL(pollURLWithArgs);
                                URLConnection conn = BaseConnection.getConnections(url, NetStormConnectionManager.this.isSkipSSLCertValidation(), NetStormConnectionManager.this.isSkipSSLHostValidation());
                                conn.setConnectTimeout(POLL_CONN_TIMEOUT);
                                conn.setReadTimeout(POLL_CONN_TIMEOUT);
                                ((HttpURLConnection)conn).setRequestMethod("GET");
                                conn.setRequestProperty("Accept", "application/json");
                                if (((HttpURLConnection)conn).getResponseCode() != 200) {
                                    logger.log(Level.FINE, "Cavisson-Plugin|Getting Error code on polling  = " + ((HttpURLConnection)conn).getResponseCode() + ". Retrying in next poll in 5 minutes.");
                                }
                                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                                String pollResString = br.readLine();
                                try {
                                    net.sf.json.JSONObject pollResponse = (net.sf.json.JSONObject)JSONSerializer.toJSON((Object)pollResString);
                                    if (pollResponse.has("testRun") && NetStormConnectionManager.this.testRun <= 0) {
                                        NetStormConnectionManager.this.testRun = Integer.parseInt(pollResponse.getString("testRun"));
                                        if (!NetStormConnectionManager.this.doNotWaitforTestCompletion) {
                                            NetStormConnectionManager.this.consoleLogger.println("Test Run - " + NetStormConnectionManager.this.testRun);
                                        }
                                        int stopTR = -1;
                                        stopTR = Integer.parseInt(pollResponse.getString("testRun"));
                                        logger.log(Level.FINE, "Cavisson-Plugin|Testrun to stop = " + stopTR);
                                        String portStr = NetStormConnectionManager.this.getUrlString();
                                        new BuildActionStopTest(stopTR, NetStormConnectionManager.this.username, portStr);
                                        NetStormConnectionManager.this.consoleLogger.println("Test In Progress...");
                                    }
                                    if (pollResponse.has("status") && pollResponse.getBoolean("status")) {
                                        isTestRunning = false;
                                    }
                                    if (NetStormConnectionManager.this.testMode.equals("T") && pollResponse.has("testCycleNumber")) {
                                        NetStormConnectionManager.this.testCycleNum = pollResponse.getString("testCycleNumber");
                                    }
                                    if (pollResponse.has("errMsg")) {
                                        NetStormConnectionManager.this.errMsg = pollResponse.getString("errMsg");
                                        NetStormConnectionManager.this.consoleLogger.println(NetStormConnectionManager.this.errMsg);
                                    }
                                    if (NetStormConnectionManager.this.doNotWaitforTestCompletion && NetStormConnectionManager.this.testRun > 0) {
                                        isTestRunning = false;
                                    }
                                }
                                catch (Exception e) {
                                    logger.log(Level.SEVERE, "Cavisson-Plugin|Error in parsing polling response = " + pollResString, e);
                                }
                                try {
                                    br.close();
                                }
                                catch (Exception e) {
                                    logger.log(Level.SEVERE, "Cavisson-Plugin|Error in closing stream inside polling thread.", e);
                                }
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, "Cavisson-Plugin|Error in polling running testRun with interval. Retrying after 5 sec.", e);
                            }
                            try {
                                if (NetStormConnectionManager.this.testRun > 0) {
                                    NetStormConnectionManager.this.pollInterval = 60L;
                                }
                                if (!isTestRunning) continue;
                                NetStormConnectionManager.Sleep(NetStormConnectionManager.this.pollInterval * 1000L);
                            }
                            catch (Exception ex) {
                                logger.log(Level.SEVERE, "Cavisson-Plugin|Error in polling connection in loop", ex);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Cavisson-Plugin|Error in polling running testRun with interval.", e);
                    }
                }
            };
            Thread pollTestRunThread = new Thread(pollTestRunState, "pollTestRunThread");
            ExecutorService threadExecutorService = Executors.newFixedThreadPool(1);
            threadExecutorService.execute(pollTestRunThread);
            threadExecutorService.shutdown();
            while (!threadExecutorService.isTerminated()) {
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Error in polling running testRun.", e);
        }
    }

    private void connectNSAndPollJsonReport(final Run build, final PrintStream logg) {
        try {
            logger.log(Level.INFO, "Cavisson-Plugin|Test is stopped. Now getting report from Netstorm. It may take some time. URL = " + this.pollReportURL);
            Runnable pollReportState = new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean isReportGenerated = true;
                        logger.log(Level.FINE, "Cavisson-Plugin|Starting Polling to server.");
                        while (isReportGenerated) {
                            try {
                                String pollURLWithArgs = NetStormConnectionManager.this.pollReportURL + "?&testRun=" + NetStormConnectionManager.this.testRun;
                                URL url = new URL(pollURLWithArgs);
                                URLConnection conn = BaseConnection.getConnections(url, NetStormConnectionManager.this.isSkipSSLCertValidation(), NetStormConnectionManager.this.isSkipSSLHostValidation());
                                conn.setConnectTimeout(POLL_CONN_TIMEOUT);
                                conn.setReadTimeout(POLL_CONN_TIMEOUT);
                                ((HttpURLConnection)conn).setRequestMethod("GET");
                                conn.setRequestProperty("Accept", "application/json");
                                if (((HttpURLConnection)conn).getResponseCode() != 200) {
                                    logger.log(Level.FINE, "Cavisson-Plugin|Getting Error code on polling  = " + ((HttpURLConnection)conn).getResponseCode() + ". Retrying in next poll in 5 minutes.");
                                }
                                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                                String pollResString = br.readLine();
                                try {
                                    net.sf.json.JSONObject pollResponse = (net.sf.json.JSONObject)JSONSerializer.toJSON((Object)pollResString);
                                    if (pollResponse.getBoolean("status")) {
                                        isReportGenerated = false;
                                        String reportstatus = pollResponse.getString("Report Status");
                                        logg.println("Report Status = " + reportstatus);
                                        logger.log(Level.FINE, "Cavisson-Plugin|Report status = " + reportstatus);
                                        if (reportstatus.equals("PASS")) {
                                            build.setResult(Result.SUCCESS);
                                        } else {
                                            build.setResult(Result.FAILURE);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    logger.log(Level.SEVERE, "Cavisson-Plugin|Error in parsing polling response = " + pollResString, e);
                                    build.setResult(Result.UNSTABLE);
                                }
                                try {
                                    br.close();
                                }
                                catch (Exception e) {
                                    logger.log(Level.SEVERE, "Cavisson-Plugin|Error in closing stream inside polling thread.", e);
                                    build.setResult(Result.UNSTABLE);
                                }
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, "Cavisson-Plugin|Error in polling report with interval. Retrying after 5 sec.", e);
                            }
                            try {
                                NetStormConnectionManager.Sleep(POLL_REPEAT_FOR_REPORT_TIME);
                                logger.log(Level.FINE, "Cavisson-Plugin|Report generation is  in progress. Going to check on server. Time = " + new Date());
                            }
                            catch (Exception ex) {
                                logger.log(Level.SEVERE, "Cavisson-Plugin|Error in polling connection in loop", ex);
                                build.setResult(Result.UNSTABLE);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Cavisson-Plugin|Error in polling report with interval.", e);
                        build.setResult(Result.UNSTABLE);
                    }
                }
            };
            ExecutorService threadExecutorService = Executors.newFixedThreadPool(1);
            Future<?> future = threadExecutorService.submit(pollReportState);
            threadExecutorService.shutdown();
            this.getFuture(this.timeout, future);
            if (!threadExecutorService.isTerminated()) {
                threadExecutorService.shutdownNow();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in polling report.", e);
        }
    }

    public boolean fetchMetricData(NetStormConnectionManager connection, String[] metrics, String durationInMinutes, int[] groupIds, int[] graphIds, int testRun, String testMode, PrintStream logg, String test_cycle_Number, Run build) {
        logger.log(Level.FINE, "Cavisson-Plugin|fetchMetricData() method called.");
        net.sf.json.JSONObject jsonRequest = this.makeRequestObject("GET_DATA");
        jsonRequest.put("TESTRUN", (Object)String.valueOf(testRun));
        jsonRequest.put(JSONKeys.TESTMODE.getValue(), (Object)testMode);
        jsonRequest.put(JSONKeys.PROJECT.getValue(), (Object)connection.getProject());
        jsonRequest.put(JSONKeys.SUBPROJECT.getValue(), (Object)connection.getSubProject());
        jsonRequest.put(JSONKeys.SCENARIO.getValue(), (Object)connection.getScenario());
        jsonRequest.put("TestCycleNumber", (Object)test_cycle_Number);
        jsonRequest.put("isDurationPhase", (Object)this.durationPhase);
        jsonRequest.put("workProfile", (Object)connection.getProfile());
        this.testRun = testRun;
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < metrics.length; ++i) {
            jSONArray.add((Object)(groupIds[i] + "." + graphIds[i]));
        }
        jsonRequest.put("Metric", (Object)jSONArray);
        StringBuffer errMsg = new StringBuffer();
        Object resonseObj = null;
        try {
            String str = this.getUrlString();
            URL url = new URL(str + "/ProductUI/productSummary/jenkinsService/jsonData");
            logger.log(Level.FINE, "Cavisson-Plugin|fetchMetricData.  method called. with arguments for metric  url" + url);
            URLConnection conn = NetStormConnectionManager.getConnections(url, this.isSkipSSLCertValidation(), this.isSkipSSLHostValidation());
            conn.setConnectTimeout(0);
            conn.setReadTimeout(0);
            ((HttpURLConnection)conn).setRequestMethod("POST");
            conn.setRequestProperty("Accept", "application/json");
            String json = jsonRequest.toString();
            conn.setDoOutput(true);
            OutputStream os = conn.getOutputStream();
            os.write(json.getBytes());
            os.flush();
            if (((HttpURLConnection)conn).getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + ((HttpURLConnection)conn).getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            this.resonseReportObj = (net.sf.json.JSONObject)JSONSerializer.toJSON((Object)br.readLine());
            if (this.resonseReportObj.containsKey((Object)"status") && !this.resonseReportObj.getBoolean("status")) {
                logger.log(Level.SEVERE, "Cavisson-Plugin|Not able to get response form server due to some reason");
                this.consoleLogger.println("Error in report generation.");
                return false;
            }
            this.pollReportURL = str + "/ProductUI/productSummary/jenkinsService/checkNetstormReportStatus";
            logger.log(Level.FINE, "Cavisson-Plugin|url for polling report - pollReportURL = " + this.pollReportURL);
            this.connectNSAndPollJsonReport(build, logg);
        }
        catch (MalformedURLException e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in establishing connection. MalformedURLException -", e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in establishing connection. IOException -", e);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in establishing connection.", e);
        }
        return true;
    }

    public String numberFormatWithDecimal(double value, String upToDecimal) {
        try {
            DecimalFormat df = new DecimalFormat(upToDecimal);
            if (value % 1.0 == 0.0) {
                upToDecimal = "0";
            }
            String num = df.format(value);
            String[] arr = num.split("\\.");
            arr[0] = NumberFormat.getIntegerInstance().format(Long.parseLong(arr[0]));
            if (arr.length == 2) {
                return arr[0] + "." + arr[1];
            }
            return arr[0];
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception ", e);
            return "";
        }
    }

    private MetricDataContainer parseJSONData(net.sf.json.JSONObject resonseObj, String testMode, PrintStream logg) {
        logger.log(Level.FINE, "Cavisson-Plugin|parseJSONData() method called.");
        MetricDataContainer metricDataContainer = new MetricDataContainer();
        try {
            ArrayList<MetricData> dataList = new ArrayList<MetricData>();
            net.sf.json.JSONObject jsonGraphs = (net.sf.json.JSONObject)resonseObj.get("graphs");
            int freq = (Integer)resonseObj.get("frequency") / 1000;
            metricDataContainer.setFrequency(freq);
            if (resonseObj.containsKey((Object)"customHTMLReport")) {
                metricDataContainer.setCustomHTMLReport((String)resonseObj.get("customHTMLReport"));
            }
            TestReport testReport = new TestReport();
            if ("T".equals(testMode)) {
                testReport = new TestReport();
                testReport.setUserName(this.username);
                net.sf.json.JSONObject jsonTestReportWholeObj = resonseObj.getJSONObject("testReport");
                net.sf.json.JSONObject jsonTestReport = jsonTestReportWholeObj.getJSONObject("members");
                String overAllStatus = jsonTestReport.getString("Overall Status");
                logg.println("----------------------------");
                logg.println("Overall Status = " + overAllStatus);
                String date = jsonTestReport.getString("Date");
                String overAllFailCriteria = jsonTestReport.getString("Overall Fail Criteria (greater than red) %");
                String serverName = jsonTestReport.getString("IP");
                String productName = jsonTestReport.getString("ProductName");
                String previousTestRun = jsonTestReport.getString("Previous Test Run");
                String baseLineTestRun = jsonTestReport.getString("Baseline Test Run");
                String initialTestRun = jsonTestReport.getString("Initial Test Run");
                String baseLineDateTime = jsonTestReport.getString("Baseline Date Time");
                String previousDateTime = jsonTestReport.getString("Previous Date Time");
                String initialDateTime = jsonTestReport.getString("Initial Date Time");
                String testRun = jsonTestReport.getString("Test Run");
                String normalThreshold = jsonTestReport.getString("Normal Threshold");
                String criticalThreshold = jsonTestReport.getString("Critical Threshold");
                String currentDateTime = "";
                String previousDescription = "";
                String baselineDescription = "";
                String currentDescription = "";
                String initialDescription = "";
                String dashboardURL = jsonTestReport.getString("Dashboard Link");
                String reportLink = jsonTestReport.getString("Report Link");
                try {
                    currentDateTime = jsonTestReport.getString("Current Date Time");
                    previousDescription = jsonTestReport.getString("Previous Description");
                    baselineDescription = jsonTestReport.getString("Baseline Description");
                    currentDescription = jsonTestReport.getString("Current Description");
                    initialDescription = jsonTestReport.getString("Initial Description");
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "Cavisson-Plugin|Error in parsing Test Report Data:" + ex);
                }
                if (jsonTestReport.get("Metrics Under Test") != null && jsonTestReport.get("Page Detail Report") == null) {
                    JSONArray metricsUnderTest = (JSONArray)jsonTestReport.get("Metrics Under Test");
                    ArrayList<TestMetrics> testMetricsList = new ArrayList<TestMetrics>(metricsUnderTest.size());
                    Object str = "";
                    int index = 0;
                    for (Object jsonData : metricsUnderTest) {
                        net.sf.json.JSONObject jsonObject = (net.sf.json.JSONObject)jsonData;
                        String prevTestValue = jsonObject.getString("Prev Test Value ");
                        String baseLineValue = jsonObject.getString("Baseline Value ");
                        String initialValue = jsonObject.getString("Initial Value ");
                        String edLink = jsonObject.getString("link");
                        String currValue = jsonObject.getString("Value");
                        String metric = jsonObject.getString("Metric");
                        String metricRule = jsonObject.getString("MetricRule");
                        String operator = jsonObject.getString("Operator");
                        String sla = jsonObject.getString("SLA");
                        if (sla.indexOf(">") != -1 || sla.indexOf(">") > 0) {
                            sla = sla.substring(sla.lastIndexOf(">") + 1, sla.length());
                        }
                        String count = jsonObject.getString("Count");
                        String transactiontStatus = jsonObject.getString("Transaction Status");
                        String transactionBgcolor = jsonObject.getString("Transaction BGcolor");
                        String transactionTooltip = jsonObject.getString("Transaction Tooltip");
                        String trendLink = jsonObject.getString("trendLink");
                        String metricLink = jsonObject.getString("Metric_DashboardLink");
                        logger.log(Level.FINE, " metric link ", metricLink);
                        TestMetrics testMetric = new TestMetrics();
                        testMetric.setBaseLineValue(baseLineValue);
                        testMetric.setCurrValue(currValue);
                        if (edLink != null) {
                            testMetric.setEdLink(edLink);
                        } else {
                            testMetric.setEdLink("NA");
                        }
                        testMetric.setOperator(operator);
                        testMetric.setPrevTestRunValue(prevTestValue);
                        testMetric.setInitialValue(initialValue);
                        testMetric.setSLA(sla);
                        if (count.equals("noCount")) {
                            testMetric.setCount("NA");
                        } else {
                            testMetric.setCount(count);
                        }
                        if (trendLink != null) {
                            testMetric.setLinkForTrend(trendLink);
                        } else {
                            testMetric.setLinkForTrend("NA");
                        }
                        boolean fromPattern = false;
                        String patt = jsonObject.getString("PATTERN");
                        if (metric.trim().contains("- PATTERN")) {
                            int len = patt.length() + 2;
                            String dName = metric.substring(metric.indexOf("-") + len + 1, metric.trim().length() - 1);
                            metric = metric.replace(metric.substring(metric.indexOf("-"), metric.length()), "- " + dName);
                            fromPattern = true;
                        }
                        String headerName = "";
                        String displayName = metric;
                        if (index == 0) {
                            str = displayName;
                            if (displayName.contains("- All") && !fromPattern) {
                                headerName = displayName.substring(0, ((String)str).indexOf("-") + 5);
                                displayName = displayName.substring(displayName.indexOf("-") + 6, displayName.length() - 1);
                            } else if (displayName.contains(" - ")) {
                                headerName = displayName.substring(0, ((String)str).indexOf("-") + 1);
                                displayName = displayName.substring(displayName.indexOf("-") + 1, displayName.length() - 1);
                            } else {
                                headerName = "Other";
                            }
                            ++index;
                        } else if (displayName.contains(" - ") && ((String)str).indexOf("-") != -1) {
                            String metricName = displayName.substring(0, displayName.indexOf("-"));
                            if (metricName.toString().trim().equals(((String)str).substring(0, ((String)str).indexOf("-")).toString().trim())) {
                                headerName = "";
                                displayName = displayName.contains("- All") && !fromPattern ? displayName.substring(displayName.indexOf("-") + 6, displayName.length() - 1) : displayName.substring(displayName.indexOf("-") + 1, displayName.length());
                            } else {
                                str = displayName;
                                if (displayName.contains("- All") && !fromPattern) {
                                    headerName = displayName.substring(0, displayName.indexOf("-") + 5);
                                    displayName = displayName.substring(displayName.indexOf("-") + 6, displayName.length() - 1);
                                } else if (displayName.contains(" - ")) {
                                    headerName = displayName.substring(0, displayName.indexOf("-"));
                                    displayName = displayName.substring(displayName.indexOf("-") + 1, displayName.length());
                                } else {
                                    headerName = "Other";
                                }
                            }
                        } else if (((String)str).indexOf("-") == -1) {
                            str = displayName;
                            if (displayName.contains("- All") && !fromPattern) {
                                headerName = displayName.substring(0, ((String)str).indexOf("-") + 5);
                                displayName = displayName.substring(((String)str).indexOf("-") + 6, displayName.length() - 1);
                            } else if (displayName.contains(" - ")) {
                                headerName = displayName.substring(0, ((String)str).indexOf("-"));
                                displayName = displayName.substring(((String)str).indexOf("-") + 1, displayName.length());
                            } else {
                                headerName = "Other";
                            }
                        } else {
                            headerName = "Other";
                        }
                        testMetric.setNewReport("NewReport");
                        testMetric.setDisplayName(displayName);
                        testMetric.setHeaderName(headerName);
                        testMetric.setMetricName(metric);
                        testMetric.setMetricLink(metricLink);
                        testMetric.setMetricRuleName(metricRule);
                        testMetric.setTransactiontStatus(transactiontStatus);
                        testMetric.setStatusColour(transactionBgcolor);
                        testMetric.setTransactionTooltip(transactionTooltip);
                        testMetricsList.add(testMetric);
                        testReport.setOperator(operator);
                        testReport.setTestMetrics(testMetricsList);
                        if (count.equals("noCount")) {
                            testReport.setShowCount("0");
                            continue;
                        }
                        testReport.setShowCount("1");
                    }
                } else {
                    if (jsonTestReport.get("Transaction Stats") != null) {
                        net.sf.json.JSONObject transStats = (net.sf.json.JSONObject)jsonTestReport.get("Transaction Stats");
                        testReport = this.metricDataForTrans(transStats, testReport, jsonTestReport);
                    }
                    if (jsonTestReport.get("Vector Groups") != null) {
                        net.sf.json.JSONObject vectorGroups = (net.sf.json.JSONObject)jsonTestReport.get("Vector Groups");
                        testReport = this.metricDataForVectorGroups(vectorGroups, testReport, jsonTestReport);
                    }
                    if (jsonTestReport.get("Scalar Groups") != null) {
                        net.sf.json.JSONObject scalarGroups = (net.sf.json.JSONObject)jsonTestReport.get("Scalar Groups");
                        testReport = this.metricDataForScalar(scalarGroups, testReport, jsonTestReport);
                    }
                }
                if (jsonTestReport.get("Page Detail Report") != null) {
                    JSONArray pageDetailReport = (JSONArray)jsonTestReport.get("Page Detail Report");
                    ArrayList<PageDetail> pageDetailReportList = new ArrayList<PageDetail>(pageDetailReport.size());
                    for (Object jsonData : pageDetailReport) {
                        net.sf.json.JSONObject jsonObject = (net.sf.json.JSONObject)jsonData;
                        String maxPageLoad = jsonObject.getString("maxPageLoad");
                        String strAvgPerfScore = jsonObject.getString("strAvgPerfScore");
                        String strAvgBestPracScore = jsonObject.getString("strAvgBestPracScore");
                        String minStartRender = jsonObject.getString("minStartRender");
                        String strPageName = jsonObject.getString("strPageName");
                        String strAverageByteRec = this.numberFormatWithDecimal(Double.parseDouble(jsonObject.getString("strAverageByteRec")), "0");
                        String maxEndRender = jsonObject.getString("maxEndRender");
                        String strBrowserAverageReq = jsonObject.getString("strBrowserAverageReq");
                        String minOnload = jsonObject.getString("minOnload");
                        String strAvgFrstCpuIdle = jsonObject.getString("strAvgFrstCpuIdle");
                        String strHostName = jsonObject.getString("strHostName");
                        String minEndRender = jsonObject.getString("minEndRender");
                        String strBrowserAverageReqOnLoad = jsonObject.getString("strBrowserAverageReqOnLoad");
                        String strAverageReqDomContent = jsonObject.getString("strAverageReqDomContent");
                        String averageEndRender = this.numberFormatWithDecimal(Double.parseDouble(jsonObject.getString("averageEndRender")), "0.00");
                        String strAverageDOM = this.numberFormatWithDecimal(Double.parseDouble(jsonObject.getString("strAverageDOM")), "0.00");
                        String strAvgAccessScore = jsonObject.getString("strAvgAccessScore");
                        String strAveragePageLoad = this.numberFormatWithDecimal(Double.parseDouble(jsonObject.getString("strAveragePageLoad")), "0.00");
                        String averageSpeedIndex = this.numberFormatWithDecimal(Double.parseDouble(jsonObject.getString("averageSpeedIndex")), "0");
                        String browserName = jsonObject.getString("browserName");
                        String strAvgFrstCPaint = jsonObject.getString("strAvgFrstCPaint");
                        String strAvgSeoScore = jsonObject.getString("strAvgSeoScore");
                        String strAvgIptLtncy = jsonObject.getString("strAvgIptLtncy");
                        String strAverageReqOnLoad = jsonObject.getString("strAverageReqOnLoad");
                        String strAverageOnload = this.numberFormatWithDecimal(Double.parseDouble(jsonObject.getString("strAverageOnload")), "0.00");
                        String strAvgPwaScrore = jsonObject.getString("strAvgPwaScrore");
                        String minDom = jsonObject.getString("minDom");
                        String maxStartRender = jsonObject.getString("maxStartRender");
                        String strSessionCount = jsonObject.getString("strSessionCount");
                        String averageStartRender = this.numberFormatWithDecimal(Double.parseDouble(jsonObject.getString("averageStartRender")), "0.00");
                        String maxDom = jsonObject.getString("maxDom");
                        String groupName = jsonObject.getString("groupName");
                        String strAverageReq = jsonObject.getString("strAverageReq");
                        String pageIndex = jsonObject.getString("pageIndex");
                        String strBrowserAverageReqDomContent = jsonObject.getString("strBrowserAverageReqDomContent");
                        String envName = jsonObject.getString("envName");
                        String sessionPagename = jsonObject.getString("sessionPagename");
                        String maxOnload = jsonObject.getString("maxOnload");
                        String strAvgFrstMpaint = jsonObject.getString("strAvgFrstMpaint");
                        String strAverageByteSent = this.numberFormatWithDecimal(Double.parseDouble(jsonObject.getString("strAverageByteSent")), "0");
                        String strScreenSize = jsonObject.getString("strScreenSize");
                        String strAverageTimeToInteract = this.numberFormatWithDecimal(Double.parseDouble(jsonObject.getString("strAverageTimeToInteract")), "0.00");
                        String minPageLoad = jsonObject.getString("minPageLoad");
                        PageDetail pageDetail = new PageDetail();
                        pageDetail.setAverageEndRender(averageEndRender);
                        pageDetail.setAverageSpeedIndex(averageSpeedIndex);
                        pageDetail.setAverageStartRender(averageStartRender);
                        pageDetail.setBrowserName(browserName);
                        pageDetail.setEnvName(envName);
                        pageDetail.setGroupName(groupName);
                        pageDetail.setMaxDom(maxDom);
                        pageDetail.setMaxEndRender(maxEndRender);
                        pageDetail.setMaxOnload(maxOnload);
                        pageDetail.setMaxPageLoad(maxPageLoad);
                        pageDetail.setMaxStartRender(maxStartRender);
                        pageDetail.setMinDom(minDom);
                        pageDetail.setMinEndRender(minEndRender);
                        pageDetail.setMinOnload(minOnload);
                        pageDetail.setMinPageLoad(minPageLoad);
                        pageDetail.setMinStartRender(minStartRender);
                        pageDetail.setPageIndex(pageIndex);
                        pageDetail.setSessionPagename(sessionPagename);
                        pageDetail.setStrAverageByteRec(strAverageByteRec);
                        pageDetail.setStrAverageByteSent(strAverageByteSent);
                        pageDetail.setStrAverageDOM(strAverageDOM);
                        pageDetail.setStrAverageOnload(strAverageOnload);
                        pageDetail.setStrAveragePageLoad(strAveragePageLoad);
                        pageDetail.setStrAverageReq(strAverageReq);
                        pageDetail.setStrAverageReqDomContent(strAverageReqDomContent);
                        pageDetail.setStrAverageReqOnLoad(strAverageReqOnLoad);
                        pageDetail.setStrAverageTimeToInteract(strAverageTimeToInteract);
                        pageDetail.setStrAvgAccessScore(strAvgAccessScore);
                        pageDetail.setStrAvgBestPracScore(strAvgBestPracScore);
                        pageDetail.setStrAvgFrstCPaint(strAvgFrstCPaint);
                        pageDetail.setStrAvgFrstCpuIdle(strAvgFrstCpuIdle);
                        pageDetail.setStrAvgFrstMpaint(strAvgFrstMpaint);
                        pageDetail.setStrAvgIptLtncy(strAvgIptLtncy);
                        pageDetail.setStrAvgPerfScore(strAvgPerfScore);
                        pageDetail.setStrAvgPwaScrore(strAvgPwaScrore);
                        pageDetail.setStrAvgSeoScore(strAvgSeoScore);
                        pageDetail.setStrBrowserAverageReq(strBrowserAverageReq);
                        pageDetail.setStrBrowserAverageReqDomContent(strBrowserAverageReqDomContent);
                        pageDetail.setStrBrowserAverageReqOnLoad(strBrowserAverageReqOnLoad);
                        pageDetail.setStrHostName(strHostName);
                        pageDetail.setStrPageName(strPageName);
                        pageDetail.setStrScreenSize(strScreenSize);
                        pageDetail.setStrSessionCount(strSessionCount);
                        pageDetailReportList.add(pageDetail);
                    }
                    net.sf.json.JSONObject pageDetailObj = (net.sf.json.JSONObject)pageDetailReport.get(0);
                    String strScreenSize = pageDetailObj.getString("strScreenSize");
                    String strAverageTimeToInteract = pageDetailObj.getString("strAverageTimeToInteract");
                    ArrayList<String> pageDetailHeader = new ArrayList<String>();
                    pageDetailHeader.add("Page Name");
                    pageDetailHeader.add("Host Name");
                    pageDetailHeader.add("Group");
                    pageDetailHeader.add("Browser");
                    pageDetailHeader.add("Screen Size");
                    pageDetailHeader.add("Session Count");
                    pageDetailHeader.add("DOM Content Load(Sec)");
                    pageDetailHeader.add("On Load(Sec)");
                    pageDetailHeader.add("Page Load(Sec)");
                    pageDetailHeader.add("Time To Interact(Sec)");
                    pageDetailHeader.add("Start Render Time(Sec)");
                    pageDetailHeader.add("Visually Complete Time");
                    pageDetailHeader.add("Requests");
                    pageDetailHeader.add("Browser Cache");
                    pageDetailHeader.add("Bytes Received(KB)");
                    pageDetailHeader.add("Bytes Send(KB)");
                    pageDetailHeader.add("Speed Index");
                    testReport.setPageDetailHeader(pageDetailHeader);
                    testReport.setPageDetail(pageDetailReportList);
                    logger.log(Level.FINE, "Cavisson-Plugin|Page Detail report : " + testReport.getPageDetail());
                }
                int transObj = 1;
                if (jsonTestReport.has("BASETOT")) {
                    transObj = 2;
                }
                for (int i = 0; i < transObj; ++i) {
                    net.sf.json.JSONObject transactionJson = null;
                    transactionJson = i == 1 ? jsonTestReport.getJSONObject("BASETOT") : (jsonTestReport.has("TOT") ? jsonTestReport.getJSONObject("TOT") : jsonTestReport.getJSONObject("CTOT"));
                    logger.log(Level.FINE, "Cavisson-Plugin|transactionJson =" + transactionJson);
                    String complete = "NA";
                    if (transactionJson.getString("complete") != null) {
                        complete = transactionJson.getString("complete");
                    }
                    String totalTimeOut = "NA";
                    if (transactionJson.getString("Time Out") != null) {
                        totalTimeOut = transactionJson.getString("Time Out");
                    }
                    String t4xx = "NA";
                    if (transactionJson.getString("4xx") != null) {
                        t4xx = transactionJson.getString("4xx");
                    }
                    String t5xx = "NA";
                    if (transactionJson.getString("5xx") != null) {
                        t5xx = transactionJson.getString("5xx");
                    }
                    String conFail = "NA";
                    if (transactionJson.getString("ConFail") != null) {
                        conFail = transactionJson.getString("ConFail");
                    }
                    String cvFail = "NA";
                    if (transactionJson.getString("C.V Fail") != null) {
                        cvFail = transactionJson.getString("C.V Fail");
                    }
                    String success = "NA";
                    if (transactionJson.getString("success") != null) {
                        success = transactionJson.getString("success");
                    }
                    String warVersionTrans = "NA";
                    if (transactionJson.has("warVersion")) {
                        warVersionTrans = transactionJson.getString("warVersion");
                    }
                    String releaseVersionTrans = "NA";
                    if (transactionJson.has("releaseVersion")) {
                        releaseVersionTrans = transactionJson.getString("releaseVersion");
                    }
                    TransactionStats transactionStats = new TransactionStats();
                    if (i == 1) {
                        transactionStats.setTransTestRun("BASETOT");
                    } else if (jsonTestReport.has("TOT")) {
                        transactionStats.setTransTestRun("TOT");
                    } else {
                        transactionStats.setTransTestRun("CTOT");
                    }
                    transactionStats.setComplete(complete);
                    transactionStats.setConFail(conFail);
                    transactionStats.setCvFail(cvFail);
                    transactionStats.setSuccess(success);
                    transactionStats.setT4xx(t4xx);
                    transactionStats.setT5xx(t5xx);
                    transactionStats.setTotalTimeOut(totalTimeOut);
                    transactionStats.setWarVersion(warVersionTrans);
                    transactionStats.setReleaseVersion(releaseVersionTrans);
                    testReport.getTransStatsList().add(transactionStats);
                }
                testReport.setBaseLineTestRun(baseLineTestRun);
                testReport.setInitialTestRun(initialTestRun);
                testReport.setBaselineDateTime(baseLineDateTime);
                testReport.setPreviousDateTime(previousDateTime);
                testReport.setInitialDateTime(initialDateTime);
                testReport.setOverAllFailCriteria(overAllFailCriteria);
                testReport.setDate(date);
                testReport.setDashboardURL(dashboardURL);
                testReport.setReportLink(reportLink);
                testReport.setOverAllStatus(overAllStatus);
                testReport.setServerName(serverName);
                testReport.setPreviousTestRun(previousTestRun);
                testReport.setTestRun(testRun);
                testReport.setNormalThreshold(normalThreshold);
                testReport.setCriticalThreshold(criticalThreshold);
                testReport.setCurrentDateTime(currentDateTime);
                testReport.setPreviousDescription(previousDescription);
                testReport.setBaselineDescription(baselineDescription);
                testReport.setIpPortLabel(productName);
                testReport.setInitialDescription(initialDescription);
                testReport.setCurrentDescription(currentDescription);
                metricDataContainer.setTestReport(testReport);
                if (!testRun.equals("-1")) {
                    String url = this.getUrlString();
                    String reportlink = url + "/logs/TR" + testRun + "/ready_reports/TestSuiteReport.html";
                    logg.println("Report Link:- " + reportlink);
                }
                logg.println("----------------------------");
            }
            if (jsonGraphs != null) {
                Set keySet = jsonGraphs.keySet();
                for (String key : keySet) {
                    MetricData metricData = new MetricData();
                    net.sf.json.JSONObject graphJsonObj = (net.sf.json.JSONObject)jsonGraphs.get(key);
                    String graphName = (String)graphJsonObj.get("graphMetricPath");
                    metricData.setMetricPath(graphName.substring(graphName.indexOf("|") + 1));
                    metricData.setFrequency(String.valueOf(freq));
                    JSONArray jsonArray = (JSONArray)graphJsonObj.get("graphMetricValues");
                    ArrayList<MetricValues> list = new ArrayList<MetricValues>();
                    for (Object jsonArray1 : jsonArray) {
                        MetricValues values = new MetricValues();
                        net.sf.json.JSONObject graphValues = (net.sf.json.JSONObject)jsonArray1;
                        String currVal = String.valueOf(graphValues.get("currentValue"));
                        String maxVal = String.valueOf(graphValues.get("maxValue"));
                        String minVal = String.valueOf(graphValues.get("minValue"));
                        String avg = String.valueOf(graphValues.get("avgValue"));
                        long timeStamp = (Long)graphValues.get("timeStamp");
                        values.setValue((Double)graphValues.get("currentValue"));
                        values.setMax((Double)graphValues.get("maxValue"));
                        values.setMin(this.getMinForMetric((Double)graphValues.get("minValue")));
                        values.setStartTimeInMillis(timeStamp);
                        list.add(values);
                    }
                    metricData.setMetricValues(list);
                    dataList.add(metricData);
                    metricDataContainer.setMetricDataList(dataList);
                }
            }
            if (testMode.equals("T")) {
                ArrayList<MetricData> baseLineMetricDataList;
                net.sf.json.JSONObject jsonGraphObj;
                ArrayList<MetricData> prevMetricDataList;
                if (resonseObj.get("previousTestDataMap") != null && (prevMetricDataList = this.parsePreviousAndBaseLineData(jsonGraphObj = (net.sf.json.JSONObject)resonseObj.get("previousTestDataMap"), freq, "Previous Test Run")) != null) {
                    logger.log(Level.FINE, "Cavisson-Plugin|Setting previous test data in metric container = " + prevMetricDataList);
                    metricDataContainer.setMetricPreviousDataList(prevMetricDataList);
                }
                if (resonseObj.get("baseLineTestDataMap") != null && (baseLineMetricDataList = this.parsePreviousAndBaseLineData(jsonGraphObj = (net.sf.json.JSONObject)resonseObj.get("baseLineTestDataMap"), freq, "Base Line Test Run")) != null) {
                    logger.log(Level.FINE, "Cavisson-Plugin|Setting baseline test data in metric container = " + baseLineMetricDataList);
                    metricDataContainer.setMetricBaseLineDataList(baseLineMetricDataList);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Error in parsing metrics stats");
            logger.log(Level.SEVERE, "Cavisson-Plugin|Metric Data:" + e);
            logger.log(Level.SEVERE, "Cavisson-Plugin|---" + e.getMessage());
            return null;
        }
        logger.log(Level.FINE, "Cavisson-Plugin|Metric Data:" + metricDataContainer);
        return metricDataContainer;
    }

    private TestReport metricDataForVectorGroups(net.sf.json.JSONObject vectorGroups, TestReport testReport, net.sf.json.JSONObject jsonTestReport) {
        try {
            logger.log(Level.FINE, "Cavisson-Plugin|metricDataForVectorGroups() called.");
            String previousTestRun = jsonTestReport.getString("Previous Test Run");
            String baseLineTestRun = jsonTestReport.getString("Baseline Test Run");
            String initialTestRun = jsonTestReport.getString("Initial Test Run");
            ArrayList<MetricInfo> arr = new ArrayList<MetricInfo>();
            Iterator keys = vectorGroups.keys();
            while (keys.hasNext()) {
                String groupName = (String)keys.next();
                MetricInfo info = new MetricInfo();
                info.setGroupName(groupName);
                net.sf.json.JSONObject groupInfo = (net.sf.json.JSONObject)vectorGroups.get(groupName);
                JSONArray metricListForVector = (JSONArray)groupInfo.get("MetricName");
                JSONArray vectorListForVector = (JSONArray)groupInfo.get("vector List");
                net.sf.json.JSONObject metricInfoForVector = (net.sf.json.JSONObject)groupInfo.get("Metric Info");
                net.sf.json.JSONObject linkInfo = (net.sf.json.JSONObject)groupInfo.get("link");
                ArrayList<String> vectorList = new ArrayList<String>();
                ArrayList<ScalarVal> arrForVectorinfo = new ArrayList<ScalarVal>();
                for (int i = 0; i < vectorListForVector.size(); ++i) {
                    vectorList.add((String)vectorListForVector.get(i));
                }
                info.setVectorList(vectorList);
                ArrayList<MetricLinkInfo> metricLinkInfo = new ArrayList<MetricLinkInfo>();
                for (int i = 0; i < vectorListForVector.size(); ++i) {
                    String vectorNameVec = (String)vectorListForVector.get(i);
                    logger.log(Level.FINE, "Cavisson-Plugin|vector name--" + vectorNameVec);
                    for (int j = 0; j < metricListForVector.size(); ++j) {
                        String metricNameVec = (String)metricListForVector.get(j);
                        logger.log(Level.FINE, "Cavisson-Plugin|metric name--" + metricNameVec);
                        if (!metricInfoForVector.containsKey((Object)vectorNameVec)) continue;
                        JSONArray vectorInfo = (JSONArray)metricInfoForVector.get(vectorNameVec);
                        for (int k = 0; k < vectorInfo.size(); ++k) {
                            net.sf.json.JSONObject metricVecInfo = (net.sf.json.JSONObject)vectorInfo.get(k);
                            if (!metricVecInfo.containsKey((Object)metricNameVec)) continue;
                            net.sf.json.JSONObject metricInfoFinal = (net.sf.json.JSONObject)metricVecInfo.get(metricNameVec);
                            ScalarVal finalInfoForVector = new ScalarVal();
                            String Op = (String)metricInfoFinal.get("Operator");
                            String prev = (String)metricInfoFinal.get("Prev Test Value ");
                            String Product = (String)metricInfoFinal.get("Prod");
                            String baselineValue = (String)metricInfoFinal.get("Baseline Value ");
                            String transStatus = (String)metricInfoFinal.get("Transaction Status");
                            String transTooltip = (String)metricInfoFinal.get("Transaction Tooltip");
                            String transBGcolor = (String)metricInfoFinal.get("Transaction BGcolor");
                            String Value = (String)metricInfoFinal.get("Value");
                            String linkss = (String)metricInfoFinal.get("Trend Link");
                            String SLA = (String)metricInfoFinal.get("SLA");
                            String initialValue = (String)metricInfoFinal.get("Initial Value ");
                            String Stress = (String)metricInfoFinal.get("Stress");
                            finalInfoForVector.setOperator(Op);
                            finalInfoForVector.setPrevTestValue(prev);
                            finalInfoForVector.setProd(Product);
                            finalInfoForVector.setBaselineValue(baselineValue);
                            finalInfoForVector.setTransactionStatus(transStatus);
                            finalInfoForVector.setTransactionTooltip(transTooltip);
                            finalInfoForVector.setTransactionBGcolor(transBGcolor);
                            finalInfoForVector.setValue(Value);
                            finalInfoForVector.setTrendLink(linkss);
                            finalInfoForVector.setSLA(SLA);
                            finalInfoForVector.setInitialValue(initialValue);
                            finalInfoForVector.setStress(Stress);
                            finalInfoForVector.setMetricName(metricNameVec);
                            finalInfoForVector.setVectorName(vectorNameVec);
                            arrForVectorinfo.add(finalInfoForVector);
                        }
                    }
                    MetricLinkInfo link = new MetricLinkInfo();
                    link.setVectorName(vectorNameVec);
                    String lnk = (String)linkInfo.get(vectorNameVec);
                    link.setLink(lnk);
                    metricLinkInfo.add(link);
                }
                info.setMetricLink(metricLinkInfo);
                info.setGroupInfo(arrForVectorinfo);
                ArrayList<MetricVal> vectorArrFinal = new ArrayList<MetricVal>();
                String vectorVal = vectorList.get(0);
                for (int i = 0; i < metricListForVector.size(); ++i) {
                    String metrcNames = (String)metricListForVector.get(i);
                    int counts = 0;
                    MetricVal metrVal = new MetricVal();
                    JSONArray metricArrSec = (JSONArray)metricInfoForVector.get(vectorVal);
                    for (int j = 0; j < metricArrSec.size(); ++j) {
                        String trans;
                        String st;
                        net.sf.json.JSONObject metricObj = (net.sf.json.JSONObject)metricArrSec.get(j);
                        if (!metricObj.containsKey((Object)metrcNames)) continue;
                        net.sf.json.JSONObject finalMetric = (net.sf.json.JSONObject)metricObj.get(metrcNames);
                        ArrayList<String> headerForVector = new ArrayList<String>();
                        headerForVector.add("SLA");
                        String pr = (String)finalMetric.get("Prod");
                        if (!pr.equals("0.0") && !pr.equals("-")) {
                            ++counts;
                            headerForVector.add("Prod");
                            metrVal.setProd(true);
                        }
                        if (!(st = (String)finalMetric.get("Stress")).equals("0.0") && !st.equals("-")) {
                            ++counts;
                            headerForVector.add("Stress");
                            metrVal.setStress(true);
                        }
                        if (!baseLineTestRun.equals("-1")) {
                            ++counts;
                            headerForVector.add("Baseline TR");
                        }
                        if (!initialTestRun.equals("-1")) {
                            ++counts;
                            headerForVector.add("Initial TR");
                        }
                        if (!previousTestRun.equals("-1")) {
                            ++counts;
                            headerForVector.add("Previous TR");
                        }
                        if (!(trans = (String)finalMetric.get("Transaction Status")).equals("-1")) {
                            ++counts;
                            headerForVector.add("Success (%)");
                            metrVal.setTrans(true);
                        }
                        metrVal.setCountForBenchmark(++counts);
                        int countForMetrices = counts + 2;
                        metrVal.setCountForMetrices(countForMetrices);
                        metrVal.setHeadersForTrans(headerForVector);
                        metrVal.setNameOfMetric(metrcNames);
                    }
                    vectorArrFinal.add(metrVal);
                }
                info.setVectorObj(vectorArrFinal);
                arr.add(info);
            }
            testReport.setVectorValues(arr);
            return testReport;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Error in getting metric data for vector Group");
            logger.log(Level.SEVERE, "Cavisson-Plugin|Metric Data:" + e);
            logger.log(Level.SEVERE, "Cavisson-Plugin|---" + e.getMessage());
            return null;
        }
    }

    private TestReport metricDataForTrans(net.sf.json.JSONObject transGroup, TestReport testReport, net.sf.json.JSONObject jsonTestReport) {
        try {
            net.sf.json.JSONObject metricObj;
            logger.log(Level.INFO, "Cavisson-Plugin|metricDataForTrans() called.");
            String previousTestRun = jsonTestReport.getString("Previous Test Run");
            String baseLineTestRun = jsonTestReport.getString("Baseline Test Run");
            String initialTestRun = jsonTestReport.getString("Initial Test Run");
            JSONArray metricNamesForTrans = (JSONArray)transGroup.get("MetricName");
            JSONArray vectorListForTrans = (JSONArray)transGroup.get("vector List");
            net.sf.json.JSONObject metricInfoForTrans = (net.sf.json.JSONObject)transGroup.get("Metric Info");
            net.sf.json.JSONObject linkObj = (net.sf.json.JSONObject)transGroup.get("link");
            boolean prodCount = false;
            boolean stressCount = false;
            ArrayList<ScalarVal> transArr = new ArrayList<ScalarVal>();
            ArrayList<String> vectorForTrans = new ArrayList<String>();
            for (int i = 0; i < vectorListForTrans.size(); ++i) {
                vectorForTrans.add((String)vectorListForTrans.get(i));
            }
            testReport.setVecList(vectorForTrans);
            ArrayList<MetricLinkInfo> merticLink = new ArrayList<MetricLinkInfo>();
            for (int i = 0; i < vectorListForTrans.size(); ++i) {
                String vectorNameTrans = (String)vectorListForTrans.get(i);
                for (int j = 0; j < metricNamesForTrans.size(); ++j) {
                    String metricNameTranss = (String)metricNamesForTrans.get(j);
                    ScalarVal transValue = new ScalarVal();
                    if (metricInfoForTrans.containsKey((Object)vectorNameTrans)) {
                        JSONArray metricArr = (JSONArray)metricInfoForTrans.get(vectorNameTrans);
                        for (int k = 0; k < metricArr.size(); ++k) {
                            net.sf.json.JSONObject newMetric = (net.sf.json.JSONObject)metricArr.get(k);
                            if (!newMetric.containsKey((Object)metricNameTranss)) continue;
                            metricObj = (net.sf.json.JSONObject)newMetric.get(metricNameTranss);
                            String Oper = (String)metricObj.get("Operator");
                            String prevTest = (String)metricObj.get("Prev Test Value ");
                            String Production = (String)metricObj.get("Prod");
                            String baselineVal = (String)metricObj.get("Baseline Value ");
                            String transStatus = (String)metricObj.get("Transaction Status");
                            String transactionTool = (String)metricObj.get("Transaction Tooltip");
                            String transactionBG = (String)metricObj.get("Transaction BGcolor");
                            String Val = (String)metricObj.get("Value");
                            String links = (String)metricObj.get("Trend Link");
                            String sla = (String)metricObj.get("SLA");
                            String initialVal = (String)metricObj.get("Initial Value ");
                            String stress = (String)metricObj.get("Stress");
                            transValue.setOperator(Oper);
                            transValue.setPrevTestValue(prevTest);
                            transValue.setProd(Production);
                            transValue.setBaselineValue(baselineVal);
                            transValue.setTransactionStatus(transStatus);
                            transValue.setTransactionTooltip(transactionTool);
                            transValue.setTransactionBGcolor(transactionBG);
                            transValue.setValue(Val);
                            transValue.setTrendLink(links);
                            transValue.setSLA(sla);
                            transValue.setInitialValue(initialVal);
                            transValue.setStress(stress);
                            transValue.setMetricName(metricNameTranss);
                            transValue.setVectorName(vectorNameTrans);
                        }
                    }
                    transArr.add(transValue);
                }
                MetricLinkInfo linkInfo = new MetricLinkInfo();
                linkInfo.setVectorName(vectorNameTrans);
                String link = (String)linkObj.get(vectorNameTrans);
                linkInfo.setLink(link);
                merticLink.add(linkInfo);
            }
            testReport.setTransactionStats(transArr);
            testReport.setTransMetricLink(merticLink);
            ArrayList<MetricVal> metricArrFinal = new ArrayList<MetricVal>();
            String vectorAny = vectorForTrans.get(0);
            for (int i = 0; i < metricNamesForTrans.size(); ++i) {
                String metrcNames = (String)metricNamesForTrans.get(i);
                int count = 0;
                MetricVal metrVal = new MetricVal();
                JSONArray metricArrSec = (JSONArray)metricInfoForTrans.get(vectorAny);
                for (int j = 0; j < metricArrSec.size(); ++j) {
                    String transactionStatus;
                    String stress;
                    metricObj = (net.sf.json.JSONObject)metricArrSec.get(j);
                    if (!metricObj.containsKey((Object)metrcNames)) continue;
                    net.sf.json.JSONObject finalMetric = (net.sf.json.JSONObject)metricObj.get(metrcNames);
                    ArrayList<String> transHeader = new ArrayList<String>();
                    transHeader.add("SLA");
                    String prod = (String)finalMetric.get("Prod");
                    if (!prod.equals("0.0") && !prod.equals("-")) {
                        ++count;
                        transHeader.add("Prod");
                        metrVal.setProd(true);
                    }
                    if (!(stress = (String)finalMetric.get("Stress")).equals("0.0") && !stress.equals("-")) {
                        ++count;
                        transHeader.add("Stress");
                        metrVal.setStress(true);
                    }
                    if (!baseLineTestRun.equals("-1")) {
                        ++count;
                        transHeader.add("Baseline TR");
                    }
                    if (!initialTestRun.equals("-1")) {
                        ++count;
                        transHeader.add("Initial TR");
                    }
                    if (!previousTestRun.equals("-1")) {
                        ++count;
                        transHeader.add("Previous TR");
                    }
                    if (!(transactionStatus = (String)finalMetric.get("Transaction Status")).equals("-1")) {
                        ++count;
                        transHeader.add("Success (%)");
                        metrVal.setTrans(true);
                    }
                    metrVal.setCountForBenchmark(++count);
                    int countForMetrices = count + 2;
                    metrVal.setCountForMetrices(countForMetrices);
                    metrVal.setHeadersForTrans(transHeader);
                    metrVal.setNameOfMetric(metrcNames);
                }
                metricArrFinal.add(metrVal);
            }
            testReport.setMetricValues(metricArrFinal);
            return testReport;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Error in getting metric data");
            logger.log(Level.SEVERE, "Cavisson-Plugin|Metric Data:" + e);
            logger.log(Level.SEVERE, "Cavisson-Plugin|---" + e.getMessage());
            return null;
        }
    }

    private TestReport metricDataForScalar(net.sf.json.JSONObject scalarGroups, TestReport testReport, net.sf.json.JSONObject jsonTestReport) {
        try {
            logger.log(Level.FINE, "Cavisson-Plugin|metricDataForScalar() called.");
            String previousTestRun = jsonTestReport.getString("Previous Test Run");
            String baseLineTestRun = jsonTestReport.getString("Baseline Test Run");
            String initialTestRun = jsonTestReport.getString("Initial Test Run");
            JSONArray metricNames = (JSONArray)scalarGroups.get("MetricName");
            net.sf.json.JSONObject metricGrp = (net.sf.json.JSONObject)scalarGroups.get("Metric Info");
            net.sf.json.JSONObject metricLink = (net.sf.json.JSONObject)scalarGroups.get("link");
            ArrayList<ScalarVal> scalarArr = new ArrayList<ScalarVal>();
            int countForProd = 0;
            int countForStress = 0;
            int countForTrans = 0;
            ArrayList<String> scalarHeader = new ArrayList<String>();
            for (int i = 0; i < metricNames.size(); ++i) {
                String name = (String)metricNames.get(i);
                if (!metricGrp.containsKey((Object)name)) continue;
                net.sf.json.JSONObject scalarVal = (net.sf.json.JSONObject)metricGrp.get(name);
                String Operator = (String)scalarVal.get("Operator");
                String preValue = (String)scalarVal.get("Prev Test Value ");
                String Prod = (String)scalarVal.get("Prod");
                String baselineValue = (String)scalarVal.get("Baseline Value ");
                String transactionStatus = (String)scalarVal.get("Transaction Status");
                String transactionTooltip = (String)scalarVal.get("Transaction Tooltip");
                String transactionBGcolor = (String)scalarVal.get("Transaction BGcolor");
                String Value = (String)scalarVal.get("Value");
                String trendLink = (String)scalarVal.get("Trend Link");
                String link = (String)metricLink.get(name);
                String SLA = (String)scalarVal.get("SLA");
                String initialValue = (String)scalarVal.get("Initial Value ");
                String Stress = (String)scalarVal.get("Stress");
                logger.log(Level.FINE, "Cavisson-Plugin|Prev Test Value------ " + preValue);
                if (!Prod.equals("0.0") && !Prod.equals("-1")) {
                    ++countForProd;
                }
                if (!Stress.equals("0.0") && !Stress.equals("-1")) {
                    ++countForStress;
                }
                if (!transactionStatus.equals("-1")) {
                    ++countForTrans;
                }
                ScalarVal scalarValue = new ScalarVal();
                scalarValue.setOperator(Operator);
                scalarValue.setPrevTestValue(preValue);
                scalarValue.setProd(Prod);
                scalarValue.setBaselineValue(baselineValue);
                scalarValue.setTransactionStatus(transactionStatus);
                scalarValue.setTransactionTooltip(transactionTooltip);
                scalarValue.setTransactionBGcolor(transactionBGcolor);
                scalarValue.setValue(Value);
                scalarValue.setLink(link);
                scalarValue.setSLA(SLA);
                scalarValue.setInitialValue(initialValue);
                scalarValue.setStress(Stress);
                scalarValue.setMetricName(name);
                scalarValue.setTrendLink(trendLink);
                scalarArr.add(scalarValue);
            }
            testReport.setScalarGroups(scalarArr);
            scalarHeader.add("SLA");
            if (countForProd != 0) {
                scalarHeader.add("Prod");
            }
            if (countForStress != 0) {
                scalarHeader.add("Stress");
            }
            if (!baseLineTestRun.equals("-1")) {
                scalarHeader.add("Baseline TR");
            }
            if (!initialTestRun.equals("-1")) {
                scalarHeader.add("Initial TR");
            }
            if (!previousTestRun.equals("-1")) {
                scalarHeader.add("Previous TR");
            }
            if (countForTrans != 0) {
                scalarHeader.add("Success(%)");
            }
            scalarHeader.add("Current");
            scalarHeader.add("Trend");
            scalarHeader.add("Action");
            testReport.setScalarHeaders(scalarHeader);
            return testReport;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Error in parsing previous or baseline metrics stats");
            logger.log(Level.SEVERE, "Cavisson-Plugin|---" + ex.getMessage());
            return null;
        }
    }

    private ArrayList<MetricData> parsePreviousAndBaseLineData(net.sf.json.JSONObject jsonGraphData, int freq, String type) {
        try {
            logger.log(Level.FINE, "Cavisson-Plugin|method called for type = " + type);
            ArrayList<MetricData> listData = new ArrayList<MetricData>();
            Set keySet = jsonGraphData.keySet();
            if (keySet.size() < 1) {
                logger.log(Level.FINE, "Cavisson-Plugin|Graph Metrics is not available for " + type);
                return null;
            }
            for (Object keyValue : keySet) {
                if (jsonGraphData.get(keyValue) == null) {
                    return null;
                }
                net.sf.json.JSONObject graphWithDataJson = (net.sf.json.JSONObject)jsonGraphData.get(keyValue);
                Set keys = graphWithDataJson.keySet();
                for (String key : keys) {
                    MetricData metricData = new MetricData();
                    net.sf.json.JSONObject graphJsonObj = (net.sf.json.JSONObject)graphWithDataJson.get(key);
                    String graphName = (String)graphJsonObj.get("graphMetricPath");
                    metricData.setMetricPath(graphName.substring(graphName.indexOf("|") + 1));
                    metricData.setFrequency(String.valueOf(freq));
                    JSONArray jsonArray = (JSONArray)graphJsonObj.get("graphMetricValues");
                    ArrayList<MetricValues> list = new ArrayList<MetricValues>();
                    for (Object jsonArray1 : jsonArray) {
                        MetricValues values = new MetricValues();
                        net.sf.json.JSONObject graphValues = (net.sf.json.JSONObject)jsonArray1;
                        String currVal = String.valueOf(graphValues.get("currentValue"));
                        String maxVal = String.valueOf(graphValues.get("maxValue"));
                        String minVal = String.valueOf(graphValues.get("minValue"));
                        String avg = String.valueOf(graphValues.get("avgValue"));
                        long timeStamp = (Long)graphValues.get("timeStamp");
                        values.setValue((Double)graphValues.get("currentValue"));
                        values.setMax((Double)graphValues.get("maxValue"));
                        values.setMin(this.getMinForMetric((Double)graphValues.get("minValue")));
                        values.setStartTimeInMillis(timeStamp);
                        list.add(values);
                    }
                    metricData.setMetricValues(list);
                    listData.add(metricData);
                }
            }
            return listData;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Error in parsing previous or baseline metrics stats");
            logger.log(Level.SEVERE, "Cavisson-Plugin|---" + ex.getMessage());
            return null;
        }
    }

    private double getMinForMetric(double metricValue) {
        if (metricValue == Double.MAX_VALUE) {
            return 0.0;
        }
        return metricValue;
    }

    public String getUrlString() {
        String urlAddrs = "";
        try {
            String[] str = this.URLConnectionString.split(":");
            if (str.length > 2) {
                urlAddrs = str[0] + ":" + str[1];
                if (str[2].contains("/")) {
                    String[] value = str[2].split("/");
                    urlAddrs = urlAddrs + ":" + value[0];
                } else {
                    urlAddrs = urlAddrs + ":" + str[2];
                }
            } else {
                urlAddrs = this.URLConnectionString;
            }
            if (urlAddrs.endsWith("/")) {
                urlAddrs = urlAddrs.substring(0, urlAddrs.length() - 1);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Error in getting url string ");
            return this.URLConnectionString.substring(0, this.URLConnectionString.lastIndexOf("/"));
        }
        return urlAddrs;
    }

    public void updateNCDataFile(FilePath fp, String scriptName, String username, String profile, PrintStream consoleLogger) {
        try {
            String str = this.getUrlString();
            URL url = new URL(str + "/ProductUI/productSummary/jenkinsService/updateDataFiles?scriptName=" + scriptName + "&username=" + username + "&profile=" + profile);
            String Boundary = UUID.randomUUID().toString();
            URLConnection connect = NetStormConnectionManager.getConnections(url, this.isSkipSSLCertValidation(), this.isSkipSSLHostValidation());
            connect.setConnectTimeout(0);
            connect.setReadTimeout(0);
            ((HttpURLConnection)connect).setRequestMethod("POST");
            connect.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + Boundary);
            connect.setDoOutput(true);
            DataOutputStream out = new DataOutputStream(connect.getOutputStream());
            out.writeUTF("--" + Boundary + "\r\nContent-Disposition: form-data; name=\"file\"; filename=" + fp.getName() + "\r\nContent-Type: application/octet-stream; charset=utf-8\r\n\r\n");
            InputStream in = fp.read();
            byte[] b = new byte[1024];
            int l = 0;
            while ((l = in.read(b)) != -1) {
                out.write(b, 0, l);
            }
            out.writeUTF("\r\n--" + Boundary + "--\r\n");
            out.flush();
            out.close();
            logger.log(Level.FINE, "Cavisson-Plugin|Staus code = " + ((HttpURLConnection)connect).getResponseCode());
            if (((HttpURLConnection)connect).getResponseCode() == 200) {
                BufferedReader br = new BufferedReader(new InputStreamReader(connect.getInputStream()));
                net.sf.json.JSONObject output = (net.sf.json.JSONObject)JSONSerializer.toJSON((Object)br.readLine());
                String mssg = (String)output.get("Message");
                consoleLogger.println(mssg);
            } else {
                consoleLogger.println("Error in uploading data files.");
            }
            if (fp.exists()) {
                fp.delete();
                logger.log(Level.INFO, "Cavisson-Plugin|Uploaded file deleted successfully.");
            }
        }
        catch (InterruptedException ie) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception. IOException -", ie);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            consoleLogger.println("Error in uploading data files.");
        }
    }

    public JSONArray getScriptList(String profile, String scenario, String project, String subProject, String testMode) {
        try {
            JSONArray scripts = new JSONArray();
            String str = this.getUrlString();
            URL url = new URL(str + "/ProductUI/productSummary/ScenarioWebService/getScenarioScriptList?scenName=" + scenario + "&userName=" + this.username + "&profile=" + profile + "&project=" + project + "&subproject=" + subProject + "&testMode=" + testMode);
            URLConnection conn = NetStormConnectionManager.getConnections(url, this.isSkipSSLCertValidation(), this.isSkipSSLHostValidation());
            ((HttpURLConnection)conn).setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Content-Type", "application/json");
            if (((HttpURLConnection)conn).getResponseCode() != 200) {
                logger.log(Level.FINE, "Cavisson-Plugin|getting error in fetching script list.");
                scripts = new JSONArray();
                return scripts;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder stb = new StringBuilder();
            String response = null;
            while ((response = br.readLine()) != null) {
                stb.append(response);
            }
            scripts = JSONArray.fromObject((Object)stb.toString());
            logger.log(Level.FINE, "Cavisson-Plugin|scripts size - " + scripts.size());
            return scripts;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Exception in getting script list - " + e);
            return null;
        }
    }

    public JSONArray getPageList(String script, String scenario, String profile, String testMode, String project, String subProjects) {
        try {
            JSONArray scripts = new JSONArray();
            String str = this.getUrlString();
            URL url = new URL(str + "/ProductUI/productSummary/ScenarioWebService/getPageListByScriptNameJenkins?scenMode=0&scenName=" + scenario + "&userName=" + this.username + "&scriptName=" + script + "&profile=" + profile + "&project=" + project + "&subproject=" + subProjects + "&testMode=" + testMode);
            URLConnection conn = NetStormConnectionManager.getConnections(url, this.isSkipSSLCertValidation(), this.isSkipSSLHostValidation());
            ((HttpURLConnection)conn).setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Content-Type", "application/json");
            if (((HttpURLConnection)conn).getResponseCode() != 200) {
                logger.log(Level.FINE, "Cavisson-Plugin|getting error in fetching page list.");
                scripts = new JSONArray();
                return scripts;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder stb = new StringBuilder();
            String response = null;
            while ((response = br.readLine()) != null) {
                stb.append(response);
            }
            scripts = JSONArray.fromObject((Object)stb.toString());
            logger.log(Level.FINE, "Cavisson-Plugin|scripts size - " + scripts.size());
            return scripts;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cavisson-Plugin|Exception in getting page list - " + e);
            return null;
        }
    }

    public void getFuture(int timeout, Future future) {
        try {
            future.get(timeout, TimeUnit.MINUTES);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        String[] METRIC_PATHS = new String[]{"Transactions Started/Second", "Transactions Completed/Second", "Transactions Successful/Second", "Average Transaction Response Time (Secs)", "Transactions Completed", "Transactions Success"};
        int[] graphId = new int[]{7, 8, 9, 3, 5, 6};
        int[] groupId = new int[]{6, 6, 6, 6, 6, 6};
    }

    private static enum OperationType {
        START_TEST,
        AUTHENTICATE_USER,
        GETDATA,
        GETPROJECT,
        GETSUBPROJECT,
        GETSCENARIOS;

    }

    private static enum JSONKeys {
        URLCONNECTION("URLConnectionString"),
        USERNAME("username"),
        PASSWORD("password"),
        PROJECT("project"),
        SUBPROJECT("subproject"),
        OPERATION_TYPE("Operation"),
        SCENARIO("scenario"),
        STATUS("Status"),
        TEST_RUN("TESTRUN"),
        TESTMODE("testmode"),
        GETPROJECT("PROJECTLIST"),
        GETSUBPROJECT("SUBPROJECTLIST"),
        GETSCENARIOS("SCENARIOLIST"),
        BASELINE_TYPE("baselineType"),
        REPORT_STATUS("reportStatus"),
        ERROR_MSG("errMsg"),
        CHECK_RULE("checkRule");

        private final String value;

        private JSONKeys(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

