/*
 * Decompiled with CFR 0.152.
 */
package com.cavisson.jenkins;

import com.cavisson.jenkins.FieldValidator;
import com.cavisson.jenkins.Messages;
import com.cavisson.jenkins.NetStormConnectionManager;
import com.cavisson.jenkins.NetStormStopAction;
import com.cavisson.jenkins.NetStormStopThread;
import com.cavisson.jenkins.ParameterDTO;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.verb.POST;

public class NetStormBuilder
extends Builder
implements SimpleBuildStep {
    private final String project;
    private final String subProject;
    private final String scenario;
    private final String URLConnectionString;
    private final String username;
    private final Secret password;
    private final String testMode;
    private final String defaultTestMode = "true";
    private static final transient Logger logger = Logger.getLogger(NetStormBuilder.class.getName());
    private final String baselineType;
    private final String pollInterval;
    private static String testRunNumber = "-1";
    private static String testCycleNumber = "";
    private static final String fileName = "jenkins_check_rule_for_NS.txt";
    private String protocol = "";
    private String repoIp = "";
    private String repoPort = "";
    private String repoPath = "";
    private String repoUsername = "";
    private String repoPassword;
    private String gitPull = "";
    String uploadFileName = "";
    private String profile = "";
    private String script = "";
    private String page = "";
    private String advanceSett = "";
    private String urlHeader = "";
    private String hiddenBox = "";
    private String testProfileBox = "";
    private final boolean generateReport;
    Map<String, String> envVarMap = null;
    private boolean doNotWaitForTestCompletion = false;
    private String totalusers = "";
    private String rampUpSec = "";
    private String rampupmin = "";
    private String rampuphour = "";
    private String duration = "";
    private String serverhost = "";
    private String sla = "";
    private String testName = "";
    private String scriptPath = "";
    private String rampupDuration = "";
    private String emailid = "";
    private String emailidCC = "";
    private String emailidBcc = "";
    private String testsuite = "";
    private String dataDir = "";
    private String checkRuleFileUpload = "";
    private boolean fileUpload = false;
    private boolean skipSSLCertCheck = false;
    private boolean skipSSLHostCheck = false;
    private static String ErrorMsg = "Error";
    NetStormConnectionManager netstormConnectionManger = null;
    List<String> testsuiteList = new ArrayList<String>();
    HashMap<String, ParameterDTO> testsuiteParameterMap = new HashMap();

    public NetStormBuilder(String URLConnectionString, String username, Object password, String project, String subProject, String scenario, String testMode, String baselineType, String pollInterval, String protocol, String repoIp, String repoPort, String repoPath, String repoUsername, String repoPassword, String profile, String script, String page, String advanceSett, String urlHeader, String hiddenBox, String gitPull, boolean generateReport, String testProfileBox) {
        logger.log(Level.FINE, "Cavisson-Plugin|constructor called.");
        this.project = project;
        this.subProject = subProject;
        this.scenario = scenario;
        this.URLConnectionString = URLConnectionString;
        this.username = username;
        this.password = password instanceof Secret ? (Secret)password : (StringUtils.isEmpty((String)password.toString()) ? null : Secret.fromString((String)password.toString()));
        this.testMode = testMode;
        this.baselineType = baselineType;
        this.pollInterval = pollInterval;
        this.protocol = protocol;
        this.repoIp = repoIp;
        this.repoPort = repoPort;
        this.repoPath = repoPath;
        this.repoUsername = repoUsername;
        this.repoPassword = repoPassword;
        this.profile = profile;
        this.gitPull = gitPull;
        this.script = script;
        this.page = page;
        this.advanceSett = advanceSett;
        this.urlHeader = urlHeader;
        this.hiddenBox = hiddenBox;
        this.testProfileBox = testProfileBox;
        this.generateReport = generateReport;
    }

    public NetStormBuilder(String URLConnectionString, String username, Object password, String project, String subProject, String scenario, String testMode, String baselineType, String pollInterval, String protocol, String repoIp, String repoPort, String repoPath, String repoUsername, String repoPassword, String profile, String script, String page, String advanceSett, String urlHeader, String hiddenBox, String gitPull, boolean generateReport, Map<String, String> envVarMap, boolean doNotWaitForTestCompletion, String testProfileBox) {
        logger.log(Level.FINE, "Cavisson-Plugin|Constructor called.");
        this.project = project;
        this.subProject = subProject;
        this.scenario = scenario;
        this.URLConnectionString = URLConnectionString;
        this.username = username;
        this.password = password instanceof Secret ? (Secret)password : (StringUtils.isEmpty((String)password.toString()) ? null : Secret.fromString((String)password.toString()));
        this.testMode = testMode;
        this.baselineType = baselineType;
        this.pollInterval = pollInterval;
        this.protocol = protocol;
        this.repoIp = repoIp;
        this.repoPort = repoPort;
        this.repoPath = repoPath;
        this.repoUsername = repoUsername;
        this.repoPassword = repoPassword;
        this.profile = profile;
        this.gitPull = gitPull;
        this.script = script;
        this.page = page;
        this.advanceSett = advanceSett;
        this.urlHeader = urlHeader;
        this.hiddenBox = hiddenBox;
        this.testProfileBox = testProfileBox;
        this.generateReport = generateReport;
        this.envVarMap = envVarMap;
        this.doNotWaitForTestCompletion = doNotWaitForTestCompletion;
    }

    @DataBoundConstructor
    public NetStormBuilder(String URLConnectionString, String username, Object password, String project, String subProject, String scenario, String testMode, String baselineType, String pollInterval, String protocol, String repoIp, String repoPort, String repoPath, String repoUsername, String repoPassword, String profile, String script, String page, String advanceSett, String urlHeader, String hiddenBox, String gitPull, boolean generateReport, String testProfileBox, boolean doNotWaitForTestCompletion, String totalusers, String rampUpSec, String rampupmin, String rampuphour, String duration, String serverhost, String sla, String testName, String scriptPath, String rampupDuration, String emailid, String emailidCC, String emailidBcc, String testsuite, String dataDir, String checkRuleFileUpload, boolean skipSSLCertCheck, boolean skipSSLHostCheck) {
        logger.log(Level.FINE, "Cavisson-Plugin|Constructor called.");
        this.project = project;
        this.subProject = subProject;
        this.scenario = scenario;
        this.URLConnectionString = URLConnectionString;
        this.username = username;
        this.password = password instanceof Secret ? (Secret)password : (StringUtils.isEmpty((String)password.toString()) ? null : Secret.fromString((String)password.toString()));
        this.testMode = testMode;
        this.baselineType = baselineType;
        this.pollInterval = pollInterval;
        this.protocol = protocol;
        this.repoIp = repoIp;
        this.repoPort = repoPort;
        this.repoPath = repoPath;
        this.repoUsername = repoUsername;
        this.repoPassword = repoPassword;
        this.profile = profile;
        this.gitPull = gitPull;
        this.script = script;
        this.page = page;
        this.advanceSett = advanceSett;
        this.urlHeader = urlHeader;
        this.hiddenBox = hiddenBox;
        this.testProfileBox = testProfileBox;
        this.generateReport = generateReport;
        this.doNotWaitForTestCompletion = doNotWaitForTestCompletion;
        this.totalusers = totalusers;
        this.rampUpSec = rampUpSec;
        this.rampupmin = rampupmin;
        this.rampuphour = rampuphour;
        this.duration = duration;
        this.serverhost = serverhost;
        this.sla = sla;
        this.testName = testName;
        this.scriptPath = scriptPath;
        this.rampupDuration = rampupDuration;
        this.emailid = emailid;
        this.emailidCC = emailidCC;
        this.emailidBcc = emailidBcc;
        this.testsuite = testsuite;
        this.dataDir = dataDir;
        this.checkRuleFileUpload = checkRuleFileUpload;
        this.skipSSLCertCheck = skipSSLCertCheck;
        this.skipSSLHostCheck = skipSSLHostCheck;
        this.setParametersValue();
    }

    public NetStormBuilder(String URLConnectionString, String username, Object password, String project, String subProject, String scenario, String testMode, String baselineType, String pollInterval, String profile, boolean generateReport) {
        logger.log(Level.FINE, "Cavisson-Plugin|Constructor called.");
        this.project = project;
        this.subProject = subProject;
        this.scenario = scenario;
        this.URLConnectionString = URLConnectionString;
        this.username = username;
        this.password = password instanceof Secret ? (Secret)password : (StringUtils.isEmpty((String)password.toString()) ? null : Secret.fromString((String)password.toString()));
        this.testMode = testMode;
        this.baselineType = baselineType;
        this.pollInterval = pollInterval;
        this.profile = profile;
        this.generateReport = generateReport;
    }

    static String getTestRunNumber() {
        return testRunNumber;
    }

    public static void setTestRunNumber(String testrunNumber) {
        testRunNumber = testrunNumber;
    }

    public static String getTestCycleNumber() {
        return testCycleNumber;
    }

    public String getProject() {
        return this.project;
    }

    public String getDefaultTestMode() {
        return "true";
    }

    public String getSubProject() {
        return this.subProject;
    }

    public String getScenario() {
        return this.scenario;
    }

    public String getURLConnectionString() {
        return this.URLConnectionString;
    }

    public String getUsername() {
        return this.username;
    }

    public Secret getPassword() {
        return this.password;
    }

    public String getTestMode() {
        return this.testMode;
    }

    public String getBaselineType() {
        return this.baselineType;
    }

    public String getPollInterval() {
        return this.pollInterval;
    }

    @DataBoundSetter
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @DataBoundSetter
    public void setRepoIp(String repoIp) {
        this.repoIp = repoIp;
    }

    @DataBoundSetter
    public void setRepoPort(String repoPort) {
        this.repoPort = repoPort;
    }

    @DataBoundSetter
    public void setRepoPath(String repoPath) {
        this.repoPath = repoPath;
    }

    @DataBoundSetter
    public void setRepoUsername(String repoUsername) {
        this.repoUsername = repoUsername;
    }

    @DataBoundSetter
    public void setRepoPassword(String repoPassword) {
        this.repoPassword = repoPassword;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getRepoIp() {
        return this.repoIp;
    }

    public String getRepoPort() {
        return this.repoPort;
    }

    public String getRepoPath() {
        return this.repoPath;
    }

    public String getRepoUsername() {
        return this.repoUsername;
    }

    public String getRepoPassword() {
        return this.repoPassword;
    }

    public String getGitPull() {
        return this.gitPull;
    }

    @DataBoundSetter
    public void setGitPull(String gitPull) {
        this.gitPull = gitPull;
    }

    public String getAdvanceSett() {
        return this.advanceSett;
    }

    @DataBoundSetter
    public void setAdvanceSett(String advanceSett) {
        this.advanceSett = advanceSett;
    }

    public String getScript() {
        return this.script;
    }

    @DataBoundSetter
    public void setScript(String script) {
        this.script = script;
    }

    public String getPage() {
        return this.page;
    }

    @DataBoundSetter
    public void setPage(String page) {
        this.page = page;
    }

    public String getUrlHeader() {
        return this.urlHeader;
    }

    @DataBoundSetter
    public void setUrlHeader(String urlHeader) {
        this.urlHeader = urlHeader;
    }

    public String getHiddenBox() {
        return this.hiddenBox;
    }

    @DataBoundSetter
    public void setHiddenBox(String hiddenBox) {
        this.hiddenBox = hiddenBox;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public boolean isGenerateReport() {
        return this.generateReport;
    }

    public boolean isDoNotWaitForTestCompletion() {
        return this.doNotWaitForTestCompletion;
    }

    public void setDoNotWaitForTestCompletion(boolean doNotWaitForTestCompletion) {
        this.doNotWaitForTestCompletion = doNotWaitForTestCompletion;
    }

    public boolean isSkipSSLCertCheck() {
        return this.skipSSLCertCheck;
    }

    public boolean isSkipSSLHostCheck() {
        return this.skipSSLHostCheck;
    }

    public Map<String, String> getEnvVarMap() {
        return this.envVarMap;
    }

    public String getTotalusers() {
        return this.totalusers;
    }

    @DataBoundSetter
    public void setTotalusers(String totalusers) {
        this.totalusers = totalusers;
    }

    public String getRampUpSec() {
        return this.rampUpSec;
    }

    @DataBoundSetter
    public void setRampUpSec(String rampupsec) {
        this.rampUpSec = rampupsec;
    }

    public String getRampupmin() {
        return this.rampupmin;
    }

    @DataBoundSetter
    public void setRampupmin(String rampupmin) {
        this.rampupmin = rampupmin;
    }

    public String getRampuphour() {
        return this.rampuphour;
    }

    @DataBoundSetter
    public void setRampuphour(String rampuphour) {
        this.rampuphour = rampuphour;
    }

    public String getDuration() {
        return this.duration;
    }

    @DataBoundSetter
    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String getServerhost() {
        return this.serverhost;
    }

    @DataBoundSetter
    public void setServerhost(String serverhost) {
        this.serverhost = serverhost;
    }

    public String getSla() {
        return this.sla;
    }

    @DataBoundSetter
    public void setSla(String sla) {
        this.sla = sla;
    }

    public String getTestName() {
        return this.testName;
    }

    @DataBoundSetter
    public void setTestName(String testName) {
        this.testName = testName;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    @DataBoundSetter
    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public String getRampupDuration() {
        return this.rampupDuration;
    }

    public void setRampupDuration(String rampupDuration) {
        this.rampupDuration = rampupDuration;
    }

    public String getEmailid() {
        return this.emailid;
    }

    @DataBoundSetter
    public void setEmailid(String emailidTo) {
        this.emailid = emailidTo;
    }

    public String getEmailidCC() {
        return this.emailidCC;
    }

    @DataBoundSetter
    public void setEmailidCC(String emailIdCC) {
        this.emailidCC = emailIdCC;
    }

    public String getEmailidBcc() {
        return this.emailidBcc;
    }

    @DataBoundSetter
    public void setEmailidBcc(String emailIdBcc) {
        this.emailidBcc = emailIdBcc;
    }

    public String getTestsuite() {
        return this.testsuite;
    }

    @DataBoundSetter
    public void setTestsuite(String testsuite) {
        this.testsuite = testsuite;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    @DataBoundSetter
    public void setDataDir(String dataDir) {
        this.dataDir = dataDir;
    }

    public String getCheckRuleFileUpload() {
        return this.checkRuleFileUpload;
    }

    @DataBoundSetter
    public void setCheckRuleFileUpload(String checkRuleFileUpload) {
        this.checkRuleFileUpload = checkRuleFileUpload;
    }

    public String getTestProfileBox() {
        return this.testProfileBox;
    }

    @DataBoundSetter
    public void setTestProfileBox(String testProfileBox) {
        this.testProfileBox = testProfileBox;
    }

    public void perform(Run<?, ?> run, FilePath fp, Launcher lnchr, TaskListener taskListener) throws InterruptedException, IOException {
        String pluginVersion = "";
        pluginVersion = Jenkins.getInstance().getPluginManager().getPlugin("cavisson-ns-nd-integration").getVersion();
        logger.log(Level.INFO, "Cavisson-Plugin|Plugin is initialized with Jenkins version: " + Jenkins.getVersion() + "and Plugin Version: " + pluginVersion);
        run.addAction((Action)new NetStormStopAction(run));
        run.addAction((Action)new NetStormStopThread(run));
        PrintStream logg = taskListener.getLogger();
        Boolean fileUpload = false;
        boolean uploadNCDataFile = false;
        String scriptName = "";
        Object object = this.envVarMap = run instanceof AbstractBuild ? run.getEnvironment(taskListener) : Collections.emptyMap();
        if (this.envVarMap.keySet().size() > 0) {
            this.envVarMap = ((EnvVars)this.envVarMap).overrideAll(((AbstractBuild)run).getBuildVariables());
            logger.log(Level.INFO, "Cavisson-Plugin|Starting Running Freestyle Job with job id: " + run.getDisplayName());
        } else {
            logger.log(Level.INFO, "Cavisson-Plugin|Starting Running Pipeline Job.");
        }
        StringBuffer errMsg = new StringBuffer();
        Set<String> keyset = this.envVarMap.keySet();
        String path = "";
        String jobName = "";
        String automateScripts = "";
        String testsuiteName = "";
        String dataDir = "";
        String serverhost = "";
        if (keyset.size() > 0) {
            this.netstormConnectionManger = new NetStormConnectionManager(this.URLConnectionString, this.username, this.password, this.project, this.subProject, this.scenario, this.testMode, this.baselineType, this.pollInterval, this.profile, this.hiddenBox, this.generateReport, this.doNotWaitForTestCompletion, this.skipSSLCertCheck, this.skipSSLHostCheck, this.gitPull);
        }
        if (this.envVarMap.get("Testsuite") != null) {
            logger.log(Level.FINE, "Cavisson-Plugin|Parameterizing Test Suite with Name - " + this.envVarMap.get("Testsuite"));
            testsuiteName = this.envVarMap.get("Testsuite");
            if (!testsuiteName.isEmpty()) {
                logger.log(Level.FINE, "Cavisson-Plugin|Test Suite Name = " + testsuiteName);
                this.testsuiteList = Arrays.asList(testsuiteName.split("\\s*,\\s*"));
            }
        } else if (this.testProfileBox != null && !this.testProfileBox.isEmpty()) {
            this.testsuiteList = Arrays.asList(this.testProfileBox.split("\\s*,\\s*"));
        } else if (this.scenario != null && !this.scenario.isEmpty()) {
            this.testsuiteList = Arrays.asList(this.scenario.split("\\s*,\\s*"));
        }
        if (keyset.size() > 0 && this.testsuiteList != null) {
            this.testsuiteParameterMap = new HashMap();
            logger.log(Level.FINE, "Cavisson-Plugin|Number of Test Suites to execute = " + this.testsuiteList.size());
            if (this.testsuiteList.size() > 1) {
                for (int i = 0; i < this.testsuiteList.size(); ++i) {
                    String suiteName = this.testsuiteList.get(i);
                    String[] prefix = suiteName.split("_");
                    if (prefix.length > 1) {
                        this.testsuiteParameterMap.put(prefix[0], new ParameterDTO());
                        continue;
                    }
                    this.testsuiteParameterMap.put(suiteName, new ParameterDTO());
                }
            } else if (this.testsuiteList.size() == 1) {
                String[] testsuite = this.testsuiteList.get(0).split("/");
                if (testsuite.length == 3) {
                    this.netstormConnectionManger.setProject(testsuite[0]);
                    this.netstormConnectionManger.setSubProject(testsuite[1]);
                    this.netstormConnectionManger.setScenario(testsuite[2]);
                } else {
                    this.netstormConnectionManger.setScenario(testsuite[0]);
                }
            }
        }
        for (String keys : keyset) {
            String[] prefix;
            String prefixName;
            String mail;
            String[] prefix2;
            String prefixName2;
            String[] temp;
            String[] prefix3;
            String value = this.envVarMap.get(keys);
            String key = keys;
            if (key.equals("JENKINS_HOME")) {
                path = this.envVarMap.get(key);
            }
            if (key.endsWith("DataDirectory")) {
                dataDir = this.envVarMap.get(key);
                if (this.testsuiteList.size() > 1) {
                    String prefixname = "";
                    prefix3 = key.split("_");
                    if (prefix3.length > 1) {
                        if (this.testsuiteParameterMap.containsKey(prefix3[0])) {
                            prefixname = prefix3[0];
                            this.testsuiteParameterMap.get(prefix3[0]).setDataDir(dataDir);
                        } else {
                            for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                if (entry.getKey().equals(prefixname)) continue;
                                this.testsuiteParameterMap.get(entry.getKey()).setDataDir(dataDir);
                            }
                        }
                    } else {
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            this.testsuiteParameterMap.get(entry.getKey()).setDataDir(dataDir);
                        }
                    }
                } else if (this.testsuiteList.size() == 1) {
                    this.netstormConnectionManger.setDataDir(dataDir);
                }
            }
            if (key.equals("Override DataDir") && !(dataDir = this.envVarMap.get(key)).equals("")) {
                this.netstormConnectionManger.setDataDir(dataDir);
            }
            if (key.endsWith("Server_Host")) {
                serverhost = this.envVarMap.get(key);
                if (this.testsuiteList.size() > 1) {
                    String prefixName3 = "";
                    prefix3 = key.split("_");
                    if (prefix3.length > 1) {
                        if (this.testsuiteParameterMap.containsKey(prefix3[0])) {
                            prefixName3 = prefix3[0];
                            this.testsuiteParameterMap.get(prefix3[0]).setServerhost(serverhost);
                        } else {
                            for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                if (entry.getKey().equals(prefixName3)) continue;
                                this.testsuiteParameterMap.get(entry.getKey()).setServerhost(serverhost);
                            }
                        }
                    } else {
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            this.testsuiteParameterMap.get(entry.getKey()).setServerhost(serverhost);
                        }
                    }
                } else if (this.testsuiteList.size() == 1) {
                    this.netstormConnectionManger.setServerHost(serverhost);
                }
            }
            if (!(value instanceof String)) continue;
            String envValue = value;
            if (key.startsWith("Script Name")) {
                scriptName = envValue;
            }
            if (envValue.startsWith("NS_SESSION")) {
                temp = envValue.split("_");
                if (temp.length > 2) {
                    if (this.testsuiteList.size() > 1) {
                        prefixName2 = "";
                        prefix2 = key.split("_");
                        if (prefix2.length > 1) {
                            if (this.testsuiteParameterMap.containsKey(prefix2[0])) {
                                prefixName2 = prefix2[0];
                                this.testsuiteParameterMap.get(prefix2[0]).setDuration(temp[2]);
                            } else {
                                for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                    if (entry.getKey().equals(prefixName2)) continue;
                                    this.testsuiteParameterMap.get(entry.getKey()).setDuration(temp[2]);
                                }
                            }
                        } else {
                            for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                this.testsuiteParameterMap.get(entry.getKey()).setDuration(temp[2]);
                            }
                        }
                    } else if (this.testsuiteList.size() == 1) {
                        this.netstormConnectionManger.setDuration(temp[2]);
                    }
                }
            } else if (envValue.startsWith("NS_NUM_USERS")) {
                temp = envValue.split("_");
                if (temp.length > 3) {
                    if (this.testsuiteList.size() > 1) {
                        prefixName2 = "";
                        prefix2 = key.split("_");
                        if (prefix2.length > 1) {
                            if (this.testsuiteParameterMap.containsKey(prefix2[0])) {
                                prefixName2 = prefix2[0];
                                this.testsuiteParameterMap.get(prefix2[0]).setTotalusers(temp[3]);
                            } else {
                                for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                    if (entry.getKey().equals(prefixName2)) continue;
                                    this.testsuiteParameterMap.get(entry.getKey()).setTotalusers(temp[3]);
                                }
                            }
                        } else {
                            for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                if (entry.getKey().equals(prefixName2)) continue;
                                this.testsuiteParameterMap.get(entry.getKey()).setTotalusers(temp[3]);
                            }
                        }
                    } else if (this.testsuiteList.size() == 1) {
                        this.netstormConnectionManger.setvUsers(temp[3]);
                    }
                }
            } else if (envValue.startsWith("NS_SERVER_HOST")) {
                temp = envValue.split("_");
                if (temp.length > 3) {
                    if (this.testsuiteList.size() > 1) {
                        prefixName2 = "";
                        prefix2 = key.split("_");
                        if (prefix2.length > 1) {
                            if (this.testsuiteParameterMap.containsKey(prefix2[0])) {
                                prefixName2 = prefix2[0];
                                this.testsuiteParameterMap.get(prefix2[0]).setServerhost(temp[3]);
                            } else {
                                for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                    if (entry.getKey().equals(prefixName2)) continue;
                                    this.testsuiteParameterMap.get(entry.getKey()).setServerhost(temp[3]);
                                }
                            }
                        } else {
                            for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                this.testsuiteParameterMap.get(entry.getKey()).setServerhost(temp[3]);
                            }
                        }
                    } else if (this.testsuiteList.size() == 1) {
                        this.netstormConnectionManger.setServerHost(temp[3]);
                    }
                }
            } else if (envValue.startsWith("NS_SLA_CHANGE")) {
                temp = envValue.split("_");
                if (temp.length > 3) {
                    if (this.testsuiteList.size() > 1) {
                        prefixName2 = "";
                        prefix2 = key.split("_");
                        if (prefix2.length > 1) {
                            if (this.testsuiteParameterMap.containsKey(prefix2[0])) {
                                prefixName2 = prefix2[0];
                                this.testsuiteParameterMap.get(prefix2[0]).addSLAValue(prefix2[1], temp[3]);
                            } else {
                                for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                    if (entry.getKey().equals(prefixName2)) continue;
                                    this.testsuiteParameterMap.get(entry.getKey()).addSLAValue(prefix2[1], temp[3]);
                                }
                            }
                        } else {
                            for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                this.testsuiteParameterMap.get(entry.getKey()).addSLAValue(key.toString(), temp[3]);
                            }
                        }
                    } else if (this.testsuiteList.size() == 1) {
                        this.netstormConnectionManger.addSLAValue(key.toString(), temp[3]);
                    }
                }
            } else if (envValue.startsWith("NS_RAMP_UP_SEC") || envValue.startsWith("NS_RAMP_UP_MIN") || envValue.startsWith("NS_RAMP_UP_HR")) {
                temp = envValue.split("_");
                if (temp.length > 4) {
                    if (this.testsuiteList.size() > 1) {
                        prefixName2 = "";
                        prefix2 = key.split("_");
                        if (prefix2.length > 1) {
                            if (this.testsuiteParameterMap.containsKey(prefix2[0])) {
                                prefixName2 = prefix2[0];
                                this.testsuiteParameterMap.get(prefix2[0]).setRampUp(temp[4] + "_" + temp[3]);
                            } else {
                                for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                    if (!entry.getKey().equals(prefixName2)) {
                                        // empty if block
                                    }
                                    this.testsuiteParameterMap.get(entry.getKey()).setRampUp(temp[4] + "_" + temp[3]);
                                }
                            }
                        } else {
                            for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                this.testsuiteParameterMap.get(entry.getKey()).setRampUp(temp[4] + "_" + temp[3]);
                            }
                        }
                    } else if (this.testsuiteList.size() == 1) {
                        this.netstormConnectionManger.setRampUp(temp[4] + "_" + temp[3]);
                    }
                }
            } else if (envValue.startsWith("NS_TNAME")) {
                String tName = this.getSubString(envValue, 2, "_");
                if (!tName.equals("")) {
                    if (this.testsuiteList.size() > 1) {
                        String[] prefix4 = key.split("_");
                        if (prefix4.length > 1) {
                            this.testsuiteParameterMap.get(prefix4[0]).setTestName(tName);
                        }
                    } else if (this.testsuiteList.size() == 1) {
                        this.netstormConnectionManger.settName(tName);
                    }
                }
            } else if (envValue.startsWith("NS_AUTOSCRIPT")) {
                temp = envValue.split("_", 3);
                if (temp.length > 2) {
                    automateScripts = automateScripts.equals("") ? temp[2] : automateScripts + "," + temp[2];
                }
            } else if (envValue.startsWith("NS_RAMP_UP_DURATION")) {
                temp = envValue.split("_");
                if (temp.length > 4) {
                    if (this.testsuiteList.size() > 1) {
                        prefixName2 = "";
                        prefix2 = key.split("_");
                        if (prefix2.length > 1) {
                            if (this.testsuiteParameterMap.containsKey(prefix2[0])) {
                                prefixName2 = prefix2[0];
                                this.testsuiteParameterMap.get(prefix2[0]).setRampupDuration(temp[4]);
                            } else {
                                for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                    if (!entry.getKey().equals(prefixName2)) {
                                        // empty if block
                                    }
                                    this.testsuiteParameterMap.get(entry.getKey()).setRampupDuration(temp[4]);
                                }
                            }
                        } else {
                            for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                this.testsuiteParameterMap.get(entry.getKey()).setRampupDuration(temp[4]);
                            }
                        }
                    } else if (this.testsuiteList.size() == 1) {
                        this.netstormConnectionManger.setRampUpDuration(temp[4]);
                    }
                }
            } else if (envValue.startsWith("EMAIL_IDS_TO")) {
                temp = envValue.split("_");
                if (temp.length > 3) {
                    mail = envValue.split("IDS_TO_")[1].replaceAll("\\|", ",");
                    if (this.testsuiteList.size() > 1) {
                        prefixName = "";
                        prefix = key.split("_");
                        if (prefix.length > 1) {
                            if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                                prefixName = prefix[0];
                                this.testsuiteParameterMap.get(prefix[0]).setEmailid(mail);
                            } else {
                                for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                    if (entry.getKey().equals(prefixName)) continue;
                                    this.testsuiteParameterMap.get(entry.getKey()).setEmailid(mail);
                                }
                            }
                        } else {
                            for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                this.testsuiteParameterMap.get(entry.getKey()).setEmailid(mail);
                            }
                        }
                    } else if (this.testsuiteList.size() == 1) {
                        this.netstormConnectionManger.setEmailIdTo(mail);
                    }
                }
            } else if (envValue.startsWith("EMAIL_IDS_CC")) {
                temp = envValue.split("_");
                if (temp.length > 3) {
                    mail = envValue.split("IDS_CC_")[1].replaceAll("\\|", ",");
                    if (this.testsuiteList.size() > 1) {
                        prefixName = "";
                        prefix = key.split("_");
                        if (prefix.length > 1) {
                            if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                                prefixName = prefix[0];
                                this.testsuiteParameterMap.get(prefix[0]).setEmailidCC(mail);
                            } else {
                                for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                    if (entry.getKey().equals(prefixName)) continue;
                                    this.testsuiteParameterMap.get(entry.getKey()).setEmailidCC(mail);
                                }
                            }
                        } else {
                            for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                this.testsuiteParameterMap.get(entry.getKey()).setEmailidCC(mail);
                            }
                        }
                    } else if (this.testsuiteList.size() == 1) {
                        this.netstormConnectionManger.setEmailIdCc(mail);
                    }
                }
            } else if (envValue.startsWith("EMAIL_IDS_BCC") && (temp = envValue.split("_")).length > 3) {
                mail = envValue.split("IDS_BCC_")[1].replaceAll("\\|", ",");
                if (this.testsuiteList.size() > 1) {
                    prefixName = "";
                    prefix = key.split("_");
                    if (prefix.length > 1) {
                        if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                            prefixName = prefix[0];
                            this.testsuiteParameterMap.get(prefix[0]).setEmailidBcc(mail);
                        } else {
                            for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                if (entry.getKey().equals(prefixName)) continue;
                                this.testsuiteParameterMap.get(entry.getKey()).setEmailidBcc(mail);
                            }
                        }
                    } else {
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            this.testsuiteParameterMap.get(entry.getKey()).setEmailidBcc(mail);
                        }
                    }
                } else if (this.testsuiteList.size() == 1) {
                    this.netstormConnectionManger.setEmailIdBcc(mail);
                }
            }
            if (!envValue.equalsIgnoreCase(fileName)) continue;
            fileUpload = true;
        }
        if (!automateScripts.isEmpty()) {
            this.netstormConnectionManger.setAutoScript(automateScripts);
        }
        if (this.testMode == null) {
            logg.println("Please verify configured buit step, test profile mode is not selected.");
            run.setResult(Result.FAILURE);
        }
        if (this.scenario.equals("") || this.scenario == null || this.scenario.equals("---Select Scenarios ---")) {
            if (this.getTestMode().equals("N")) {
                logg.println("Please verify configured build step, scenario is not selected.");
            } else {
                logg.println("Please verify configured build step, Test Suite is not selected.");
            }
            run.setResult(Result.FAILURE);
            return;
        }
        if (this.getTestMode().equals("N")) {
            logg.println("Starting test with scenario(" + this.project + "/" + this.subProject + "/" + this.scenario + ")");
        } else {
            logg.println("Starting test with test suite(" + this.project + "/" + this.subProject + "/" + this.scenario + ")");
        }
        logg.println("NetStorm URI: " + this.URLConnectionString);
        JSONObject json = null;
        if (fileUpload.booleanValue()) {
            json = this.createJsonForFileUpload(fp, logg);
        }
        this.netstormConnectionManger.setJkRule(json);
        if (scriptName != null && !scriptName.equals("")) {
            FilePath file = new FilePath(fp.getChannel(), fp + "/uploadNCDataFiles");
            logger.log(Level.FINE, "Cavisson-Plugin|File path for uploading data file = " + file);
            if (file.isDirectory()) {
                logger.log(Level.FINE, "Cavisson-Plugin|List of files = " + file.list());
                if (file.list().size() > 0) {
                    FilePath files = (FilePath)file.list().get(0);
                    this.netstormConnectionManger.updateNCDataFile(files, scriptName, this.username, this.profile, logg);
                } else {
                    logg.println("No Data file is uploaded");
                }
            }
        }
        String destDir = fp + "/TestSuiteReport";
        FilePath direc = new FilePath(fp.getChannel(), destDir);
        if (direc.exists()) {
            direc.deleteRecursive();
        }
        HashMap result = new HashMap();
        if (this.testsuiteList != null && this.testsuiteList.size() > 1) {
            this.netstormConnectionManger.setTestsuitelist(this.testsuiteList);
            this.netstormConnectionManger.setTestsuiteParameterDTO(this.testsuiteParameterMap);
            result = this.netstormConnectionManger.startMultipleTest(errMsg, logg, this.repoPath);
        } else {
            result = this.netstormConnectionManger.startNetstormTest(errMsg, logg, this.repoPath, run);
        }
        logger.log(Level.INFO, "Cavisson-Plugin|Test Cycle Number and Test Run Number = " + result.toString());
        if (this.doNotWaitForTestCompletion) {
            if (result.get("TESTRUN") != null && !result.get("TESTRUN").toString().trim().equals("")) {
                logg.println("Test Run Number - " + result.get("TESTRUN"));
                run.setDisplayName((String)result.get("TESTRUN"));
                run.setResult(Result.SUCCESS);
            }
            logger.log(Level.INFO, "Cavisson-Plugin|Plugin is destroyed.");
            return;
        }
        this.processTestResult(result, logg, fp, run, path, this.netstormConnectionManger);
    }

    public void processTestResult(HashMap result, PrintStream logg, FilePath fp, Run<?, ?> run, String path, NetStormConnectionManager netstormConnectionManger) {
        try {
            boolean status = (Boolean)result.get("STATUS");
            if (result.get("TESTRUN") != null && !result.get("TESTRUN").toString().trim().equals("")) {
                try {
                    File file;
                    File dir;
                    run.setDisplayName((String)result.get("TESTRUN"));
                    testRunNumber = (String)result.get("TESTRUN");
                    if (this.testMode.equals("T") && (result.get("errMsg") == null || result.get("errMsg").toString().trim().equals(""))) {
                        if (result.get("TEST_CYCLE_NUMBER") != null) {
                            testCycleNumber = (String)result.get("TEST_CYCLE_NUMBER");
                        }
                        if (this.generateReport) {
                            logg.println("generateReport  - " + this.generateReport);
                            netstormConnectionManger.checkTestSuiteStatus(logg, fp, run);
                        }
                    }
                    if (result.get("ENV_NAME") != null && !result.get("ENV_NAME").toString().trim().equals("")) {
                        run.setDescription((String)result.get("ENV_NAME"));
                    }
                    if (!(dir = new File(path.trim() + "/Property")).exists()) {
                        if (dir.mkdir()) {
                            System.out.println("Directory is created!");
                        } else {
                            System.out.println("Failed to create directory!");
                        }
                    }
                    if ((file = new File(path.trim() + "/Property/" + ((String)result.get("TESTRUN")).trim() + "_CavEnv.property")).exists() && file.delete()) {
                        if (!file.createNewFile()) {
                            // empty if block
                        }
                        try (FileWriter fw = new FileWriter(file, true);
                             BufferedWriter bw = new BufferedWriter(fw);){
                            bw.write("HostName=" + this.URLConnectionString);
                            bw.write("\n");
                            bw.write("UserName=" + this.username);
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Unknown exception in processTestResult.", e);
                        }
                    }
                    run.setResult(Result.SUCCESS);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Unknown exception in processTestResult.", e);
                }
            } else {
                run.setResult(Result.FAILURE);
            }
            logger.log(Level.INFO, "Cavisson-Plugin|Plugin is destroyed.");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unknown exception in processTestResult.", e);
        }
    }

    public void setParametersValue() {
        try {
            String mail;
            String[] temp;
            String mail2;
            String mail3;
            Object mail4;
            String email;
            String[] temp2;
            String tName;
            String rampupsec;
            String[] prefix;
            ArrayList<String> prefixList;
            logger.log(Level.FINE, "Cavisson-Plugin|Getting parameter values of pipeline job");
            this.netstormConnectionManger = new NetStormConnectionManager(this.URLConnectionString, this.username, this.password, this.project, this.subProject, this.scenario, this.testMode, this.baselineType, this.pollInterval, this.profile, this.hiddenBox, this.generateReport, this.doNotWaitForTestCompletion, this.skipSSLCertCheck, this.skipSSLHostCheck, this.gitPull);
            if (this.testsuite != null && !this.testsuite.isEmpty()) {
                logger.log(Level.FINE, "Cavisson-Plugin|Test Suite Name = " + this.testsuite);
                this.testsuiteList = Arrays.asList(this.testsuite.split("\\s*,\\s*"));
                this.testsuiteParameterMap = new HashMap();
                if (this.testsuiteList.size() > 1) {
                    for (int i = 0; i < this.testsuiteList.size(); ++i) {
                        String suiteName = this.testsuiteList.get(i);
                        String[] prefix2 = suiteName.split("_");
                        if (prefix2.length > 1) {
                            this.testsuiteParameterMap.put(prefix2[0], new ParameterDTO());
                            continue;
                        }
                        this.testsuiteParameterMap.put(suiteName, new ParameterDTO());
                    }
                } else if (this.testsuiteList.size() == 1) {
                    String[] testsuites = this.testsuite.split("/");
                    if (testsuites.length == 3) {
                        this.netstormConnectionManger.setProject(testsuites[0]);
                        this.netstormConnectionManger.setSubProject(testsuites[1]);
                        this.netstormConnectionManger.setScenario(testsuites[2]);
                    } else {
                        this.netstormConnectionManger.setScenario(this.testsuite);
                    }
                }
            }
            if (this.dataDir != null && !this.dataDir.isEmpty()) {
                if (this.testsuiteList.size() > 1) {
                    List<String> dataDirNames = Arrays.asList(this.dataDir.split("\\s*,\\s*"));
                    prefixList = new ArrayList<String>();
                    for (int i = 0; i < dataDirNames.size(); ++i) {
                        String dirName = dataDirNames.get(i);
                        prefix = dirName.split("_");
                        if (prefix.length > 1) {
                            if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                                prefixList.add(prefix[0]);
                                this.testsuiteParameterMap.get(prefix[0]).setDataDir(dirName.substring(dirName.indexOf("_") + 1, dirName.length()));
                                continue;
                            }
                            for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                if (prefixList.contains(entry.getKey())) continue;
                                this.testsuiteParameterMap.get(entry.getKey()).setDataDir(dirName.substring(dirName.indexOf("_") + 1, dirName.length()));
                            }
                            continue;
                        }
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            this.testsuiteParameterMap.get(entry.getKey()).setDataDir(this.dataDir);
                        }
                    }
                } else if (this.testsuiteList.size() == 1) {
                    this.netstormConnectionManger.setDataDir(this.dataDir);
                }
            }
            if (this.duration != null && this.duration.contains("NS_SESSION")) {
                String[] temp3;
                if (this.testsuiteList.size() > 1) {
                    List<String> durationValue = Arrays.asList(this.duration.split("\\s*,\\s*"));
                    prefixList = new ArrayList();
                    for (int i = 0; i < durationValue.size(); ++i) {
                        String durtn = durationValue.get(i);
                        prefix = durtn.split("_");
                        if (prefix.length > 1) {
                            if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                                prefixList.add(prefix[0]);
                                this.testsuiteParameterMap.get(prefix[0]).setDuration(prefix[3]);
                                continue;
                            }
                            for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                if (prefixList.contains(entry.getKey())) continue;
                                this.testsuiteParameterMap.get(entry.getKey()).setDuration(prefix[2]);
                            }
                            continue;
                        }
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            this.testsuiteParameterMap.get(entry.getKey()).setDuration(prefix[2]);
                        }
                    }
                } else if (this.testsuiteList.size() == 1 && (temp3 = this.duration.split("_")).length > 2) {
                    this.netstormConnectionManger.setDuration(temp3[2]);
                }
            }
            if (this.totalusers != null && this.totalusers.contains("NS_NUM_USERS")) {
                String[] temp4;
                if (this.testsuiteList.size() > 1) {
                    List<String> users = Arrays.asList(this.totalusers.split("\\s*,\\s*"));
                    prefixList = new ArrayList();
                    for (int i = 0; i < users.size(); ++i) {
                        String vusers = users.get(i);
                        prefix = vusers.split("_");
                        if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                            if (prefix.length <= 3) continue;
                            prefixList.add(prefix[0]);
                            this.testsuiteParameterMap.get(prefix[0]).setTotalusers(prefix[4]);
                            continue;
                        }
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            if (prefix.length <= 2 || prefixList.contains(entry.getKey())) continue;
                            this.testsuiteParameterMap.get(entry.getKey()).setTotalusers(prefix[3]);
                        }
                    }
                } else if (this.testsuiteList.size() == 1 && (temp4 = this.totalusers.split("_")).length > 3) {
                    this.netstormConnectionManger.setvUsers(temp4[3]);
                }
            }
            if (this.serverhost != null && this.serverhost.contains("NS_SERVER_HOST")) {
                String[] temp5;
                logger.log(Level.FINE, "Cavisson-Plugin|Server Host = " + this.serverhost);
                if (this.testsuiteList.size() > 1) {
                    List<String> host = Arrays.asList(this.serverhost.split("\\s*,\\s*"));
                    prefixList = new ArrayList();
                    for (int i = 0; i < host.size(); ++i) {
                        String shost = host.get(i);
                        prefix = shost.split("_");
                        if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                            if (prefix.length <= 4) continue;
                            prefixList.add(prefix[0]);
                            this.testsuiteParameterMap.get(prefix[0]).setServerhost(shost.split("HOST_")[1]);
                            continue;
                        }
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            if (prefix.length <= 3 || prefixList.contains(entry.getKey())) continue;
                            this.testsuiteParameterMap.get(entry.getKey()).setServerhost(shost.split("HOST_")[1]);
                        }
                    }
                } else if (this.testsuiteList.size() == 1 && (temp5 = this.serverhost.split("_")).length > 3) {
                    this.netstormConnectionManger.setServerHost(this.serverhost.split("HOST_")[1]);
                }
            }
            if (this.sla != null && this.sla.contains("NS_SLA_CHANGE")) {
                String[] temp6;
                if (this.testsuiteList.size() > 1) {
                    List<String> slas = Arrays.asList(this.sla.split("\\s*,\\s*"));
                    prefixList = new ArrayList();
                    for (int i = 0; i < slas.size(); ++i) {
                        String checkRuleSla = slas.get(i);
                        prefix = checkRuleSla.split("_");
                        if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                            if (prefix.length <= 5) continue;
                            prefixList.add(prefix[0]);
                            this.testsuiteParameterMap.get(prefix[0]).addSLAValue(prefix[5], prefix[4]);
                            continue;
                        }
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            if (prefix.length <= 4 || prefixList.contains(entry.getKey())) continue;
                            this.testsuiteParameterMap.get(entry.getKey()).addSLAValue(prefix[4], prefix[3]);
                        }
                    }
                } else if (this.testsuiteList.size() == 1 && (temp6 = this.sla.split("_")).length > 3) {
                    this.netstormConnectionManger.addSLAValue(temp6[4], temp6[3]);
                }
            }
            if (this.rampUpSec != null && this.rampUpSec.contains("NS_RAMP_UP_SEC")) {
                String[] temp7;
                if (this.testsuiteList.size() > 1) {
                    List<String> rampup = Arrays.asList(this.rampUpSec.split("\\s*,\\s*"));
                    prefixList = new ArrayList();
                    for (int i = 0; i < rampup.size(); ++i) {
                        rampupsec = rampup.get(i);
                        prefix = rampupsec.split("_");
                        if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                            if (prefix.length <= 5) continue;
                            prefixList.add(prefix[0]);
                            this.testsuiteParameterMap.get(prefix[0]).setRampUp(prefix[5] + "_" + prefix[4]);
                            continue;
                        }
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            if (prefix.length <= 4 || prefixList.contains(entry.getKey())) continue;
                            this.testsuiteParameterMap.get(entry.getKey()).setRampUp(prefix[4] + "_" + prefix[3]);
                        }
                    }
                } else if (this.testsuiteList.size() == 1 && (temp7 = this.rampUpSec.split("_")).length > 4) {
                    this.netstormConnectionManger.setRampUp(temp7[4] + "_" + temp7[3]);
                }
            }
            if (this.rampupmin != null && this.rampupmin.contains("NS_RAMP_UP_MIN")) {
                String[] temp8;
                if (this.testsuiteList.size() > 1) {
                    List<String> rampup = Arrays.asList(this.rampupmin.split("\\s*,\\s*"));
                    prefixList = new ArrayList();
                    for (int i = 0; i < rampup.size(); ++i) {
                        rampupsec = rampup.get(i);
                        prefix = rampupsec.split("_");
                        if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                            if (prefix.length <= 5) continue;
                            prefixList.add(prefix[0]);
                            this.testsuiteParameterMap.get(prefix[0]).setRampUp(prefix[5] + "_" + prefix[4]);
                            continue;
                        }
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            if (prefix.length <= 4 || prefixList.contains(entry.getKey())) continue;
                            this.testsuiteParameterMap.get(entry.getKey()).setRampUp(prefix[4] + "_" + prefix[3]);
                        }
                    }
                } else if (this.testsuiteList.size() == 1 && (temp8 = this.rampupmin.split("_")).length > 4) {
                    this.netstormConnectionManger.setRampUp(temp8[4] + "_" + temp8[3]);
                }
            }
            if (this.rampuphour != null && this.rampuphour.contains("NS_RAMP_UP_HR")) {
                String[] temp9;
                if (this.testsuiteList.size() > 1) {
                    List<String> rampup = Arrays.asList(this.rampuphour.split("\\s*,\\s*"));
                    prefixList = new ArrayList();
                    for (int i = 0; i < rampup.size(); ++i) {
                        rampupsec = rampup.get(i);
                        prefix = rampupsec.split("_");
                        if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                            if (prefix.length <= 5) continue;
                            prefixList.add(prefix[0]);
                            this.testsuiteParameterMap.get(prefix[0]).setRampUp(prefix[5] + "_" + prefix[4]);
                            continue;
                        }
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            if (prefix.length <= 4) continue;
                            if (!prefixList.contains(entry.getKey())) {
                                // empty if block
                            }
                            this.testsuiteParameterMap.get(entry.getKey()).setRampUp(prefix[4] + "_" + prefix[3]);
                        }
                    }
                } else if (this.testsuiteList.size() == 1 && (temp9 = this.rampupmin.split("_")).length > 4) {
                    this.netstormConnectionManger.setRampUp(temp9[4] + "_" + temp9[3]);
                }
            }
            if (this.testName != null && this.testName.contains("NS_TNAME") && !(tName = this.getSubString(this.testName, 2, "_")).equals("")) {
                this.netstormConnectionManger.settName(tName);
            }
            if (this.scriptPath.startsWith("NS_AUTOSCRIPT") && (temp2 = this.scriptPath.split("_", 3)).length > 2) {
                this.netstormConnectionManger.setAutoScript(temp2[2]);
            }
            if (this.rampupDuration != null && this.rampupDuration.contains("NS_RAMP_UP_DURATION")) {
                if (this.testsuiteList.size() > 1) {
                    List<String> rampup = Arrays.asList(this.rampupDuration.split("\\s*,\\s*"));
                    prefixList = new ArrayList();
                    for (int i = 0; i < rampup.size(); ++i) {
                        rampupsec = rampup.get(i);
                        prefix = rampupsec.split("_");
                        if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                            if (prefix.length <= 5) continue;
                            prefixList.add(prefix[0]);
                            this.testsuiteParameterMap.get(prefix[0]).setRampupDuration(prefix[5]);
                            continue;
                        }
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            if (prefix.length <= 4 || prefixList.contains(entry.getKey())) continue;
                            this.testsuiteParameterMap.get(entry.getKey()).setEmailid(rampupsec.split("UP_DURATION_")[1]);
                        }
                    }
                } else if (this.testsuiteList.size() == 1 && (temp = this.rampupDuration.split("_")).length > 4) {
                    this.netstormConnectionManger.setRampUpDuration(temp[4]);
                }
            }
            if (this.emailid != null && this.emailid.contains("EMAIL_IDS_TO")) {
                if (this.testsuiteList.size() > 1) {
                    List<String> emailidto = Arrays.asList(this.emailid.split("\\s*,\\s*"));
                    prefixList = new ArrayList();
                    for (int i = 0; i < emailidto.size(); ++i) {
                        email = emailidto.get(i);
                        prefix = email.split("_");
                        if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                            if (prefix.length <= 4) continue;
                            prefixList.add(prefix[0]);
                            mail4 = email.split("IDS_TO_")[1].replaceAll("\\|", ",");
                            this.testsuiteParameterMap.get(prefix[0]).setEmailid((String)mail4);
                            continue;
                        }
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            if (prefix.length <= 3 || prefixList.contains(entry.getKey())) continue;
                            mail3 = email.split("IDS_TO_")[1].replaceAll("\\|", ",");
                            this.testsuiteParameterMap.get(entry.getKey()).setEmailid(mail3);
                        }
                    }
                } else if (this.testsuiteList.size() == 1 && (temp = this.emailid.split("_")).length > 3) {
                    mail2 = this.emailid.split("IDS_TO_")[1].replaceAll("\\|", ",");
                    this.netstormConnectionManger.setEmailIdTo(mail2);
                }
            }
            if (this.emailidCC != null && this.emailidCC.contains("EMAIL_IDS_CC")) {
                if (this.testsuiteList.size() > 1) {
                    List<String> emailidcc = Arrays.asList(this.emailidCC.split("\\s*,\\s*"));
                    prefixList = new ArrayList();
                    for (int i = 0; i < emailidcc.size(); ++i) {
                        email = emailidcc.get(i);
                        prefix = email.split("_");
                        if (prefix.length > 1) {
                            if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                                if (prefix.length <= 4) continue;
                                prefixList.add(prefix[0]);
                                mail4 = email.split("IDS_CC_")[1].replaceAll("\\|", ",");
                                this.testsuiteParameterMap.get(prefix[0]).setEmailidCC((String)mail4);
                                continue;
                            }
                            for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                if (prefix.length <= 3 || !prefixList.contains(entry.getKey())) continue;
                                mail3 = email.split("IDS_CC_")[1].replaceAll("\\|", ",");
                                this.testsuiteParameterMap.get(entry.getKey()).setEmailidCC(mail3);
                            }
                            continue;
                        }
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            temp = this.emailidCC.split("_");
                            if (temp.length <= 3) continue;
                            mail = this.emailidCC.split("IDS_CC_")[1].replaceAll("\\|", ",");
                            this.testsuiteParameterMap.get(entry.getKey()).setEmailidCC(mail);
                        }
                    }
                } else if (this.testsuiteList.size() == 1 && (temp = this.emailidCC.split("_")).length > 3) {
                    mail2 = this.emailidCC.split("IDS_CC_")[1].replaceAll("\\|", ",");
                    this.netstormConnectionManger.setEmailIdCc(mail2);
                }
            }
            if (this.emailidBcc != null && this.emailidBcc.contains("EMAIL_IDS_BCC")) {
                if (this.testsuiteList.size() > 1) {
                    List<String> emailidbcc = Arrays.asList(this.emailidBcc.split("\\s*,\\s*"));
                    prefixList = new ArrayList();
                    for (int i = 0; i < emailidbcc.size(); ++i) {
                        email = emailidbcc.get(i);
                        prefix = email.split("_");
                        if (prefix.length > 1) {
                            if (this.testsuiteParameterMap.containsKey(prefix[0])) {
                                if (prefix.length <= 4) continue;
                                prefixList.add(prefix[0]);
                                mail4 = email.split("IDS_BCC_")[1].replaceAll("\\|", ",");
                                this.testsuiteParameterMap.get(prefix[0]).setEmailidBcc((String)mail4);
                                continue;
                            }
                            for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                                if (prefix.length <= 3 || prefixList.contains(entry.getKey())) continue;
                                mail3 = email.split("IDS_BCC_")[1].replaceAll("\\|", ",");
                                this.testsuiteParameterMap.get(entry.getKey()).setEmailidBcc(mail3);
                            }
                            continue;
                        }
                        for (Map.Entry<String, ParameterDTO> entry : this.testsuiteParameterMap.entrySet()) {
                            temp = this.emailidBcc.split("_");
                            if (temp.length <= 3) continue;
                            mail = this.emailidBcc.split("IDS_BCC_")[1].replaceAll("\\|", ",");
                            this.testsuiteParameterMap.get(entry.getKey()).setEmailidBcc(mail);
                        }
                    }
                } else if (this.testsuiteList.size() == 1 && (temp = this.emailidBcc.split("_")).length > 3) {
                    mail2 = this.emailidBcc.split("IDS_BCC_")[1].replaceAll("\\|", ",");
                    this.netstormConnectionManger.setEmailIdBcc(mail2);
                }
            }
            if (this.checkRuleFileUpload.equalsIgnoreCase(fileName)) {
                this.fileUpload = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void getGitConfigurationFromNS(boolean skipSSLCertCheck, boolean skipSSLHostCheck) {
        try {
            logger.log(Level.FINE, "Cavisson-Plugin|getGitConfigurationFromNS Method called.");
            NetStormConnectionManager netstormConnectionManger = new NetStormConnectionManager(this.URLConnectionString, this.username, this.password, false, 15, skipSSLCertCheck, skipSSLHostCheck);
            String res = netstormConnectionManger.getGitConfiguration();
            if (res == null || res.equals("") || res.equals("notConfigured")) {
                logger.log(Level.FINE, "Cavisson-Plugin|Git is not configured.");
                this.repoIp = "";
                this.repoPort = "";
                this.repoPath = "";
                this.repoUsername = "";
                this.protocol = "";
            } else {
                String[] resArr = res.split(" ");
                if (resArr.length > 8) {
                    this.repoPath = resArr[0];
                    this.repoUsername = resArr[2];
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unknown exception in getGitConfigurationFromNS.", e);
        }
    }

    @JavaScriptMethod
    public String getAddedHeaders() {
        try {
            logger.log(Level.FINE, "Cavisson-Plugin|getAddedHeaders Method called.");
            return this.hiddenBox;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unknown exception in getAddedHeaders.", e);
            return "";
        }
    }

    @JavaScriptMethod
    public String getTableValue() {
        try {
            logger.log(Level.FINE, "Cavisson-Plugin|getTableValue Method called.");
            return this.testProfileBox;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unknown exception in getTableValue.", e);
            return "";
        }
    }

    public JSONObject createJsonForFileUpload(FilePath fp, PrintStream logger) {
        block19: {
            try {
                JSONObject json = null;
                String fileNm = fileName;
                if (fileName.indexOf(".") != -1) {
                    String[] name = fileName.split("\\.");
                    fileNm = name[0];
                }
                File file = new File(fp + "/" + fileNm);
                logger.println("File path" + file);
                if (!file.exists()) break block19;
                try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                    String line;
                    StringBuilder builder = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        if (line.contains("GroupName") || line.contains("GraphName") || line.contains("VectorName") || line.contains("RuleDesc")) {
                            line = line.trim().replaceAll("\\s", "@@");
                        }
                        builder.append(line.trim());
                    }
                    json = (JSONObject)JSONSerializer.toJSON((Object)builder.toString());
                }
                catch (Exception e) {
                    logger.println("Unknown exception in createJsonForFileUpload." + e);
                }
                return json;
            }
            catch (Exception e) {
                logger.println("Unknown exception in createJsonForFileUpload." + e);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String startTest(NetStormConnectionManager netstormConnectionManger) {
        try {
            StringBuffer errBuf = new StringBuffer();
            File tempFile = File.createTempFile("myfile", ".tmp");
            AbstractMap result = null;
            try (FileOutputStream fout = new FileOutputStream(tempFile);){
                PrintStream pout = new PrintStream(fout);
                result = netstormConnectionManger.startNetstormTest(errBuf, pout, this.repoPath, null);
                if (((HashMap)result).get("TESTRUN") != null && !((HashMap)result).get("TESTRUN").toString().trim().equals("")) {
                    testRunNumber = (String)((HashMap)result).get("TESTRUN");
                    testCycleNumber = (String)((HashMap)result).get("TEST_CYCLE_NUMBER");
                    String string = result.toString();
                    return string;
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Unknown exception in startTest.", e);
            }
            if (result == null) return "Error in starting a test";
            return result.toString();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unknown exception in startTest.", e);
        }
        return "Error in starting a test";
    }

    public String getSubString(String OrgString, int startIndex, String seperator) {
        String[] f = OrgString.split(seperator);
        String result = "";
        if (startIndex <= f.length - 1) {
            for (int i = startIndex; i < f.length; ++i) {
                result = i == startIndex ? result + f[i] : result + "_" + f[i];
            }
        }
        return result;
    }

    public Descriptor getDescriptor() {
        return (Descriptor)super.getDescriptor();
    }

    @Extension
    public static class Descriptor
    extends BuildStepDescriptor<Builder> {
        public Descriptor() {
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.save();
            return true;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return FreeStyleProject.class.isAssignableFrom(jobType);
        }

        public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Builder)super.newInstance(req, formData);
        }

        public String getDisplayName() {
            return Messages.NetStormBuilder_Task();
        }

        public FormValidation doCheckPassword(@QueryParameter String password) {
            return FieldValidator.validatePassword(password);
        }

        public FormValidation doCheckUsername(@QueryParameter String username) {
            return FieldValidator.validateUsername(username);
        }

        public FormValidation doCheckURLConnectionString(@QueryParameter String URLConnectionString) {
            return FieldValidator.validateURLConnectionString(URLConnectionString);
        }

        @JavaScriptMethod
        public ArrayList<String> getPulledObjects(String value, String URLConnectionString, String username, String password, String project, String subProject, String testMode, String profile, boolean skipSSLCertCheck, boolean skipSSLHostCheck) {
            try {
                logger.log(Level.FINE, "Cavisson-Plugin|getPulledObjects Method Called.");
                ArrayList<String> res = new ArrayList<String>();
                StringBuffer errMsg = new StringBuffer();
                if (!(URLConnectionString.equals("") || URLConnectionString.equals("NA") || URLConnectionString.equals(" ") || URLConnectionString == null || password.equals("") || password.equals("NA") || password.equals(" ") || password == null || username.equals("") || username.equals("NA") || username.equals(" ") || username == null)) {
                    NetStormConnectionManager connection = new NetStormConnectionManager(URLConnectionString, username, Secret.fromString((String)password), false, 15, skipSSLCertCheck, skipSSLHostCheck);
                    if (value.equals("P")) {
                        res = connection.getProjectList(errMsg, profile);
                    } else if (value.equals("SP")) {
                        res = connection.getSubProjectList(errMsg, project, profile);
                    } else if (value.equals("S")) {
                        res = connection.getScenarioList(errMsg, project, subProject, testMode, profile);
                    }
                }
                return res;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception in getPulledObjects -" + e);
                return null;
            }
        }

        @JavaScriptMethod
        public JSONObject performGitpull(String URLConnectionString, String username, String password, String gitPull, String project, String subProject, String testMode, String repoPath, boolean skipSSLCertCheck, boolean skipSSLHostCheck) {
            logger.log(Level.FINE, "Cavisson-Plugin|performGitpull Method Called.");
            JSONObject status = new JSONObject();
            if (URLConnectionString.equals("") || URLConnectionString.equals("NA") || URLConnectionString.equals(" ") || URLConnectionString == null || password.equals("") || password.equals("NA") || password.equals(" ") || password == null || username.equals("") || username.equals("NA") || username.equals(" ") || username == null) {
                String temp = "Specify Netstorm URL Connection, Username and Password";
                status.put("msg", (Object)temp);
                status.put("color", (Object)"#CC0000");
                return status;
            }
            NetStormConnectionManager netstormConnectionManger = new NetStormConnectionManager(URLConnectionString, username, Secret.fromString((String)password), false, 15, skipSSLCertCheck, skipSSLHostCheck);
            String res = netstormConnectionManger.pullObjectsFromGit(repoPath);
            if (res != null && !res.isEmpty()) {
                status.put("msg", (Object)res);
                status.put("color", (Object)"#C4A000");
            } else {
                status.put("msg", (Object)"GIT Pull was unsuccessful.");
                status.put("color", (Object)"#C4A000");
            }
            return status;
        }

        @POST
        public FormValidation doTestNetstormConnection(@QueryParameter(value="URLConnectionString") String URLConnectionString, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="skipSSLCertCheck") boolean skipSSLCertCheck, @QueryParameter(value="skipSSLHostCheck") boolean skipSSLHostCheck) {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            NetStormConnectionManager netstormConnectionManger = new NetStormConnectionManager(URLConnectionString, username, Secret.fromString((String)password), false, 15, skipSSLCertCheck, skipSSLHostCheck);
            StringBuffer errMsg = new StringBuffer();
            FormValidation validationResult = netstormConnectionManger.testNSConnection(errMsg) ? FormValidation.ok((String)"Successfully Connected") : FormValidation.warning((String)("Cannot Connect to NetStorm due to :" + errMsg));
            return validationResult;
        }

        @POST
        public FormValidation doPullObjectsFromGit(@QueryParameter(value="URLConnectionString") String URLConnectionString, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="profile") String profile, @QueryParameter(value="repoPath") String repoPath, @QueryParameter(value="skipSSLCertCheck") boolean skipSSLCertCheck, @QueryParameter(value="skipSSLHostCheck") boolean skipSSLHostCheck) {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            StringBuffer errMsg = new StringBuffer();
            NetStormConnectionManager netstormConnectionManger = new NetStormConnectionManager(URLConnectionString, username, Secret.fromString((String)password), false, 15, skipSSLCertCheck, skipSSLHostCheck);
            String res = netstormConnectionManger.pullObjectsFromGit(repoPath);
            FormValidation validationResult = res != null && !res.isEmpty() ? FormValidation.warning((String)res) : FormValidation.warning((String)"GIT Pull was unsuccessful.");
            this.doFillProjectItems(URLConnectionString, username, password, profile, skipSSLCertCheck, skipSSLHostCheck);
            return validationResult;
        }

        @POST
        public FormValidation doTestGitConfiguration(@QueryParameter(value="repoPath") String repoPath, @QueryParameter(value="repoUsername") String repoUserName, @QueryParameter(value="repoPassword") String repoPassword, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="URLConnectionString") String URLConnectionString, @QueryParameter(value="skipSSLCertCheck") boolean skipSSLCertCheck, @QueryParameter(value="skipSSLHostCheck") boolean skipSSLHostCheck) {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            if (URLConnectionString.equals("") || URLConnectionString.equals("NA") || URLConnectionString.equals(" ") || URLConnectionString == null || password.equals("") || password.equals("NA") || password.equals(" ") || password == null || username.equals("") || username.equals("NA") || username.equals(" ") || username == null) {
                FormValidation validationResult = FormValidation.warning((String)"Specify Netstorm URL Connection, Username and Password first ...");
                return validationResult;
            }
            if (repoPath.equals("") || repoPath.equals("NA") || repoPath.equals(" ") || repoPath == null) {
                FormValidation validationResult = FormValidation.warning((String)"Repository Path can not be empty");
                return validationResult;
            }
            if (repoUserName.equals("") || repoUserName.equals("NA") || repoUserName.equals(" ") || repoUserName == null) {
                FormValidation validationResult = FormValidation.warning((String)"Repository username can not be empty");
                return validationResult;
            }
            if (repoPassword.equals("") || repoPassword.equals("NA") || repoPassword.equals(" ") || repoPassword == null) {
                FormValidation validationResult = FormValidation.warning((String)"Repository password can not be empty");
                return validationResult;
            }
            NetStormConnectionManager netstormConnectionManger = new NetStormConnectionManager(URLConnectionString, username, Secret.fromString((String)password), false, 15, skipSSLCertCheck, skipSSLHostCheck);
            JSONObject res = netstormConnectionManger.checkGitConfiguration(repoPath, repoUserName, repoPassword, "NA");
            FormValidation validationResult = res != null && !res.isEmpty() ? (res.get("errMsg").toString().equals("") ? FormValidation.ok((String)res.get("msg").toString()) : (!res.get("errMsg").toString().equals("") ? FormValidation.warning((String)res.get("errMsg").toString()) : FormValidation.warning((String)"GIT configuration test failed."))) : FormValidation.warning((String)"GIT configuration test failed.");
            return validationResult;
        }

        @POST
        public FormValidation doSaveGitConfiguration(@QueryParameter(value="repoPath") String repoPath, @QueryParameter(value="repoUsername") String repoUserName, @QueryParameter(value="repoPassword") String repoPassword, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="URLConnectionString") String URLConnectionString, @QueryParameter(value="skipSSLCertCheck") boolean skipSSLCertCheck, @QueryParameter(value="skipSSLHostCheck") boolean skipSSLHostCheck) {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            if (URLConnectionString.equals("") || URLConnectionString.equals("NA") || URLConnectionString.equals(" ") || URLConnectionString == null || password.equals("") || password.equals("NA") || password.equals(" ") || password == null || username.equals("") || username.equals("NA") || username.equals(" ") || username == null) {
                FormValidation validationResult = FormValidation.warning((String)"Specify Netstorm URL Connection, Username and Password first ...");
                return validationResult;
            }
            if (repoPath.equals("") || repoPath.equals("NA") || repoPath.equals(" ") || repoPath == null) {
                FormValidation validationResult = FormValidation.warning((String)"Repository Path can not be empty");
                return validationResult;
            }
            if (repoUserName.equals("") || repoUserName.equals("NA") || repoUserName.equals(" ") || repoUserName == null) {
                FormValidation validationResult = FormValidation.warning((String)"Repository username can not be empty");
                return validationResult;
            }
            if (repoPassword.equals("") || repoPassword.equals("NA") || repoPassword.equals(" ") || repoPassword == null) {
                FormValidation validationResult = FormValidation.warning((String)"Repository password can not be empty");
                return validationResult;
            }
            NetStormConnectionManager netstormConnectionManger = new NetStormConnectionManager(URLConnectionString, username, Secret.fromString((String)password), false, 15, skipSSLCertCheck, skipSSLHostCheck);
            String res = netstormConnectionManger.saveGitConfiguration(repoPath, repoUserName, repoPassword, "NA");
            FormValidation validationResult = FormValidation.ok((String)res);
            return validationResult;
        }

        @POST
        public synchronized ListBoxModel doFillProfileItems(@QueryParameter(value="URLConnectionString") String URLConnectionString, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="skipSSLCertCheck") boolean skipSSLCertCheck, @QueryParameter(value="skipSSLHostCheck") boolean skipSSLHostCheck) {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            ListBoxModel models = new ListBoxModel();
            StringBuffer errMsg = new StringBuffer();
            if (URLConnectionString == null || URLConnectionString.trim().equals("") || username == null || username.trim().equals("") || password == null || password.trim().equals("")) {
                models.add("---Select Profile ---");
                return models;
            }
            NetStormConnectionManager objProject = new NetStormConnectionManager(URLConnectionString, username, Secret.fromString((String)password), false, 15, skipSSLCertCheck, skipSSLHostCheck);
            ArrayList<String> profileList = objProject.getProfileList(errMsg);
            if (profileList == null || profileList.size() == 0) {
                models.add("---Select Profile ---");
                return models;
            }
            for (String profile : profileList) {
                models.add(profile);
            }
            return models;
        }

        @POST
        public synchronized ListBoxModel doFillProjectItems(@QueryParameter(value="URLConnectionString") String URLConnectionString, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="profile") String profile, @QueryParameter(value="skipSSLCertCheck") boolean skipSSLCertCheck, @QueryParameter(value="skipSSLHostCheck") boolean skipSSLHostCheck) {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            ListBoxModel models = new ListBoxModel();
            StringBuffer errMsg = new StringBuffer();
            if (URLConnectionString == null || URLConnectionString.trim().equals("") || username == null || username.trim().equals("") || password == null || password.trim().equals("") || profile == null || profile.trim().equals("")) {
                models.add("---Select Project ---");
                return models;
            }
            if (profile.trim().equals("---Select Profile ---")) {
                models.add("---Select Project ---");
                return models;
            }
            NetStormConnectionManager objProject = new NetStormConnectionManager(URLConnectionString, username, Secret.fromString((String)password), false, 15, skipSSLCertCheck, skipSSLHostCheck);
            ArrayList<String> projectList = objProject.getProjectList(errMsg, profile);
            if (projectList == null || projectList.size() == 0) {
                models.add("---Select Project ---");
                return models;
            }
            for (String project : projectList) {
                models.add(project);
            }
            return models;
        }

        public synchronized ListBoxModel doFillBaselineTypeItems() {
            ListBoxModel models = new ListBoxModel();
            models.add("Select Baseline");
            models.add("All");
            models.add("Baseline1");
            models.add("Baseline2");
            models.add("Baseline3");
            return models;
        }

        @POST
        public synchronized ListBoxModel doFillSubProjectItems(@QueryParameter(value="URLConnectionString") String URLConnectionString, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="profile") String profile, @QueryParameter(value="project") String project, @QueryParameter(value="skipSSLCertCheck") boolean skipSSLCertCheck, @QueryParameter(value="skipSSLHostCheck") boolean skipSSLHostCheck) {
            StringBuffer errMsg;
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            ListBoxModel models = new ListBoxModel();
            if (URLConnectionString == null || URLConnectionString.trim().equals("") || username == null || username.trim().equals("") || password == null || password.trim().equals("") || project == null || project.trim().equals("")) {
                models.add("---Select SubProject ---");
                return models;
            }
            if (project.trim().equals("---Select Project ---")) {
                models.add("---Select SubProject ---");
                return models;
            }
            NetStormConnectionManager connection = new NetStormConnectionManager(URLConnectionString, username, Secret.fromString((String)password), false, 15, skipSSLCertCheck, skipSSLHostCheck);
            ArrayList<String> subProjectList = connection.getSubProjectList(errMsg = new StringBuffer(), project, profile);
            if (subProjectList == null || subProjectList.size() == 0) {
                models.add("---Select SubProject ---");
                return models;
            }
            for (String subProject : subProjectList) {
                models.add(subProject);
            }
            return models;
        }

        @POST
        public synchronized ListBoxModel doFillScenarioItems(@QueryParameter(value="URLConnectionString") String URLConnectionString, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="profile") String profile, @QueryParameter(value="project") String project, @QueryParameter(value="subProject") String subProject, @QueryParameter(value="testMode") String testMode, @QueryParameter(value="skipSSLCertCheck") boolean skipSSLCertCheck, @QueryParameter(value="skipSSLHostCheck") boolean skipSSLHostCheck) {
            StringBuffer errMsg;
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            ListBoxModel models = new ListBoxModel();
            if (URLConnectionString == null || URLConnectionString.trim().equals("") || username == null || username.trim().equals("") || password == null || password.trim().equals("") || project == null || project.trim().equals("") || subProject == null || subProject.trim().equals("")) {
                models.add("---Select Profile ---");
                return models;
            }
            if (project.trim().equals("---Select Project ---") || subProject.trim().equals("---Select SubProject ---")) {
                models.add("---Select SubProject ---");
                return models;
            }
            NetStormConnectionManager connection = new NetStormConnectionManager(URLConnectionString, username, Secret.fromString((String)password), false, 15, skipSSLCertCheck, skipSSLHostCheck);
            ArrayList<String> scenariosList = connection.getScenarioList(errMsg = new StringBuffer(), project, subProject, testMode, profile);
            if (scenariosList == null || scenariosList.size() == 0) {
                models.add("---Select Scenarios ---");
                return models;
            }
            for (String scenarios : scenariosList) {
                models.add(scenarios);
            }
            return models;
        }

        public ListBoxModel doFillTestModeItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("Scenario", "N");
            model.add("Test Suite", "T");
            return model;
        }

        @POST
        public synchronized ListBoxModel doFillScriptItems(@QueryParameter(value="URLConnectionString") String URLConnectionString, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="profile") String profile, @QueryParameter(value="scenario") String scenario, @QueryParameter(value="project") String project, @QueryParameter(value="subProject") String subProject, @QueryParameter(value="testMode") String testMode, @QueryParameter(value="skipSSLCertCheck") boolean skipSSLCertCheck, @QueryParameter(value="skipSSLHostCheck") boolean skipSSLHostCheck) {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            ListBoxModel models = new ListBoxModel();
            StringBuffer errMsg = new StringBuffer();
            if (URLConnectionString == null || URLConnectionString.trim().equals("") || username == null || username.trim().equals("") || password == null || password.trim().equals("")) {
                models.add("---Select Script---");
                return models;
            }
            NetStormConnectionManager objProject = new NetStormConnectionManager(URLConnectionString, username, Secret.fromString((String)password), false, 15, skipSSLCertCheck, skipSSLHostCheck);
            JSONArray scriptList = objProject.getScriptList(profile, scenario, project, subProject, testMode);
            if (scriptList == null || scriptList.size() == 0) {
                models.add("---Select Profile ---");
                return models;
            }
            for (int i = 0; i < scriptList.size(); ++i) {
                models.add((String)scriptList.get(i));
            }
            return models;
        }

        @POST
        public synchronized ListBoxModel doFillPageItems(@QueryParameter(value="URLConnectionString") String URLConnectionString, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="script") String script, @QueryParameter(value="profile") String profile, @QueryParameter(value="scenario") String scenario, @QueryParameter(value="project") String project, @QueryParameter(value="subProject") String subProject, @QueryParameter(value="testMode") String testMode, @QueryParameter(value="skipSSLCertCheck") boolean skipSSLCertCheck, @QueryParameter(value="skipSSLHostCheck") boolean skipSSLHostCheck) {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            ListBoxModel models = new ListBoxModel();
            StringBuffer errMsg = new StringBuffer();
            if (URLConnectionString == null || URLConnectionString.trim().equals("") || username == null || username.trim().equals("") || password == null || password.trim().equals("") || script.equals("---Select Script---")) {
                models.add("---Select Page---");
                return models;
            }
            NetStormConnectionManager objProject = new NetStormConnectionManager(URLConnectionString, username, Secret.fromString((String)password), false, 15, skipSSLCertCheck, skipSSLHostCheck);
            if (!script.equals("All")) {
                JSONArray pageList = objProject.getPageList(script, scenario, profile, testMode, project, subProject);
                if (pageList == null || pageList.size() == 0) {
                    models.add("---Select Profile ---");
                    return models;
                }
                for (int i = 0; i < pageList.size(); ++i) {
                    String temp = (String)pageList.get(i);
                    temp = temp.replace("\"", "");
                    models.add(temp);
                }
            } else if (script.equals("All")) {
                models.add("All");
            }
            return models;
        }

        public synchronized ListBoxModel doFillUrlHeaderItems() {
            ListBoxModel models = new ListBoxModel();
            StringBuffer errMsg = new StringBuffer();
            models.add("Main");
            models.add("Inline");
            models.add("ALL");
            return models;
        }
    }
}

