/*
 * Decompiled with CFR 0.152.
 */
package com.cavisson.jenkins;

import com.cavisson.jenkins.BaseConnection;
import com.cavisson.jenkins.FieldValidator;
import com.cavisson.jenkins.LocalMessages;
import com.cavisson.jenkins.NdConnectionManager;
import com.cavisson.jenkins.NetDiagnosticsParamtersForReport;
import com.cavisson.jenkins.NetStormBuildAction;
import com.cavisson.jenkins.NetStormDataCollector;
import com.cavisson.jenkins.NetStormReport;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class NetDiagnosticsResultsPublisher
extends Recorder
implements SimpleBuildStep {
    private static final String DEFAULT_USERNAME = "netstorm";
    private static final String DEFAULT_TEST_METRIC = "Average Transaction Response Time (Secs)";
    private static final String fileName = "jenkins_check_rule";
    private static PrintStream logger;
    @Extension
    public static final DescriptorImpl DESCRIPTOR;
    private String netdiagnosticsUri = "";
    private String username = "";
    private Secret password;
    private String curStartTime;
    private String curEndTime;
    private String base1StartTime;
    private String base1EndTime;
    private String checkProfilePath;
    private String base2StartTime;
    private String base2EndTime;
    private String base3StartTime;
    private String base3EndTime;
    private String base1MSRName;
    private String base2MSRName;
    private String base3MSRName;
    private String criThreshold;
    private String warThreshold;
    private String failThreshold;
    String duration;
    private String profile;
    private static String testRun;
    private final Boolean skipSSLCertCheck;
    private final Boolean skipSSLHostCheck;
    NetDiagnosticsParamtersForReport ndParams = new NetDiagnosticsParamtersForReport();

    public void perform(Run<?, ?> run, FilePath fp, Launcher lnchr, TaskListener listener) throws InterruptedException, IOException {
        File file;
        Object keyEnv;
        Map env = run instanceof AbstractBuild ? ((AbstractBuild)run).getBuildVariables() : Collections.emptyMap();
        logger = listener.getLogger();
        StringBuffer errMsg = new StringBuffer();
        String curStart = "";
        String curEnd = " ";
        String path = "";
        String jobName = "";
        String criticalThreshold = "";
        String warningThreshold = "";
        String overallThreshold = "";
        Boolean fileUpload = false;
        Set keyset = env.keySet();
        System.out.println("cur start time -- " + keyset);
        for (Object key : keyset) {
            Object value = env.get(key);
            keyEnv = (String)key;
            if (!(value instanceof String)) continue;
            if (((String)keyEnv).startsWith("curStartTime")) {
                curStart = (String)value;
                this.setCurStartTime(curStart);
            }
            if (((String)keyEnv).startsWith("curEndTime")) {
                curEnd = (String)value;
                this.setCurEndTime(curEnd);
            }
            if (((String)keyEnv).startsWith("JENKINS_HOME")) {
                path = (String)value;
            }
            if (((String)keyEnv).startsWith("JOB_NAME")) {
                jobName = (String)value;
            }
            if (((String)keyEnv).equalsIgnoreCase("criticalThreshold")) {
                criticalThreshold = (String)value;
            }
            if (((String)keyEnv).equalsIgnoreCase("warningThreshold")) {
                warningThreshold = (String)value;
            }
            if (((String)keyEnv).equalsIgnoreCase("overallThreshold")) {
                overallThreshold = (String)value;
            }
            if (!((String)keyEnv).equalsIgnoreCase(fileName)) continue;
            fileUpload = true;
        }
        JSONObject json = null;
        if (fileUpload.booleanValue() && (file = new File(path + "/workspace/" + jobName + "/" + fileName)).exists()) {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            keyEnv = null;
            try {
                String line;
                StringBuilder builder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    if (line.contains("GroupName") || line.contains("GraphName") || line.contains("VectorName") || line.contains("RuleDesc")) {
                        line = line.trim().replaceAll("\\s", "@@");
                    }
                    builder.append(line.trim());
                }
                json = (JSONObject)JSONSerializer.toJSON((Object)builder.toString());
            }
            catch (Throwable builder) {
                keyEnv = builder;
                throw builder;
            }
            finally {
                if (reader != null) {
                    if (keyEnv != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable builder) {
                            ((Throwable)keyEnv).addSuppressed(builder);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        NdConnectionManager connection = new NdConnectionManager(this.netdiagnosticsUri, this.username, this.password, this.ndParams, true, this.isSkipSSLCertCheck(), this.isSkipSSLHostCheck());
        connection.setCurStart(this.curStartTime);
        connection.setCurEnd(this.curEndTime);
        connection.setJkRule(json);
        connection.setCritical(criticalThreshold);
        connection.setWarning(warningThreshold);
        connection.setOverall(overallThreshold);
        logger.println("Verify connection to NetDiagnostics interface ...");
        if (!connection.testNDConnection(errMsg, null, logger)) {
            logger.println("Connection to netdiagnostics unsuccessful, cannot to proceed to generate report.");
            logger.println("Error: " + errMsg);
            return;
        }
        logger.println("Successfully generated report on server.");
        try {
            SimpleDateFormat trDateFormat = new SimpleDateFormat("MM/dd/yy HH:mm:ss");
            Date userDate = trDateFormat.parse(this.curStartTime);
            long absoluteDateInMillies = userDate.getTime();
            Date userEndDate = trDateFormat.parse(this.curEndTime);
            long absoluteEndDateInMillies = userEndDate.getTime();
            long durationCal = absoluteEndDateInMillies - absoluteDateInMillies;
            long seconds = durationCal / 1000L;
            long s = seconds % 60L;
            long m = seconds / 60L % 60L;
            long h = seconds / 3600L % 24L;
            this.duration = String.format("%d:%02d:%02d", h, m, s);
        }
        catch (Exception trDateFormat) {
            // empty catch block
        }
        NetStormDataCollector dataCollector = new NetStormDataCollector(connection, run, 50000, "T", true, this.duration);
        try {
            Object report = null;
            boolean pdfUpload = this.dumpPdfInWorkspace(fp, connection);
            boolean htmlReport = this.getHTMLReport(fp, connection);
            logger.println("Pdf Uploaded = " + pdfUpload);
        }
        catch (Exception e) {
            logger.println("Not able to create netstorm report.may be some configuration issue in running scenario.");
            return;
        }
    }

    private boolean getHTMLReport(FilePath fp, NdConnectionManager connection) {
        String destDirectory = fp + "/TestSuiteReport";
        File dirr = new File(destDirectory);
        if (!dirr.exists() || !dirr.delete()) {
            // empty if block
        }
        String testRun = NetDiagnosticsResultsPublisher.testRun;
        String zipFile = fp + "/TestSuiteReport.zip";
        File file = new File(zipFile);
        try {
            String destDir;
            File dir;
            String str = connection.getUrlString();
            URL urlForHTMLReport = new URL(str + "/ProductUI/productSummary/jenkinsService/getHTMLReport");
            URLConnection connect = BaseConnection.getConnections(urlForHTMLReport, this.isSkipSSLCertCheck(), this.isSkipSSLHostCheck());
            connect.setConnectTimeout(0);
            connect.setReadTimeout(0);
            ((HttpURLConnection)connect).setRequestMethod("POST");
            connect.setRequestProperty("Content-Type", "application/octet-stream");
            connect.setDoOutput(true);
            OutputStream outStream = connect.getOutputStream();
            outStream.write(testRun.getBytes());
            outStream.flush();
            if (((HttpURLConnection)connect).getResponseCode() == 200) {
                byte[] mybytearray = new byte[1024];
                InputStream is = connect.getInputStream();
                try (FileOutputStream fos = new FileOutputStream(file);
                     BufferedOutputStream bos = new BufferedOutputStream(fos);){
                    int bytesRead;
                    while ((bytesRead = is.read(mybytearray)) > 0) {
                        bos.write(mybytearray, 0, bytesRead);
                    }
                }
            }
            if (!(dir = new File(destDir = fp + "/TestSuiteReport")).exists() || !dirr.delete()) {
                // empty if block
            }
            NetDiagnosticsResultsPublisher.unzip(zipFile, destDir);
            return true;
        }
        catch (Exception e) {
            logger.println("Not able to get HTML report");
            return false;
        }
    }

    private static void unzip(String zipFilePath, String destDir) {
        File dir = new File(destDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        byte[] buffer = new byte[1024];
        try (FileInputStream fis = new FileInputStream(zipFilePath);
             ZipInputStream zis = new ZipInputStream(fis);){
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String fileName = ze.getName();
                File newFile = new File(destDir + File.separator + fileName);
                System.out.println("Unzipping to " + newFile.getAbsolutePath());
                new File(newFile.getParent()).mkdirs();
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    int len;
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                }
                catch (IOException e) {
                    System.out.println("Exception in writing in file - " + e);
                }
                zis.closeEntry();
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
        }
        catch (IOException e) {
            System.out.println("Exception in writing in file - " + e);
        }
    }

    private boolean dumpPdfInWorkspace(FilePath fp, NdConnectionManager connection) {
        String testRun = NetDiagnosticsResultsPublisher.testRun;
        String dir = fp + "/TR" + testRun;
        File fl = new File(dir);
        if (!fl.exists() || !fl.delete()) {
            // empty if block
        }
        fl.mkdir();
        File file = new File(dir + "/testsuite_report_" + testRun + ".pdf");
        try {
            String str = connection.getUrlString();
            URL urlForPdf = new URL(str + "/ProductUI/productSummary/jenkinsService/getPdfData");
            URLConnection connect = BaseConnection.getConnections(urlForPdf, this.isSkipSSLCertCheck(), this.isSkipSSLHostCheck());
            connect.setConnectTimeout(0);
            connect.setReadTimeout(0);
            ((HttpURLConnection)connect).setRequestMethod("POST");
            connect.setRequestProperty("Content-Type", "application/octet-stream");
            connect.setDoOutput(true);
            OutputStream outStream = connect.getOutputStream();
            outStream.write(testRun.getBytes());
            outStream.flush();
            if (((HttpURLConnection)connect).getResponseCode() == 200) {
                byte[] mybytearray = new byte[1024];
                InputStream is = connect.getInputStream();
                try (FileOutputStream fos = new FileOutputStream(file);
                     BufferedOutputStream bos = new BufferedOutputStream(fos);){
                    int bytesRead;
                    while ((bytesRead = is.read(mybytearray)) > 0) {
                        bos.write(mybytearray, 0, bytesRead);
                    }
                    is.close();
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void geterate(AbstractBuild<?, ?> job) {
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public String getTestRun() {
        return testRun;
    }

    public static void setTestRun(String testrun) {
        testRun = testrun;
    }

    public String getCriThreshold() {
        return this.criThreshold;
    }

    public void setCriThreshold(String criThreshold) {
        this.criThreshold = criThreshold;
    }

    public String getWarThreshold() {
        return this.warThreshold;
    }

    public void setWarThreshold(String warThreshold) {
        this.warThreshold = warThreshold;
    }

    public String getFailThreshold() {
        return this.failThreshold;
    }

    public void setFailThreshold(String failThreshold) {
        this.failThreshold = failThreshold;
    }

    public String getCurStartTime() {
        return this.curStartTime;
    }

    public void setCurStartTime(String curStartTime) {
        this.curStartTime = curStartTime;
    }

    public String getCurEndTime() {
        return this.curEndTime;
    }

    public void setCurEndTime(String curEndTime) {
        this.curEndTime = curEndTime;
    }

    public String getCheckProfilePath() {
        return this.checkProfilePath;
    }

    public void setCheckProfilePath(String checkProfilePath) {
        this.checkProfilePath = checkProfilePath;
    }

    public String getNetdiagnosticsUri() {
        return this.netdiagnosticsUri;
    }

    public void setNetdiagnosticsUri(String netdiagnosticsUri) {
        this.netdiagnosticsUri = netdiagnosticsUri;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Secret getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = StringUtils.isEmpty((String)password) ? null : Secret.fromString((String)password);
    }

    public String getBase1StartTime() {
        return this.base1StartTime;
    }

    public void setBase1StartTime(String base1StartTime) {
        this.base1StartTime = base1StartTime;
    }

    public String getBase1EndTime() {
        return this.base1EndTime;
    }

    public void setBase1EndTime(String base1EndTime) {
        this.base1EndTime = base1EndTime;
    }

    public String getBase2StartTime() {
        return this.base2StartTime;
    }

    public void setBase2StartTime(String base2StartTime) {
        this.base2StartTime = base2StartTime;
    }

    public String getBase2EndTime() {
        return this.base2EndTime;
    }

    public void setBase2EndTime(String base2EndTime) {
        this.base2EndTime = base2EndTime;
    }

    public String getBase3StartTime() {
        return this.base3StartTime;
    }

    public void setBase3StartTime(String base3StartTime) {
        this.base3StartTime = base3StartTime;
    }

    public String getBase3EndTime() {
        return this.base3EndTime;
    }

    public void setBase3EndTime(String base3EndTime) {
        this.base3EndTime = base3EndTime;
    }

    public String getBase1MSRName() {
        return this.base1MSRName;
    }

    public void setBase1MSRName(String base1msrName) {
        this.base1MSRName = base1msrName;
    }

    public String getBase2MSRName() {
        return this.base2MSRName;
    }

    public void setBase2MSRName(String base2msrName) {
        this.base2MSRName = base2msrName;
    }

    public String getBase3MSRName() {
        return this.base3MSRName;
    }

    public void setBase3MSRName(String base3msrName) {
        this.base3MSRName = base3msrName;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public boolean isSkipSSLCertCheck() {
        return this.skipSSLCertCheck;
    }

    public boolean isSkipSSLHostCheck() {
        return this.skipSSLHostCheck;
    }

    @DataBoundConstructor
    public NetDiagnosticsResultsPublisher(String netdiagnosticsUri, String username, String password, String base1StartTime, String base1EndTime, String base2EndTime, String base2StartTime, String base3StartTime, String base3EndTime, String checkProfilePath, String criThreshold, String warThreshold, String failThreshold, String curStartTime, String curEndTime, String base1MSRName, String base2MSRName, String base3MSRName, String profile, boolean skipSSLCertCheck, boolean skipSSLHostCheck) {
        this.setNetdiagnosticsUri(netdiagnosticsUri);
        this.setUsername(username);
        this.setPassword(password);
        this.setBase1StartTime(base1StartTime);
        this.setBase1EndTime(base1EndTime);
        this.setBase1MSRName(base1MSRName);
        this.setBase2StartTime(base2StartTime);
        this.setBase2EndTime(base2EndTime);
        this.setBase2MSRName(base2MSRName);
        this.setBase3StartTime(base3StartTime);
        this.setBase3EndTime(base3EndTime);
        this.setBase3MSRName(base3MSRName);
        if (curStartTime != null) {
            this.setCurStartTime(curStartTime);
        } else {
            this.setCurStartTime(this.getCurStartTime());
        }
        if (curEndTime != null) {
            this.setCurEndTime(curEndTime);
        } else {
            this.setCurEndTime(this.getCurEndTime());
        }
        this.setCheckProfilePath(checkProfilePath);
        this.setCriThreshold(criThreshold);
        this.setWarThreshold(warThreshold);
        this.setFailThreshold(failThreshold);
        this.setProfile(profile);
        this.ndParams.setCheckProfilePath(checkProfilePath);
        this.ndParams.setBase1MSRName(base1MSRName);
        this.ndParams.setBase1StartTime(base1StartTime);
        this.ndParams.setBase1EndTime(base1EndTime);
        this.ndParams.setBase2EndTime(base2EndTime);
        this.ndParams.setBase2StartTime(base2StartTime);
        this.ndParams.setBase2MSRName(base2MSRName);
        this.ndParams.setBase3EndTime(base3EndTime);
        this.ndParams.setBase3StartTime(base3StartTime);
        this.ndParams.setBase3MSRName(base3MSRName);
        this.ndParams.setCheckProfilePath(checkProfilePath);
        this.ndParams.setProfile(profile);
        this.ndParams.setUsername(username);
        if (!this.getCurEndTime().equals("")) {
            this.ndParams.setCurEndTime(this.getCurEndTime());
        } else {
            this.ndParams.setCurEndTime(curEndTime);
        }
        if (!this.getCurStartTime().equals("")) {
            this.ndParams.setCurStartTime(this.getCurStartTime());
        } else {
            this.ndParams.setCurStartTime(curStartTime);
        }
        if (!this.getCriThreshold().equals("")) {
            this.ndParams.setCritiThreshold(this.getCriThreshold());
        } else {
            this.ndParams.setCritiThreshold(criThreshold);
        }
        if (!this.getWarThreshold().equals("")) {
            this.ndParams.setWarThreshold(this.getWarThreshold());
        } else {
            this.ndParams.setWarThreshold(warThreshold);
        }
        if (!this.getFailThreshold().equals("")) {
            this.ndParams.setFailThreshold(this.getFailThreshold());
        } else {
            this.ndParams.setFailThreshold(failThreshold);
        }
        this.skipSSLCertCheck = skipSSLCertCheck;
        this.skipSSLHostCheck = skipSSLHostCheck;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private double calculateAverageBasedOnPreviousReports(List<NetStormReport> reports) {
        double calculatedSum = 0.0;
        int numberOfMeasurements = 0;
        for (NetStormReport report : reports) {
            double value = report.getAverageForMetric(DEFAULT_TEST_METRIC);
            if (!(value >= 0.0)) continue;
            calculatedSum += value;
            ++numberOfMeasurements;
        }
        double result = -1.0;
        if (numberOfMeasurements > 0) {
            result = calculatedSum / (double)numberOfMeasurements;
        }
        return result;
    }

    private List<NetStormReport> getListOfPreviousReports(Run<?, ?> build, long currentTimestamp) {
        ArrayList<NetStormReport> previousReports = new ArrayList<NetStormReport>();
        NetStormBuildAction performanceBuildAction = (NetStormBuildAction)build.getAction(NetStormBuildAction.class);
        previousReports.add(performanceBuildAction.getBuildActionResultsDisplay().getNetStormReport());
        return previousReports;
    }

    static {
        DESCRIPTOR = new DescriptorImpl();
        testRun = "-1";
    }

    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return LocalMessages.ND_PUBLISHER_DISPLAYNAME.toString();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDefaultUsername() {
            return NetDiagnosticsResultsPublisher.DEFAULT_USERNAME;
        }

        public String getDefaultTestMetric() {
            return NetDiagnosticsResultsPublisher.DEFAULT_TEST_METRIC;
        }

        public FormValidation doCheckNetdiagnosticsUri(@QueryParameter String netdiagnosticsUri) {
            return FieldValidator.validateURLConnectionString(netdiagnosticsUri);
        }

        public FormValidation doCheckPassword(@QueryParameter String password) {
            return FieldValidator.validatePassword(password);
        }

        public FormValidation doCheckUsername(@QueryParameter String username) {
            return FieldValidator.validateUsername(username);
        }

        public FormValidation doCheckWarThreshold(@QueryParameter String warThreshold) {
            return FieldValidator.validateThresholdValues(warThreshold);
        }

        public FormValidation doCheckCriThreshold(@QueryParameter String criThreshold) {
            return FieldValidator.validateThresholdValues(criThreshold);
        }

        public FormValidation doCheckFailThreshold(@QueryParameter String failThreshold) {
            return FieldValidator.validateThresholdValues(failThreshold);
        }

        public FormValidation doCheckBaseStartTime(@QueryParameter String baseStartTime) throws ParseException {
            return FieldValidator.validateDateTime(baseStartTime);
        }

        public FormValidation doCheckBaseEndTime(@QueryParameter String baseEndTime) throws ParseException {
            return FieldValidator.validateDateTime(baseEndTime);
        }

        @POST
        public FormValidation doTestNetDiagnosticsConnection(@QueryParameter(value="netdiagnosticsUri") String netdiagnosticRestUri, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="curStartTime") String curStartTime, @QueryParameter(value="curEndTime") String curEndTime, @QueryParameter(value="baseStartTime") String baseStartTime, @QueryParameter(value="baseEndTime") String baseEndTime, @QueryParameter(value="criThreshold") String criThreshold, @QueryParameter(value="warThreshold") String warThreshold, @QueryParameter(value="failThreshold") String failThreshold, @QueryParameter(value="initDuration") Boolean initDuration, @QueryParameter(value="initStartTime") String initStartTime, @QueryParameter(value="initEndTime") String initEndTime, @QueryParameter(value="skipSSLCertCheck") boolean skipSSLCertCheck, @QueryParameter(value="skipSSLHostCheck") boolean skipSSLHostCheck) {
            String check;
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            StringBuffer errMsg = new StringBuffer();
            if (FieldValidator.isEmptyField(netdiagnosticRestUri)) {
                FormValidation validationResult = FormValidation.error((String)"URL connection string cannot be empty and should start with http:// or https://");
                return validationResult;
            }
            if (!netdiagnosticRestUri.startsWith("http://") && !netdiagnosticRestUri.startsWith("https://")) {
                FormValidation validationResult = FormValidation.error((String)"URL connection st should start with http:// or https://");
                return validationResult;
            }
            if (FieldValidator.isEmptyField(username)) {
                FormValidation validationResult = FormValidation.error((String)"Please enter user name.");
                return validationResult;
            }
            if (FieldValidator.isEmptyField(password)) {
                FormValidation validationResult = FormValidation.error((String)"Please enter password.");
                return validationResult;
            }
            if (FieldValidator.isEmptyField(criThreshold)) {
                FormValidation validationResult = FormValidation.error((String)"Critical threshold can not be empty.");
                return validationResult;
            }
            if (FieldValidator.isEmptyField(warThreshold)) {
                FormValidation validationResult = FormValidation.error((String)"Warning threshold can not be empty.");
                return validationResult;
            }
            if (FieldValidator.isEmptyField(failThreshold)) {
                FormValidation validationResult = FormValidation.error((String)"Overall Fail Criteria can not be empty.");
                return validationResult;
            }
            if (FieldValidator.isEmptyField(curStartTime) || FieldValidator.isEmptyField(curEndTime)) {
                FormValidation validationResult = FormValidation.error((String)"Current Time Period can not be empty.");
                return validationResult;
            }
            if (!(FieldValidator.isEmptyField(baseStartTime) && FieldValidator.isEmptyField(baseEndTime) || !FieldValidator.isEmptyField(baseStartTime) && !FieldValidator.isEmptyField(baseEndTime))) {
                FormValidation validationResult = FormValidation.error((String)"Baseline Time Period can not be empty.");
                return validationResult;
            }
            if (initDuration.booleanValue() && (FieldValidator.isEmptyField(initStartTime) || FieldValidator.isEmptyField(initEndTime))) {
                FormValidation validationResult = FormValidation.error((String)"Initial Time Period can not be empty.");
                return validationResult;
            }
            NdConnectionManager connection = new NdConnectionManager(netdiagnosticRestUri, username, Secret.fromString((String)password), true, skipSSLCertCheck, skipSSLHostCheck);
            FormValidation validationResult = !connection.testNDConnection(errMsg, check = netdiagnosticRestUri + "@@" + username + "@@" + password, logger) ? FormValidation.warning((String)("Connection to netdiagnostics unsuccessful, due to: " + errMsg)) : FormValidation.ok((String)"Connection successful");
            return validationResult;
        }

        @POST
        public synchronized ListBoxModel doFillProfileItems(@QueryParameter(value="netdiagnosticsUri") String netdiagnosticRestUri, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="skipSSLCertCheck") boolean skipSSLCertCheck, @QueryParameter(value="skipSSLHostCheck") boolean skipSSLHostCheck) {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            ListBoxModel models = new ListBoxModel();
            StringBuffer errMsg = new StringBuffer();
            if (netdiagnosticRestUri == null || netdiagnosticRestUri.trim().equals("") || username == null || username.trim().equals("") || password == null || password.trim().equals("")) {
                models.add("---Select Profile ---");
                return models;
            }
            NdConnectionManager connection = new NdConnectionManager(netdiagnosticRestUri, username, Secret.fromString((String)password), true, skipSSLCertCheck, skipSSLHostCheck);
            ArrayList<String> profileList = connection.getProfileList(errMsg);
            if (profileList == null || profileList.size() == 0) {
                models.add("---Select Profile ---");
                return models;
            }
            for (String profile : profileList) {
                models.add(profile);
            }
            return models;
        }
    }
}

