/*
 * Decompiled with CFR 0.152.
 */
package com.cavisson.jenkins;

import com.cavisson.jenkins.BaseConnection;
import com.cavisson.jenkins.MetricData;
import com.cavisson.jenkins.MetricDataContainer;
import com.cavisson.jenkins.MetricInfo;
import com.cavisson.jenkins.MetricLinkInfo;
import com.cavisson.jenkins.MetricVal;
import com.cavisson.jenkins.MetricValues;
import com.cavisson.jenkins.NetDiagnosticsParamtersForReport;
import com.cavisson.jenkins.NetDiagnosticsResultsPublisher;
import com.cavisson.jenkins.ScalarVal;
import com.cavisson.jenkins.TestMetrics;
import com.cavisson.jenkins.TestReport;
import com.cavisson.jenkins.TransactionStats;
import hudson.util.Secret;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;

public class NdConnectionManager
extends BaseConnection {
    private final String URLConnectionString;
    private URLConnection urlConn = null;
    private final transient Logger logger = Logger.getLogger(NdConnectionManager.class.getName());
    private String username = "";
    private Secret password;
    NetDiagnosticsParamtersForReport ndParam;
    private String restUrl = "";
    private String result;
    private boolean isNDE = false;
    private String curStart;
    private String curEnd;
    private JSONObject jkRule = new JSONObject();
    private String critical;
    private String warning;
    private String overall;
    private String err = "Connection failure, please check whether Connection URI is specified correctly";
    private boolean skipSSLCertValidation = false;
    private boolean skipSSLHostValidation = false;

    public String getCritical() {
        return this.critical;
    }

    public void setCritical(String critical) {
        this.critical = critical;
    }

    public String getWarning() {
        return this.warning;
    }

    public void setWarning(String warning) {
        this.warning = warning;
    }

    public String getOverall() {
        return this.overall;
    }

    public void setOverall(String overall) {
        this.overall = overall;
    }

    public JSONObject getJkRule() {
        return this.jkRule;
    }

    public void setJkRule(JSONObject jkRule) {
        this.jkRule = jkRule;
    }

    public String getCurStart() {
        return this.curStart;
    }

    public void setCurStart(String curStart) {
        this.curStart = curStart;
    }

    public String getCurEnd() {
        return this.curEnd;
    }

    public void setCurEnd(String curEnd) {
        this.curEnd = curEnd;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public boolean isSkipSSLCertValidation() {
        return this.skipSSLCertValidation;
    }

    public void setSkipSSLCertValidation(boolean skipSSLCertValidation) {
        this.skipSSLCertValidation = skipSSLCertValidation;
    }

    public boolean isSkipSSLHostValidation() {
        return this.skipSSLHostValidation;
    }

    public void setSkipSSLHostValidation(boolean skipSSLHostValidation) {
        this.skipSSLHostValidation = skipSSLHostValidation;
    }

    public NdConnectionManager(String uRLConnectionString, String username, Secret password, boolean isNDE) {
        this.URLConnectionString = uRLConnectionString;
        this.username = username;
        this.restUrl = uRLConnectionString;
        this.isNDE = isNDE;
        this.password = password;
    }

    public NdConnectionManager(String uRLConnectionString, String username, Secret password, boolean isNDE, boolean skipSSLCertValidation, boolean skipSSLHostValidation) {
        this.URLConnectionString = uRLConnectionString;
        this.username = username;
        this.restUrl = uRLConnectionString;
        this.isNDE = isNDE;
        this.password = password;
        this.skipSSLCertValidation = skipSSLCertValidation;
        this.skipSSLHostValidation = skipSSLHostValidation;
    }

    public NdConnectionManager(String uRLConnectionString, String username, Secret password, NetDiagnosticsParamtersForReport ndParam, boolean isNDE, boolean skipSSLCertValidation, boolean skipSSLHostValidation) {
        this.URLConnectionString = uRLConnectionString;
        this.username = username;
        this.ndParam = ndParam;
        this.restUrl = uRLConnectionString;
        this.isNDE = isNDE;
        this.password = password;
        this.skipSSLCertValidation = skipSSLCertValidation;
        this.skipSSLHostValidation = skipSSLHostValidation;
    }

    public boolean testNDConnection(StringBuffer errMsg, String test, PrintStream consoleLogger) {
        this.logger.log(Level.FINE, "Cavisson-Plugin|testNDConnection() method is  called. rest url -" + this.restUrl);
        if (this.checkAndMakeConnection(this.URLConnectionString, this.restUrl, errMsg, test, consoleLogger)) {
            this.logger.log(Level.FINE, "Cavisson-Plugin|After check connection method.");
            return true;
        }
        this.logger.log(Level.FINE, "Cavisson-Plugin|connection is fail - ", this.err);
        errMsg.append(this.err);
        return false;
    }

    private boolean checkAndMakeConnection(String urlString, String restUrl, StringBuffer errMsg, PrintStream consoleLogger) {
        return this.checkAndMakeConnection(urlString, restUrl, errMsg, null, consoleLogger);
    }

    private boolean checkAndMakeConnection(String urlString, String restUrl, StringBuffer errMsg, String test, PrintStream consoleLogger) {
        this.logger.log(Level.FINE, "Cavisson-Plugin|checkAndMakeConnection method called. with arguments restUrl : ", new Object[]{restUrl});
        try {
            restUrl = this.getUrlString();
            if (this.ndParam != null) {
                this.logger.log(Level.FINE, "Cavisson-Plugin|checkAndMakeConnection method called. with ndParam " + this.ndParam.toString());
                this.ndParam.setCurStartTime(this.getCurStart().replace(" ", "@"));
                this.ndParam.setCurEndTime(this.getCurEnd().replace(" ", "@"));
                if (this.ndParam.getBase1StartTime() != null && !this.ndParam.getBase1StartTime().equals("")) {
                    this.ndParam.setBase1StartTime(this.ndParam.getBase1StartTime().replace(" ", "@"));
                } else {
                    this.ndParam.setBase1StartTime(null);
                }
                if (this.ndParam.getBase1EndTime() != null && !this.ndParam.getBase1EndTime().equals("")) {
                    this.ndParam.setBase1EndTime(this.ndParam.getBase1EndTime().replace(" ", "@"));
                } else {
                    this.ndParam.setBase1EndTime(null);
                }
                if (this.ndParam.getBase2StartTime() != null && !this.ndParam.getBase2StartTime().equals("")) {
                    this.ndParam.setBase2StartTime(this.ndParam.getBase2StartTime().replace(" ", "@"));
                } else {
                    this.ndParam.setBase2StartTime(null);
                }
                if (this.ndParam.getBase2EndTime() != null && !this.ndParam.getBase2EndTime().equals("")) {
                    this.ndParam.setBase2EndTime(this.ndParam.getBase2EndTime().replace(" ", "@"));
                } else {
                    this.ndParam.setBase2EndTime(null);
                }
                if (this.ndParam.getBase3StartTime() != null && !this.ndParam.getBase3StartTime().equals("")) {
                    this.ndParam.setBase3StartTime(this.ndParam.getBase3StartTime().replace(" ", "@"));
                } else {
                    this.ndParam.setBase3StartTime(null);
                }
                if (this.ndParam.getBase3EndTime() != null && !this.ndParam.getBase3EndTime().equals("")) {
                    this.ndParam.setBase3EndTime(this.ndParam.getBase3EndTime().replace(" ", "@"));
                } else {
                    this.ndParam.setBase3EndTime(null);
                }
                if (this.ndParam.getBase1MSRName() != null && this.ndParam.getBase1MSRName().equals("")) {
                    this.ndParam.setBase1MSRName(null);
                }
                if (this.ndParam.getBase2MSRName() != null && this.ndParam.getBase2MSRName().equals("")) {
                    this.ndParam.setBase2MSRName(null);
                }
                if (this.ndParam.getBase3MSRName() != null && this.ndParam.getBase3MSRName().equals("")) {
                    this.ndParam.setBase3MSRName(null);
                }
            }
            if (this.getCritical() != null && !this.getCritical().equals("")) {
                this.ndParam.setCritiThreshold(this.getCritical().replace(" ", "@"));
            }
            if (this.getWarning() != null && !this.getWarning().equals("")) {
                this.ndParam.setWarThreshold(this.getWarning().replace(" ", "@"));
            }
            if (this.getOverall() != null && !this.getOverall().equals("")) {
                this.ndParam.setFailThreshold(this.getOverall().replace(" ", "@"));
            }
            URL url = test == null ? new URL((restUrl + "/ProductUI/productSummary/jenkinsService/reportData?reportParam=" + this.ndParam.toString() + "&status=false&chkRule=" + this.getJkRule()).replaceAll(" ", "%20")) : new URL((restUrl + "/ProductUI/productSummary/jenkinsService/reportData?reportParam=" + test + "&status=true").replaceAll(" ", "%20"));
            this.logger.log(Level.FINE, "Cavisson-Plugin|checkAndMakeConnection method called. with arguments url" + url);
            URLConnection conn = NdConnectionManager.getConnections(url, this.isSkipSSLCertValidation(), this.isSkipSSLHostValidation());
            conn.setConnectTimeout(0);
            conn.setReadTimeout(0);
            ((HttpURLConnection)conn).setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            conn.setDoOutput(false);
            if (((HttpURLConnection)conn).getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + ((HttpURLConnection)conn).getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            this.setResult(br.readLine());
            JSONObject resonseObj = null;
            resonseObj = (JSONObject)JSONSerializer.toJSON((Object)this.result);
            Boolean status = (Boolean)resonseObj.get("status");
            if (resonseObj.has("TestRun")) {
                String testRun = (String)resonseObj.get("TestRun");
                if (!testRun.equals("-1")) {
                    consoleLogger.println("NDE Test Run Number  = " + testRun);
                }
                NetDiagnosticsResultsPublisher.setTestRun(testRun.toString());
            }
            return status;
        }
        catch (MalformedURLException e) {
            this.logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in establishing connection. MalformedURLException -", e);
            return false;
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in establishing connection. IOException -", e);
            errMsg.append("\"" + e.getMessage() + "\". |");
            return false;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Cavisson-Plugin|Unknown exception in establishing connection.", e);
            return false;
        }
    }

    public MetricDataContainer fetchMetricData(String[] metrics, String durationInMinutes, int[] groupIds, int[] graphIds, int testRun, String testMode) {
        this.logger.log(Level.FINE, "Cavisson-Plugin|fetchMetricData() called. get resulet" + this.getResult());
        JSONObject resonseObj = null;
        resonseObj = (JSONObject)JSONSerializer.toJSON((Object)this.result);
        if (resonseObj == null) {
            this.logger.log(Level.SEVERE, "Cavisson-Plugin|Not able to get response form server due to: ");
            return null;
        }
        return this.parseJSONData(resonseObj, testMode);
    }

    private MetricDataContainer parseJSONData(JSONObject resonseObj, String testMode) {
        this.logger.log(Level.FINE, "Cavisson-Plugin|parseJSONData() called.");
        MetricDataContainer metricDataContainer = new MetricDataContainer();
        this.logger.log(Level.FINE, "Cavisson-Plugin|Metric Data:" + metricDataContainer);
        this.logger.log(Level.FINE, "Cavisson-Plugin|Recived response from : " + resonseObj);
        try {
            ArrayList<MetricData> dataList = new ArrayList<MetricData>();
            JSONObject jsonGraphs = (JSONObject)resonseObj.get("graphs");
            this.logger.log(Level.FINE, "Cavisson-Plugin|Recived response from graphs : " + jsonGraphs);
            int freq = (Integer)resonseObj.get("frequency") / 1000;
            this.logger.log(Level.FINE, "Cavisson-Plugin|Recived response from : frq = " + freq);
            metricDataContainer.setFrequency(freq);
            if (resonseObj.containsKey((Object)"customHTMLReport")) {
                metricDataContainer.setCustomHTMLReport((String)resonseObj.get("customHTMLReport"));
            }
            String[] prefix = this.URLConnectionString.split("//");
            TestReport testReport = new TestReport();
            if ("T".equals(testMode)) {
                this.logger.log(Level.FINE, "Cavisson-Plugin|Recived response inside test mode : ");
                testReport = new TestReport();
                JSONObject jsonTestReportWholeObj = resonseObj.getJSONObject("testReport");
                this.logger.log(Level.FINE, "Cavisson-Plugin|Recived response from whole report : " + jsonTestReportWholeObj);
                JSONObject jsonTestReport = jsonTestReportWholeObj.getJSONObject("members");
                this.logger.log(Level.FINE, "Cavisson-Plugin|Recived response from test report : " + jsonTestReport);
                String overAllStatus = jsonTestReport.getString("Overall Status");
                String date = jsonTestReport.getString("Date");
                String overAllFailCriteria = jsonTestReport.getString("Overall Fail Criteria (greater than red) %");
                String serverName = jsonTestReport.getString("IP");
                String productName = jsonTestReport.getString("ProductName");
                String previousTestRun = jsonTestReport.getString("Previous Test Run");
                String baseLineTestRun = jsonTestReport.getString("Baseline Test Run");
                String initialTestRun = jsonTestReport.getString("Initial Test Run");
                String baseLineDateTime = jsonTestReport.getString("Baseline Date Time");
                String previousDateTime = jsonTestReport.getString("Previous Date Time");
                String initialDateTime = jsonTestReport.getString("Initial Date Time");
                String testRun = jsonTestReport.getString("Test Run");
                String normalThreshold = jsonTestReport.getString("Normal Threshold");
                String criticalThreshold = jsonTestReport.getString("Critical Threshold");
                String dashboardURL = jsonTestReport.getString("Dashboard Link");
                String reportLink = jsonTestReport.getString("Report Link");
                String currentDateTime = "";
                String previousDescription = "";
                String baselineDescription = "";
                String currentDescription = "";
                String initialDescription = "";
                try {
                    currentDateTime = jsonTestReport.getString("Current Date Time");
                    previousDescription = jsonTestReport.getString("Previous Description");
                    baselineDescription = jsonTestReport.getString("Baseline Description");
                    currentDescription = jsonTestReport.getString("Current Description");
                    initialDescription = jsonTestReport.getString("Initial Description");
                }
                catch (Exception ex) {
                    this.logger.log(Level.SEVERE, "Cavisson-Plugin|Error in parsing Test Report Data:" + ex);
                    this.logger.log(Level.SEVERE, "Cavisson-Plugin|---" + ex.getMessage());
                }
                if (jsonTestReport.get("Metrics Under Test") != null) {
                    JSONArray metricsUnderTest = (JSONArray)jsonTestReport.get("Metrics Under Test");
                    ArrayList<TestMetrics> testMetricsList = new ArrayList<TestMetrics>(metricsUnderTest.size());
                    String str = "";
                    int index = 0;
                    for (Object jsonData : metricsUnderTest) {
                        JSONObject jsonObject = (JSONObject)jsonData;
                        String prevTestValue = jsonObject.getString("Prev Test Value ");
                        String baseLineValue = jsonObject.getString("Baseline Value ");
                        String initialValue = jsonObject.getString("Initial Value ");
                        String currValue = jsonObject.getString("Value");
                        String edLink = jsonObject.getString("link");
                        String metric = jsonObject.getString("Metric");
                        String metricRule = jsonObject.getString("MetricRule");
                        String operator = jsonObject.getString("Operator");
                        String sla = jsonObject.getString("SLA");
                        String count = jsonObject.getString("Count");
                        if (sla.indexOf(">") != -1 || sla.indexOf(">") > 0) {
                            sla = sla.substring(sla.lastIndexOf(">") + 1, sla.length());
                        }
                        String transactiontStatus = jsonObject.getString("Transaction Status");
                        String transactionBgcolor = jsonObject.getString("Transaction BGcolor");
                        String transactionTooltip = jsonObject.getString("Transaction Tooltip");
                        String trendLink = jsonObject.getString("trendLink");
                        String metricLink = jsonObject.getString("Metric_DashboardLink");
                        TestMetrics testMetric = new TestMetrics();
                        testMetric.setBaseLineValue(baseLineValue);
                        testMetric.setCurrValue(currValue);
                        if (edLink != null) {
                            testMetric.setEdLink(edLink);
                        } else {
                            testMetric.setEdLink("NA");
                        }
                        testMetric.setOperator(operator);
                        testMetric.setPrevTestRunValue(prevTestValue);
                        testMetric.setInitialValue(initialValue);
                        testMetric.setSLA(sla);
                        if (count.equals("noCount")) {
                            testMetric.setCount("NA");
                        } else {
                            testMetric.setCount(count);
                        }
                        testMetric.setLinkForTrend(trendLink);
                        testMetric.setMetricName(metric);
                        boolean fromPattern = false;
                        String patt = jsonObject.getString("PATTERN");
                        if (metric.trim().contains("- PATTERN")) {
                            int len = patt.length() + 2;
                            String dName = metric.substring(metric.indexOf("-") + len + 1, metric.trim().length() - 1);
                            metric = metric.replace(metric.substring(metric.indexOf("-"), metric.length()), "- " + dName);
                            fromPattern = true;
                        }
                        String headerName = "";
                        String displayName = metric;
                        if (index == 0) {
                            str = displayName;
                            if (displayName.contains("- All") && !fromPattern) {
                                headerName = displayName.substring(0, str.indexOf("-") + 5);
                                displayName = displayName.substring(displayName.indexOf("-") + 6, displayName.length() - 1);
                            } else if (displayName.contains(" - ")) {
                                headerName = displayName.substring(0, str.indexOf("-") + 1);
                                displayName = displayName.substring(displayName.indexOf("-") + 1, displayName.length() - 1);
                            } else {
                                headerName = "Other";
                            }
                            ++index;
                        } else if (displayName.contains(" - ") && str.indexOf("-") != -1) {
                            String metricName = displayName.substring(0, displayName.indexOf("-"));
                            if (metricName.toString().trim().equals(str.substring(0, str.indexOf("-")).toString().trim())) {
                                headerName = "";
                                displayName = displayName.contains("- All") && !fromPattern ? displayName.substring(displayName.indexOf("-") + 6, displayName.length() - 1) : displayName.substring(displayName.indexOf("-") + 1, displayName.length());
                            } else {
                                str = displayName;
                                if (displayName.contains("- All") && !fromPattern) {
                                    headerName = displayName.substring(0, displayName.indexOf("-") + 5);
                                    displayName = displayName.substring(displayName.indexOf("-") + 6, displayName.length() - 1);
                                } else if (displayName.contains(" - ")) {
                                    headerName = displayName.substring(0, displayName.indexOf("-"));
                                    displayName = displayName.substring(displayName.indexOf("-") + 1, displayName.length());
                                } else {
                                    headerName = "Other";
                                }
                            }
                        } else if (str.indexOf("-") == -1) {
                            str = displayName;
                            if (displayName.contains("- All") && !fromPattern) {
                                headerName = displayName.substring(0, str.indexOf("-") + 5);
                                displayName = displayName.substring(str.indexOf("-") + 6, displayName.length() - 1);
                            } else if (displayName.contains(" - ")) {
                                headerName = displayName.substring(0, str.indexOf("-"));
                                displayName = displayName.substring(str.indexOf("-") + 1, displayName.length());
                            } else {
                                headerName = "Other";
                            }
                        } else {
                            headerName = "Other";
                        }
                        testMetric.setNewReport("NewReport");
                        testMetric.setDisplayName(displayName);
                        testMetric.setHeaderName(headerName);
                        testMetric.setMetricLink(metricLink);
                        testMetric.setMetricRuleName(metricRule);
                        testMetric.setTransactiontStatus(transactiontStatus);
                        testMetric.setStatusColour(transactionBgcolor);
                        testMetric.setTransactionTooltip(transactionTooltip);
                        testMetricsList.add(testMetric);
                        testReport.setOperator(operator);
                        testReport.setTestMetrics(testMetricsList);
                        if (count.equals("noCount")) {
                            testReport.setShowCount("0");
                            continue;
                        }
                        testReport.setShowCount("1");
                    }
                } else {
                    if (jsonTestReport.get("Transaction Stats") != null) {
                        JSONObject transStats = (JSONObject)jsonTestReport.get("Transaction Stats");
                        testReport = this.metricDataForTrans(transStats, testReport, jsonTestReport);
                    }
                    if (jsonTestReport.get("Vector Groups") != null) {
                        JSONObject vectorGroups = (JSONObject)jsonTestReport.get("Vector Groups");
                        testReport = this.metricDataForVectorGroups(vectorGroups, testReport, jsonTestReport);
                    }
                    if (jsonTestReport.get("Scalar Groups") != null) {
                        JSONObject scalarGroups = (JSONObject)jsonTestReport.get("Scalar Groups");
                        testReport = this.metricDataForScalar(scalarGroups, testReport, jsonTestReport);
                    }
                }
                int transObj = 1;
                if (jsonTestReport.has("BASETOT")) {
                    transObj = 2;
                }
                if (!this.isNDE) {
                    for (int i = 0; i < transObj; ++i) {
                        JSONObject transactionJson = null;
                        transactionJson = i == 1 ? jsonTestReport.getJSONObject("BASETOT") : (jsonTestReport.has("TOT") ? jsonTestReport.getJSONObject("TOT") : jsonTestReport.getJSONObject("CTOT"));
                        String complete = "NA";
                        if (transactionJson.getString("complete") != null) {
                            complete = transactionJson.getString("complete");
                        }
                        String totalTimeOut = "NA";
                        if (transactionJson.getString("Time Out") != null) {
                            totalTimeOut = transactionJson.getString("Time Out");
                        }
                        String t4xx = "NA";
                        if (transactionJson.getString("4xx") != null) {
                            t4xx = transactionJson.getString("4xx");
                        }
                        String t5xx = "NA";
                        if (transactionJson.getString("5xx") != null) {
                            t5xx = transactionJson.getString("5xx");
                        }
                        String conFail = "NA";
                        if (transactionJson.getString("ConFail") != null) {
                            conFail = transactionJson.getString("ConFail");
                        }
                        String cvFail = "NA";
                        if (transactionJson.getString("C.V Fail") != null) {
                            cvFail = transactionJson.getString("C.V Fail");
                        }
                        String success = "NA";
                        if (transactionJson.getString("success") != null) {
                            success = transactionJson.getString("success");
                        }
                        String warVersionTrans = "NA";
                        if (transactionJson.has("warVersion")) {
                            warVersionTrans = transactionJson.getString("warVersion");
                        }
                        String releaseVersionTrans = "NA";
                        if (transactionJson.has("releaseVersion")) {
                            releaseVersionTrans = transactionJson.getString("releaseVersion");
                        }
                        TransactionStats transactionStats = new TransactionStats();
                        if (i == 1) {
                            transactionStats.setTransTestRun("BASETOT");
                        } else if (jsonTestReport.has("TOT")) {
                            transactionStats.setTransTestRun("TOT");
                        } else {
                            transactionStats.setTransTestRun("CTOT");
                        }
                        transactionStats.setComplete(complete);
                        transactionStats.setConFail(conFail);
                        transactionStats.setCvFail(cvFail);
                        transactionStats.setSuccess(success);
                        transactionStats.setT4xx(t4xx);
                        transactionStats.setT5xx(t5xx);
                        transactionStats.setTotalTimeOut(totalTimeOut);
                        transactionStats.setWarVersion(warVersionTrans);
                        transactionStats.setReleaseVersion(releaseVersionTrans);
                        testReport.getTransStatsList().add(transactionStats);
                    }
                } else {
                    testReport.setShowHideTransaction(true);
                }
                if (this.isNDE) {
                    String[] curEndDateTime;
                    String[] curStartDateTime = this.ndParam.getCurStartTime().split("@");
                    currentDateTime = curStartDateTime[0].equals((curEndDateTime = this.ndParam.getCurEndTime().split("@"))[0]) ? this.ndParam.getCurStartTime().replace("@", " ") + " to " + curEndDateTime[1] : this.ndParam.getCurStartTime().replace("@", " ") + " to " + this.ndParam.getCurEndTime().replace("@", " ");
                    if (this.ndParam.isPrevDuration()) {
                        String prevStartTime = this.ndParam.getCurStartTime().replace("@", " ");
                        String prevEndTime = this.ndParam.getCurEndTime().replace("@", " ");
                        SimpleDateFormat trDateFormat = new SimpleDateFormat("MM/dd/yy HH:mm:ss");
                        Date userStartDate = trDateFormat.parse(prevStartTime);
                        long startTime = userStartDate.getTime();
                        Date userEndDate = trDateFormat.parse(prevEndTime);
                        long endTime = userEndDate.getTime();
                        long diff = endTime - startTime;
                        long prevStartTS = startTime - diff;
                        long prevEndTS = startTime;
                        Date startDatePrev = new Date(prevStartTS);
                        String prevStartDuration = trDateFormat.format(startDatePrev);
                        Date endDatePrev = new Date(prevEndTS);
                        String prevEndDuration = trDateFormat.format(endDatePrev);
                        String[] prevStartDateTime = prevStartDuration.split(" ");
                        String[] prevEndDateTime = prevEndDuration.split(" ");
                        System.out.println("prevStartDuration = " + prevStartDuration + " , prevEndDuration = " + prevEndDuration);
                        previousDateTime = prevStartDateTime[0].equals(prevEndDateTime[0]) ? prevStartDuration + " to " + prevEndDateTime[1] : prevStartDuration + " to " + prevEndDuration;
                    }
                }
                testReport.setDashboardURL(dashboardURL);
                testReport.setReportLink(reportLink);
                testReport.setBaseLineTestRun(baseLineTestRun);
                testReport.setInitialTestRun(initialTestRun);
                testReport.setBaselineDateTime(baseLineDateTime);
                testReport.setPreviousDateTime(previousDateTime);
                testReport.setInitialDateTime(initialDateTime);
                testReport.setOverAllFailCriteria(overAllFailCriteria);
                testReport.setDate(date);
                testReport.setOverAllStatus(overAllStatus);
                testReport.setServerName(serverName);
                testReport.setIpPortLabel(productName);
                testReport.setPreviousTestRun(previousTestRun);
                testReport.setTestRun(testRun);
                testReport.setNormalThreshold(normalThreshold);
                testReport.setCriticalThreshold(criticalThreshold);
                testReport.setCurrentDateTime(currentDateTime);
                testReport.setPreviousDescription(previousDescription);
                testReport.setBaselineDescription(baselineDescription);
                testReport.setInitialDescription(initialDescription);
                testReport.setCurrentDescription(currentDescription);
                metricDataContainer.setTestReport(testReport);
            }
            Set keySet = jsonGraphs.keySet();
            for (String key : keySet) {
                MetricData metricData = new MetricData();
                JSONObject graphJsonObj = (JSONObject)jsonGraphs.get(key);
                String graphName = (String)graphJsonObj.get("graphMetricPath");
                metricData.setMetricPath(graphName.substring(graphName.indexOf("|") + 1));
                metricData.setFrequency(String.valueOf(freq));
                JSONArray jsonArray = (JSONArray)graphJsonObj.get("graphMetricValues");
                ArrayList<MetricValues> list = new ArrayList<MetricValues>();
                for (Object jsonArray1 : jsonArray) {
                    MetricValues values = new MetricValues();
                    JSONObject graphValues = (JSONObject)jsonArray1;
                    String currVal = String.valueOf(graphValues.get("currentValue"));
                    String maxVal = String.valueOf(graphValues.get("maxValue"));
                    String minVal = String.valueOf(graphValues.get("minValue"));
                    String avg = String.valueOf(graphValues.get("avgValue"));
                    long timeStamp = (Long)graphValues.get("timeStamp");
                    values.setValue((Double)graphValues.get("currentValue"));
                    values.setMax((Double)graphValues.get("maxValue"));
                    values.setMin(this.getMinForMetric((Double)graphValues.get("minValue")));
                    values.setStartTimeInMillis(timeStamp);
                    list.add(values);
                }
                metricData.setMetricValues(list);
                dataList.add(metricData);
                metricDataContainer.setMetricDataList(dataList);
            }
            if (testMode.equals("T")) {
                ArrayList<MetricData> baseLineMetricDataList;
                JSONObject jsonGraphObj;
                ArrayList<MetricData> prevMetricDataList;
                if (resonseObj.get("previousTestDataMap") != null && (prevMetricDataList = this.parsePreviousAndBaseLineData(jsonGraphObj = (JSONObject)resonseObj.get("previousTestDataMap"), freq, "Previous Test Run")) != null) {
                    this.logger.log(Level.FINE, "Cavisson-Plugin|Setting previous test data in metric container = " + prevMetricDataList);
                    metricDataContainer.setMetricPreviousDataList(prevMetricDataList);
                }
                if (resonseObj.get("baseLineTestDataMap") != null && (baseLineMetricDataList = this.parsePreviousAndBaseLineData(jsonGraphObj = (JSONObject)resonseObj.get("baseLineTestDataMap"), freq, "Base Line Test Run")) != null) {
                    this.logger.log(Level.FINE, "Cavisson-Plugin|Setting baseline test data in metric container = " + baseLineMetricDataList);
                    metricDataContainer.setMetricBaseLineDataList(baseLineMetricDataList);
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Cavisson-Plugin|Error in parsing metrics stats");
            this.logger.log(Level.SEVERE, "Cavisson-Plugin|Metric Data:" + e);
            this.logger.log(Level.SEVERE, "Cavisson-Plugin|---" + e.getMessage());
            return null;
        }
        this.logger.log(Level.FINE, "Cavisson-Plugin|Metric Data:" + metricDataContainer);
        return metricDataContainer;
    }

    private TestReport metricDataForVectorGroups(JSONObject vectorGroups, TestReport testReport, JSONObject jsonTestReport) {
        try {
            this.logger.log(Level.FINE, "Cavisson-Plugin|metricDataForVectorGroups() called.");
            String previousTestRun = jsonTestReport.getString("Previous Test Run");
            String baseLineTestRun = jsonTestReport.getString("Baseline Test Run");
            String initialTestRun = jsonTestReport.getString("Initial Test Run");
            ArrayList<MetricInfo> arr = new ArrayList<MetricInfo>();
            Iterator keys = vectorGroups.keys();
            while (keys.hasNext()) {
                String groupName = (String)keys.next();
                MetricInfo info = new MetricInfo();
                info.setGroupName(groupName);
                JSONObject groupInfo = (JSONObject)vectorGroups.get(groupName);
                JSONArray metricListForVector = (JSONArray)groupInfo.get("MetricName");
                JSONArray vectorListForVector = (JSONArray)groupInfo.get("vector List");
                JSONObject metricInfoForVector = (JSONObject)groupInfo.get("Metric Info");
                JSONObject linkInfo = (JSONObject)groupInfo.get("link");
                ArrayList<String> vectorList = new ArrayList<String>();
                ArrayList<ScalarVal> arrForVectorinfo = new ArrayList<ScalarVal>();
                for (int i = 0; i < vectorListForVector.size(); ++i) {
                    vectorList.add((String)vectorListForVector.get(i));
                }
                info.setVectorList(vectorList);
                ArrayList<MetricLinkInfo> metricLinkInfo = new ArrayList<MetricLinkInfo>();
                for (int i = 0; i < vectorListForVector.size(); ++i) {
                    String vectorNameVec = (String)vectorListForVector.get(i);
                    this.logger.log(Level.FINE, "Cavisson-Plugin|vector name--" + vectorNameVec);
                    for (int j = 0; j < metricListForVector.size(); ++j) {
                        String metricNameVec = (String)metricListForVector.get(j);
                        this.logger.log(Level.FINE, "Cavisson-Plugin|metric name--" + metricNameVec);
                        if (!metricInfoForVector.containsKey((Object)vectorNameVec)) continue;
                        JSONArray vectorInfo = (JSONArray)metricInfoForVector.get(vectorNameVec);
                        for (int k = 0; k < vectorInfo.size(); ++k) {
                            JSONObject metricVecInfo = (JSONObject)vectorInfo.get(k);
                            if (!metricVecInfo.containsKey((Object)metricNameVec)) continue;
                            JSONObject metricInfoFinal = (JSONObject)metricVecInfo.get(metricNameVec);
                            ScalarVal finalInfoForVector = new ScalarVal();
                            String Op = (String)metricInfoFinal.get("Operator");
                            String prev = (String)metricInfoFinal.get("Prev Test Value ");
                            String Product = (String)metricInfoFinal.get("Prod");
                            String baselineValue = (String)metricInfoFinal.get("Baseline Value ");
                            String transStatus = (String)metricInfoFinal.get("Transaction Status");
                            String transTooltip = (String)metricInfoFinal.get("Transaction Tooltip");
                            String transBGcolor = (String)metricInfoFinal.get("Transaction BGcolor");
                            String Value = (String)metricInfoFinal.get("Value");
                            String linkss = (String)metricInfoFinal.get("link");
                            String SLA = (String)metricInfoFinal.get("SLA");
                            String initialValue = (String)metricInfoFinal.get("Initial Value ");
                            String Stress = (String)metricInfoFinal.get("Stress");
                            finalInfoForVector.setOperator(Op);
                            finalInfoForVector.setPrevTestValue(prev);
                            finalInfoForVector.setProd(Product);
                            finalInfoForVector.setBaselineValue(baselineValue);
                            finalInfoForVector.setTransactionStatus(transStatus);
                            finalInfoForVector.setTransactionTooltip(transTooltip);
                            finalInfoForVector.setTransactionBGcolor(transBGcolor);
                            finalInfoForVector.setValue(Value);
                            finalInfoForVector.setLink(linkss);
                            finalInfoForVector.setSLA(SLA);
                            finalInfoForVector.setInitialValue(initialValue);
                            finalInfoForVector.setStress(Stress);
                            finalInfoForVector.setMetricName(metricNameVec);
                            finalInfoForVector.setVectorName(vectorNameVec);
                            arrForVectorinfo.add(finalInfoForVector);
                        }
                    }
                    MetricLinkInfo link = new MetricLinkInfo();
                    link.setVectorName(vectorNameVec);
                    String lnk = (String)linkInfo.get(vectorNameVec);
                    link.setLink(lnk);
                    metricLinkInfo.add(link);
                }
                info.setMetricLink(metricLinkInfo);
                info.setGroupInfo(arrForVectorinfo);
                ArrayList<MetricVal> vectorArrFinal = new ArrayList<MetricVal>();
                String vectorVal = vectorList.get(0);
                for (int i = 0; i < metricListForVector.size(); ++i) {
                    String metrcNames = (String)metricListForVector.get(i);
                    int counts = 0;
                    MetricVal metrVal = new MetricVal();
                    JSONArray metricArrSec = (JSONArray)metricInfoForVector.get(vectorVal);
                    for (int j = 0; j < metricArrSec.size(); ++j) {
                        String trans;
                        String st;
                        JSONObject metricObj = (JSONObject)metricArrSec.get(j);
                        if (!metricObj.containsKey((Object)metrcNames)) continue;
                        JSONObject finalMetric = (JSONObject)metricObj.get(metrcNames);
                        ArrayList<String> headerForVector = new ArrayList<String>();
                        headerForVector.add("SLA");
                        String pr = (String)finalMetric.get("Prod");
                        if (!pr.equals("0.0") && !pr.equals("-")) {
                            ++counts;
                            headerForVector.add("Prod");
                            metrVal.setProd(true);
                        }
                        if (!(st = (String)finalMetric.get("Stress")).equals("0.0") && !st.equals("-")) {
                            ++counts;
                            headerForVector.add("Stress");
                            metrVal.setStress(true);
                        }
                        if (!baseLineTestRun.equals("-1")) {
                            ++counts;
                            headerForVector.add("Baseline TR");
                        }
                        if (!initialTestRun.equals("-1")) {
                            ++counts;
                            headerForVector.add("Initial TR");
                        }
                        if (!previousTestRun.equals("-1")) {
                            ++counts;
                            headerForVector.add("Previous TR");
                        }
                        if (!(trans = (String)finalMetric.get("Transaction Status")).equals("-1")) {
                            ++counts;
                            headerForVector.add("Success (%)");
                            metrVal.setTrans(true);
                        }
                        metrVal.setCountForBenchmark(++counts);
                        int countForMetrices = counts + 2;
                        metrVal.setCountForMetrices(countForMetrices);
                        metrVal.setHeadersForTrans(headerForVector);
                        metrVal.setNameOfMetric(metrcNames);
                    }
                    vectorArrFinal.add(metrVal);
                }
                info.setVectorObj(vectorArrFinal);
                arr.add(info);
            }
            testReport.setVectorValues(arr);
            return testReport;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Cavisson-Plugin|Error in getting metric data for vector Group");
            this.logger.log(Level.SEVERE, "Cavisson-Plugin|Metric Data:" + e);
            this.logger.log(Level.SEVERE, "Cavisson-Plugin|---" + e.getMessage());
            return null;
        }
    }

    private TestReport metricDataForTrans(JSONObject transGroup, TestReport testReport, JSONObject jsonTestReport) {
        try {
            JSONObject metricObj;
            this.logger.log(Level.FINE, "Cavisson-Plugin|metricDataForTrans() called.");
            String previousTestRun = jsonTestReport.getString("Previous Test Run");
            String baseLineTestRun = jsonTestReport.getString("Baseline Test Run");
            String initialTestRun = jsonTestReport.getString("Initial Test Run");
            JSONArray metricNamesForTrans = (JSONArray)transGroup.get("MetricName");
            JSONArray vectorListForTrans = (JSONArray)transGroup.get("vector List");
            JSONObject metricInfoForTrans = (JSONObject)transGroup.get("Metric Info");
            JSONObject linkObj = (JSONObject)transGroup.get("link");
            boolean prodCount = false;
            boolean stressCount = false;
            ArrayList<ScalarVal> transArr = new ArrayList<ScalarVal>();
            ArrayList<String> vectorForTrans = new ArrayList<String>();
            for (int i = 0; i < vectorListForTrans.size(); ++i) {
                vectorForTrans.add((String)vectorListForTrans.get(i));
            }
            testReport.setVecList(vectorForTrans);
            ArrayList<MetricLinkInfo> merticLink = new ArrayList<MetricLinkInfo>();
            for (int i = 0; i < vectorListForTrans.size(); ++i) {
                String vectorNameTrans = (String)vectorListForTrans.get(i);
                for (int j = 0; j < metricNamesForTrans.size(); ++j) {
                    String metricNameTranss = (String)metricNamesForTrans.get(j);
                    ScalarVal transValue = new ScalarVal();
                    if (metricInfoForTrans.containsKey((Object)vectorNameTrans)) {
                        JSONArray metricArr = (JSONArray)metricInfoForTrans.get(vectorNameTrans);
                        for (int k = 0; k < metricArr.size(); ++k) {
                            JSONObject newMetric = (JSONObject)metricArr.get(k);
                            if (!newMetric.containsKey((Object)metricNameTranss)) continue;
                            metricObj = (JSONObject)newMetric.get(metricNameTranss);
                            String Oper = (String)metricObj.get("Operator");
                            String prevTest = (String)metricObj.get("Prev Test Value ");
                            String Production = (String)metricObj.get("Prod");
                            String baselineVal = (String)metricObj.get("Baseline Value ");
                            String transStatus = (String)metricObj.get("Transaction Status");
                            String transactionTool = (String)metricObj.get("Transaction Tooltip");
                            String transactionBG = (String)metricObj.get("Transaction BGcolor");
                            String Val = (String)metricObj.get("Value");
                            String links = (String)metricObj.get("link");
                            String sla = (String)metricObj.get("SLA");
                            String initialVal = (String)metricObj.get("Initial Value ");
                            String stress = (String)metricObj.get("Stress");
                            transValue.setOperator(Oper);
                            transValue.setPrevTestValue(prevTest);
                            transValue.setProd(Production);
                            transValue.setBaselineValue(baselineVal);
                            transValue.setTransactionStatus(transStatus);
                            transValue.setTransactionTooltip(transactionTool);
                            transValue.setTransactionBGcolor(transactionBG);
                            transValue.setValue(Val);
                            transValue.setLink(links);
                            transValue.setSLA(sla);
                            transValue.setInitialValue(initialVal);
                            transValue.setStress(stress);
                            transValue.setMetricName(metricNameTranss);
                            transValue.setVectorName(vectorNameTrans);
                        }
                    }
                    transArr.add(transValue);
                }
                MetricLinkInfo linkInfo = new MetricLinkInfo();
                linkInfo.setVectorName(vectorNameTrans);
                String link = (String)linkObj.get(vectorNameTrans);
                linkInfo.setLink(link);
                merticLink.add(linkInfo);
            }
            testReport.setTransactionStats(transArr);
            testReport.setTransMetricLink(merticLink);
            ArrayList<MetricVal> metricArrFinal = new ArrayList<MetricVal>();
            String vectorAny = vectorForTrans.get(0);
            for (int i = 0; i < metricNamesForTrans.size(); ++i) {
                String metrcNames = (String)metricNamesForTrans.get(i);
                int count = 0;
                MetricVal metrVal = new MetricVal();
                JSONArray metricArrSec = (JSONArray)metricInfoForTrans.get(vectorAny);
                for (int j = 0; j < metricArrSec.size(); ++j) {
                    String transactionStatus;
                    String stress;
                    metricObj = (JSONObject)metricArrSec.get(j);
                    if (!metricObj.containsKey((Object)metrcNames)) continue;
                    JSONObject finalMetric = (JSONObject)metricObj.get(metrcNames);
                    ArrayList<String> transHeader = new ArrayList<String>();
                    transHeader.add("SLA");
                    String prod = (String)finalMetric.get("Prod");
                    if (!prod.equals("0.0") && !prod.equals("-")) {
                        ++count;
                        transHeader.add("Prod");
                        metrVal.setProd(true);
                    }
                    if (!(stress = (String)finalMetric.get("Stress")).equals("0.0") && !stress.equals("-")) {
                        ++count;
                        transHeader.add("Stress");
                        metrVal.setStress(true);
                    }
                    if (!baseLineTestRun.equals("-1")) {
                        ++count;
                        transHeader.add("Baseline TR");
                    }
                    if (!initialTestRun.equals("-1")) {
                        ++count;
                        transHeader.add("Initial TR");
                    }
                    if (!previousTestRun.equals("-1")) {
                        ++count;
                        transHeader.add("Previous TR");
                    }
                    if (!(transactionStatus = (String)finalMetric.get("Transaction Status")).equals("-1")) {
                        ++count;
                        transHeader.add("Success (%)");
                        metrVal.setTrans(true);
                    }
                    metrVal.setCountForBenchmark(++count);
                    int countForMetrices = count + 2;
                    metrVal.setCountForMetrices(countForMetrices);
                    metrVal.setHeadersForTrans(transHeader);
                    metrVal.setNameOfMetric(metrcNames);
                }
                metricArrFinal.add(metrVal);
            }
            testReport.setMetricValues(metricArrFinal);
            return testReport;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Cavisson-Plugin|Error in getting metric data");
            this.logger.log(Level.SEVERE, "Cavisson-Plugin|Metric Data:" + e);
            this.logger.log(Level.SEVERE, "Cavisson-Plugin|---" + e.getMessage());
            return null;
        }
    }

    private TestReport metricDataForScalar(JSONObject scalarGroups, TestReport testReport, JSONObject jsonTestReport) {
        try {
            this.logger.log(Level.FINE, "Cavisson-Plugin|metricDataForScalar() called.");
            String previousTestRun = jsonTestReport.getString("Previous Test Run");
            String baseLineTestRun = jsonTestReport.getString("Baseline Test Run");
            String initialTestRun = jsonTestReport.getString("Initial Test Run");
            JSONArray metricNames = (JSONArray)scalarGroups.get("MetricName");
            JSONObject metricGrp = (JSONObject)scalarGroups.get("Metric Info");
            JSONObject metricLink = (JSONObject)scalarGroups.get("link");
            ArrayList<ScalarVal> scalarArr = new ArrayList<ScalarVal>();
            int countForProd = 0;
            int countForStress = 0;
            int countForTrans = 0;
            ArrayList<String> scalarHeader = new ArrayList<String>();
            for (int i = 0; i < metricNames.size(); ++i) {
                String name = (String)metricNames.get(i);
                if (!metricGrp.containsKey((Object)name)) continue;
                JSONObject scalarVal = (JSONObject)metricGrp.get(name);
                String Operator = (String)scalarVal.get("Operator");
                String preValue = (String)scalarVal.get("Prev Test Value ");
                String Prod = (String)scalarVal.get("Prod");
                String baselineValue = (String)scalarVal.get("Baseline Value ");
                String transactionStatus = (String)scalarVal.get("Transaction Status");
                String transactionTooltip = (String)scalarVal.get("Transaction Tooltip");
                String transactionBGcolor = (String)scalarVal.get("Transaction BGcolor");
                String Value = (String)scalarVal.get("Value");
                String link = (String)metricLink.get(name);
                String SLA = (String)scalarVal.get("SLA");
                String initialValue = (String)scalarVal.get("Initial Value ");
                String Stress = (String)scalarVal.get("Stress");
                this.logger.log(Level.FINE, "Cavisson-Plugin|Prev Test Value------ " + preValue);
                if (!Prod.equals("0.0") && !Prod.equals("-1")) {
                    ++countForProd;
                }
                if (!Stress.equals("0.0") && !Stress.equals("-1")) {
                    ++countForStress;
                }
                if (!transactionStatus.equals("-1")) {
                    ++countForTrans;
                }
                ScalarVal scalarValue = new ScalarVal();
                scalarValue.setOperator(Operator);
                scalarValue.setPrevTestValue(preValue);
                scalarValue.setProd(Prod);
                scalarValue.setBaselineValue(baselineValue);
                scalarValue.setTransactionStatus(transactionStatus);
                scalarValue.setTransactionTooltip(transactionTooltip);
                scalarValue.setTransactionBGcolor(transactionBGcolor);
                scalarValue.setValue(Value);
                scalarValue.setLink(link);
                scalarValue.setSLA(SLA);
                scalarValue.setInitialValue(initialValue);
                scalarValue.setStress(Stress);
                scalarValue.setMetricName(name);
                scalarArr.add(scalarValue);
            }
            testReport.setScalarGroups(scalarArr);
            scalarHeader.add("SLA");
            if (countForProd != 0) {
                scalarHeader.add("Prod");
            }
            if (countForStress != 0) {
                scalarHeader.add("Stress");
            }
            if (!baseLineTestRun.equals("-1")) {
                scalarHeader.add("Baseline TR");
            }
            if (!initialTestRun.equals("-1")) {
                scalarHeader.add("Initial TR");
            }
            if (!previousTestRun.equals("-1")) {
                scalarHeader.add("Previous TR");
            }
            if (countForTrans != 0) {
                scalarHeader.add("Success(%)");
            }
            scalarHeader.add("Current");
            scalarHeader.add("Trend");
            scalarHeader.add("Action");
            testReport.setScalarHeaders(scalarHeader);
            return testReport;
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "Cavisson-Plugin|Error in parsing previous or baseline metrics stats");
            this.logger.log(Level.SEVERE, "Cavisson-Plugin|---" + ex.getMessage());
            return null;
        }
    }

    private ArrayList<MetricData> parsePreviousAndBaseLineData(JSONObject jsonGraphData, int freq, String type) {
        try {
            this.logger.log(Level.FINE, "Cavisson-Plugin|method called for type = " + type);
            ArrayList<MetricData> listData = new ArrayList<MetricData>();
            Set keySet = jsonGraphData.keySet();
            if (keySet.size() < 1) {
                this.logger.log(Level.FINE, "Cavisson-Plugin|Graph Metrics is not available for " + type);
                return null;
            }
            for (Object keyValue : keySet) {
                if (jsonGraphData.get(keyValue) == null) {
                    return null;
                }
                JSONObject graphWithDataJson = (JSONObject)jsonGraphData.get(keyValue);
                Set keys = graphWithDataJson.keySet();
                for (String key : keys) {
                    MetricData metricData = new MetricData();
                    JSONObject graphJsonObj = (JSONObject)graphWithDataJson.get(key);
                    String graphName = (String)graphJsonObj.get("graphMetricPath");
                    metricData.setMetricPath(graphName.substring(graphName.indexOf("|") + 1));
                    metricData.setFrequency(String.valueOf(freq));
                    JSONArray jsonArray = (JSONArray)graphJsonObj.get("graphMetricValues");
                    ArrayList<MetricValues> list = new ArrayList<MetricValues>();
                    for (Object jsonArray1 : jsonArray) {
                        MetricValues values = new MetricValues();
                        JSONObject graphValues = (JSONObject)jsonArray1;
                        String currVal = String.valueOf(graphValues.get("currentValue"));
                        String maxVal = String.valueOf(graphValues.get("maxValue"));
                        String minVal = String.valueOf(graphValues.get("minValue"));
                        String avg = String.valueOf(graphValues.get("avgValue"));
                        long timeStamp = (Long)graphValues.get("timeStamp");
                        values.setValue((Double)graphValues.get("currentValue"));
                        values.setMax((Double)graphValues.get("maxValue"));
                        values.setMin(this.getMinForMetric((Double)graphValues.get("minValue")));
                        values.setStartTimeInMillis(timeStamp);
                        list.add(values);
                    }
                    metricData.setMetricValues(list);
                    listData.add(metricData);
                }
            }
            return listData;
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "Cavisson-Plugin|Error in parsing previous or baseline metrics stats");
            this.logger.log(Level.SEVERE, "Cavisson-Plugin|---" + ex.getMessage());
            return null;
        }
    }

    private double getMinForMetric(double metricValue) {
        if (metricValue == Double.MAX_VALUE) {
            return 0.0;
        }
        return metricValue;
    }

    public String getUrlString() {
        String urlAddrs = "";
        try {
            String[] str = this.URLConnectionString.split(":");
            if (str.length > 2) {
                urlAddrs = str[0] + ":" + str[1];
                if (str[2].contains("/")) {
                    String[] value = str[2].split("/");
                    urlAddrs = urlAddrs + ":" + value[0];
                } else {
                    urlAddrs = urlAddrs + ":" + str[2];
                }
            } else {
                urlAddrs = this.URLConnectionString;
            }
            if (urlAddrs.endsWith("/")) {
                urlAddrs = urlAddrs.substring(0, urlAddrs.length() - 1);
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "Cavisson-Plugin|Error in getting url string ");
            return this.URLConnectionString.substring(0, this.URLConnectionString.lastIndexOf("/"));
        }
        return urlAddrs;
    }

    public ArrayList<String> getProfileList(StringBuffer errMsg) {
        try {
            this.logger.log(Level.FINE, "Cavisson-Plugin|getting profile list ");
            ArrayList<String> profiles = new ArrayList<String>();
            String str = this.getUrlString();
            URL url = new URL(str + "/DashboardServer/web/commons/getProfileList?userName=" + this.username);
            URLConnection conn = NdConnectionManager.getConnections(url, this.isSkipSSLCertValidation(), this.isSkipSSLHostValidation());
            ((HttpURLConnection)conn).setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
            conn.setRequestProperty("Content-Type", "application/json");
            if (((HttpURLConnection)conn).getResponseCode() != 200) {
                this.logger.log(Level.FINE, "Cavisson-Plugin|getting error in fetching profile list.");
                profiles = new ArrayList();
                return profiles;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(new GZIPInputStream(conn.getInputStream())));
            StringBuilder stb = new StringBuilder();
            String response = null;
            while ((response = br.readLine()) != null) {
                stb.append(response);
            }
            JSONArray arr = JSONArray.fromObject((Object)stb.toString());
            for (Object obj : arr) {
                String res = JSONObject.fromObject(obj).get("profileName").toString();
                profiles.add(res);
            }
            this.logger.log(Level.FINE, "Cavisson-Plugin|profiles- " + profiles.size());
            return profiles;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Cavisson-Plugin|Error getting profile list- " + e);
            return null;
        }
    }
}

