/*
 * Decompiled with CFR 0.152.
 */
package com.cavisson.jenkins;

import com.cavisson.jenkins.FieldValidator;
import com.cavisson.jenkins.LocalMessages;
import com.cavisson.jenkins.NSNDIntegrationConnectionManager;
import com.cavisson.jenkins.NSNDIntegrationParameterForReport;
import com.cavisson.jenkins.NetStormBuildAction;
import com.cavisson.jenkins.NetStormBuilder;
import com.cavisson.jenkins.NetStormDataCollector;
import com.cavisson.jenkins.NetStormReport;
import com.cavisson.jenkins.TestReport;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Project;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class NSNDIntegrationResultsPublisher
extends Recorder
implements SimpleBuildStep {
    private static final String DEFAULT_USERNAME = "netstorm";
    private static final String DEFAULT_TEST_METRIC = "Average Transaction Response Time (Secs)";
    private static final String fileName = "jenkins_check_rule";
    private static final transient Logger logger = Logger.getLogger(NSNDIntegrationResultsPublisher.class.getName());
    private boolean skipSSLCertCheck = false;
    private boolean skipSSLHostCheck = false;
    NSNDIntegrationParameterForReport ndParams = new NSNDIntegrationParameterForReport();
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private String nsIntegrationUri = "";
    private String nsUsername = "";
    private Secret nsPassword;
    private String ndIntegrationUri = "";
    private String ndUsername = "";
    private Secret ndPassword;
    private String base1StartTime;
    private String base1EndTime;
    private String checkProfilePath;
    private String base2StartTime;
    private String base2EndTime;
    private String base3StartTime;
    private String base3EndTime;
    private String base1MSRName;
    private String base2MSRName;
    private String base3MSRName;
    private String criThreshold;
    private String warThreshold;
    private String failThreshold;
    private String phase;
    private String curStartTimeAbsolute;
    private String curEndTimeAbsolute;
    private String curStartTimeElapsed;
    private String curEndTimeElapsed;
    private static String timePeriod;
    String duration;

    public boolean isSkipSSLCertCheck() {
        return this.skipSSLCertCheck;
    }

    public boolean isSkipSSLHostCheck() {
        return this.skipSSLHostCheck;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(Run<?, ?> run, FilePath fp, Launcher lnchr, TaskListener listener) throws InterruptedException, IOException {
        Object keyEnv;
        Map env = run instanceof AbstractBuild ? ((AbstractBuild)run).getBuildVariables() : Collections.emptyMap();
        PrintStream logger = listener.getLogger();
        StringBuffer errMsg = new StringBuffer();
        String curStart = "";
        String curEnd = " ";
        String path = "";
        String jobName = "";
        String criticalThreshold = "";
        String warningThreshold = "";
        String overallThreshold = "";
        Boolean fileUpload = false;
        Set keyset = env.keySet();
        for (Object key : keyset) {
            Object value = env.get(key);
            keyEnv = (String)key;
            if (!(value instanceof String)) continue;
            if (((String)keyEnv).startsWith("JENKINS_HOME")) {
                path = (String)value;
            }
            if (((String)keyEnv).startsWith("JOB_NAME")) {
                jobName = (String)value;
            }
            if (((String)keyEnv).equalsIgnoreCase("criticalThreshold")) {
                criticalThreshold = (String)value;
            }
            if (((String)keyEnv).equalsIgnoreCase("warningThreshold")) {
                warningThreshold = (String)value;
            }
            if (((String)keyEnv).equalsIgnoreCase("overallThreshold")) {
                overallThreshold = (String)value;
            }
            if (!((String)keyEnv).equalsIgnoreCase(fileName)) continue;
            fileUpload = true;
        }
        JSONObject json = null;
        if (fileUpload.booleanValue()) {
            File file = new File(path + "/workspace/" + jobName + "/" + fileName);
            if (file.exists()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(file));
                    keyEnv = null;
                    try {
                        String line;
                        StringBuilder builder = new StringBuilder();
                        while ((line = reader.readLine()) != null) {
                            if (!line.contains("GroupName") && !line.contains("GraphName") && !line.contains("VectorName") && !line.contains("RuleDesc")) continue;
                            line = line.trim().replaceAll("\\s", "@@");
                        }
                    }
                    catch (Throwable line) {
                        keyEnv = line;
                        throw line;
                    }
                    finally {
                        if (reader != null) {
                            if (keyEnv != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable line) {
                                    ((Throwable)keyEnv).addSuppressed(line);
                                }
                            } else {
                                reader.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.println("Not able to create netstorm report for NSNDIntegrated.may be some configuration issue in running scenario.");
                }
            }
            NSNDIntegrationConnectionManager connection = new NSNDIntegrationConnectionManager(this.nsIntegrationUri, this.nsUsername, this.nsPassword, this.ndIntegrationUri, this.ndUsername, this.ndPassword, this.ndParams);
            connection.setJkRule(json);
            connection.setCritical(criticalThreshold);
            connection.setWarning(warningThreshold);
            connection.setOverall(overallThreshold);
            Project buildProject = (Project)((AbstractBuild)run).getProject();
            List blist = buildProject.getBuilders();
            String testMode = "N";
            for (Builder currentBuilder : blist) {
                if (!(currentBuilder instanceof NetStormBuilder)) continue;
                testMode = ((NetStormBuilder)currentBuilder).getTestMode();
                if (!testMode.equals("T")) break;
                connection.setProject(((NetStormBuilder)currentBuilder).getProject());
                connection.setSubProject(((NetStormBuilder)currentBuilder).getSubProject());
                connection.setScenario(((NetStormBuilder)currentBuilder).getScenario());
                break;
            }
            NetStormDataCollector dataCollector = new NetStormDataCollector(connection, run, Integer.parseInt(NetStormBuilder.getTestRunNumber()), "T", true, this.duration);
            logger.println("data collector object in NSNDIntegration.." + dataCollector.toString());
            try {
                NetStormReport report = dataCollector.createReportFromMeasurements(logger, fp);
                run.setDisplayName(NetStormBuilder.getTestRunNumber());
                NetStormBuilder.setTestRunNumber("-1");
                TestReport tstRpt = report.getTestReport();
                URL url = new URL("http://localhost:8080/job/demo_/buildWithParameters?token=abc&PARAMETER=10.10.2");
                if (tstRpt.getOverAllStatus().equals("PASS")) {
                    URLConnection connect = url.openConnection();
                    String string = connect.getContentType();
                }
            }
            catch (Exception e) {
                logger.println("Not able to create netstorm report for NSNDIntegrated.may be some configuration issue in running scenario.");
                return;
            }
            return;
        }
    }

    public String isTimePeriod(String testTypeName) {
        logger.log(Level.FINE, "Cavisson-Plugin|inside time period check..." + testTypeName + ", ndParams.getTimePeriod() = " + this.ndParams.getTimePeriod());
        return this.ndParams.getTimePeriod().equalsIgnoreCase(testTypeName) ? "true" : "";
    }

    private double calculateAverageBasedOnPreviousReports(List<NetStormReport> reports) {
        double calculatedSum = 0.0;
        int numberOfMeasurements = 0;
        for (NetStormReport report : reports) {
            double value = report.getAverageForMetric(DEFAULT_TEST_METRIC);
            if (!(value >= 0.0)) continue;
            calculatedSum += value;
            ++numberOfMeasurements;
        }
        double result = -1.0;
        if (numberOfMeasurements > 0) {
            result = calculatedSum / (double)numberOfMeasurements;
        }
        return result;
    }

    private List<NetStormReport> getListOfPreviousReports(Run<?, ?> build, long currentTimestamp) {
        ArrayList<NetStormReport> previousReports = new ArrayList<NetStormReport>();
        NetStormBuildAction performanceBuildAction = (NetStormBuildAction)build.getAction(NetStormBuildAction.class);
        previousReports.add(performanceBuildAction.getBuildActionResultsDisplay().getNetStormReport());
        return previousReports;
    }

    @DataBoundConstructor
    public NSNDIntegrationResultsPublisher(String nsIntegrationUri, String nsUsername, String nsPassword, String ndIntegrationUri, String ndUsername, String ndPassword, String base1StartTime, String base1EndTime, String base2StartTime, String base2EndTime, String base3StartTime, String base3EndTime, String checkProfilePath, String criThreshold, String warThreshold, String failThreshold, String timePeriod, String curStartTimeAbsolute, String curEndTimeAbsolute, String curStartTimeElapsed, String curEndTimeElapsed, String phase, String base1MSRName, String base2MSRName, String base3MSRName) {
        this.setNsIntegrationUri(nsIntegrationUri);
        this.setNsUsername(nsUsername);
        this.setNsPassword(nsPassword);
        this.setNdIntegrationUri(ndIntegrationUri);
        this.setNdUsername(ndUsername);
        this.setNdPassword(ndPassword);
        this.setBase1StartTime(base1StartTime);
        this.setBase1EndTime(base1EndTime);
        this.setBase2StartTime(base2StartTime);
        this.setBase2EndTime(base2EndTime);
        this.setBase3StartTime(base3StartTime);
        this.setBase3EndTime(base3EndTime);
        this.setBase3MSRName(base3MSRName);
        this.setBase2MSRName(base2MSRName);
        this.setBase1MSRName(base1MSRName);
        this.setCheckProfilePath(checkProfilePath);
        this.setCriThreshold(criThreshold);
        this.setWarThreshold(warThreshold);
        this.setFailThreshold(failThreshold);
        this.ndParams.setBase1StartTime(base1StartTime);
        this.ndParams.setBase1EndTime(base1EndTime);
        this.ndParams.setBase2StartTime(base2StartTime);
        this.ndParams.setBase2EndTime(base2EndTime);
        this.ndParams.setBase3StartTime(base3StartTime);
        this.ndParams.setBase3EndTime(base3EndTime);
        this.ndParams.setBase1MSRName(base1MSRName);
        this.ndParams.setBase2MSRName(base2MSRName);
        this.ndParams.setBase3MSRName(base3MSRName);
        this.ndParams.setCheckProfilePath(checkProfilePath);
        if (!this.getCriThreshold().equals("")) {
            this.ndParams.setCritiThreshold(this.getCriThreshold());
        } else {
            this.ndParams.setCritiThreshold(criThreshold);
        }
        if (!this.getWarThreshold().equals("")) {
            this.ndParams.setWarThreshold(this.getWarThreshold());
        } else {
            this.ndParams.setWarThreshold(warThreshold);
        }
        if (!this.getFailThreshold().equals("")) {
            this.ndParams.setFailThreshold(this.getFailThreshold());
        } else {
            this.ndParams.setFailThreshold(failThreshold);
        }
        this.setTimePeriod(timePeriod);
        this.ndParams.setTimePeriod(timePeriod);
        if (timePeriod != null) {
            if (timePeriod.equals("Absolute Time")) {
                this.ndParams.setCurStartTimeAbsolute(curStartTimeAbsolute);
                this.ndParams.setCurEndTimeAbsolute(curEndTimeAbsolute);
                this.setCurStartTimeAbsolute(curStartTimeAbsolute);
                this.setCurEndTimeAbsolute(curEndTimeAbsolute);
            } else if (timePeriod.equals("Elapsed Time")) {
                this.ndParams.setCurStartTimeElapsed(curStartTimeElapsed);
                this.ndParams.setCurEndTimeElapsed(curEndTimeElapsed);
                this.setCurStartTimeElapsed(curStartTimeElapsed);
                this.setCurEndTimeElapsed(curEndTimeElapsed);
            } else if (timePeriod.equals("Phase")) {
                this.ndParams.setPhase(phase);
                this.setPhase(phase);
            }
        }
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public String getTimePeriod() {
        return timePeriod;
    }

    public void setTimePeriod(String timePeriod) {
        NSNDIntegrationResultsPublisher.timePeriod = timePeriod;
    }

    public String getCurStartTimeAbsolute() {
        return this.curStartTimeAbsolute;
    }

    public void setCurStartTimeAbsolute(String curStartTimeAbsolute) {
        this.curStartTimeAbsolute = curStartTimeAbsolute;
    }

    public String getCurEndTimeAbsolute() {
        return this.curEndTimeAbsolute;
    }

    public void setCurEndTimeAbsolute(String curEndTimeAbsolute) {
        this.curEndTimeAbsolute = curEndTimeAbsolute;
    }

    public String getCurStartTimeElapsed() {
        return this.curStartTimeElapsed;
    }

    public void setCurStartTimeElapsed(String curStartTimeElapsed) {
        this.curStartTimeElapsed = curStartTimeElapsed;
    }

    public String getCurEndTimeElapsed() {
        return this.curEndTimeElapsed;
    }

    public void setCurEndTimeElapsed(String curEndTimeElapsed) {
        this.curEndTimeElapsed = curEndTimeElapsed;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public String getCriThreshold() {
        return this.criThreshold;
    }

    public void setCriThreshold(String criThreshold) {
        this.criThreshold = criThreshold;
    }

    public String getWarThreshold() {
        return this.warThreshold;
    }

    public void setWarThreshold(String warThreshold) {
        this.warThreshold = warThreshold;
    }

    public String getFailThreshold() {
        return this.failThreshold;
    }

    public void setFailThreshold(String failThreshold) {
        this.failThreshold = failThreshold;
    }

    public String getBase1StartTime() {
        return this.base1StartTime;
    }

    public void setBase1StartTime(String base1StartTime) {
        this.base1StartTime = base1StartTime;
    }

    public String getBase1EndTime() {
        return this.base1EndTime;
    }

    public void setBase1EndTime(String base1EndTime) {
        this.base1EndTime = base1EndTime;
    }

    public String getBase2StartTime() {
        return this.base2StartTime;
    }

    public void setBase2StartTime(String base2StartTime) {
        this.base2StartTime = base2StartTime;
    }

    public String getBase2EndTime() {
        return this.base2EndTime;
    }

    public void setBase2EndTime(String base2EndTime) {
        this.base2EndTime = base2EndTime;
    }

    public String getBase3StartTime() {
        return this.base3StartTime;
    }

    public void setBase3StartTime(String base3StartTime) {
        this.base3StartTime = base3StartTime;
    }

    public String getBase3EndTime() {
        return this.base3EndTime;
    }

    public void setBase3EndTime(String base3EndTime) {
        this.base3EndTime = base3EndTime;
    }

    public String getBase1MSRName() {
        return this.base1MSRName;
    }

    public void setBase1MSRName(String base1msrName) {
        this.base1MSRName = base1msrName;
    }

    public String getBase2MSRName() {
        return this.base2MSRName;
    }

    public void setBase2MSRName(String base2msrName) {
        this.base2MSRName = base2msrName;
    }

    public String getBase3MSRName() {
        return this.base3MSRName;
    }

    public void setBase3MSRName(String base3msrName) {
        this.base3MSRName = base3msrName;
    }

    public String getCheckProfilePath() {
        return this.checkProfilePath;
    }

    public void setCheckProfilePath(String checkProfilePath) {
        this.checkProfilePath = checkProfilePath;
    }

    public String getNdIntegrationUri() {
        return this.ndIntegrationUri;
    }

    public void setNdIntegrationUri(String ndIntegrationUri) {
        this.ndIntegrationUri = ndIntegrationUri;
    }

    public String getNdUsername() {
        return this.ndUsername;
    }

    public void setNdUsername(String ndUsername) {
        this.ndUsername = ndUsername;
    }

    public Secret getNdPassword() {
        return this.ndPassword;
    }

    public void setNdPassword(String ndPassword) {
        this.ndPassword = StringUtils.isEmpty((String)ndPassword) ? null : Secret.fromString((String)ndPassword);
    }

    public String getNsIntegrationUri() {
        return this.nsIntegrationUri;
    }

    public void setNsIntegrationUri(String nsIntegrationUri) {
        this.nsIntegrationUri = nsIntegrationUri;
    }

    public String getNsUsername() {
        return this.nsUsername;
    }

    public void setNsUsername(String nsUsername) {
        this.nsUsername = nsUsername;
    }

    public Secret getNsPassword() {
        return this.nsPassword;
    }

    public void setNsPassword(String nsPassword) {
        this.nsPassword = StringUtils.isEmpty((String)nsPassword) ? null : Secret.fromString((String)nsPassword);
    }

    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return LocalMessages.NSND_PUBLISHER_DISPLAYNAME.toString();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDefaultUsername() {
            return NSNDIntegrationResultsPublisher.DEFAULT_USERNAME;
        }

        public String getDefaultTestMetric() {
            return NSNDIntegrationResultsPublisher.DEFAULT_TEST_METRIC;
        }

        public FormValidation doCheckNsIntegrationUri(@QueryParameter String nsIntegrationUri) {
            return FieldValidator.validateURLConnectionString(nsIntegrationUri);
        }

        public FormValidation doCheckNsPassword(@QueryParameter String nsPassword) {
            return FieldValidator.validatePassword(nsPassword);
        }

        public FormValidation doCheckNsUsername(@QueryParameter String nsUsername) {
            return FieldValidator.validateUsername(nsUsername);
        }

        public synchronized ListBoxModel doFillPhaseItems() {
            ListBoxModel models = new ListBoxModel();
            models.add("Duration");
            return models;
        }

        public FormValidation doCheckNdIntegrationUri(@QueryParameter String ndIntegrationUri) {
            return FieldValidator.validateURLConnectionString(ndIntegrationUri);
        }

        public FormValidation doCheckNdPassword(@QueryParameter String ndPassword) {
            return FieldValidator.validatePassword(ndPassword);
        }

        public FormValidation doCheckNdUsername(@QueryParameter String ndUsername) {
            return FieldValidator.validateUsername(ndUsername);
        }

        public FormValidation doCheckWarThreshold(@QueryParameter String warThreshold) {
            return FieldValidator.validateThresholdValues(warThreshold);
        }

        public FormValidation doCheckCriThreshold(@QueryParameter String criThreshold) {
            return FieldValidator.validateThresholdValues(criThreshold);
        }

        public FormValidation doCheckFailThreshold(@QueryParameter String failThreshold) {
            return FieldValidator.validateThresholdValues(failThreshold);
        }

        public FormValidation doCheckBaseStartTime(@QueryParameter String baseStartTime) throws ParseException {
            return FieldValidator.validateDateTime(baseStartTime);
        }

        public FormValidation doCheckBaseEndTime(@QueryParameter String baseEndTime) throws ParseException {
            return FieldValidator.validateDateTime(baseEndTime);
        }

        @POST
        public FormValidation doTestNsNdIntegratedConnection(@QueryParameter(value="nsIntegrationUri") String nsIntegrationUri, @QueryParameter(value="nsUsername") String nsUsername, @QueryParameter(value="nsPassword") String nsPassword, @QueryParameter(value="ndIntegrationUri") String ndIntegrationUri, @QueryParameter(value="ndUsername") String ndUsername, @QueryParameter(value="ndPassword") String ndPassword, @QueryParameter(value="skipSSLCertCheck") boolean skipSSLCertCheck, @QueryParameter(value="skipSSLHostCheck") boolean skipSSLHostCheck) {
            String check;
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            StringBuffer errMsg = new StringBuffer();
            if (Util.fixEmptyAndTrim((String)nsIntegrationUri) == null || FieldValidator.isEmptyField(nsIntegrationUri)) {
                FormValidation validationResult = FormValidation.error((String)"URL connection string for NS cannot be empty and should start with http:// or https://");
                return validationResult;
            }
            if (!nsIntegrationUri.startsWith("http://") && !nsIntegrationUri.startsWith("https://")) {
                FormValidation validationResult = FormValidation.error((String)"URL connection string should start with http:// or https://");
                return validationResult;
            }
            if (Util.fixEmptyAndTrim((String)nsUsername) == null || FieldValidator.isEmptyField(nsUsername)) {
                FormValidation validationResult = FormValidation.error((String)"Please enter user name.");
                return validationResult;
            }
            if (Util.fixEmptyAndTrim((String)nsPassword) == null || FieldValidator.isEmptyField(nsPassword)) {
                FormValidation validationResult = FormValidation.error((String)"Please enter password.");
                return validationResult;
            }
            if (Util.fixEmptyAndTrim((String)ndIntegrationUri) == null || FieldValidator.isEmptyField(ndIntegrationUri)) {
                FormValidation validationResult = FormValidation.error((String)"URL connection string for ND cannot be empty and should start with http:// or https://");
                return validationResult;
            }
            if (!ndIntegrationUri.startsWith("http://") && !ndIntegrationUri.startsWith("https://")) {
                FormValidation validationResult = FormValidation.error((String)"URL connection string should start with http:// or https://");
                return validationResult;
            }
            if (Util.fixEmptyAndTrim((String)ndUsername) == null || FieldValidator.isEmptyField(ndUsername)) {
                FormValidation validationResult = FormValidation.error((String)"Please enter user name.");
                return validationResult;
            }
            if (Util.fixEmptyAndTrim((String)ndPassword) == null || FieldValidator.isEmptyField(ndPassword)) {
                FormValidation validationResult = FormValidation.error((String)"Please enter password.");
                return validationResult;
            }
            NSNDIntegrationConnectionManager connection = new NSNDIntegrationConnectionManager(nsIntegrationUri, nsUsername, Secret.fromString((String)nsPassword), ndIntegrationUri, ndUsername, Secret.fromString((String)ndPassword), null, skipSSLCertCheck, skipSSLHostCheck);
            FormValidation validationResult = !connection.testNDConnection(errMsg, check = ndIntegrationUri + "@@" + ndUsername + "@@" + ndPassword) ? FormValidation.warning((String)("Connection to NSNDIntegration unsuccessful, due to: " + errMsg)) : FormValidation.ok((String)"Connection successful");
            return validationResult;
        }
    }
}

