/*
 * Decompiled with CFR 0.152.
 */
package com.cavisson.jenkins;

import com.cavisson.jenkins.BaseConnection;
import com.cavisson.jenkins.Messages;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class FetchTestAssets
extends Builder
implements SimpleBuildStep {
    private String username = "";
    private String profile = "";
    private String giturl = "";
    private String ipAddress = "";
    private static final transient Logger logger = Logger.getLogger(FetchTestAssets.class.getName());
    private final Boolean skipSSLCertCheck;
    private final Boolean skipSSLHostCheck;

    @DataBoundConstructor
    public FetchTestAssets(String username, String profile, String giturl, String ipAddress, boolean skipSSLCertCheck, boolean skipSSLHostCheck) {
        this.username = username;
        this.profile = profile;
        this.giturl = giturl;
        this.ipAddress = ipAddress;
        this.skipSSLCertCheck = skipSSLCertCheck;
        this.skipSSLHostCheck = skipSSLHostCheck;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getGiturl() {
        return this.giturl;
    }

    public void setGiturl(String giturl) {
        this.giturl = giturl;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public boolean isSkipSSLCertCheck() {
        return this.skipSSLCertCheck;
    }

    public boolean isSkipSSLHostCheck() {
        return this.skipSSLHostCheck;
    }

    public void perform(Run<?, ?> run, FilePath fp, Launcher lnchr, TaskListener taskListener) throws InterruptedException, IOException {
        String line;
        PrintStream consoleLog = taskListener.getLogger();
        JSONObject data = new JSONObject();
        data.put("masterRepo", (Object)this.giturl);
        data.put("passType", (Object)"0");
        data.put("passValue", (Object)"");
        data.put("productType", (Object)"NS>NO");
        data.put("repoProject", (Object)"configuration");
        data.put("userName", (Object)this.username);
        consoleLog.println("Starting Git Clone.");
        String urladd = "https://" + this.ipAddress + "/ProductUI/productSummary/gitRepositoryService/gitClone";
        logger.log(Level.FINE, "Cavisson-Plugin|Git clone Url = " + urladd);
        URL url = new URL(urladd);
        URLConnection conn = BaseConnection.getConnections(url, this.isSkipSSLCertCheck(), this.isSkipSSLHostCheck());
        conn.setConnectTimeout(0);
        conn.setReadTimeout(0);
        ((HttpURLConnection)conn).setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setDoOutput(true);
        BufferedWriter httpRequestBodyWriter = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream()));
        httpRequestBodyWriter.write(data.toString());
        httpRequestBodyWriter.close();
        if (((HttpURLConnection)conn).getResponseCode() != 200) {
            logger.log(Level.FINE, "Cavisson-Plugin|Error in git clone.");
            logger.log(Level.FINE, "Cavisson-Plugin|Getting Error code = " + ((HttpURLConnection)conn).getResponseCode());
            throw new RuntimeException("Failed : HTTP error code : " + ((HttpURLConnection)conn).getResponseCode());
        }
        BufferedReader br = null;
        br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        consoleLog.println(sb.toString());
        br.close();
        try {
            this.gitPullObjects(this.giturl, this.username, this.profile, consoleLog);
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Cavisson-Plugin|Exception = " + e);
        }
    }

    public void gitPullObjects(String giturl, String username, String profile, PrintStream consoleLog) throws IOException {
        String line;
        JSONObject data = new JSONObject();
        data.put("activeProfile", (Object)profile);
        data.put("passType", (Object)"0");
        data.put("passValue", (Object)"");
        data.put("productType", (Object)"NS>NO");
        data.put("repo", (Object)"configuration");
        data.put("userName", (Object)username);
        consoleLog.println("Starting Git Pull.");
        String urladd = "https://" + this.ipAddress + "/ProductUI/productSummary/gitRepositoryService/gitRefresh";
        logger.log(Level.FINE, "Cavisson-Plugin|Git pull Url = " + urladd);
        URL url = new URL(urladd);
        URLConnection conn = BaseConnection.getConnections(url, this.isSkipSSLCertCheck(), this.isSkipSSLHostCheck());
        conn.setConnectTimeout(0);
        conn.setReadTimeout(0);
        ((HttpURLConnection)conn).setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setDoOutput(true);
        BufferedWriter httpRequestBodyWriter = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream()));
        httpRequestBodyWriter.write(data.toString());
        httpRequestBodyWriter.close();
        if (((HttpURLConnection)conn).getResponseCode() != 200) {
            logger.log(Level.FINE, "Cavisson-Plugin|Error in git pull.");
            logger.log(Level.FINE, "Cavisson-Plugin|Getting Error code = " + ((HttpURLConnection)conn).getResponseCode());
            throw new RuntimeException("Failed : HTTP error code : " + ((HttpURLConnection)conn).getResponseCode());
        }
        BufferedReader br = null;
        br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        consoleLog.println(sb.toString());
        br.close();
    }

    @Extension
    public static class Descriptor
    extends BuildStepDescriptor<Builder> {
        public Descriptor() {
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.save();
            return true;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return FreeStyleProject.class.isAssignableFrom(jobType);
        }

        public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Builder)super.newInstance(req, formData);
        }

        public String getDisplayName() {
            return Messages.FetchTestAssets_Task();
        }
    }
}

