/*
 * Decompiled with CFR 0.152.
 */
package com.cavisson.jenkins;

import com.cavisson.jenkins.Messages;
import com.cavisson.jenkins.NetStormBuilder;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.ServiceAccountCredentials;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class DestroyVM
extends Builder
implements SimpleBuildStep {
    private String INSTANCE_NAME = "";
    private String GCP_PROJECT_ID = "";
    private String IMAGE_NAME = "";
    private static final transient Logger logger = Logger.getLogger(NetStormBuilder.class.getName());

    @DataBoundConstructor
    public DestroyVM(String INSTANCE_NAME, String GCP_PROJECT_ID, String IMAGE_NAME) {
        this.INSTANCE_NAME = INSTANCE_NAME;
        this.GCP_PROJECT_ID = GCP_PROJECT_ID;
        this.IMAGE_NAME = IMAGE_NAME;
    }

    public String getINSTANCE_NAME() {
        return this.INSTANCE_NAME;
    }

    public void setINSTANCE_NAME(String iNSTANCE_NAME) {
        this.INSTANCE_NAME = iNSTANCE_NAME;
    }

    public String getGCP_PROJECT_ID() {
        return this.GCP_PROJECT_ID;
    }

    public void setGCP_PROJECT_ID(String gCP_PROJECT_ID) {
        this.GCP_PROJECT_ID = gCP_PROJECT_ID;
    }

    public String getIMAGE_NAME() {
        return this.IMAGE_NAME;
    }

    public void setIMAGE_NAME(String iMAGE_NAME) {
        this.IMAGE_NAME = iMAGE_NAME;
    }

    public void perform(Run<?, ?> run, FilePath fp, Launcher lnchr, TaskListener taskListener) throws InterruptedException, IOException {
        ServiceAccountCredentials credential;
        PrintStream consoleLog = taskListener.getLogger();
        File credentialsPath = new File("/tmp/key.json");
        try (FileInputStream serviceAccountStream = new FileInputStream(credentialsPath);){
            credential = ServiceAccountCredentials.fromStream((InputStream)serviceAccountStream);
        }
        ArrayList<String> scope = new ArrayList<String>();
        scope.add("https://www.googleapis.com/auth/cloud-platform");
        credential = credential.createScoped(scope);
        AccessToken token = credential.refreshAccessToken();
        String tokn = token.getTokenValue();
        consoleLog.println("Going to stop VM.");
        String urladd = "https://www.googleapis.com/compute/v1/projects/" + this.GCP_PROJECT_ID + "/zones/us-central1-a/instances/" + this.INSTANCE_NAME + "/stop";
        logger.log(Level.INFO, "Cavisson-Plugin|VM stop url = " + urladd);
        URL url = new URL(urladd);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(0);
        conn.setReadTimeout(0);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("Authorization", "Bearer " + tokn);
        conn.setDoOutput(true);
        BufferedWriter httpRequestBodyWriter = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream()));
        httpRequestBodyWriter.write("");
        httpRequestBodyWriter.close();
        if (conn.getResponseCode() != 200) {
            logger.log(Level.INFO, "Cavisson-Plugin|Error in stopping VM.");
            logger.log(Level.INFO, "Cavisson-Plugin|Getting Error code = " + conn.getResponseCode());
            throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
        }
        consoleLog.println("Successfully stopped VM on Google Cloud... " + this.INSTANCE_NAME);
        TimeUnit.SECONDS.sleep(40L);
        this.deletingVM(tokn, consoleLog);
    }

    public void deletingVM(String tokn, PrintStream consoleLog) {
        try {
            consoleLog.println("Going to delete VM.");
            String urladd = "https://www.googleapis.com/compute/v1/projects/" + this.GCP_PROJECT_ID + "/zones/us-central1-a/instances/" + this.INSTANCE_NAME;
            URL url = new URL(urladd);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(0);
            conn.setReadTimeout(0);
            conn.setRequestMethod("DELETE");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Authorization", "Bearer " + tokn);
            conn.setDoOutput(true);
            if (conn.getResponseCode() != 200) {
                logger.log(Level.INFO, "Cavisson-Plugin|Error in deleting VM.");
                logger.log(Level.INFO, "Cavisson-Plugin|Getting Error code = " + conn.getResponseCode());
                throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
            }
            consoleLog.println("Successfully deleted VM on Google Cloud: " + this.INSTANCE_NAME);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Cavisson-Plugin|Exception = " + e);
        }
    }

    @Extension
    public static class Descriptor
    extends BuildStepDescriptor<Builder> {
        public Descriptor() {
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.save();
            return true;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return FreeStyleProject.class.isAssignableFrom(jobType);
        }

        public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Builder)super.newInstance(req, formData);
        }

        public String getDisplayName() {
            return Messages.DestroyVM_Task();
        }
    }
}

