/*
 * Decompiled with CFR 0.152.
 */
package com.cavisson.jenkins;

import com.cavisson.jenkins.CreateVirtualService;
import com.cavisson.jenkins.Messages;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.io.PrintStream;
import jenkins.tasks.SimpleBuildStep;
import org.json.simple.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class DeleteVirtualService
extends Builder
implements SimpleBuildStep {
    private final String serviceName;
    private String API = "/ProductUI/cavservices/virtualize/v4/deleteService?token=" + CreateVirtualService.getTOKENS();
    private String URLPath = CreateVirtualService.getURLHOST() + this.API;

    @DataBoundConstructor
    public DeleteVirtualService(String serviceName) {
        this.serviceName = serviceName;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        PrintStream logg = listener.getLogger();
        try {
            JSONObject obj = new JSONObject();
            obj.put((Object)"serviceName", (Object)this.serviceName);
            logg.println("URLPath : " + this.URLPath);
            logg.println("Config : " + obj.toString());
            String data = CreateVirtualService.getHttpResponse("POST", this.URLPath, obj.toString());
            if (data != null && !data.equals("")) {
                logg.println("Response : " + data);
                run.setResult(Result.SUCCESS);
            } else {
                logg.println("Services Fail" + data);
                run.setResult(Result.FAILURE);
            }
        }
        catch (Exception e) {
            System.out.println("Exception in writing in file - " + e);
        }
    }

    public Descriptor getDescriptor() {
        return (Descriptor)super.getDescriptor();
    }

    @Extension
    public static class Descriptor
    extends BuildStepDescriptor<Builder> {
        public Descriptor() {
            this.load();
        }

        public boolean configure(StaplerRequest req, net.sf.json.JSONObject json) throws Descriptor.FormException {
            this.save();
            return true;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return FreeStyleProject.class.isAssignableFrom(jobType);
        }

        public Builder newInstance(StaplerRequest req, net.sf.json.JSONObject formData) throws Descriptor.FormException {
            return (Builder)super.newInstance(req, formData);
        }

        public String getDisplayName() {
            return Messages.DeleteVirtualService_Task();
        }
    }
}

