/*
 * Decompiled with CFR 0.152.
 */
package com.cavisson.jenkins;

import com.cavisson.jenkins.BaseConnection;
import com.cavisson.jenkins.Messages;
import com.cavisson.jenkins.NetStormBuilder;
import com.cavisson.jenkins.NetStormConnectionManager;
import com.cavisson.jenkins.VirtualServiceDetails;
import com.google.gson.Gson;
import dnl.utils.text.table.TextTable;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.Secret;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class CreateVirtualService
extends Builder
implements SimpleBuildStep {
    private final String config;
    private final String API = "/ProductUI/cavservices/virtualize/v4/createServiceUsingGIT";
    private static final transient Logger logger = Logger.getLogger(CreateVirtualService.class.getName());
    private static String URLHOST;
    private static String TOKENS;
    private static boolean SSLCheck;
    private String URLPath;
    private final String rrFilePath;
    private static boolean sslCotextChanged;
    private final String username;
    private final Secret password;
    private final Secret token;
    private final String host;
    private final Boolean isstart;
    private final Boolean skipSSLCertCheck;
    private final Boolean skipSSLHostCheck;
    private static String testRunNumber;
    private static String testCycleNumber;
    String path = "";

    public static String getURLHOST() {
        return URLHOST;
    }

    public void setURLHOST(String newHost) {
        URLHOST = newHost;
    }

    public static String getTOKENS() {
        return TOKENS;
    }

    public String getUsername() {
        return this.username;
    }

    public Secret getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public Secret getToken() {
        return this.token;
    }

    public Boolean getIsstart() {
        return this.isstart;
    }

    public String getConfig() {
        return this.config;
    }

    public String getRrFilePath() {
        return this.rrFilePath;
    }

    public boolean isSkipSSLCertCheck() {
        return this.skipSSLCertCheck;
    }

    public boolean isSkipSSLHostCheck() {
        return this.skipSSLHostCheck;
    }

    @DataBoundConstructor
    public CreateVirtualService(String config, String rrFilePath, String host, String username, Secret password, boolean isstart, Secret token, boolean skipSSLCertCheck, boolean skipSSLHostCheck) {
        this.config = config;
        this.rrFilePath = rrFilePath;
        this.host = host;
        this.username = username;
        this.password = password;
        this.isstart = isstart;
        this.token = token;
        this.skipSSLCertCheck = skipSSLCertCheck;
        this.skipSSLHostCheck = skipSSLHostCheck;
        SSLCheck = skipSSLCertCheck;
        if (host != null) {
            URLHOST = host;
        }
        if (token != null) {
            TOKENS = token.getPlainText();
        }
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        PrintStream logg = listener.getLogger();
        try {
            if (URLHOST != null) {
                Cause.UserIdCause cause = (Cause.UserIdCause)run.getCause(Cause.UserIdCause.class);
                this.URLPath = cause != null ? URLHOST + "/ProductUI/cavservices/virtualize/v4/createServiceUsingGIT" + "?token=" + this.getToken().getPlainText() + "&user=" + cause.getUserName().toString() : URLHOST + "/ProductUI/cavservices/virtualize/v4/createServiceUsingGIT" + "?token=" + this.getToken().getPlainText() + "&user=****";
            } else {
                logg.println("[Cavisson Service Virtualsation]: Please Provide HOST");
                run.setResult(Result.FAILURE);
                return;
            }
            logg.println("URLPath : " + this.URLPath);
            logg.println("Config : " + this.config);
            String data = CreateVirtualService.getHttpResponse("POST", this.URLPath, this.config);
            VirtualServiceDetails vSd = null;
            if (data != null && !data.equals("")) {
                logg.println("data : " + data);
                vSd = (VirtualServiceDetails)new Gson().fromJson(data, VirtualServiceDetails.class);
            }
            if (vSd != null && vSd.getData() != null && vSd.getData().getServices().size() > 0) {
                int fail = 0;
                int pass = 0;
                int size = vSd.getData().getServices().size();
                logg.println("[Cavisson Service Virtualsation] Total " + size + " Services Created Succesfully. Below are the detail - :");
                String[] coloumn = new String[]{"Service Name", "URL", "Templates", "Activated"};
                Object[][] Pdata = new Object[size][4];
                boolean isFail = false;
                int isFailCount = 0;
                for (int i = 0; i < size; ++i) {
                    VirtualServiceDetails.ServiceData sd = vSd.getData().getServices().get(i);
                    if (sd.getStatus() != null && !sd.getStatus().equals("") && sd.getStatus().equals("pass")) {
                        ++pass;
                    }
                    if (sd.getStatus() != null && !sd.getStatus().equals("") && sd.getStatus().equals("fail")) {
                        ++fail;
                    }
                    if (!sd.isActivated()) {
                        ++isFailCount;
                        isFail = true;
                    }
                    for (int l = 0; l < 3; ++l) {
                        Pdata[i][0] = sd.getName();
                        Pdata[i][1] = sd.getUrl();
                        Pdata[i][2] = sd.getTemplates();
                        Pdata[i][3] = sd.isActivated() ? "Yes" : "No";
                    }
                }
                TextTable tt = new TextTable(coloumn, Pdata);
                tt.printTable(logg, 0);
                logg.println("Total " + pass + " services are created successfully.");
                if (this.isstart.booleanValue() && !isFail) {
                    String[] testsuite;
                    String SuiteName = vSd.getData().getTestSuiteName();
                    if (SuiteName != null) {
                        logg.println("testSuiteName" + SuiteName);
                    }
                    if (SuiteName != null && !SuiteName.equals("") && (testsuite = SuiteName.split("/")).length == 3) {
                        String project = testsuite[0];
                        String subProject = testsuite[1];
                        String scenario = testsuite[2];
                        logg.println("Starting test with test suite(" + project + "/" + subProject + "/" + scenario + ")");
                        logg.println("NetStorm URI: " + URLHOST);
                        HashMap result = new HashMap();
                        StringBuffer errMsg = new StringBuffer();
                        NetStormConnectionManager netstormConnectionManger = new NetStormConnectionManager(URLHOST, this.getUsername(), this.getPassword(), project, subProject, scenario, "T", "", "20", "system", "", true, false, this.isSkipSSLCertCheck(), this.isSkipSSLHostCheck(), "");
                        result = netstormConnectionManger.startNetstormTest(errMsg, logg, "", run);
                        NetStormBuilder nsb = new NetStormBuilder(URLHOST, this.getUsername(), this.getPassword().getPlainText(), project, subProject, scenario, "T", "", "20", "system", true);
                        nsb.setDoNotWaitForTestCompletion(false);
                        nsb.processTestResult(result, logg, workspace, run, "", netstormConnectionManger);
                    }
                }
                if (isFail) {
                    logg.println("[Cavisson Service Virtualsation]: Error: '" + vSd.getData().getServices().get(0).getName() + "' and " + (isFailCount - 1) + " more Service are failed to activated. Not running Smoke test.");
                    run.setResult(Result.FAILURE);
                }
                if (fail > 0) {
                    logg.println("NOTE: " + fail + " services are failed to be created");
                }
                run.setResult(Result.SUCCESS);
            } else {
                logg.println("[Cavisson Service Virtualsation]: Error: " + data);
                logg.println("[Cavisson Service Virtualsation]: No new service is created, there is no changes in artifacts ");
                run.setResult(Result.FAILURE);
            }
        }
        catch (Exception e) {
            System.out.println("Exception in writing in file - " + e);
        }
    }

    public static String getHttpResponse(String method, String requestUrl, String requestData) {
        String inputLine = "";
        try {
            String line;
            URLConnection conn = CreateVirtualService.getURLConnection(requestUrl);
            if (conn == null) {
                throw new SocketTimeoutException();
            }
            ((HttpURLConnection)conn).setRequestMethod(method);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setDoOutput(true);
            if (method.equals("POST")) {
                OutputStreamWriter wr1 = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
                wr1.write(requestData);
                wr1.flush();
                wr1.close();
            }
            int responseCode = ((HttpURLConnection)conn).getResponseCode();
            BufferedReader br = null;
            br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = br.readLine()) != null) {
                inputLine = inputLine + line;
            }
            br.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unknown exception in getHttpResponse.", e);
        }
        return inputLine;
    }

    public static URLConnection getURLConnection(String resourceurl) {
        URLConnection urlConn = null;
        try {
            URL url = new URL(resourceurl);
            urlConn = BaseConnection.getConnections(url, SSLCheck, SSLCheck);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unknown exception in getURLConnection.", e);
        }
        return urlConn;
    }

    public Descriptor getDescriptor() {
        return (Descriptor)super.getDescriptor();
    }

    static {
        sslCotextChanged = false;
        testRunNumber = "-1";
        testCycleNumber = "";
    }

    @Extension
    public static class Descriptor
    extends BuildStepDescriptor<Builder> {
        public Descriptor() {
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.save();
            return true;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return FreeStyleProject.class.isAssignableFrom(jobType);
        }

        public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Builder)super.newInstance(req, formData);
        }

        public String getDisplayName() {
            return Messages.CreateVirtualService_Task();
        }
    }
}

