/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.receiver;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.config.BitBucketPPRPluginConfig;
import io.jenkins.plugins.bitbucketpushandpullrequest.exception.InputStreamException;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.BitBucketPPRHookEvent;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.BitBucketPPRPayload;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.BitBucketPPRPayloadFactory;
import io.jenkins.plugins.bitbucketpushandpullrequest.observer.BitBucketPPRObservable;
import io.jenkins.plugins.bitbucketpushandpullrequest.observer.BitBucketPPRObserverFactory;
import io.jenkins.plugins.bitbucketpushandpullrequest.processor.BitBucketPPRPayloadProcessorFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.naming.OperationNotSupportedException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class BitBucketPPRHookReceiver
implements UnprotectedRootAction {
    private static final Logger logger = Logger.getLogger(BitBucketPPRHookReceiver.class.getName());
    private static final BitBucketPPRPluginConfig globalConfig = BitBucketPPRPluginConfig.getInstance();

    public void doIndex(@Nonnull StaplerRequest request, @Nonnull StaplerResponse response) throws IOException {
        if (request.getRequestURI().toLowerCase().contains("/" + this.getUrlName() + "/") && request.getMethod().equalsIgnoreCase("POST")) {
            logger.log(Level.INFO, "Received POST request over Bitbucket hook");
            try {
                BitBucketPPRHookEvent bitbucketEvent = this.getBitbucketEvent(request);
                BitBucketPPRPayload payload = this.getPayload(this.getInputStream(request), bitbucketEvent);
                BitBucketPPRObservable observable = BitBucketPPRObserverFactory.createObservable(bitbucketEvent);
                this.writeSuccessResponse(response, "Bitbuckt PPR Plugin: request received successfully.");
                BitBucketPPRPayloadProcessorFactory.createProcessor(bitbucketEvent).processPayload(payload, observable);
            }
            catch (JsonSyntaxException | InputStreamException | IOException | OperationNotSupportedException e) {
                this.writeFailResponse(response, "Bitbuckt PPR Plugin: request failed.");
            }
        }
    }

    private void writeSuccessResponse(@Nonnull StaplerResponse response, @Nonnull String msg) throws IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(200);
        PrintWriter out = response.getWriter();
        out.write(msg);
        out.flush();
        out.close();
    }

    private void writeFailResponse(@Nonnull StaplerResponse response, @Nonnull String msg) throws IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(400);
        PrintWriter out = response.getWriter();
        out.write(msg);
        out.flush();
        out.close();
    }

    String getInputStream(@Nonnull StaplerRequest request) throws IOException, InputStreamException {
        String inputStream = IOUtils.toString((InputStream)request.getInputStream());
        if (StringUtils.isBlank((CharSequence)inputStream)) {
            logger.severe("The Jenkins job cannot be triggered. The input stream is empty.");
            throw new InputStreamException("The input stream is empty");
        }
        return BitBucketPPRHookReceiver.decodeInputStream(inputStream, request.getContentType());
    }

    BitBucketPPRPayload getPayload(@Nonnull String inputStream, @Nonnull BitBucketPPRHookEvent bitbucketEvent) throws JsonSyntaxException, OperationNotSupportedException {
        BitBucketPPRPayload pl = (BitBucketPPRPayload)new Gson().fromJson(inputStream, BitBucketPPRPayloadFactory.getInstance(bitbucketEvent).getClass());
        logger.log(Level.FINEST, "the payload is: {0}", pl);
        return pl;
    }

    static String decodeInputStream(@Nonnull String inputStream, @Nonnull String contentType) throws UnsupportedEncodingException {
        String input = inputStream;
        if (StringUtils.startsWithIgnoreCase((CharSequence)contentType, (CharSequence)"application/x-www-form-urlencoded")) {
            input = URLDecoder.decode(input, StandardCharsets.UTF_8.toString());
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)input, (CharSequence)"payload=")) {
            input = StringUtils.removeStartIgnoreCase((String)input, (String)"payload=");
        }
        return input;
    }

    BitBucketPPRHookEvent getBitbucketEvent(@Nonnull StaplerRequest request) throws OperationNotSupportedException {
        String xEventHeader = request.getHeader("x-event-key");
        return StringUtils.isNotBlank((CharSequence)xEventHeader) ? new BitBucketPPRHookEvent(xEventHeader) : new BitBucketPPRHookEvent("repo:post");
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "Processing Bitbucket request.";
    }

    public String getUrlName() {
        return (globalConfig.isHookUrlSet() ? globalConfig.getHookUrl() : "bitbucket-hook").toLowerCase();
    }
}

