/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.observer;

import hudson.model.Result;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.client.BitBucketPPRClientType;
import io.jenkins.plugins.bitbucketpushandpullrequest.event.BitBucketPPREvent;
import io.jenkins.plugins.bitbucketpushandpullrequest.observer.BitBucketPPRHandlerTemplate;
import io.jenkins.plugins.bitbucketpushandpullrequest.observer.BitBucketPPRObserver;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class BitBucketPPRPushServerObserver
extends BitBucketPPRHandlerTemplate
implements BitBucketPPRObserver {
    static final Logger logger = Logger.getLogger(BitBucketPPRPushServerObserver.class.getName());

    public BitBucketPPRPushServerObserver() {
        this.clientType = BitBucketPPRClientType.SERVER;
    }

    @Override
    public void getNotification(BitBucketPPREvent event) {
        this.context = event.getContext();
        event.setEventHandler(this);
        event.runHandler();
    }

    @Override
    public void setBuildStatusOnFinished() {
        BitBucketPPRAction bitbucketAction = this.context.getAction();
        Result result = this.context.getRun().getResult();
        String state = result == Result.SUCCESS ? "SUCCESSFUL" : "FAILED";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", this.computeBitBucketBuildKey(this.context));
        map.put("url", this.context.getAbsoluteUrl());
        map.put("state", state);
        bitbucketAction.getCommitLinks().forEach(l -> this.callClient((String)l, (Map<String, String>)map));
    }

    @Override
    public void setBuildStatusInProgress() {
        BitBucketPPRAction bitbucketAction = this.context.getAction();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", this.computeBitBucketBuildKey(this.context));
        map.put("url", this.context.getAbsoluteUrl());
        map.put("state", "INPROGRESS");
        bitbucketAction.getCommitLinks().forEach(l -> this.callClient((String)l, (Map<String, String>)map));
    }
}

