/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.model;

import io.jenkins.plugins.bitbucketpushandpullrequest.model.BitBucketPPRHookEvent;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.BitBucketPPRPayload;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.cloud.BitBucketPPRCloudPayload;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.server.BitBucketPPRServerPayload;
import java.util.logging.Logger;
import javax.naming.OperationNotSupportedException;

public class BitBucketPPRPayloadFactory {
    static final Logger logger = Logger.getLogger(BitBucketPPRPayloadFactory.class.getName());

    private BitBucketPPRPayloadFactory() {
    }

    public static BitBucketPPRPayload getInstance(BitBucketPPRHookEvent bitbucketEvent) throws OperationNotSupportedException {
        if ("repo".equalsIgnoreCase(bitbucketEvent.getEvent())) {
            if ("push".equalsIgnoreCase(bitbucketEvent.getAction())) {
                return new BitBucketPPRCloudPayload();
            }
            if ("post".equalsIgnoreCase(bitbucketEvent.getAction())) {
                logger.warning("Got unexpected old post event, ignored!");
            }
            if ("refs_changed".equalsIgnoreCase(bitbucketEvent.getAction())) {
                return new BitBucketPPRServerPayload();
            }
        }
        if ("pullrequest".equals(bitbucketEvent.getEvent())) {
            return new BitBucketPPRCloudPayload();
        }
        if ("pr".equals(bitbucketEvent.getEvent())) {
            return new BitBucketPPRServerPayload();
        }
        if ("diagnostics".equals(bitbucketEvent.getEvent())) {
            return new BitBucketPPRServerPayload();
        }
        throw new OperationNotSupportedException(String.format("No processor found for bitbucket event %s.", bitbucketEvent.getEvent()));
    }
}

