/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.model;

import javax.naming.OperationNotSupportedException;

public class BitBucketPPRHookEvent {
    private String event;
    private String action;
    private String bitbucketEventKey;

    public BitBucketPPRHookEvent(String bitbucketEventKey) throws OperationNotSupportedException {
        this.bitbucketEventKey = bitbucketEventKey;
        this.setEventAndAction();
        this.checkOperationSupported();
    }

    private void setEventAndAction() {
        String[] eventActionPair = this.bitbucketEventKey.split(":");
        this.event = eventActionPair[0];
        this.action = eventActionPair.length == 3 && eventActionPair[1].equalsIgnoreCase("reviewer") ? eventActionPair[2] : (eventActionPair.length == 3 && eventActionPair[1].equalsIgnoreCase("comment") ? eventActionPair[1] + ":" + eventActionPair[2] : eventActionPair[1]);
    }

    private void checkOperationSupported() throws OperationNotSupportedException {
        if ("repo".equalsIgnoreCase(this.event) && ("push".equalsIgnoreCase(this.action) || "post".equalsIgnoreCase(this.action) || "refs_changed".equalsIgnoreCase(this.action))) {
            return;
        }
        if ("pullrequest".equalsIgnoreCase(this.event) || "pr".equalsIgnoreCase(this.event) && ("approved".equalsIgnoreCase(this.action) || "created".equalsIgnoreCase(this.action) || "updated".equalsIgnoreCase(this.action) || "fulfilled".equalsIgnoreCase(this.action) || "comment_created".equalsIgnoreCase(this.action) || "comment_updated".equalsIgnoreCase(this.action) || "rejected".equalsIgnoreCase(this.action) || "comment_deleted".equalsIgnoreCase(this.action) || "opened".equalsIgnoreCase(this.action) || "modified".equalsIgnoreCase(this.action) || "from_ref_updated".equalsIgnoreCase(this.action) || "approved".equalsIgnoreCase(this.action) || "merged".equalsIgnoreCase(this.action) || "declined".equalsIgnoreCase(this.action) || "comment:added".equalsIgnoreCase(this.action))) {
            return;
        }
        if ("diagnostics".equalsIgnoreCase(this.event) && "ping".equalsIgnoreCase(this.action)) {
            return;
        }
        throw new OperationNotSupportedException(String.format("The event action %s : %s with bitbucket Event Key %s is not supported.", this.event, this.action, this.bitbucketEventKey));
    }

    public String getEvent() {
        return this.event;
    }

    public String getBitbucketEventKey() {
        return this.bitbucketEventKey;
    }

    public String getAction() {
        return this.action;
    }

    public String toString() {
        return String.format("BitBucketPPREvent [bitbucketEventKey = %s, event = %s, action = %s]", this.bitbucketEventKey, this.event, this.action);
    }
}

