/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.filter.pullrequest.cloud;

import hudson.Extension;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.cause.BitBucketPPRTriggerCause;
import io.jenkins.plugins.bitbucketpushandpullrequest.cause.pullrequest.cloud.BitBucketPPRPullRequestApprovedCause;
import io.jenkins.plugins.bitbucketpushandpullrequest.filter.pullrequest.cloud.BitBucketPPRPullRequestActionDescriptor;
import io.jenkins.plugins.bitbucketpushandpullrequest.filter.pullrequest.cloud.BitBucketPPRPullRequestActionFilter;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.BitBucketPPRHookEvent;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.cloud.BitBucketPPRParticipant;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class BitBucketPPRPullRequestApprovedActionFilter
extends BitBucketPPRPullRequestActionFilter {
    private static final Logger logger = Logger.getLogger(BitBucketPPRPullRequestApprovedActionFilter.class.getName());
    public boolean triggerOnlyIfAllReviewersApproved;
    public String allowedBranches;

    @DataBoundConstructor
    public BitBucketPPRPullRequestApprovedActionFilter(boolean triggerOnlyIfAllReviewersApproved) {
        this.triggerOnlyIfAllReviewersApproved = triggerOnlyIfAllReviewersApproved;
    }

    @DataBoundSetter
    public void setAllowedBranches(String allowedBranches) {
        this.allowedBranches = allowedBranches == null ? "" : allowedBranches;
    }

    @Override
    public boolean shouldTriggerBuild(BitBucketPPRAction bitbucketAction) {
        if (this.triggerOnlyIfAllReviewersApproved && !this.allReviewersHaveApproved(bitbucketAction)) {
            logger.info("Not triggered because not all reviewers have approved the pull request");
            return false;
        }
        return this.matches(this.allowedBranches, bitbucketAction.getTargetBranch(), null);
    }

    @Override
    public BitBucketPPRTriggerCause getCause(File pollingLog, BitBucketPPRAction pullRequestAction, BitBucketPPRHookEvent bitBucketEvent) throws IOException {
        return new BitBucketPPRPullRequestApprovedCause(pollingLog, pullRequestAction, bitBucketEvent);
    }

    @Override
    public boolean shouldSendApprove() {
        return false;
    }

    @Override
    public boolean shouldSendDecline() {
        return false;
    }

    public boolean getTriggerOnlyIfAllReviewersApproved() {
        return this.triggerOnlyIfAllReviewersApproved;
    }

    private boolean allReviewersHaveApproved(BitBucketPPRAction pullRequestAction) {
        return pullRequestAction.getPayload().getPullRequest().getParticipants().stream().filter(p -> this.isReviewer((BitBucketPPRParticipant)p) && !p.getApproved()).count() == 0L;
    }

    private boolean isReviewer(BitBucketPPRParticipant pullRequestParticipant) {
        String role = pullRequestParticipant.getRole();
        return "REVIEWER".equals(role);
    }

    @Extension
    public static class ActionFilterDescriptorImpl
    extends BitBucketPPRPullRequestActionDescriptor {
        public String getDisplayName() {
            return "Approved";
        }
    }
}

