/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.action;

import hudson.model.InvisibleAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.BitBucketPPRPayload;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.cloud.BitBucketPPRChange;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class BitBucketPPRRepositoryAction
extends InvisibleAction
implements BitBucketPPRAction {
    private static final Logger logger = Logger.getLogger(BitBucketPPRAction.class.getName());
    @Nonnull
    private final BitBucketPPRPayload payload;
    private List<String> scmUrls = new ArrayList<String>(2);
    private String targetBranchName;
    private String type;
    private String repositoryUuid;

    public BitBucketPPRRepositoryAction(@Nonnull BitBucketPPRPayload payload) {
        this.payload = payload;
        this.scmUrls.add(payload.getRepository().getLinks().getHtml().getHref());
        for (BitBucketPPRChange change : payload.getPush().getChanges()) {
            if (change.getNewChange() == null) continue;
            this.targetBranchName = change.getNewChange().getName();
            this.type = change.getNewChange().getType();
            this.repositoryUuid = payload.getRepository().getUuid();
            break;
        }
        logger.log(Level.INFO, () -> "Received commit hook notification for branch: " + this.targetBranchName);
        logger.log(Level.INFO, () -> "Received commit hook type: " + this.type);
    }

    @Override
    public String getTargetBranch() {
        return this.targetBranchName;
    }

    @Override
    public String getRepositoryUrl() {
        return this.payload.getRepository().getLinks().getHtml().getHref();
    }

    @Override
    public BitBucketPPRPayload getPayload() {
        return this.payload;
    }

    @Override
    public String getScm() {
        return this.payload.getRepository().getScm() != null ? this.payload.getRepository().getScm() : "git";
    }

    @Override
    public String getUser() {
        return this.payload.getActor().getNickname();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getRepositoryName() {
        return this.payload.getRepository().getName();
    }

    @Override
    public List<String> getScmUrls() {
        return this.scmUrls;
    }

    @Override
    public String getRepositoryId() {
        return this.repositoryUuid;
    }

    @Override
    public String getLatestCommit() {
        for (BitBucketPPRChange change : this.payload.getPush().getChanges()) {
            if (change.getNewChange() == null) continue;
            return change.getNewChange().getTarget().getHash();
        }
        return null;
    }

    @Override
    public List<String> getCommitLinks() {
        List<BitBucketPPRChange> changes = this.payload.getPush().getChanges();
        ArrayList<String> links = new ArrayList<String>();
        for (BitBucketPPRChange change : changes) {
            links.add(change.getNewChange().getTarget().getLinks().getSelf().getHref());
        }
        return links;
    }

    public String toString() {
        return "BitBucketPPRRepositoryAction";
    }
}

