/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.action;

import hudson.model.InvisibleAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.BitBucketPPRPayload;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.server.BitBucketPPRServerClone;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class BitBucketPPRPullRequestServerAction
extends InvisibleAction
implements BitBucketPPRAction {
    private static final Logger logger = Logger.getLogger(BitBucketPPRPullRequestServerAction.class.getName());
    @Nonnull
    private final BitBucketPPRPayload payload;
    private List<String> scmUrls = new ArrayList<String>(2);
    private String repositoryUuid;

    public BitBucketPPRPullRequestServerAction(@Nonnull BitBucketPPRPayload payload) {
        this.payload = payload;
        List<BitBucketPPRServerClone> clones = payload.getServerPullRequest().getToRef().getRepository().getLinks().getCloneProperty();
        for (BitBucketPPRServerClone clone : clones) {
            if (!clone.getName().equalsIgnoreCase("http") && !clone.getName().equalsIgnoreCase("https") && !clone.getName().equalsIgnoreCase("ssh")) continue;
            this.scmUrls.add(clone.getHref());
        }
        logger.fine("BitBucketPPRPullRequestServerAction was called.");
    }

    @Override
    public String getSourceBranch() {
        return this.payload.getServerPullRequest().getFromRef().getDisplayId();
    }

    @Override
    public String getLatestCommitFromRef() {
        return this.payload.getServerPullRequest().getFromRef().getLatestCommit();
    }

    @Override
    public String getLatestCommitToRef() {
        return this.payload.getServerPullRequest().getToRef().getLatestCommit();
    }

    @Override
    public String getTargetBranch() {
        return this.payload.getServerPullRequest().getToRef().getDisplayId();
    }

    @Override
    public String getTargetBranchRefId() {
        return this.payload.getServerPullRequest().getToRef().getId();
    }

    @Override
    public String getPullRequestUrl() {
        return this.payload.getServerPullRequest().getLinks().getSelfProperty().get(0).getHref();
    }

    @Override
    public String getScm() {
        return this.payload.getServerPullRequest().getFromRef().getRepository().getScmId();
    }

    @Override
    public String getUser() {
        return this.payload.getServerActor().getName();
    }

    @Override
    public String getTitle() {
        return this.payload.getServerPullRequest().getTitle();
    }

    @Override
    public BitBucketPPRPayload getPayload() {
        return this.payload;
    }

    @Override
    public String getRepositoryName() {
        return this.payload.getServerRepository().getName();
    }

    @Override
    public String getServerComment() {
        if (this.payload.getServerComment() == null) {
            return "";
        }
        return this.payload.getServerComment().getText();
    }

    @Override
    public List<String> getScmUrls() {
        return this.scmUrls;
    }

    @Override
    public String getPullRequestId() {
        return Long.toString(this.payload.getServerPullRequest().getId());
    }

    @Override
    public String getRepositoryId() {
        return this.repositoryUuid;
    }

    @Override
    public String getLinkApprove() {
        String projectKey = this.payload.getServerPullRequest().getFromRef().getRepository().getProject().getKey();
        String repoSlug = this.payload.getServerPullRequest().getFromRef().getRepository().getSlug();
        Long pullrequestId = this.payload.getServerPullRequest().getId();
        String projectSelfUrl = this.payload.getServerPullRequest().getFromRef().getRepository().getProject().getLinks().getSelfProperty().get(0).getHref();
        String baseUrl = this.getBaseUrl(projectSelfUrl);
        if (baseUrl == null) {
            logger.log(Level.WARNING, "Base url is empty.");
            return "";
        }
        return baseUrl + "/rest/api/1.0/projects/" + projectKey.trim() + "/repos/" + repoSlug.trim() + "/pull-requests/" + Long.toString(pullrequestId).trim() + "/approve";
    }

    @Override
    public String getLinkDecline() {
        String projectKey = this.payload.getServerPullRequest().getFromRef().getRepository().getProject().getKey();
        String repoSlug = this.payload.getServerPullRequest().getFromRef().getRepository().getSlug();
        Long pullrequestId = this.payload.getServerPullRequest().getId();
        String projectSelfUrl = this.payload.getServerPullRequest().getFromRef().getRepository().getProject().getLinks().getSelfProperty().get(0).getHref();
        String baseUrl = this.getBaseUrl(projectSelfUrl);
        if (baseUrl == null) {
            logger.log(Level.WARNING, "Base url is empty.");
            return "";
        }
        return baseUrl + "/rest/api/1.0/projects/" + projectKey.trim() + "/repos/" + repoSlug.trim() + "/pull-requests/" + Long.toString(pullrequestId).trim() + "/decline";
    }

    @Override
    public String getLatestCommit() {
        return this.payload.getServerPullRequest().getFromRef().getLatestCommit();
    }

    @Override
    public String getCommitLink() {
        String projectSelfUrl = this.payload.getServerPullRequest().getFromRef().getRepository().getProject().getLinks().getSelfProperty().get(0).getHref();
        String commitId = this.payload.getServerPullRequest().getFromRef().getLatestCommit();
        String baseUrl = this.getBaseUrl(projectSelfUrl);
        if (baseUrl == null) {
            logger.log(Level.WARNING, "Base url is empty.");
            return "";
        }
        String result = baseUrl + "/rest/build-status/1.0/commits/" + commitId;
        return result;
    }

    public String toString() {
        return "BitBucketPPRPullRequestServerAction";
    }

    private String getBaseUrl(String projectSelfUrl) {
        String baseUrl = null;
        try {
            URL url = new URL(projectSelfUrl);
            baseUrl = url.getProtocol() + "://" + url.getHost() + ":" + url.getPort();
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "Cannot extract base url", e);
        }
        return baseUrl;
    }
}

