/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest;

import hudson.Util;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.scm.PollingResult;
import hudson.util.StreamTaskListener;
import io.jenkins.plugins.bitbucketpushandpullrequest.BitBucketPPRPollResultListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.triggers.SCMTriggerItem;

public class BitBucketPPRPollingRunnable
implements Runnable {
    private Job<?, ?> job;
    private File logFile;
    private BitBucketPPRPollResultListener bitbucketPollResultListener;
    private static final Logger logger = Logger.getLogger(BitBucketPPRPollingRunnable.class.getName());

    public BitBucketPPRPollingRunnable(@Nonnull Job<?, ?> job, @Nonnull File logFile, @Nonnull BitBucketPPRPollResultListener bitbucketPollResultListener) {
        this.job = job;
        this.bitbucketPollResultListener = bitbucketPollResultListener;
        this.logFile = logFile;
    }

    @Override
    public void run() {
        logger.log(Level.FINE, "Run method called.");
        try (StreamTaskListener streamListener = new StreamTaskListener(this.logFile);){
            PrintStream logger = streamListener.getLogger();
            long start = System.currentTimeMillis();
            logger.println("Started on " + DateFormat.getDateTimeInstance().format(new Date()));
            PollingResult pollingResult = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem(this.job).poll((TaskListener)streamListener);
            logger.println("Done. Took " + Util.getTimeSpanString((long)(System.currentTimeMillis() - start)));
            this.bitbucketPollResultListener.onPollSuccess(pollingResult);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed {0}", e.getMessage());
        }
        catch (NullPointerException e) {
            logger.log(Level.SEVERE, "NullPointerException: Failed to record SCM polling {0}", e.getMessage());
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, "RuntimeException: Failed to record SCM polling {0}", e.getMessage());
            this.bitbucketPollResultListener.onPollError(e);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed ", e);
        }
    }
}

