/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest;

import hudson.model.Job;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitStatus;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.security.ACLContext;
import io.jenkins.plugins.bitbucketpushandpullrequest.BitBucketPPRTrigger;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.exception.TriggerNotSetException;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.BitBucketPPRHookEvent;
import io.jenkins.plugins.bitbucketpushandpullrequest.observer.BitBucketPPRObservable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jenkins.branch.MultiBranchProject;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.triggers.SCMTriggerItem;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.URIish;

public class BitBucketPPRJobProbe {
    private static final Logger logger = Logger.getLogger(BitBucketPPRJobProbe.class.getName());

    public void triggerMatchingJobs(BitBucketPPRHookEvent bitbucketEvent, BitBucketPPRAction bitbucketAction, BitBucketPPRObservable observable) {
        if (!"git".equals(bitbucketAction.getScm()) && !"hg".equals(bitbucketAction.getScm())) {
            throw new UnsupportedOperationException(String.format("Unsupported SCM type %s", bitbucketAction.getScm()));
        }
        Function<String, URIish> f = a -> {
            try {
                return new URIish(a);
            }
            catch (URISyntaxException e) {
                logger.warning(String.format("Invalid URI %s.", e.getMessage()));
                return null;
            }
        };
        List remotes = bitbucketAction.getScmUrls().stream().map(f).filter(Objects::nonNull).collect(Collectors.toList());
        try (ACLContext ctx = ACL.as((Authentication)ACL.SYSTEM);){
            Jenkins.get().getAllItems(Job.class).stream().forEach(job -> {
                try {
                    this.triggerScm((Job<?, ?>)job, remotes, bitbucketEvent, bitbucketAction, observable);
                }
                catch (TriggerNotSetException e) {
                    logger.log(Level.FINE, "Trigger not set");
                }
            });
        }
    }

    private void triggerScm(@Nonnull Job<?, ?> job, List<URIish> remotes, BitBucketPPRHookEvent bitbucketEvent, BitBucketPPRAction bitbucketAction, BitBucketPPRObservable observable) throws TriggerNotSetException {
        BitBucketPPRTrigger bitbucketTrigger = this.getBitBucketTrigger(job).orElseThrow(() -> new TriggerNotSetException(job.getFullDisplayName()));
        ArrayList scmTriggered = new ArrayList();
        Optional<SCMTriggerItem> item = Optional.ofNullable(SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem(job));
        item.ifPresent(it -> it.getSCMs().stream().forEach(scmTrigger -> {
            if (job.getParent() instanceof MultiBranchProject && this.mPJobShouldNotBeTriggered(job, bitbucketEvent, bitbucketAction)) {
                logger.log(Level.FINEST, "Skipping job {0}.", job.getDisplayName());
                return;
            }
            Predicate<URIish> p = url -> scmTrigger instanceof GitSCM ? this.matchGitScm((SCM)scmTrigger, (URIish)url) : (scmTrigger instanceof MercurialSCM ? this.matchMercurialScm((SCM)scmTrigger, (URIish)url) : false);
            if (remotes.stream().anyMatch(p) && !scmTriggered.contains(scmTrigger)) {
                scmTriggered.add(scmTrigger);
                try {
                    bitbucketTrigger.onPost(bitbucketEvent, bitbucketAction, (SCM)scmTrigger, observable);
                    return;
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "Error: {0}", e.getMessage());
                    e.printStackTrace();
                }
            }
            logger.log(Level.FINE, "{0} SCM doesn't match remote repo {1} or it was already triggered.", new Object[]{job.getName(), remotes});
        }));
    }

    private boolean mPJobShouldNotBeTriggered(Job<?, ?> job, BitBucketPPRHookEvent bitbucketEvent, BitBucketPPRAction bitbucketAction) {
        if (job.getDisplayName() != null) {
            String displayName = job.getDisplayName();
            String sourceBranchName = bitbucketAction.getSourceBranch();
            String targetBranchName = bitbucketAction.getTargetBranch();
            logger.log(Level.FINEST, "Bitbucket event is : {0}, Job Name : {1}, sourceBranchName: {2}, targetBranchName: {3}", new String[]{bitbucketEvent.getAction(), displayName, sourceBranchName, targetBranchName});
            if ("fulfilled".equalsIgnoreCase(bitbucketEvent.getAction())) {
                return !displayName.equalsIgnoreCase(targetBranchName);
            }
            if ("merged".equalsIgnoreCase(bitbucketEvent.getAction())) {
                return !displayName.equalsIgnoreCase(targetBranchName);
            }
            if (sourceBranchName != null) {
                return !displayName.equalsIgnoreCase(sourceBranchName);
            }
            if ("push".equalsIgnoreCase(bitbucketEvent.getAction()) && targetBranchName != null) {
                return !displayName.equals(targetBranchName);
            }
            if ("refs_changed".equalsIgnoreCase(bitbucketEvent.getAction()) && targetBranchName != null) {
                return !displayName.equals(targetBranchName);
            }
        }
        return true;
    }

    private Optional<BitBucketPPRTrigger> getBitBucketTrigger(Job<?, ?> job) {
        Optional<BitBucketPPRTrigger> trigger = null;
        if (job instanceof ParameterizedJobMixIn.ParameterizedJob) {
            ParameterizedJobMixIn.ParameterizedJob pJob = (ParameterizedJobMixIn.ParameterizedJob)job;
            trigger = pJob.getTriggers().values().stream().filter(BitBucketPPRTrigger.class::isInstance).findFirst().map(BitBucketPPRTrigger.class::cast);
        }
        return trigger;
    }

    private boolean matchMercurialScm(SCM scm, URIish remote) {
        try {
            URI hgUri = new URI(((MercurialSCM)scm).getSource());
            logger.log(Level.INFO, "Trying to match {0} ", hgUri.toString() + "<-->" + remote.toString());
            return this.hgLooselyMatches(hgUri, remote.toString());
        }
        catch (URISyntaxException ex) {
            logger.log(Level.SEVERE, "Could not parse jobSource uri: {0} ", ex);
            return false;
        }
    }

    private boolean matchGitScm(SCM scm, URIish remote) {
        return ((GitSCM)scm).getRepositories().stream().anyMatch(a -> a.getURIs().stream().anyMatch(b -> GitStatus.looselyMatches((URIish)b, (URIish)remote)));
    }

    private boolean hgLooselyMatches(URI notifyUri, String repository) {
        boolean result = false;
        try {
            if (!this.hgIsUnexpandedEnvVar(repository)) {
                URI repositoryUri = new URI(repository);
                logger.log(Level.INFO, "Mercurial loose match between {0} ", notifyUri.toString() + "<- and ->" + repositoryUri.toString());
                result = Objects.equals(notifyUri.getHost(), repositoryUri.getHost()) && Objects.equals(StringUtils.stripEnd((String)notifyUri.getPath(), (String)"/"), StringUtils.stripEnd((String)repositoryUri.getPath(), (String)"/")) && Objects.equals(notifyUri.getQuery(), repositoryUri.getQuery());
            }
        }
        catch (URISyntaxException ex) {
            logger.log(Level.SEVERE, "could not parse repository uri " + repository, ex);
        }
        return result;
    }

    private boolean hgIsUnexpandedEnvVar(String str) {
        return str.startsWith("$");
    }

    public boolean testMatchMercurialScm(SCM scm, URIish remote) {
        return this.matchMercurialScm(scm, remote);
    }
}

