/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.benchmark.data;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.plugins.benchmark.Messages;
import io.jenkins.plugins.benchmark.data.CSVReader;
import io.jenkins.plugins.benchmark.data.ReadResult;
import io.jenkins.plugins.benchmark.data.Reader;
import io.jenkins.plugins.benchmark.data.YCSBReader;

public class BenchmarkResults {
    private final String path;
    @SuppressFBWarnings(value={"MS_MUTABLE_ARRAY"})
    public static String[] endings = new String[]{"csv", "ycsb"};
    private final Reader reader;

    public BenchmarkResults(String path) throws WrongFormatException {
        this.path = path;
        if (path.endsWith(".csv")) {
            this.reader = new CSVReader();
        } else if (path.endsWith(".ycsb")) {
            this.reader = new YCSBReader();
        } else {
            throw new WrongFormatException(Messages.wrongFormat(BenchmarkResults.getFormats()));
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE", "DM_DEFAULT_ENCODING"})
    public ReadResult read() throws Reader.InputException {
        return this.reader.read(this.path);
    }

    public static String getFormats() {
        String r = "";
        for (int i = 0; i < endings.length; ++i) {
            r = r.concat(endings[i]);
            if (i < endings.length - 2) {
                r = r.concat(", ");
            }
            if (i != endings.length - 2) continue;
            r = r.concat(" ").concat(Messages.and()).concat(" ");
        }
        return r;
    }

    public static class WrongFormatException
    extends Exception {
        private static final long serialVersionUID = -3845234573349339916L;

        WrongFormatException(String message) {
            super(message);
        }

        WrongFormatException() {
        }
    }
}

