/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.benchmark;

import com.google.gson.Gson;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.ProminentProjectAction;
import hudson.model.Result;
import io.jenkins.plugins.benchmark.BenchmarkAction;
import io.jenkins.plugins.benchmark.BenchmarkBuilder;
import io.jenkins.plugins.benchmark.Messages;
import io.jenkins.plugins.benchmark.configuration.BenchmarkConfiguration;
import io.jenkins.plugins.benchmark.configuration.ConfigEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BenchmarkResultAction
implements ProminentProjectAction {
    private final AbstractProject<?, ?> project;
    private final BenchmarkBuilder benchmarkBuilder;
    private String lastResult = null;
    private int lastLength = -1;
    private AbstractBuild<?, ?> lastElement = null;
    Map<String, String> metricValues = new ConcurrentHashMap<String, String>();
    private final BenchmarkConfiguration globalConfig;
    private Set<String> lastKeySet = null;

    public BenchmarkResultAction(AbstractProject<?, ?> project, BenchmarkBuilder benchmarkBuilder) {
        this.project = project;
        this.benchmarkBuilder = benchmarkBuilder;
        this.globalConfig = benchmarkBuilder.getConfig(project);
    }

    public String getIconFileName() {
        int i = this.getNumber();
        if (i == -1) {
            return null;
        }
        return "/plugin/benchmark-evaluator/images/256x256/diagramm.png";
    }

    public String getDisplayName() {
        int i = this.getNumber();
        if (i == -1) {
            return null;
        }
        return Messages.benchmarkResults() + " " + i;
    }

    public String getUrlName() {
        int i = this.getNumber();
        if (i == -1) {
            return null;
        }
        return "benchmarkResult_" + i;
    }

    private int getNumber() {
        int i = this.project.getProminentActions().stream().filter(x -> x instanceof BenchmarkResultAction).collect(Collectors.toList()).indexOf(this);
        return i == -1 ? -1 : i + 1;
    }

    private String getBuildNrs(Stream<AbstractBuild<?, ?>> stream) {
        String b = stream.map(x -> x.getDisplayName()).reduce("[", (x, y) -> x.concat("'").concat((String)y).concat("',"));
        if (b.length() == 1) {
            return "[]";
        }
        return b.substring(0, b.length() - 1) + ']';
    }

    private ArrayList<AbstractBuild<?, ?>> getAllActions() {
        ArrayList list = new ArrayList();
        for (AbstractBuild b = this.project.getLastBuild(); b != null; b = b.getPreviousBuild()) {
            if (this.getPreviousAction(b) == null) continue;
            list.add(0, b);
        }
        return list;
    }

    public synchronized String getAllInformations() {
        ArrayList<AbstractBuild<?, ?>> in = this.getAllActions();
        if (in.size() == this.lastLength && (in.isEmpty() || in.get(in.size() - 1) == this.lastElement)) {
            boolean error = false;
            for (String lk : this.lastKeySet) {
                String u2;
                String u1 = this.globalConfig.get(lk).getUnit();
                String string = u2 = this.metricValues.containsKey(lk) ? this.metricValues.get(lk) : null;
                if (!(u1 == null && u2 != null || u1 != null && u2 == null) && (u1 == null || u1.equals(u2))) continue;
                error = true;
            }
            if (!error) {
                return this.lastResult;
            }
        }
        this.metricValues.clear();
        this.lastLength = in.size();
        this.lastElement = in.isEmpty() ? null : in.get(in.size() - 1);
        BenchmarkAction[] actions = (BenchmarkAction[])in.parallelStream().map(x -> this.getPreviousAction((AbstractBuild<?, ?>)x)).toArray(BenchmarkAction[]::new);
        BenchmarkAction[] prevActions = (BenchmarkAction[])in.parallelStream().map(x -> this.getPreviousAction((AbstractBuild)x.getPreviousSuccessfulBuild())).toArray(BenchmarkAction[]::new);
        ConcurrentHashMap map = new ConcurrentHashMap();
        String[] names = new String[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            int iteration = i;
            BenchmarkAction action = actions[i];
            BenchmarkAction prevAction = prevActions[i];
            if (action != null) {
                names[i] = action.getName();
            }
            if (action == null || action.getResults() == null) continue;
            Map<String, Double> prevResult = prevAction != null ? prevAction.getResults() : null;
            Map<String, Double> result = action.getResults();
            result.entrySet().parallelStream().map(x -> {
                Double[][] metricsResults = null;
                String key = (String)x.getKey();
                if (!map.containsKey(key)) {
                    ConfigEntry t = this.globalConfig.get(key);
                    if (t.getUnit() != null) {
                        this.metricValues.put(key, t.getUnit());
                    }
                    metricsResults = new Double[actions.length][6];
                    map.put(key, metricsResults);
                    for (int j = 0; j < actions.length; ++j) {
                        ConfigEntry c;
                        if (actions[j] == null || actions[j].getConfig() == null || (c = actions[j].getConfig().get(key)) == null) continue;
                        metricsResults[j][1] = c.getMinValue();
                        metricsResults[j][2] = c.getMaxValue();
                        Double p_min = c.getMinPercent();
                        Double p_max = c.getMaxPercent();
                        metricsResults[j][4] = p_min == null ? null : Double.valueOf(p_min / 100.0);
                        metricsResults[j][5] = p_max == null ? null : Double.valueOf(p_max / 100.0);
                    }
                } else {
                    metricsResults = (Double[][])map.get(key);
                }
                metricsResults[iteration][0] = (Double)x.getValue();
                if (prevResult != null && prevResult.get(key) != null) {
                    metricsResults[iteration][3] = this.calculateChange((Double)prevResult.get(key), (Double)x.getValue());
                }
                return null;
            }).forEach(x -> {});
        }
        this.lastKeySet = map.keySet();
        String result = "";
        String dataSet2 = "{";
        dataSet2 = dataSet2.concat(map.entrySet().parallelStream().map(e -> "'".concat((String)e.getKey()).concat("':[").concat(Arrays.stream((Double[][])e.getValue()).map(x -> {
            Double per = x[3];
            String perS = "";
            perS = per == null ? "null" : (per == Double.POSITIVE_INFINITY ? "'inf'" : (per == Double.NEGATIVE_INFINITY ? "'-inf'" : per.toString()));
            return "[" + x[0] + "," + x[1] + "," + x[2] + "," + perS + "," + x[4] + "," + x[5] + "]";
        }).collect(Collectors.joining(","))).concat("]")).collect(Collectors.joining(","))).concat("}");
        result = result + "var buildNr = " + this.getBuildNrs(in.stream()) + ";\n";
        result = result + "var unsuccesfullBuildsNames = " + this.getBuildNrs(in.stream().filter(x -> x.getResult() != Result.SUCCESS)) + ";\n";
        result = result + "var dataSet2 = " + dataSet2 + ";\n";
        result = result + "var metricInfo = " + new Gson().toJson(this.metricValues) + ";\n";
        this.lastResult = result = result + "var buildNames = " + new Gson().toJson((Object)names) + ";";
        return result;
    }

    private Double calculateChange(double prev, double now) {
        if (prev == 0.0) {
            if (now > 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            if (now < 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
            return 0.0;
        }
        double r = now / prev - 1.0;
        if (now > prev && r > 0.0 || now == prev && r == 0.0 || now < prev && r < 0.0) {
            return r;
        }
        return r * -1.0;
    }

    private BenchmarkAction getPreviousAction(AbstractBuild<?, ?> b) {
        if (b == null) {
            return null;
        }
        Optional<BenchmarkAction> l = b.getActions(BenchmarkAction.class).stream().filter(x -> x.getBenchmarkBuilder().equals((Object)this.benchmarkBuilder)).findFirst();
        return l.isPresent() ? l.get() : null;
    }
}

