/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.benchmark;

import hudson.model.AbstractProject;
import hudson.model.ProminentProjectAction;
import io.jenkins.plugins.benchmark.Messages;
import io.jenkins.plugins.benchmark.configuration.BenchmarkConfiguration;
import io.jenkins.plugins.benchmark.configuration.ConfigEntry;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class BenchmarkConfigAction
implements ProminentProjectAction {
    private final BenchmarkConfiguration configuration;
    private final AbstractProject<?, ?> project;

    public BenchmarkConfigAction(BenchmarkConfiguration config, AbstractProject<?, ?> project) {
        this.configuration = config;
        this.project = project;
    }

    public Set<Map.Entry<String, ConfigEntry>> getConfiguration() {
        return this.configuration.getEntrys();
    }

    @JavaScriptMethod
    public void setMetricMinPercent(String metric, Double minPercent) {
        ConfigEntry c = this.configuration.get(metric);
        if (c == null || minPercent != null && c.getMaxPercent() != null && c.getMaxPercent() < minPercent) {
            return;
        }
        this.configuration.change(metric, new ConfigEntry(minPercent, c.getMaxPercent(), c.getMinValue(), c.getMaxValue(), c.getUnit(), c.getBuildNr()));
    }

    @JavaScriptMethod
    public void setMetricMaxPercent(String metric, Double maxPercent) {
        ConfigEntry c = this.configuration.get(metric);
        if (c == null || maxPercent != null && c.getMinPercent() != null && c.getMinPercent() > maxPercent) {
            return;
        }
        this.configuration.change(metric, new ConfigEntry(c.getMinPercent(), maxPercent, c.getMinValue(), c.getMaxValue(), c.getUnit(), c.getBuildNr()));
    }

    @JavaScriptMethod
    public void setMetricMinValue(String metric, Double minValue) {
        ConfigEntry c = this.configuration.get(metric);
        if (c == null || minValue != null && c.getMaxValue() != null && c.getMaxValue() < minValue) {
            return;
        }
        this.configuration.change(metric, new ConfigEntry(c.getMinPercent(), c.getMaxPercent(), minValue, c.getMaxValue(), c.getUnit(), c.getBuildNr()));
    }

    @JavaScriptMethod
    public void setMetricMaxValue(String metric, Double maxValue) {
        ConfigEntry c = this.configuration.get(metric);
        if (c == null || maxValue != null && c.getMinValue() != null && c.getMinValue() > maxValue) {
            return;
        }
        this.configuration.change(metric, new ConfigEntry(c.getMinPercent(), c.getMaxPercent(), c.getMinValue(), maxValue, c.getUnit(), c.getBuildNr()));
    }

    @JavaScriptMethod
    public void setMetricUnit(String metric, String unit) {
        if (unit != null && unit.toLowerCase().contains("<script")) {
            return;
        }
        ConfigEntry c = this.configuration.get(metric);
        if (c != null) {
            this.configuration.change(metric, new ConfigEntry(c.getMinPercent(), c.getMaxPercent(), c.getMinValue(), c.getMaxValue(), unit, c.getBuildNr()));
        }
    }

    @JavaScriptMethod
    public boolean createMetric(String metric) {
        return this.configuration.add(metric, new ConfigEntry(null, null, null, null, null, -1));
    }

    @JavaScriptMethod
    public boolean deleteMetric(String metric) {
        return this.configuration.delete(metric);
    }

    public String getIconFileName() {
        int i = this.getNumber();
        if (i == -1) {
            return null;
        }
        return "/plugin/benchmark-evaluator/images/256x256/configuration.png";
    }

    public String getDisplayName() {
        int i = this.getNumber();
        if (i == -1) {
            return null;
        }
        return Messages.benchmarkConfig() + " " + i;
    }

    public String getUrlName() {
        int i = this.getNumber();
        if (i == -1) {
            return null;
        }
        return "benchmarkConfig_" + i;
    }

    private int getNumber() {
        int i = this.project.getProminentActions().stream().filter(x -> x instanceof BenchmarkConfigAction).collect(Collectors.toList()).indexOf(this);
        return i == -1 ? -1 : i + 1;
    }
}

