/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.aws.global_configuration;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.Credentials;
import com.amazonaws.services.securitytoken.model.GetSessionTokenRequest;
import com.amazonaws.services.securitytoken.model.GetSessionTokenResult;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.Failure;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.aws.global_configuration.AbstractAwsGlobalConfiguration;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Symbol(value={"awsCredentials"})
@Extension
public class CredentialsAwsGlobalConfiguration
extends AbstractAwsGlobalConfiguration {
    private static int SESSION_DURATION = Integer.getInteger(CredentialsAwsGlobalConfiguration.class.getName() + ".sessionDuration", 3600);
    private String region;
    private String credentialsId;

    public CredentialsAwsGlobalConfiguration() {
        this.load();
    }

    @Restricted(value={NoExternalUse.class})
    protected CredentialsAwsGlobalConfiguration(boolean test) {
    }

    public String getRegion() {
        return this.region;
    }

    @DataBoundSetter
    public void setRegion(String region) {
        this.region = Util.fixEmpty((String)region);
        this.checkValue(this.doCheckRegion(region));
        this.save();
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = StringUtils.defaultIfBlank((String)credentialsId, null);
        this.save();
    }

    public AmazonWebServicesCredentials getCredentials() {
        return this.getCredentials(this.credentialsId);
    }

    public AmazonWebServicesCredentials getCredentials(String credentialsId) {
        Optional<AmazonWebServicesCredentials> credential = CredentialsProvider.lookupCredentials(AmazonWebServicesCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList()).stream().filter(it -> it.getId().equals(credentialsId)).findFirst();
        if (credential.isPresent()) {
            return credential.get();
        }
        return null;
    }

    private boolean hasCredentialsConfigured(String credentialsId) {
        return StringUtils.isNotBlank((String)credentialsId) && this.getCredentials(credentialsId) != null;
    }

    private AWSSessionCredentials sessionCredentialsFromKeyAndSecret(String region, String credentialsId) {
        AmazonWebServicesCredentials jenkinsAwsCredentials = this.getCredentials(credentialsId);
        AWSCredentials awsCredentials = jenkinsAwsCredentials.getCredentials();
        if (awsCredentials instanceof AWSSessionCredentials) {
            return (AWSSessionCredentials)awsCredentials;
        }
        AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider(awsCredentials);
        Credentials credentials = this.getSessionCredentials((AWSCredentialsProvider)credentialsProvider, region);
        return new BasicSessionCredentials(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), credentials.getSessionToken());
    }

    private Credentials getSessionCredentials(AWSCredentialsProvider credentialsProvider, String region) {
        AWSSecurityTokenServiceClientBuilder tokenSvcBuilder = (AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials(credentialsProvider);
        if (region != null) {
            tokenSvcBuilder.withRegion(region);
        }
        AWSSecurityTokenService tokenSvc = (AWSSecurityTokenService)tokenSvcBuilder.build();
        GetSessionTokenRequest sessionTokenRequest = new GetSessionTokenRequest().withDurationSeconds(Integer.valueOf(this.getSessionDuration()));
        GetSessionTokenResult sessionToken = tokenSvc.getSessionToken(sessionTokenRequest);
        return sessionToken.getCredentials();
    }

    private AWSSessionCredentials sessionCredentialsFromInstanceProfile(@Nonnull AwsClientBuilder<?, ?> builder) throws IOException {
        AWSCredentialsProvider credentialsProvider = builder.getCredentials();
        if (credentialsProvider == null) {
            throw new IOException("This client builder has no associated credentials");
        }
        AWSCredentials awsCredentials = credentialsProvider.getCredentials();
        if (awsCredentials == null) {
            throw new IOException("Unable to get credentials from environment");
        }
        if (!(awsCredentials instanceof AWSSessionCredentials)) {
            throw new IOException("No valid session credentials");
        }
        return (AWSSessionCredentials)awsCredentials;
    }

    @Deprecated
    public AWSSessionCredentials sessionCredentials(@Nonnull AwsClientBuilder<?, ?> builder) throws IOException {
        return this.sessionCredentials(builder, this.getRegion(), this.getCredentialsId());
    }

    public AWSSessionCredentials sessionCredentials(@Nonnull AwsClientBuilder<?, ?> builder, String region, String credentialsId) throws IOException {
        AWSSessionCredentials awsCredentials = this.hasCredentialsConfigured(credentialsId) ? this.sessionCredentialsFromKeyAndSecret(region, credentialsId) : this.sessionCredentialsFromInstanceProfile(builder);
        return awsCredentials;
    }

    private void checkValue(@NonNull FormValidation formValidation) {
        if (formValidation.kind == FormValidation.Kind.ERROR) {
            throw new Failure(formValidation.getMessage());
        }
    }

    public int getSessionDuration() {
        return SESSION_DURATION;
    }

    @Nonnull
    public String getDisplayName() {
        return "Amazon S3 Bucket Access settings";
    }

    @Nonnull
    public static CredentialsAwsGlobalConfiguration get() {
        return (CredentialsAwsGlobalConfiguration)((Object)ExtensionList.lookupSingleton(CredentialsAwsGlobalConfiguration.class));
    }

    public ListBoxModel doFillRegionItems() {
        ListBoxModel regions = new ListBoxModel();
        regions.add("Auto", "");
        for (Regions s : Regions.values()) {
            regions.add(s.getDescription(), s.getName());
        }
        return regions;
    }

    @RequirePOST
    public ListBoxModel doFillCredentialsIdItems() {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        ListBoxModel credentials = new ListBoxModel();
        credentials.add("IAM instance Profile/user AWS configuration", "");
        credentials.addAll((Collection)CredentialsProvider.listCredentials(AmazonWebServicesCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.instanceOf(AmazonWebServicesCredentials.class)));
        return credentials;
    }

    public FormValidation doCheckRegion(@QueryParameter String region) {
        if (StringUtils.isNotBlank((String)region)) {
            try {
                Regions.fromName((String)region);
            }
            catch (IllegalArgumentException x) {
                return FormValidation.error((String)"Region is not valid");
            }
        }
        return FormValidation.ok();
    }
}

