/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.trigger;

import com.atlassian.bitbucket.jenkins.internal.trigger.BitbucketWebhookConsumer;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.AbstractWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.BitbucketWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.MirrorSynchronizedWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.PullRequestDeclinedWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.PullRequestDeletedWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.PullRequestFromRefUpdatedWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.PullRequestMergedWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.PullRequestOpenedWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.RefsChangedWebhookEvent;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.verb.POST;

@Extension
public class BitbucketWebhookEndpoint
implements UnprotectedRootAction {
    public static final String BIBUCKET_WEBHOOK_URL = "bitbucket-server-webhook";
    public static final String X_EVENT_KEY = "X-Event-Key";
    private static final String APPLICATION_JSON = "application/json";
    private static final Logger LOGGER = Logger.getLogger(BitbucketWebhookEndpoint.class.getName());
    private final ObjectMapper objectMapper = new ObjectMapper();
    @Inject
    private BitbucketWebhookConsumer webhookConsumer;

    @POST
    public HttpResponse doTrigger(StaplerRequest request, StaplerResponse response) {
        this.validateContentType(request);
        String eventKey = this.getEventKey(request);
        switch (BitbucketWebhookEvent.findByEventId(eventKey)) {
            case DIAGNOSTICS_PING: {
                return HttpResponses.ok();
            }
            case REPO_REF_CHANGE: {
                return this.processEvent(request, RefsChangedWebhookEvent.class);
            }
            case MIRROR_SYNCHRONIZED: {
                return this.processEvent(request, MirrorSynchronizedWebhookEvent.class);
            }
            case PULL_REQUEST_DECLINED: {
                return this.processEvent(request, PullRequestDeclinedWebhookEvent.class);
            }
            case PULL_REQUEST_DELETED: {
                return this.processEvent(request, PullRequestDeletedWebhookEvent.class);
            }
            case PULL_REQUEST_FROM_REF_UPDATED: {
                return this.processEvent(request, PullRequestFromRefUpdatedWebhookEvent.class);
            }
            case PULL_REQUEST_MERGED: {
                return this.processEvent(request, PullRequestMergedWebhookEvent.class);
            }
            case PULL_REQUEST_OPENED: {
                return this.processEvent(request, PullRequestOpenedWebhookEvent.class);
            }
        }
        response.setStatus(400);
        return hudson.util.HttpResponses.errorJSON((String)("Event is not supported: " + eventKey));
    }

    @CheckForNull
    public String getDisplayName() {
        return null;
    }

    @CheckForNull
    public String getIconFileName() {
        return null;
    }

    @CheckForNull
    public String getUrlName() {
        return BIBUCKET_WEBHOOK_URL;
    }

    private String getEventKey(StaplerRequest request) {
        String eventKey = request.getHeader(X_EVENT_KEY);
        if (StringUtils.isEmpty((CharSequence)eventKey)) {
            throw HttpResponses.errorWithoutStack((int)400, (String)"X-Event-Key header not set");
        }
        return eventKey;
    }

    private <T> T parse(StaplerRequest request, Class<T> type) {
        try {
            Object event = this.objectMapper.readValue((InputStream)request.getInputStream(), type);
            LOGGER.fine(String.format("Payload: %s", event));
            return (T)event;
        }
        catch (IOException e) {
            String error = "Failed to parse the body: " + e.getMessage();
            LOGGER.severe(error);
            throw HttpResponses.errorWithoutStack((int)400, (String)error);
        }
    }

    private <T extends AbstractWebhookEvent> HttpResponse processEvent(StaplerRequest request, Class<T> eventType) {
        AbstractWebhookEvent event = (AbstractWebhookEvent)this.parse(request, eventType);
        this.webhookConsumer.process(event);
        return HttpResponses.ok();
    }

    private void validateContentType(StaplerRequest request) {
        String contentType = request.getContentType();
        if (contentType != null && !contentType.startsWith(APPLICATION_JSON)) {
            LOGGER.severe(String.format("Invalid content type %s", contentType));
            throw HttpResponses.errorWithoutStack((int)415, (String)("Invalid content type: '" + contentType + "'. Content type should be 'application/json'"));
        }
    }
}

