/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.status;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactory;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactoryProvider;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketPluginConfiguration;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketServerConfiguration;
import com.atlassian.bitbucket.jenkins.internal.credentials.GlobalCredentialsProvider;
import com.atlassian.bitbucket.jenkins.internal.credentials.JenkinsToBitbucketCredentials;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketBuildStatus;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRepository;
import com.atlassian.bitbucket.jenkins.internal.status.BitbucketBuildStatusFactory;
import com.atlassian.bitbucket.jenkins.internal.status.BitbucketRevisionAction;
import com.cloudbees.plugins.credentials.Credentials;
import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;

@Extension
public class BuildStatusPoster
extends RunListener<Run<?, ?>> {
    private static final String BUILD_STATUS_DISABLED_MSG = "Build statuses disabled, no build status sent.";
    private static final String BUILD_STATUS_ERROR_MSG = "Failed to post build status, additional information:";
    private static final String BUILD_STATUS_FORMAT = "Posting build status of %s to %s for commit id [%s] and ref '%s'";
    private static final Logger LOGGER = Logger.getLogger(BuildStatusPoster.class.getName());
    private static final String NO_SERVER_MSG = "Failed to post build status as the provided Bitbucket Server config does not exist";
    private static final String LEGACY_BUILD_STATUS_PROPERTY = "legacyBuildStatus";
    @Inject
    private BitbucketClientFactoryProvider bitbucketClientFactoryProvider;
    @Inject
    private BitbucketPluginConfiguration pluginConfiguration;
    @Inject
    private JenkinsToBitbucketCredentials jenkinsToBitbucketCredentials;
    @Inject
    private BitbucketBuildStatusFactory bitbucketBuildStatusFactory;

    public BuildStatusPoster() {
    }

    public BuildStatusPoster(BitbucketClientFactoryProvider bitbucketClientFactoryProvider, BitbucketPluginConfiguration pluginConfiguration, JenkinsToBitbucketCredentials jenkinsToBitbucketCredentials, BitbucketBuildStatusFactory bitbucketBuildStatusFactory) {
        this.bitbucketClientFactoryProvider = bitbucketClientFactoryProvider;
        this.pluginConfiguration = pluginConfiguration;
        this.jenkinsToBitbucketCredentials = jenkinsToBitbucketCredentials;
        this.bitbucketBuildStatusFactory = bitbucketBuildStatusFactory;
    }

    public void onCompleted(Run<?, ?> r, TaskListener listener) {
        for (BitbucketRevisionAction action : r.getActions(BitbucketRevisionAction.class)) {
            this.postBuildStatus(action, r, listener);
        }
    }

    public void postBuildStatus(BitbucketRevisionAction revisionAction, Run<?, ?> run, TaskListener listener) {
        if (Boolean.getBoolean("bitbucket.status.disable")) {
            listener.getLogger().println(BUILD_STATUS_DISABLED_MSG);
            return;
        }
        Optional<BitbucketServerConfiguration> serverOptional = this.pluginConfiguration.getServerById(revisionAction.getBitbucketSCMRepo().getServerId());
        if (serverOptional.isPresent()) {
            this.postBuildStatus(serverOptional.get(), revisionAction, run, listener);
        } else {
            listener.error(NO_SERVER_MSG);
        }
    }

    private void postBuildStatus(BitbucketServerConfiguration server, BitbucketRevisionAction revisionAction, Run<?, ?> run, TaskListener listener) {
        GlobalCredentialsProvider globalCredentialsProvider = server.getGlobalCredentialsProvider((Item)run.getParent());
        try {
            BitbucketClientFactory bbsClient = this.getBbsClient(server, globalCredentialsProvider);
            BitbucketBuildStatus.Builder buildStatusBuilder = this.bitbucketBuildStatusFactory.prepareBuildStatus(run, revisionAction);
            BitbucketSCMRepository bitbucketSCMRepo = revisionAction.getBitbucketSCMRepo();
            bbsClient.getProjectClient(bitbucketSCMRepo.getProjectKey()).getRepositoryClient(bitbucketSCMRepo.getRepositorySlug()).getBuildStatusClient(revisionAction.getRevisionSha1()).post(buildStatusBuilder, buildStatus -> listener.getLogger().println(String.format(BUILD_STATUS_FORMAT, buildStatus.getState(), server.getServerName(), revisionAction.getRevisionSha1(), buildStatus.getRef())));
        }
        catch (RuntimeException e) {
            String errorMsg = "Failed to post build status, additional information: " + e.getMessage();
            LOGGER.info(errorMsg);
            listener.getLogger().println(errorMsg);
            LOGGER.log(Level.FINE, "Stacktrace from build status failure", e);
        }
    }

    private BitbucketClientFactory getBbsClient(BitbucketServerConfiguration server, GlobalCredentialsProvider globalCredentialsProvider) {
        Credentials globalAdminCredentials = globalCredentialsProvider.getGlobalAdminCredentials().orElse(null);
        return this.bitbucketClientFactoryProvider.getClient(server.getBaseUrl(), this.jenkinsToBitbucketCredentials.toBitbucketCredentials(globalAdminCredentials));
    }

    @VisibleForTesting
    boolean useLegacyBuildStatus() {
        return Boolean.getBoolean(LEGACY_BUILD_STATUS_PROPERTY);
    }
}

