/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.scm;

import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMHeadDiscoveryHandler;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRepository;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMSourceRequest;
import com.cloudbees.plugins.credentials.Credentials;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.CheckForNull;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.trait.SCMSourceContext;

public class BitbucketSCMSourceContext
extends SCMSourceContext<BitbucketSCMSourceContext, BitbucketSCMSourceRequest> {
    private final Credentials credentials;
    private final Collection<BitbucketSCMHeadDiscoveryHandler> discoveryHandlers = new ArrayList<BitbucketSCMHeadDiscoveryHandler>();
    private final Collection<SCMHead> eventHeads;
    private final BitbucketSCMRepository repository;
    private final TaskListener taskListener;

    public BitbucketSCMSourceContext(@CheckForNull SCMSourceCriteria criteria, SCMHeadObserver observer, @CheckForNull Credentials credentials, Collection<SCMHead> eventHeads, BitbucketSCMRepository repository, TaskListener taskListener) {
        super(criteria, observer);
        this.credentials = credentials;
        this.eventHeads = Objects.requireNonNull(eventHeads, "eventHeads");
        this.repository = Objects.requireNonNull(repository, "repository");
        this.taskListener = Objects.requireNonNull(taskListener);
    }

    @CheckForNull
    public Credentials getCredentials() {
        return this.credentials;
    }

    public Collection<BitbucketSCMHeadDiscoveryHandler> getDiscoveryHandlers() {
        return Collections.unmodifiableCollection(this.discoveryHandlers);
    }

    public Collection<SCMHead> getEventHeads() {
        return Collections.unmodifiableCollection(this.eventHeads);
    }

    public BitbucketSCMSourceRequest newRequest(SCMSource source, @CheckForNull TaskListener listener) {
        return new BitbucketSCMSourceRequest(source, this, listener);
    }

    public BitbucketSCMRepository getRepository() {
        return this.repository;
    }

    public TaskListener getTaskListener() {
        return this.taskListener;
    }

    public void withDiscoveryHandler(BitbucketSCMHeadDiscoveryHandler handler) {
        this.discoveryHandlers.add(Objects.requireNonNull(handler, "handler"));
    }
}

