/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.scm;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactory;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactoryProvider;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketMirrorClient;
import com.atlassian.bitbucket.jenkins.internal.client.exception.BitbucketClientException;
import com.atlassian.bitbucket.jenkins.internal.credentials.BitbucketCredentials;
import com.atlassian.bitbucket.jenkins.internal.credentials.JenkinsToBitbucketCredentials;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketMirroredRepository;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketMirroredRepositoryDescriptor;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketMirroredRepositoryStatus;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketRepository;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketRepoFetcher;
import com.atlassian.bitbucket.jenkins.internal.scm.EnrichedBitbucketMirroredRepository;
import com.atlassian.bitbucket.jenkins.internal.scm.MirrorFetchException;
import com.atlassian.bitbucket.jenkins.internal.scm.MirrorFetchRequest;
import hudson.util.ListBoxModel;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class BitbucketMirrorHandler {
    private static final String DEFAULT_UPSTREAM_SERVER = "Primary Server";
    private static final ListBoxModel.Option DEFAULT_OPTION_SELECTED = new ListBoxModel.Option("Primary Server", "", true);
    private static final Logger LOGGER = Logger.getLogger(BitbucketMirrorHandler.class.getName());
    private final BitbucketClientFactoryProvider bitbucketClientFactoryProvider;
    private final JenkinsToBitbucketCredentials jenkinsToBitbucketCredentials;
    private final BitbucketRepoFetcher bitbucketRepoFetcher;

    public BitbucketMirrorHandler(BitbucketClientFactoryProvider bitbucketClientFactoryProvider, JenkinsToBitbucketCredentials jenkinsToBitbucketCredentials, BitbucketRepoFetcher bitbucketRepoFetcher) {
        this.bitbucketClientFactoryProvider = bitbucketClientFactoryProvider;
        this.jenkinsToBitbucketCredentials = jenkinsToBitbucketCredentials;
        this.bitbucketRepoFetcher = bitbucketRepoFetcher;
    }

    public EnrichedBitbucketMirroredRepository fetchRepository(MirrorFetchRequest mirrorFetchRequest) {
        return this.fetchRepositories(mirrorFetchRequest).stream().filter(r -> r.getMirroringDetails().getMirrorName().equals(mirrorFetchRequest.getExistingMirrorSelection())).findFirst().orElseThrow(() -> new MirrorFetchException("Unable to find the mirror" + mirrorFetchRequest.getExistingMirrorSelection()));
    }

    public ListBoxModel fetchAsListBox(MirrorFetchRequest mirrorFetchRequest) {
        if (StringUtils.isEmpty((CharSequence)mirrorFetchRequest.getProjectNameOrKey()) || StringUtils.isEmpty((CharSequence)mirrorFetchRequest.getRepoNameOrSlug())) {
            return this.getDefaultListBox();
        }
        ListBoxModel options = new ListBoxModel();
        String existingSelection = mirrorFetchRequest.getExistingMirrorSelection();
        List<EnrichedBitbucketMirroredRepository> repositories = this.fetchRepositoriesQuietly(mirrorFetchRequest);
        if (repositories.isEmpty()) {
            return this.getDefaultListBox();
        }
        List mirrors = repositories.stream().map(mirroredRepo -> this.createOption(existingSelection, (EnrichedBitbucketMirroredRepository)mirroredRepo)).collect(Collectors.toList());
        boolean isPresent = mirrors.stream().anyMatch(option -> option.selected);
        if (isPresent) {
            options.add((Object)new ListBoxModel.Option(DEFAULT_UPSTREAM_SERVER, ""));
        } else {
            options.add((Object)DEFAULT_OPTION_SELECTED);
        }
        options.addAll(mirrors);
        return options;
    }

    public ListBoxModel getDefaultListBox() {
        ListBoxModel options = new ListBoxModel();
        options.add((Object)DEFAULT_OPTION_SELECTED);
        return options;
    }

    private List<EnrichedBitbucketMirroredRepository> fetchRepositories(MirrorFetchRequest mirrorFetchRequest) {
        String bitbucketBaseUrl = Objects.requireNonNull(mirrorFetchRequest.getBitbucketServerBaseUrl(), "Bitbucket base Url not found");
        BitbucketCredentials jobOrGlobalConf = this.jenkinsToBitbucketCredentials.toBitbucketCredentials(mirrorFetchRequest.getCredentialsId(), mirrorFetchRequest.getContext());
        BitbucketClientFactory client = this.bitbucketClientFactoryProvider.getClient(bitbucketBaseUrl, jobOrGlobalConf);
        BitbucketRepository repository = this.bitbucketRepoFetcher.fetchRepo(client, mirrorFetchRequest.getProjectNameOrKey(), mirrorFetchRequest.getRepoNameOrSlug());
        BitbucketMirrorClient mirrorClient = client.getMirroredRepositoriesClient(repository.getId());
        return mirrorClient.getMirroredRepositoryDescriptors().getValues().stream().map(repoDescriptor -> this.fetchMirroredRepo(mirrorClient, (BitbucketMirroredRepositoryDescriptor)repoDescriptor, repository.getId())).filter(BitbucketMirroredRepository::isAvailable).map(mirrorDetails -> new EnrichedBitbucketMirroredRepository(repository, (BitbucketMirroredRepository)mirrorDetails)).collect(Collectors.toList());
    }

    private ListBoxModel.Option createOption(String existingSelection, EnrichedBitbucketMirroredRepository mirroredRepo) {
        String mirrorName = mirroredRepo.getMirroringDetails().getMirrorName();
        return new ListBoxModel.Option(mirrorName, mirrorName, mirrorName.equals(existingSelection));
    }

    private List<EnrichedBitbucketMirroredRepository> fetchRepositoriesQuietly(MirrorFetchRequest mirrorFetchRequest) {
        try {
            return this.fetchRepositories(mirrorFetchRequest);
        }
        catch (BitbucketClientException ex) {
            LOGGER.log(Level.FINE, String.format("Failed to retrieve mirroring information for project %s and repo %s", mirrorFetchRequest.getProjectNameOrKey(), mirrorFetchRequest.getRepoNameOrSlug()), ex);
            return Collections.emptyList();
        }
    }

    private BitbucketMirroredRepository fetchMirroredRepo(BitbucketMirrorClient client, BitbucketMirroredRepositoryDescriptor repoDescriptor, int repositoryId) {
        try {
            return client.getRepositoryDetails(repoDescriptor);
        }
        catch (BitbucketClientException e) {
            LOGGER.log(Level.FINE, "Failed to retrieve repository information from mirror: " + repoDescriptor.getMirrorServer().getName(), e);
            return new BitbucketMirroredRepository(false, Collections.emptyMap(), repoDescriptor.getMirrorServer().getName(), repositoryId, BitbucketMirroredRepositoryStatus.NOT_MIRRORED);
        }
    }
}

