/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.scm;

import com.atlassian.bitbucket.jenkins.internal.model.BitbucketCommit;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketDefaultBranch;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketPullRequestRef;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketRefChange;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMHead;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRevision;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import jenkins.plugins.git.GitBranchSCMHead;
import jenkins.plugins.git.GitBranchSCMRevision;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadMigration;
import jenkins.scm.api.SCMRevision;

public class BitbucketBranchSCMHead
extends BitbucketSCMHead {
    private static final String REFS_HEADS_PREFIX = "refs/heads/";
    private static final long UNKNOWN_TIMESTAMP = -1L;

    public BitbucketBranchSCMHead(String name) {
        super(name, null, -1L);
    }

    public BitbucketBranchSCMHead(BitbucketDefaultBranch branch) {
        super(branch.getDisplayId(), branch.getLatestCommit(), -1L);
    }

    public BitbucketBranchSCMHead(BitbucketPullRequestRef prRef) {
        super(prRef.getDisplayId(), prRef.getLatestCommit(), -1L);
    }

    public BitbucketBranchSCMHead(BitbucketRefChange refChange) {
        super(refChange.getRef().getDisplayId(), refChange.getToHash(), -1L);
    }

    public BitbucketBranchSCMHead(String name, BitbucketCommit commit) {
        super(name, commit.getId(), commit.getCommitterTimestamp());
    }

    @Override
    public String getFullRef() {
        return REFS_HEADS_PREFIX + this.getName();
    }

    @Extension
    public static class SCMHeadMigrationImpl
    extends SCMHeadMigration<BitbucketSCMSource, GitBranchSCMHead, GitBranchSCMRevision> {
        public SCMHeadMigrationImpl() {
            super(BitbucketSCMSource.class, GitBranchSCMHead.class, GitBranchSCMRevision.class);
        }

        public SCMHead migrate(@NonNull BitbucketSCMSource source, @NonNull GitBranchSCMHead head) {
            return new BitbucketBranchSCMHead(head.getName());
        }

        public SCMRevision migrate(@NonNull BitbucketSCMSource source, @NonNull GitBranchSCMRevision revision) {
            return new BitbucketSCMRevision(new BitbucketBranchSCMHead(revision.getHead().getName()), revision.getHash());
        }
    }
}

