/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.model;

import com.atlassian.bitbucket.jenkins.internal.model.BuildState;
import com.atlassian.bitbucket.jenkins.internal.model.TestResults;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BitbucketBuildStatus {
    private final String buildNumber;
    private final String description;
    private final Long duration;
    private final String key;
    private final String name;
    private final String parent;
    private final String ref;
    private final BuildState state;
    private final TestResults testResults;
    private final String url;

    @JsonCreator
    public BitbucketBuildStatus(@JsonProperty(value="buildNumber") @CheckForNull String buildNumber, @JsonProperty(value="description") @CheckForNull String description, @JsonProperty(value="duration") @CheckForNull Long duration, @JsonProperty(value="key") String key, @JsonProperty(value="name") @CheckForNull String name, @JsonProperty(value="parent") @CheckForNull String parent, @JsonProperty(value="ref") @CheckForNull String ref, @JsonProperty(value="state") BuildState state, @JsonProperty(value="testResults") @CheckForNull TestResults testResults, @JsonProperty(value="url") String url) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(state, "state");
        Objects.requireNonNull(url, "url");
        this.buildNumber = buildNumber;
        this.description = description;
        this.duration = duration;
        this.key = key;
        this.name = name;
        this.parent = parent;
        this.ref = ref;
        this.state = state;
        this.testResults = testResults;
        this.url = url;
    }

    private BitbucketBuildStatus(Builder builder) {
        this.key = Objects.requireNonNull(builder.key, "key");
        this.url = Objects.requireNonNull(builder.url, "url");
        this.description = builder.description;
        this.name = builder.name;
        if (builder.isLegacy) {
            this.buildNumber = null;
            this.duration = null;
            this.parent = null;
            this.ref = null;
            this.testResults = null;
        } else {
            this.buildNumber = builder.buildNumber;
            this.duration = builder.duration;
            this.parent = builder.parent;
            this.ref = builder.ref;
            this.testResults = builder.testResults;
        }
        this.state = builder.state == BuildState.CANCELLED && (builder.isLegacy || builder.noCancelledState) ? BuildState.FAILED : Objects.requireNonNull(builder.state, "state");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitbucketBuildStatus that = (BitbucketBuildStatus)o;
        return Objects.equals(this.buildNumber, that.buildNumber) && Objects.equals(this.description, that.description) && Objects.equals(this.duration, that.duration) && Objects.equals(this.key, that.key) && Objects.equals(this.name, that.name) && Objects.equals(this.parent, that.parent) && Objects.equals(this.ref, that.ref) && this.state == that.state && Objects.equals(this.testResults, that.testResults) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.buildNumber, this.description, this.duration, this.key, this.name, this.parent, this.ref, this.state, this.testResults, this.url});
    }

    @JsonProperty(value="buildNumber")
    public String getBuildNumber() {
        return this.buildNumber;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="duration")
    @Nullable
    public Long getDuration() {
        return this.duration;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="parent")
    @Nullable
    public String getParent() {
        return this.parent;
    }

    @JsonProperty(value="ref")
    @Nullable
    public String getRef() {
        return this.ref;
    }

    @JsonProperty(value="state")
    public String getState() {
        return this.state.toString();
    }

    @JsonProperty(value="testResults")
    @Nullable
    public TestResults getTestResults() {
        return this.testResults;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public static class Builder {
        private String buildNumber;
        private String description;
        private Long duration;
        private boolean isLegacy;
        private boolean noCancelledState;
        private String key;
        private String name;
        private String parent;
        private String ref;
        private BuildState state;
        private TestResults testResults;
        private String url;

        public Builder(String key, BuildState state, String url) {
            this.key = key;
            this.state = state;
            this.url = url;
        }

        public BitbucketBuildStatus build() {
            return new BitbucketBuildStatus(this);
        }

        public Builder legacy() {
            this.isLegacy = true;
            return this;
        }

        public Builder noCancelledState() {
            this.noCancelledState = true;
            return this;
        }

        public Builder setBuildNumber(String buildNumber) {
            this.buildNumber = buildNumber;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setDuration(long duration) {
            this.duration = duration;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setParent(String parent) {
            this.parent = parent;
            return this;
        }

        public Builder setRef(@Nullable String ref) {
            if (ref != null && !ref.startsWith("refs/")) {
                Logger.getLogger(BitbucketBuildStatus.class.getName()).warning(String.format("Supplied ref '%s' does not start with 'refs/', ignoring", ref));
                return this;
            }
            this.ref = ref;
            return this;
        }

        public Builder setTestResults(@Nullable TestResults testResults) {
            this.testResults = testResults;
            return this;
        }
    }
}

