/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.client.exception;

import com.atlassian.bitbucket.jenkins.internal.client.exception.BitbucketClientException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Headers;

public class RateLimitedException
extends BitbucketClientException {
    private long retryInMs;

    public RateLimitedException(String message, int responseCode, @Nullable String body, Headers headers) {
        super(message, responseCode, body);
        String retryAfter = headers.get("Retry-After");
        this.retryInMs = TimeUnit.SECONDS.toMillis(5L);
        if (retryAfter != null) {
            try {
                this.retryInMs = Long.parseLong(retryAfter) * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public long getRetryIn() {
        return this.retryInMs;
    }
}

