/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.client;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketFilePathClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketRequestExecutor;
import com.atlassian.bitbucket.jenkins.internal.client.RequestConfiguration;
import com.atlassian.bitbucket.jenkins.internal.client.exception.NotFoundException;
import com.atlassian.bitbucket.jenkins.internal.client.paging.BitbucketPageStreamUtil;
import com.atlassian.bitbucket.jenkins.internal.client.paging.NextPageFetcher;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketDirectory;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketDirectoryChild;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketPage;
import com.atlassian.bitbucket.jenkins.internal.scm.filesystem.BitbucketSCMFile;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import jenkins.scm.api.SCMFile;
import okhttp3.HttpUrl;

public class BitbucketFilePathClientImpl
implements BitbucketFilePathClient {
    private final BitbucketRequestExecutor bitbucketRequestExecutor;
    private final String projectKey;
    private final String repositorySlug;

    public BitbucketFilePathClientImpl(BitbucketRequestExecutor bitbucketRequestExecutor, String projectKey, String repositorySlug) {
        this.bitbucketRequestExecutor = bitbucketRequestExecutor;
        this.projectKey = projectKey;
        this.repositorySlug = repositorySlug;
    }

    @Override
    public List<SCMFile> getDirectoryContent(BitbucketSCMFile directory) {
        HttpUrl url = this.getUrl(directory);
        BitbucketPage<BitbucketDirectoryChild> firstPage = this.bitbucketRequestExecutor.makeGetRequest(url, BitbucketDirectory.class, new RequestConfiguration[0]).getBody().getChildren();
        return BitbucketPageStreamUtil.toStream(firstPage, new DirectoryNextPageFetcher(url, this.bitbucketRequestExecutor)).map(BitbucketPage::getValues).flatMap(Collection::stream).map(child -> {
            SCMFile.Type type = "FILE".equals(child.getType()) ? SCMFile.Type.REGULAR_FILE : SCMFile.Type.DIRECTORY;
            return new BitbucketSCMFile(directory, child.getPath().getComponents().get(0), type);
        }).collect(Collectors.toList());
    }

    @Override
    public SCMFile.Type getFileType(String path, String ref) {
        HttpUrl url = this.getUrlBuilder(path, ref).addQueryParameter("type", "true").build();
        try {
            BitbucketDirectoryChild file = this.bitbucketRequestExecutor.makeGetRequest(url, BitbucketDirectoryChild.class, new RequestConfiguration[0]).getBody();
            if ("FILE".equals(file.getType())) {
                return SCMFile.Type.REGULAR_FILE;
            }
            return SCMFile.Type.DIRECTORY;
        }
        catch (NotFoundException e) {
            return SCMFile.Type.NONEXISTENT;
        }
    }

    @Override
    public InputStream getRawFileStream(BitbucketSCMFile scmFile) {
        HttpUrl.Builder urlBuilder = this.bitbucketRequestExecutor.getCoreRestPath().newBuilder().addPathSegment("projects").addPathSegment(this.projectKey).addPathSegment("repos").addPathSegment(this.repositorySlug).addPathSegment("raw").addPathSegments(scmFile.getFilePath());
        scmFile.getRef().map(ref -> urlBuilder.addQueryParameter("at", ref));
        HttpUrl url = urlBuilder.build();
        return this.bitbucketRequestExecutor.makeStreamingGetRequest(url);
    }

    private HttpUrl getUrl(BitbucketSCMFile scmFile) {
        return this.getUrlBuilder(scmFile.getFilePath(), scmFile.getRef().orElse(null)).build();
    }

    private HttpUrl.Builder getUrlBuilder(String filePath, @CheckForNull String ref) {
        HttpUrl.Builder urlBuilder = this.bitbucketRequestExecutor.getCoreRestPath().newBuilder().addPathSegment("projects").addPathSegment(this.projectKey).addPathSegment("repos").addPathSegment(this.repositorySlug).addPathSegment("browse").addPathSegments(filePath);
        if (ref != null) {
            urlBuilder.addQueryParameter("at", ref);
        }
        return urlBuilder;
    }

    static class DirectoryNextPageFetcher
    implements NextPageFetcher<BitbucketDirectoryChild> {
        private final BitbucketRequestExecutor bitbucketRequestExecutor;
        private final HttpUrl url;

        DirectoryNextPageFetcher(HttpUrl url, BitbucketRequestExecutor bitbucketRequestExecutor) {
            this.url = url;
            this.bitbucketRequestExecutor = bitbucketRequestExecutor;
        }

        @Override
        public BitbucketPage<BitbucketDirectoryChild> next(BitbucketPage<BitbucketDirectoryChild> previous) {
            if (previous.isLastPage()) {
                throw new IllegalArgumentException("Last page does not have next page");
            }
            return this.bitbucketRequestExecutor.makeGetRequest(this.nextPageUrl(previous), new TypeReference<BitbucketPage<BitbucketDirectoryChild>>(){}, new RequestConfiguration[0]).getBody();
        }

        private HttpUrl nextPageUrl(BitbucketPage<BitbucketDirectoryChild> previous) {
            return this.url.newBuilder().addQueryParameter("start", String.valueOf(previous.getNextPageStart())).build();
        }
    }
}

