/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.client;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketAuthenticatedUserClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketAuthenticatedUserClientImpl;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketCapabilitiesClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketCapabilitiesClientImpl;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactory;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketMirrorClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketMirrorClientImpl;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketProjectClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketProjectClientImpl;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketRequestExecutor;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketSearchClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketSearchClientImpl;
import com.atlassian.bitbucket.jenkins.internal.client.HttpRequestExecutor;
import com.atlassian.bitbucket.jenkins.internal.credentials.BitbucketCredentials;
import com.atlassian.bitbucket.jenkins.internal.model.AtlassianServerCapabilities;
import com.atlassian.bitbucket.jenkins.internal.util.SystemPropertyUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;

public class BitbucketClientFactoryImpl
implements BitbucketClientFactory {
    public static final long CAPABILITIES_CACHE_DURATION = SystemPropertyUtils.parsePositiveLongFromSystemProperty("bitbucket.client.capabilities.cache.duration", 360000L);
    private final Cache<HttpUrl, AtlassianServerCapabilities> capabilitiesCache = CacheBuilder.newBuilder().expireAfterWrite(CAPABILITIES_CACHE_DURATION, TimeUnit.MILLISECONDS).build();
    private final BitbucketRequestExecutor bitbucketRequestExecutor;

    BitbucketClientFactoryImpl(String serverUrl, BitbucketCredentials credentials, ObjectMapper objectMapper, HttpRequestExecutor httpRequestExecutor) {
        this.bitbucketRequestExecutor = new BitbucketRequestExecutor(serverUrl, httpRequestExecutor, objectMapper, credentials);
    }

    @Override
    public BitbucketAuthenticatedUserClient getAuthenticatedUserClient() {
        return new BitbucketAuthenticatedUserClientImpl(this.bitbucketRequestExecutor);
    }

    @Override
    public BitbucketCapabilitiesClient getCapabilityClient() {
        return new BitbucketCapabilitiesClientImpl(this.bitbucketRequestExecutor, this.capabilitiesCache);
    }

    @Override
    public BitbucketMirrorClient getMirroredRepositoriesClient(int repositoryId) {
        return new BitbucketMirrorClientImpl(this.bitbucketRequestExecutor, repositoryId);
    }

    @Override
    public BitbucketProjectClient getProjectClient(String projectKey) {
        return new BitbucketProjectClientImpl(this.bitbucketRequestExecutor, this.getCapabilityClient(), projectKey);
    }

    @Override
    public BitbucketSearchClient getSearchClient(String projectName) {
        return new BitbucketSearchClientImpl(this.bitbucketRequestExecutor, projectName);
    }
}

