/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.status;

import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCM;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRepository;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRepositoryHelper;
import com.atlassian.bitbucket.jenkins.internal.status.BitbucketRevisionAction;
import com.atlassian.bitbucket.jenkins.internal.status.BuildStatusPoster;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.SCMListener;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import java.io.File;
import java.util.HashMap;
import javax.annotation.CheckForNull;
import javax.inject.Inject;

@Extension
public class LocalSCMListener
extends SCMListener {
    private BuildStatusPoster buildStatusPoster;
    private BitbucketSCMRepositoryHelper repositoryHelper;

    public LocalSCMListener() {
    }

    @Inject
    LocalSCMListener(BuildStatusPoster buildStatusPoster, BitbucketSCMRepositoryHelper repositoryHelper) {
        this.buildStatusPoster = buildStatusPoster;
        this.repositoryHelper = repositoryHelper;
    }

    public void onCheckout(Run<?, ?> build, SCM scm, FilePath workspace, TaskListener listener, @CheckForNull File changelogFile, @CheckForNull SCMRevisionState pollingBaseline) {
        BitbucketSCMRepository bitbucketSCMRepository = this.repositoryHelper.getRepository(build, scm);
        if (bitbucketSCMRepository == null) {
            return;
        }
        GitSCM underlyingScm = this.getUnderlyingGitSCM(scm);
        if (underlyingScm == null) {
            return;
        }
        HashMap env = new HashMap();
        underlyingScm.buildEnvironment(build, env);
        String branch = (String)env.get("GIT_BRANCH");
        String refName = branch != null ? underlyingScm.deriveLocalBranchName(branch) : null;
        BitbucketRevisionAction revisionAction = new BitbucketRevisionAction(bitbucketSCMRepository, refName, (String)env.get("GIT_COMMIT"));
        build.addAction((Action)revisionAction);
        this.buildStatusPoster.postBuildStatus(revisionAction, build, listener);
    }

    @CheckForNull
    public GitSCM getUnderlyingGitSCM(SCM scm) {
        BitbucketSCM bitbucketSCM;
        if (scm instanceof GitSCM) {
            return (GitSCM)scm;
        }
        if (scm instanceof BitbucketSCM && (bitbucketSCM = (BitbucketSCM)scm).getServerId() != null) {
            return bitbucketSCM.getGitSCM();
        }
        return null;
    }
}

