/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.scm;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactoryProvider;
import com.atlassian.bitbucket.jenkins.internal.client.exception.BitbucketClientException;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketPluginConfiguration;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketServerConfiguration;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketTokenCredentials;
import com.atlassian.bitbucket.jenkins.internal.credentials.GlobalCredentialsProvider;
import com.atlassian.bitbucket.jenkins.internal.credentials.JenkinsToBitbucketCredentials;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketDefaultBranch;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketNamedLink;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketProject;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketRepository;
import com.atlassian.bitbucket.jenkins.internal.model.RepositoryState;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketMirrorHandler;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRepository;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmFormFill;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmFormFillDelegate;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmFormValidation;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmFormValidationDelegate;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmHelper;
import com.atlassian.bitbucket.jenkins.internal.scm.CloneProtocol;
import com.atlassian.bitbucket.jenkins.internal.scm.CustomGitSCMSource;
import com.atlassian.bitbucket.jenkins.internal.scm.EnrichedBitbucketMirroredRepository;
import com.atlassian.bitbucket.jenkins.internal.scm.MirrorFetchException;
import com.atlassian.bitbucket.jenkins.internal.scm.MirrorFetchRequest;
import com.atlassian.bitbucket.jenkins.internal.status.BitbucketRepositoryMetadataAction;
import com.atlassian.bitbucket.jenkins.internal.trigger.BitbucketWebhookMultibranchTrigger;
import com.atlassian.bitbucket.jenkins.internal.trigger.RetryingWebhookHandler;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.AbstractWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.register.WebhookRegistrationFailed;
import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import com.cloudbees.plugins.credentials.Credentials;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.browser.Stash;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.scm.SCM;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import jenkins.plugins.git.GitSCMSource;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceEvent;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.metadata.PrimaryInstanceMetadataAction;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.impl.TagSCMHeadCategory;
import jenkins.scm.impl.UncategorizedSCMHeadCategory;
import jenkins.scm.impl.form.NamedArrayList;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class BitbucketSCMSource
extends SCMSource {
    private static final Logger LOGGER = Logger.getLogger(BitbucketSCMSource.class.getName());
    private final List<SCMSourceTrait> traits = new ArrayList<SCMSourceTrait>();
    private CustomGitSCMSource gitSCMSource;
    private BitbucketSCMRepository repository;
    private volatile boolean webhookRegistered;

    @DataBoundConstructor
    public BitbucketSCMSource(@CheckForNull String id, @CheckForNull String credentialsId, @CheckForNull String sshCredentialsId, @CheckForNull List<SCMSourceTrait> traits, @CheckForNull String projectName, @CheckForNull String repositoryName, @CheckForNull String serverId, @CheckForNull String mirrorName) {
        DescriptorImpl descriptor;
        Optional<BitbucketServerConfiguration> mayBeServerConf;
        super.setId(id);
        if (traits != null) {
            this.traits.addAll(traits);
        }
        if (!(mayBeServerConf = (descriptor = (DescriptorImpl)this.getDescriptor()).getConfiguration(serverId)).isPresent()) {
            LOGGER.info("No Bitbucket Server configuration for serverId " + serverId);
            this.setEmptyRepository(credentialsId, sshCredentialsId, projectName, repositoryName, serverId, mirrorName);
            return;
        }
        BitbucketServerConfiguration serverConfiguration = mayBeServerConf.get();
        GlobalCredentialsProvider globalCredentialsProvider = serverConfiguration.getGlobalCredentialsProvider(String.format("Bitbucket SCM: Query Bitbucket for project [%s] repo [%s] mirror[%s]", projectName, repositoryName, mirrorName));
        BitbucketScmHelper scmHelper = descriptor.getBitbucketScmHelper(serverConfiguration.getBaseUrl(), globalCredentialsProvider.getGlobalAdminCredentials().orElse(null));
        if (StringUtils.isBlank((CharSequence)projectName)) {
            LOGGER.info("Error creating the Bitbucket SCM: The project name is blank");
            this.setEmptyRepository(credentialsId, sshCredentialsId, projectName, repositoryName, serverId, mirrorName);
            return;
        }
        if (StringUtils.isBlank((CharSequence)repositoryName)) {
            LOGGER.info("Error creating the Bitbucket SCM: The repository name is blank");
            this.setEmptyRepository(credentialsId, sshCredentialsId, projectName, repositoryName, serverId, mirrorName);
            return;
        }
        String selfLink = "";
        if (StringUtils.isNotBlank((CharSequence)mirrorName)) {
            try {
                EnrichedBitbucketMirroredRepository mirroredRepository = descriptor.createMirrorHandler(scmHelper).fetchRepository(new MirrorFetchRequest(serverConfiguration.getBaseUrl(), credentialsId, globalCredentialsProvider, projectName, repositoryName, mirrorName));
                this.setRepositoryDetails(credentialsId, sshCredentialsId, serverId, mirroredRepository);
                selfLink = mirroredRepository.getRepository().getSelfLink();
            }
            catch (MirrorFetchException ex) {
                this.setEmptyRepository(credentialsId, sshCredentialsId, projectName, repositoryName, serverId, mirrorName);
            }
        } else {
            BitbucketRepository localRepo = scmHelper.getRepository(projectName, repositoryName);
            this.setRepositoryDetails(credentialsId, sshCredentialsId, serverId, "", localRepo);
            selfLink = localRepo.getSelfLink();
        }
        String repositoryUrl = selfLink.substring(0, Math.max(selfLink.lastIndexOf("/browse"), 0));
        this.gitSCMSource.setBrowser((GitRepositoryBrowser)new Stash(repositoryUrl));
        this.gitSCMSource.setId(this.getId() + "-git-scm");
    }

    public BitbucketSCMSource(BitbucketSCMSource oldScm) {
        this(oldScm.getId(), oldScm.getCredentialsId(), oldScm.getSshCredentialsId(), oldScm.getTraits(), oldScm.getProjectName(), oldScm.getRepositoryName(), oldScm.getServerId(), oldScm.getMirrorName());
    }

    public SCM build(SCMHead head, @CheckForNull SCMRevision revision) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Building SCM for " + head.getName() + " at revision " + revision);
        }
        return this.getGitSCMSource().build(head, revision);
    }

    protected List<Action> retrieveActions(SCMSourceEvent event, TaskListener listener) throws IOException, InterruptedException {
        ArrayList<Action> result = new ArrayList<Action>();
        DescriptorImpl descriptor = (DescriptorImpl)this.getDescriptor();
        Optional<BitbucketServerConfiguration> mayBeServerConf = descriptor.getConfiguration(this.getServerId());
        if (!mayBeServerConf.isPresent()) {
            LOGGER.info("No Bitbucket Server configuration for serverId " + this.getServerId());
            return Collections.emptyList();
        }
        BitbucketServerConfiguration serverConfiguration = mayBeServerConf.get();
        GlobalCredentialsProvider globalCredentialsProvider = serverConfiguration.getGlobalCredentialsProvider(String.format("Bitbucket SCM: Query Bitbucket for project [%s] repo [%s] mirror[%s]", this.getProjectName(), this.getRepositoryName(), this.getMirrorName()));
        BitbucketScmHelper scmHelper = descriptor.getBitbucketScmHelper(serverConfiguration.getBaseUrl(), globalCredentialsProvider.getGlobalAdminCredentials().orElse(null));
        scmHelper.getDefaultBranch(this.repository.getProjectName(), this.repository.getRepositoryName()).ifPresent(defaultBranch -> result.add((Action)new BitbucketRepositoryMetadataAction(this.repository, (BitbucketDefaultBranch)defaultBranch)));
        return result;
    }

    protected List<Action> retrieveActions(SCMHead head, @CheckForNull SCMHeadEvent event, TaskListener listener) throws IOException, InterruptedException {
        ArrayList<Action> result = new ArrayList<Action>();
        SCMSourceOwner owner = this.getOwner();
        if (owner instanceof Actionable) {
            ((Actionable)owner).getActions(BitbucketRepositoryMetadataAction.class).stream().filter(action -> action.getBitbucketSCMRepository().equals(this.repository) && StringUtils.equals((CharSequence)action.getBitbucketDefaultBranch().getDisplayId(), (CharSequence)head.getName())).findAny().ifPresent(action -> result.add((Action)new PrimaryInstanceMetadataAction()));
        }
        return result;
    }

    public void afterSave() {
        SCMSourceOwner owner;
        super.afterSave();
        this.getGitSCMSource().setOwner(this.getOwner());
        if (!this.webhookRegistered && this.isValid() && (owner = this.getOwner()) instanceof ComputedFolder) {
            ComputedFolder project = (ComputedFolder)owner;
            DescriptorImpl descriptor = (DescriptorImpl)this.getDescriptor();
            BitbucketServerConfiguration bitbucketServerConfiguration = descriptor.getConfiguration(this.getServerId()).orElseThrow(() -> new BitbucketClientException("Server config not found for input server id " + this.getServerId()));
            List<BitbucketWebhookMultibranchTrigger> triggers = this.getTriggers(project);
            boolean isPullRequestTrigger = triggers.stream().anyMatch(BitbucketWebhookMultibranchTrigger::isPullRequestTrigger);
            boolean isRefTrigger = triggers.stream().anyMatch(BitbucketWebhookMultibranchTrigger::isRefTrigger);
            try {
                descriptor.getRetryingWebhookHandler().register(bitbucketServerConfiguration.getBaseUrl(), bitbucketServerConfiguration.getGlobalCredentialsProvider((Item)owner), this.repository, isPullRequestTrigger, isRefTrigger);
            }
            catch (WebhookRegistrationFailed webhookRegistrationFailed) {
                LOGGER.severe("Webhook failed to register- token credentials assigned to " + bitbucketServerConfiguration.getServerName() + " do not have admin access. Please reconfigure your instance in the Manage Jenkins -> Settings page.");
            }
        }
    }

    public BitbucketSCMRepository getBitbucketSCMRepository() {
        return this.repository;
    }

    CustomGitSCMSource getGitSCMSource() {
        return this.gitSCMSource;
    }

    @CheckForNull
    public String getCredentialsId() {
        return this.getBitbucketSCMRepository().getCredentialsId();
    }

    public String getMirrorName() {
        return this.getBitbucketSCMRepository().getMirrorName();
    }

    public String getProjectKey() {
        return this.getBitbucketSCMRepository().getProjectKey();
    }

    public String getProjectName() {
        BitbucketSCMRepository repository = this.getBitbucketSCMRepository();
        return repository.isPersonal() ? repository.getProjectKey() : repository.getProjectName();
    }

    public String getRemote() {
        return this.getGitSCMSource().getRemote();
    }

    public String getRepositoryName() {
        return this.getBitbucketSCMRepository().getRepositoryName();
    }

    public String getRepositorySlug() {
        return this.getBitbucketSCMRepository().getRepositorySlug();
    }

    @CheckForNull
    public String getServerId() {
        return this.getBitbucketSCMRepository().getServerId();
    }

    @CheckForNull
    public String getSshCredentialsId() {
        return this.getBitbucketSCMRepository().getSshCredentialsId();
    }

    public boolean isEventApplicable(@CheckForNull SCMHeadEvent<?> event) {
        if (this.getOwner() instanceof ComputedFolder && event != null) {
            ComputedFolder owner = (ComputedFolder)this.getOwner();
            Object payload = event.getPayload();
            if (payload instanceof AbstractWebhookEvent) {
                AbstractWebhookEvent webhookEvent = (AbstractWebhookEvent)payload;
                return owner.getTriggers().values().stream().filter(trg -> trg instanceof BitbucketWebhookMultibranchTrigger).anyMatch(trig -> ((BitbucketWebhookMultibranchTrigger)((Object)trig)).isApplicableForEventType(webhookEvent));
            }
        }
        return false;
    }

    public boolean isValid() {
        return this.getMirrorName() != null && StringUtils.isNotBlank((CharSequence)this.getProjectKey()) && StringUtils.isNotBlank((CharSequence)this.getProjectName()) && StringUtils.isNotBlank((CharSequence)this.getRemote()) && StringUtils.isNotBlank((CharSequence)this.getRepositoryName()) && StringUtils.isNotBlank((CharSequence)this.getRepositorySlug()) && StringUtils.isNotBlank((CharSequence)this.getServerId());
    }

    public List<SCMSourceTrait> getTraits() {
        return this.traits;
    }

    public boolean isWebhookRegistered() {
        return this.webhookRegistered;
    }

    public void setWebhookRegistered(boolean webhookRegistered) {
        this.webhookRegistered = webhookRegistered;
    }

    private List<BitbucketWebhookMultibranchTrigger> getTriggers(ComputedFolder<?> owner) {
        return owner.getTriggers().values().stream().filter(BitbucketWebhookMultibranchTrigger.class::isInstance).map(BitbucketWebhookMultibranchTrigger.class::cast).collect(Collectors.toList());
    }

    protected void retrieve(@CheckForNull SCMSourceCriteria criteria, SCMHeadObserver observer, @CheckForNull SCMHeadEvent<?> event, TaskListener listener) throws IOException, InterruptedException {
        if (!this.isEventApplicable(event) && event != null) {
            SCMSourceOwner owner = this.getOwner();
            String projectName = owner == null ? "" : owner.getFullName();
            String eventType = event.getPayload() instanceof AbstractWebhookEvent ? ((AbstractWebhookEvent)event.getPayload()).getEventKey() : "";
            LOGGER.info(String.format("Performing retrieve for project %s with no relevant trigger for %s event", projectName, eventType));
        }
        this.getGitSCMSource().accessibleRetrieve(criteria, observer, event, listener);
    }

    private String getCloneUrl(List<BitbucketNamedLink> cloneUrls, CloneProtocol cloneProtocol) {
        return cloneUrls.stream().filter(link -> Objects.equals(cloneProtocol.name, link.getName())).findFirst().map(BitbucketNamedLink::getHref).orElse("");
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private void initialize(String cloneUrl, BitbucketSCMRepository bitbucketSCMRepository) {
        this.repository = bitbucketSCMRepository;
        String credentialsId = StringUtils.isBlank((CharSequence)bitbucketSCMRepository.getSshCredentialsId()) ? bitbucketSCMRepository.getCredentialsId() : bitbucketSCMRepository.getSshCredentialsId();
        UserRemoteConfig remoteConfig = new UserRemoteConfig(cloneUrl, bitbucketSCMRepository.getRepositorySlug(), null, credentialsId);
        this.gitSCMSource = new CustomGitSCMSource(remoteConfig.getUrl(), this.repository);
        this.getGitSCMSource().setTraits(this.traits);
        this.getGitSCMSource().setCredentialsId(credentialsId);
    }

    private void setEmptyRepository(@Nullable String credentialsId, @Nullable String sshCredentialsId, @CheckForNull String projectName, @CheckForNull String repositoryName, @CheckForNull String serverId, @CheckForNull String mirrorName) {
        projectName = Objects.toString(projectName, "");
        repositoryName = Objects.toString(repositoryName, "");
        mirrorName = Objects.toString(mirrorName, "");
        BitbucketRepository repository = new BitbucketRepository(-1, repositoryName, null, new BitbucketProject(projectName, null, projectName), repositoryName, RepositoryState.AVAILABLE);
        this.setRepositoryDetails(credentialsId, sshCredentialsId, serverId, mirrorName, repository);
    }

    private void setRepositoryDetails(@Nullable String credentialsId, @Nullable String sshCredentialsId, @Nullable String serverId, String mirrorName, BitbucketRepository repository) {
        CloneProtocol cloneProtocol = StringUtils.isBlank((CharSequence)sshCredentialsId) ? CloneProtocol.HTTP : CloneProtocol.SSH;
        String cloneUrl = this.getCloneUrl(repository.getCloneUrls(), cloneProtocol);
        if (cloneUrl.isEmpty()) {
            LOGGER.info("No clone url found for repository: " + repository.getName());
        }
        BitbucketSCMRepository bitbucketSCMRepository = new BitbucketSCMRepository(credentialsId, sshCredentialsId, repository.getProject().getName(), repository.getProject().getKey(), repository.getName(), repository.getSlug(), serverId, mirrorName);
        this.initialize(cloneUrl, bitbucketSCMRepository);
    }

    private void setRepositoryDetails(@Nullable String credentialsId, @Nullable String sshCredentialsId, @Nullable String serverId, EnrichedBitbucketMirroredRepository repository) {
        if (StringUtils.isBlank((CharSequence)serverId)) {
            return;
        }
        CloneProtocol cloneProtocol = StringUtils.isBlank((CharSequence)sshCredentialsId) ? CloneProtocol.HTTP : CloneProtocol.SSH;
        String cloneUrl = this.getCloneUrl(repository.getMirroringDetails().getCloneUrls(), cloneProtocol);
        if (cloneUrl.isEmpty()) {
            LOGGER.info("No clone url found for repository: " + repository.getRepository().getName());
        }
        BitbucketRepository underlyingRepo = repository.getRepository();
        BitbucketSCMRepository bitbucketSCMRepository = new BitbucketSCMRepository(credentialsId, sshCredentialsId, underlyingRepo.getProject().getName(), underlyingRepo.getProject().getKey(), underlyingRepo.getName(), underlyingRepo.getSlug(), serverId, repository.getMirroringDetails().getMirrorName());
        this.initialize(cloneUrl, bitbucketSCMRepository);
    }

    @Symbol(value={"BbS"})
    @Extension
    public static class DescriptorImpl
    extends SCMSourceDescriptor
    implements BitbucketScmFormValidation,
    BitbucketScmFormFill {
        private final GitSCMSource.DescriptorImpl gitScmSourceDescriptor = new GitSCMSource.DescriptorImpl();
        @Inject
        private BitbucketClientFactoryProvider bitbucketClientFactoryProvider;
        @Inject
        private BitbucketPluginConfiguration bitbucketPluginConfiguration;
        @Inject
        private BitbucketScmFormFillDelegate formFill;
        @Inject
        private BitbucketScmFormValidationDelegate formValidation;
        @Inject
        private JenkinsToBitbucketCredentials jenkinsToBitbucketCredentials;
        @Inject
        private RetryingWebhookHandler retryingWebhookHandler;

        @Override
        @POST
        public FormValidation doCheckCredentialsId(@AncestorInPath Item context, @QueryParameter String credentialsId) {
            return this.formValidation.doCheckCredentialsId(context, credentialsId);
        }

        @Override
        public FormValidation doCheckSshCredentialsId(@AncestorInPath Item context, @QueryParameter String sshCredentialsId) {
            return this.formValidation.doCheckSshCredentialsId(context, sshCredentialsId);
        }

        @Override
        @POST
        public FormValidation doCheckProjectName(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName) {
            return this.formValidation.doCheckProjectName(context, serverId, credentialsId, projectName);
        }

        @Override
        @POST
        public FormValidation doCheckRepositoryName(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName, @QueryParameter String repositoryName) {
            return this.formValidation.doCheckRepositoryName(context, serverId, credentialsId, projectName, repositoryName);
        }

        @Override
        @POST
        public FormValidation doCheckServerId(@AncestorInPath Item context, @QueryParameter String serverId) {
            return this.formValidation.doCheckServerId(context, serverId);
        }

        @Override
        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String baseUrl, @QueryParameter String credentialsId) {
            return this.formFill.doFillCredentialsIdItems(context, baseUrl, credentialsId);
        }

        @Override
        public ListBoxModel doFillSshCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String baseUrl, @QueryParameter String sshCredentialsId) {
            return this.formFill.doFillSshCredentialsIdItems(context, baseUrl, sshCredentialsId);
        }

        @Override
        @POST
        public ListBoxModel doFillMirrorNameItems(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName, @QueryParameter String repositoryName, @QueryParameter String mirrorName) {
            return this.formFill.doFillMirrorNameItems(context, serverId, credentialsId, projectName, repositoryName, mirrorName);
        }

        @Override
        @POST
        public HttpResponse doFillProjectNameItems(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName) {
            return this.formFill.doFillProjectNameItems(context, serverId, credentialsId, projectName);
        }

        @Override
        @POST
        public HttpResponse doFillRepositoryNameItems(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName, @QueryParameter String repositoryName) {
            return this.formFill.doFillRepositoryNameItems(context, serverId, credentialsId, projectName, repositoryName);
        }

        @Override
        @POST
        public ListBoxModel doFillServerIdItems(@AncestorInPath Item context, @QueryParameter String serverId) {
            return this.formFill.doFillServerIdItems(context, serverId);
        }

        @Override
        @POST
        public FormValidation doTestConnection(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName, @QueryParameter String repositoryName, @QueryParameter String mirrorName) {
            return this.formValidation.doTestConnection(context, serverId, credentialsId, projectName, repositoryName, mirrorName);
        }

        public String getDisplayName() {
            return "Bitbucket server";
        }

        @Override
        public List<GitSCMExtensionDescriptor> getExtensionDescriptors() {
            return Collections.emptyList();
        }

        @Override
        public List<GitTool> getGitTools() {
            return Collections.emptyList();
        }

        public RetryingWebhookHandler getRetryingWebhookHandler() {
            return this.retryingWebhookHandler;
        }

        public BitbucketClientFactoryProvider getBitbucketClientFactoryProvider() {
            return this.bitbucketClientFactoryProvider;
        }

        @Override
        public boolean getShowGitToolOptions() {
            return false;
        }

        public List<SCMSourceTrait> getTraitsDefaults() {
            return this.gitScmSourceDescriptor.getTraitsDefaults();
        }

        public List<NamedArrayList<? extends SCMSourceTraitDescriptor>> getTraitsDescriptorLists() {
            return this.gitScmSourceDescriptor.getTraitsDescriptorLists();
        }

        protected SCMHeadCategory[] createCategories() {
            return new SCMHeadCategory[]{UncategorizedSCMHeadCategory.DEFAULT, TagSCMHeadCategory.DEFAULT};
        }

        BitbucketScmHelper getBitbucketScmHelper(String bitbucketUrl, @Nullable BitbucketTokenCredentials tokenCredentials) {
            return new BitbucketScmHelper(bitbucketUrl, this.bitbucketClientFactoryProvider, this.jenkinsToBitbucketCredentials.toBitbucketCredentials((Credentials)tokenCredentials));
        }

        Optional<BitbucketServerConfiguration> getConfiguration(@Nullable String serverId) {
            return this.bitbucketPluginConfiguration.getServerById(serverId);
        }

        private BitbucketMirrorHandler createMirrorHandler(BitbucketScmHelper helper) {
            return new BitbucketMirrorHandler(this.bitbucketClientFactoryProvider, this.jenkinsToBitbucketCredentials, (client, project, repo) -> helper.getRepository(project, repo));
        }
    }
}

