/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.scm;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactoryProvider;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketPluginConfiguration;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketServerConfiguration;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketTokenCredentials;
import com.atlassian.bitbucket.jenkins.internal.credentials.GlobalCredentialsProvider;
import com.atlassian.bitbucket.jenkins.internal.credentials.JenkinsToBitbucketCredentials;
import com.atlassian.bitbucket.jenkins.internal.credentials.JenkinsToBitbucketCredentialsModule;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketNamedLink;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketProject;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketRepository;
import com.atlassian.bitbucket.jenkins.internal.model.RepositoryState;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketMirrorHandler;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRepository;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmFormFill;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmFormFillDelegate;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmFormValidation;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmFormValidationDelegate;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmHelper;
import com.atlassian.bitbucket.jenkins.internal.scm.CloneProtocol;
import com.atlassian.bitbucket.jenkins.internal.scm.EnrichedBitbucketMirroredRepository;
import com.atlassian.bitbucket.jenkins.internal.scm.MirrorFetchException;
import com.atlassian.bitbucket.jenkins.internal.scm.MirrorFetchRequest;
import com.cloudbees.plugins.credentials.Credentials;
import com.google.inject.Guice;
import com.google.inject.Module;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.SubmoduleConfig;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.browser.Stash;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class BitbucketSCM
extends SCM {
    private static final Logger LOGGER = Logger.getLogger(BitbucketSCM.class.getName());
    private GitSCM gitSCM;
    private final List<BranchSpec> branches;
    private final List<GitSCMExtension> extensions;
    private final String gitTool;
    private final String id;
    private final List<BitbucketSCMRepository> repositories;
    private volatile boolean isWebhookRegistered;

    @DataBoundConstructor
    public BitbucketSCM(@CheckForNull String id, @CheckForNull List<BranchSpec> branches, @CheckForNull String credentialsId, @CheckForNull String sshCredentialsId, @CheckForNull List<GitSCMExtension> extensions, @CheckForNull String gitTool, @CheckForNull String projectName, @CheckForNull @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="We handle null values properly in a way that Findbugs misses") String repositoryName, @CheckForNull String serverId, @CheckForNull String mirrorName) {
        this(id, branches, extensions, gitTool, serverId, repositoryName);
        DescriptorImpl descriptor = (DescriptorImpl)this.getDescriptor();
        Optional<BitbucketServerConfiguration> mayBeServerConf = descriptor.getConfiguration(serverId);
        if (!mayBeServerConf.isPresent()) {
            LOGGER.info("No Bitbucket Server configuration for serverId " + serverId);
            this.setEmptyRepository(credentialsId, sshCredentialsId, projectName, repositoryName, serverId, mirrorName);
            return;
        }
        BitbucketServerConfiguration serverConfiguration = mayBeServerConf.get();
        GlobalCredentialsProvider globalCredentialsProvider = serverConfiguration.getGlobalCredentialsProvider(String.format("Bitbucket SCM: Query Bitbucket for project [%s] repo [%s] mirror[%s]", projectName, repositoryName, mirrorName));
        BitbucketScmHelper scmHelper = descriptor.getBitbucketScmHelper(serverConfiguration.getBaseUrl(), globalCredentialsProvider.getGlobalAdminCredentials().orElse(null));
        if (StringUtils.isBlank((CharSequence)projectName)) {
            LOGGER.info("Error creating the Bitbucket SCM: The project name is blank");
            this.setEmptyRepository(credentialsId, sshCredentialsId, projectName, repositoryName, serverId, mirrorName);
            return;
        }
        if (StringUtils.isBlank((CharSequence)repositoryName)) {
            LOGGER.info("Error creating the Bitbucket SCM: The repository name is blank");
            this.setEmptyRepository(credentialsId, sshCredentialsId, projectName, repositoryName, serverId, mirrorName);
            return;
        }
        if (!StringUtils.isBlank((CharSequence)mirrorName)) {
            try {
                EnrichedBitbucketMirroredRepository mirroredRepository = descriptor.createMirrorHandler(scmHelper).fetchRepository(new MirrorFetchRequest(serverConfiguration.getBaseUrl(), credentialsId, globalCredentialsProvider, projectName, repositoryName, mirrorName));
                this.setRepositoryDetails(credentialsId, sshCredentialsId, serverId, mirroredRepository);
            }
            catch (MirrorFetchException ex) {
                this.setEmptyRepository(credentialsId, sshCredentialsId, projectName, repositoryName, serverId, mirrorName);
            }
        } else {
            BitbucketRepository repository = scmHelper.getRepository(projectName, repositoryName);
            this.setRepositoryDetails(credentialsId, sshCredentialsId, serverId, mirrorName, repository);
        }
    }

    public BitbucketSCM(@CheckForNull String id, @CheckForNull List<BranchSpec> branches, @CheckForNull String credentialsId, @CheckForNull String sshCredentialsId, @CheckForNull List<GitSCMExtension> extensions, @CheckForNull String gitTool, @CheckForNull String serverId, BitbucketRepository repository) {
        this(id, branches, extensions, gitTool, serverId, repository.getName());
        this.setRepositoryDetails(credentialsId, sshCredentialsId, serverId, "", repository);
    }

    public BitbucketSCM(BitbucketSCM oldScm) {
        this(oldScm.getId(), oldScm.getBranches(), oldScm.getCredentialsId(), oldScm.getSshCredentialsId(), oldScm.getExtensions(), oldScm.getGitTool(), oldScm.getProjectName(), oldScm.getRepositoryName(), oldScm.getServerId(), oldScm.getMirrorName());
    }

    private BitbucketSCM(@CheckForNull String id, @CheckForNull List<BranchSpec> branches, @CheckForNull List<GitSCMExtension> extensions, @CheckForNull String gitTool, @CheckForNull String serverId, String repositoryName) {
        this.id = StringUtils.isBlank((CharSequence)id) ? UUID.randomUUID().toString() : id;
        this.branches = new ArrayList<BranchSpec>();
        this.extensions = new ArrayList<GitSCMExtension>();
        this.gitTool = gitTool;
        this.repositories = new ArrayList<BitbucketSCMRepository>(1);
        if (branches != null) {
            this.branches.addAll(branches);
        }
        if (extensions != null) {
            this.extensions.addAll(extensions);
        }
    }

    @CheckForNull
    public String getGitTool() {
        return this.gitTool;
    }

    public void buildEnvironment(Run<?, ?> build, Map<String, String> env) {
        this.gitSCM.buildEnvironment(build, env);
    }

    @CheckForNull
    public SCMRevisionState calcRevisionsFromBuild(Run<?, ?> build, @Nullable FilePath workspace, @Nullable Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return this.gitSCM.calcRevisionsFromBuild(build, workspace, launcher, listener);
    }

    public void checkout(Run<?, ?> build, Launcher launcher, FilePath workspace, TaskListener listener, @CheckForNull File changelogFile, @CheckForNull SCMRevisionState baseline) throws IOException, InterruptedException {
        this.gitSCM.checkout(build, launcher, workspace, listener, changelogFile, baseline);
    }

    public PollingResult compareRemoteRevisionWith(Job<?, ?> project, @Nullable Launcher launcher, @Nullable FilePath workspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        return this.gitSCM.compareRemoteRevisionWith(project, launcher, workspace, listener, baseline);
    }

    public ChangeLogParser createChangeLogParser() {
        return this.gitSCM.createChangeLogParser();
    }

    public List<BranchSpec> getBranches() {
        if (this.gitSCM == null) {
            return Collections.emptyList();
        }
        return this.gitSCM.getBranches();
    }

    @CheckForNull
    public RepositoryBrowser<?> getBrowser() {
        return this.gitSCM.getBrowser();
    }

    @CheckForNull
    public GitSCM getGitSCM() {
        return this.gitSCM;
    }

    @CheckForNull
    public String getCredentialsId() {
        return this.getBitbucketSCMRepository().getCredentialsId();
    }

    @CheckForNull
    public String getSshCredentialsId() {
        return this.getBitbucketSCMRepository().getSshCredentialsId();
    }

    public List<GitSCMExtension> getExtensions() {
        return this.gitSCM.getExtensions();
    }

    public String getId() {
        return this.id;
    }

    public String getProjectKey() {
        return this.getBitbucketSCMRepository().getProjectKey();
    }

    public String getProjectName() {
        BitbucketSCMRepository repository = this.getBitbucketSCMRepository();
        return repository.isPersonal() ? repository.getProjectKey() : repository.getProjectName();
    }

    public List<BitbucketSCMRepository> getRepositories() {
        return this.repositories;
    }

    public String getRepositorySlug() {
        return this.getBitbucketSCMRepository().getRepositorySlug();
    }

    public String getRepositoryName() {
        return this.getBitbucketSCMRepository().getRepositoryName();
    }

    public String getMirrorName() {
        return this.getBitbucketSCMRepository().getMirrorName();
    }

    @CheckForNull
    public String getServerId() {
        return this.getBitbucketSCMRepository().getServerId();
    }

    public Collection<SubmoduleConfig> getSubmoduleCfg() {
        if (this.gitSCM == null) {
            return Collections.emptyList();
        }
        return this.gitSCM.getSubmoduleCfg();
    }

    public List<UserRemoteConfig> getUserRemoteConfigs() {
        if (this.gitSCM == null) {
            return Collections.emptyList();
        }
        return this.gitSCM.getUserRemoteConfigs();
    }

    public void setWebhookRegistered(boolean isWebhookRegistered) {
        this.isWebhookRegistered = isWebhookRegistered;
    }

    public boolean isWebhookRegistered() {
        return this.isWebhookRegistered;
    }

    public BitbucketSCMRepository getBitbucketSCMRepository() {
        return this.repositories.get(0);
    }

    private String getCloneUrl(List<BitbucketNamedLink> cloneUrls, CloneProtocol protocol) {
        return cloneUrls.stream().filter(link -> Objects.equals(protocol.name, link.getName())).findFirst().map(BitbucketNamedLink::getHref).orElse("");
    }

    private void initialize(String cloneUrl, String selfLink, BitbucketSCMRepository bitbucketSCMRepository) {
        this.repositories.add(bitbucketSCMRepository);
        String credentialsId = StringUtils.isBlank((CharSequence)bitbucketSCMRepository.getSshCredentialsId()) ? bitbucketSCMRepository.getCredentialsId() : bitbucketSCMRepository.getSshCredentialsId();
        UserRemoteConfig remoteConfig = new UserRemoteConfig(cloneUrl, bitbucketSCMRepository.getRepositorySlug(), null, credentialsId);
        String repositoryUrl = selfLink.substring(0, Math.max(selfLink.lastIndexOf("/browse"), 0));
        this.gitSCM = new GitSCM(Collections.singletonList(remoteConfig), this.branches, Boolean.valueOf(false), Collections.emptyList(), (GitRepositoryBrowser)new Stash(repositoryUrl), this.gitTool, this.extensions);
    }

    private void setEmptyRepository(@CheckForNull String credentialsId, @CheckForNull String sshCredentialsId, @CheckForNull String projectName, @CheckForNull String repositoryName, @CheckForNull String serverId, @CheckForNull String mirrorName) {
        projectName = Objects.toString(projectName, "");
        repositoryName = Objects.toString(repositoryName, "");
        mirrorName = Objects.toString(mirrorName, "");
        BitbucketRepository repository = new BitbucketRepository(-1, repositoryName, null, new BitbucketProject(projectName, null, projectName), repositoryName, RepositoryState.AVAILABLE);
        this.setRepositoryDetails(credentialsId, sshCredentialsId, serverId, mirrorName, repository);
    }

    private void setRepositoryDetails(@CheckForNull String credentialsId, @CheckForNull String sshCredentialsId, @Nullable String serverId, String mirrorName, BitbucketRepository repository) {
        CloneProtocol cloneProtocol = StringUtils.isBlank((CharSequence)sshCredentialsId) ? CloneProtocol.HTTP : CloneProtocol.SSH;
        String cloneUrl = this.getCloneUrl(repository.getCloneUrls(), cloneProtocol);
        BitbucketSCMRepository bitbucketSCMRepository = new BitbucketSCMRepository(credentialsId, sshCredentialsId, repository.getProject().getName(), repository.getProject().getKey(), repository.getName(), repository.getSlug(), serverId, mirrorName);
        this.initialize(cloneUrl, repository.getSelfLink(), bitbucketSCMRepository);
    }

    private void setRepositoryDetails(@CheckForNull String credentialsId, @CheckForNull String sshCredentialsId, @Nullable String serverId, EnrichedBitbucketMirroredRepository repository) {
        if (StringUtils.isBlank((CharSequence)serverId)) {
            return;
        }
        CloneProtocol cloneProtocol = StringUtils.isBlank((CharSequence)sshCredentialsId) ? CloneProtocol.HTTP : CloneProtocol.SSH;
        String cloneUrl = this.getCloneUrl(repository.getMirroringDetails().getCloneUrls(), cloneProtocol);
        BitbucketRepository underlyingRepo = repository.getRepository();
        BitbucketSCMRepository bitbucketSCMRepository = new BitbucketSCMRepository(credentialsId, sshCredentialsId, underlyingRepo.getProject().getName(), underlyingRepo.getProject().getKey(), underlyingRepo.getName(), underlyingRepo.getSlug(), serverId, repository.getMirroringDetails().getMirrorName());
        this.initialize(cloneUrl, underlyingRepo.getSelfLink(), bitbucketSCMRepository);
    }

    @Symbol(value={"BbS"})
    @Extension
    public static class DescriptorImpl
    extends SCMDescriptor<BitbucketSCM>
    implements BitbucketScmFormValidation,
    BitbucketScmFormFill {
        private final GitSCM.DescriptorImpl gitScmDescriptor = new GitSCM.DescriptorImpl();
        @Inject
        private BitbucketScmFormFillDelegate formFill;
        @Inject
        private BitbucketScmFormValidationDelegate formValidation;
        @Inject
        private BitbucketClientFactoryProvider bitbucketClientFactoryProvider;
        @Inject
        private BitbucketPluginConfiguration bitbucketPluginConfiguration;
        private transient JenkinsToBitbucketCredentials jenkinsToBitbucketCredentials;

        public DescriptorImpl() {
            super(Stash.class);
            this.load();
        }

        @Override
        @POST
        public FormValidation doCheckCredentialsId(@AncestorInPath Item context, @QueryParameter String credentialsId) {
            return this.formValidation.doCheckCredentialsId(context, credentialsId);
        }

        @Override
        @POST
        public FormValidation doCheckSshCredentialsId(@AncestorInPath Item context, @QueryParameter String sshCredentialsId) {
            return this.formValidation.doCheckCredentialsId(context, sshCredentialsId);
        }

        @Override
        @POST
        public FormValidation doCheckProjectName(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName) {
            return this.formValidation.doCheckProjectName(context, serverId, credentialsId, projectName);
        }

        @Override
        @POST
        public FormValidation doCheckRepositoryName(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName, @QueryParameter String repositoryName) {
            return this.formValidation.doCheckRepositoryName(context, serverId, credentialsId, projectName, repositoryName);
        }

        @Override
        @POST
        public FormValidation doCheckServerId(@AncestorInPath Item context, @QueryParameter String serverId) {
            return this.formValidation.doCheckServerId(context, serverId);
        }

        @Override
        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String baseUrl, @QueryParameter String credentialsId) {
            return this.formFill.doFillCredentialsIdItems(context, baseUrl, credentialsId);
        }

        @Override
        @POST
        public ListBoxModel doFillSshCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String baseUrl, @QueryParameter String sshCredentialsId) {
            return this.formFill.doFillSshCredentialsIdItems(context, baseUrl, sshCredentialsId);
        }

        @Override
        @POST
        public FormValidation doTestConnection(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName, @QueryParameter String repositoryName, @QueryParameter String mirrorName) {
            return this.formValidation.doTestConnection(context, serverId, credentialsId, projectName, repositoryName, mirrorName);
        }

        @POST
        public ListBoxModel doFillGitToolItems() {
            return this.gitScmDescriptor.doFillGitToolItems();
        }

        @Override
        @POST
        public HttpResponse doFillProjectNameItems(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName) {
            return this.formFill.doFillProjectNameItems(context, serverId, credentialsId, projectName);
        }

        @Override
        @POST
        public HttpResponse doFillRepositoryNameItems(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName, @QueryParameter String repositoryName) {
            return this.formFill.doFillRepositoryNameItems(context, serverId, credentialsId, projectName, repositoryName);
        }

        @Override
        @POST
        public ListBoxModel doFillServerIdItems(@AncestorInPath Item context, @QueryParameter String serverId) {
            return this.formFill.doFillServerIdItems(context, serverId);
        }

        @Override
        @POST
        public ListBoxModel doFillMirrorNameItems(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName, @QueryParameter String repositoryName, @QueryParameter String mirrorName) {
            return this.formFill.doFillMirrorNameItems(context, serverId, credentialsId, projectName, repositoryName, mirrorName);
        }

        public String getDisplayName() {
            return "Bitbucket Server";
        }

        @Override
        public List<GitSCMExtensionDescriptor> getExtensionDescriptors() {
            return this.gitScmDescriptor.getExtensionDescriptors();
        }

        @Override
        public List<GitTool> getGitTools() {
            return this.gitScmDescriptor.getGitTools();
        }

        @Override
        public boolean getShowGitToolOptions() {
            return this.gitScmDescriptor.showGitToolOptions();
        }

        public boolean isApplicable(Job project) {
            return true;
        }

        @Inject
        public void setJenkinsToBitbucketCredentials(JenkinsToBitbucketCredentials jenkinsToBitbucketCredentials) {
            this.jenkinsToBitbucketCredentials = jenkinsToBitbucketCredentials;
        }

        BitbucketScmHelper getBitbucketScmHelper(String bitbucketUrl, @Nullable BitbucketTokenCredentials tokenCredentials) {
            return new BitbucketScmHelper(bitbucketUrl, this.bitbucketClientFactoryProvider, this.jenkinsToBitbucketCredentials.toBitbucketCredentials((Credentials)tokenCredentials));
        }

        private BitbucketMirrorHandler createMirrorHandler(BitbucketScmHelper helper) {
            return new BitbucketMirrorHandler(this.bitbucketClientFactoryProvider, this.jenkinsToBitbucketCredentials, (client, project, repo) -> helper.getRepository(project, repo));
        }

        Optional<BitbucketServerConfiguration> getConfiguration(@Nullable String serverId) {
            return this.bitbucketPluginConfiguration.getServerById(serverId);
        }

        public void injectJenkinsToBitbucketCredentials() {
            if (this.jenkinsToBitbucketCredentials == null) {
                Guice.createInjector((Module[])new Module[]{new JenkinsToBitbucketCredentialsModule()}).injectMembers((Object)this);
            }
        }
    }
}

