/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.link;

import com.atlassian.bitbucket.jenkins.internal.link.BitbucketExternalLinkUtils;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCM;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRepository;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMSource;
import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.FreeStyleProject;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.scm.SCM;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import jenkins.model.TransientActionFactory;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;

@Extension
public class BitbucketJobLinkActionFactory
extends TransientActionFactory<Job> {
    @Inject
    private BitbucketExternalLinkUtils externalLinkUtils;

    public BitbucketJobLinkActionFactory() {
    }

    public BitbucketJobLinkActionFactory(BitbucketExternalLinkUtils externalLinkUtils) {
        this.externalLinkUtils = externalLinkUtils;
    }

    @Nonnull
    public Collection<? extends Action> createFor(@Nonnull Job target) {
        if (target instanceof FreeStyleProject) {
            FreeStyleProject freeStyleProject = (FreeStyleProject)target;
            if (freeStyleProject.getScm() instanceof BitbucketSCM) {
                BitbucketSCMRepository scmRepository2 = ((BitbucketSCM)freeStyleProject.getScm()).getBitbucketSCMRepository();
                return this.externalLinkUtils.createRepoLink(scmRepository2).map(xva$0 -> Arrays.asList(xva$0)).orElse(Collections.emptyList());
            }
        } else if (target instanceof WorkflowJob) {
            Optional<BitbucketSCMRepository> maybeRepository;
            CpsScmFlowDefinition definition;
            WorkflowJob workflowJob = (WorkflowJob)target;
            if (workflowJob.getDefinition() instanceof CpsScmFlowDefinition && (definition = (CpsScmFlowDefinition)workflowJob.getDefinition()).getScm() instanceof BitbucketSCM) {
                BitbucketSCMRepository scmRepository3 = ((BitbucketSCM)definition.getScm()).getBitbucketSCMRepository();
                return this.externalLinkUtils.createRepoLink(scmRepository3).map(xva$0 -> Arrays.asList(xva$0)).orElse(Collections.emptyList());
            }
            if (this.getWorkflowSCMs(workflowJob).stream().anyMatch(scm -> scm instanceof BitbucketSCM)) {
                maybeRepository = this.getWorkflowSCMs(workflowJob).stream().filter(scm -> scm instanceof BitbucketSCM).map(scm -> ((BitbucketSCM)((Object)scm)).getBitbucketSCMRepository()).findFirst();
                return maybeRepository.flatMap(scmRepository -> this.externalLinkUtils.createBranchDiffLink((BitbucketSCMRepository)scmRepository, target.getName())).map(xva$0 -> Arrays.asList(xva$0)).orElse(Collections.emptyList());
            }
            if (this.getWorkflowParent(workflowJob) instanceof WorkflowMultiBranchProject) {
                maybeRepository = ((WorkflowMultiBranchProject)this.getWorkflowParent(workflowJob)).getSCMSources().stream().filter(scmSource -> scmSource instanceof BitbucketSCMSource).map(scmSource -> ((BitbucketSCMSource)((Object)scmSource)).getBitbucketSCMRepository()).findFirst();
                return maybeRepository.flatMap(scmRepository -> this.externalLinkUtils.createBranchDiffLink((BitbucketSCMRepository)scmRepository, target.getName())).map(xva$0 -> Arrays.asList(xva$0)).orElse(Collections.emptyList());
            }
        }
        return Collections.emptySet();
    }

    public Class<Job> type() {
        return Job.class;
    }

    @VisibleForTesting
    ItemGroup getWorkflowParent(WorkflowJob job) {
        return job.getParent();
    }

    @VisibleForTesting
    Collection<? extends SCM> getWorkflowSCMs(WorkflowJob job) {
        return job.getSCMs();
    }
}

