/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.deployments;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactory;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactoryProvider;
import com.atlassian.bitbucket.jenkins.internal.client.exception.AuthorizationException;
import com.atlassian.bitbucket.jenkins.internal.client.exception.BitbucketClientException;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketPluginConfiguration;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketServerConfiguration;
import com.atlassian.bitbucket.jenkins.internal.credentials.BitbucketCredentials;
import com.atlassian.bitbucket.jenkins.internal.credentials.JenkinsToBitbucketCredentials;
import com.atlassian.bitbucket.jenkins.internal.deployments.BitbucketDeploymentFactory;
import com.atlassian.bitbucket.jenkins.internal.deployments.DeploymentNotifier;
import com.atlassian.bitbucket.jenkins.internal.deployments.DeploymentPoster;
import com.atlassian.bitbucket.jenkins.internal.model.deployment.BitbucketDeployment;
import com.atlassian.bitbucket.jenkins.internal.model.deployment.BitbucketDeploymentCapabilities;
import com.atlassian.bitbucket.jenkins.internal.model.deployment.BitbucketDeploymentEnvironment;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRepository;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRepositoryHelper;
import com.cloudbees.plugins.credentials.Credentials;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.SCMListener;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;

@Extension
@Singleton
public class DeploymentPosterImpl
extends SCMListener
implements DeploymentPoster {
    protected static final Logger LOGGER = Logger.getLogger(DeploymentPosterImpl.class.getName());
    private BitbucketClientFactoryProvider bitbucketClientFactoryProvider;
    private BitbucketDeploymentFactory bitbucketDeploymentFactory;
    private JenkinsToBitbucketCredentials jenkinsToBitbucketCredentials;
    private BitbucketPluginConfiguration pluginConfiguration;
    private BitbucketSCMRepositoryHelper scmRunHelper;

    public DeploymentPosterImpl() {
        throw new IllegalStateException("DeploymentPosterImpl no-arg constructor should not be called explicitly");
    }

    @Inject
    public DeploymentPosterImpl(BitbucketClientFactoryProvider bitbucketClientFactoryProvider, BitbucketDeploymentFactory bitbucketDeploymentFactory, JenkinsToBitbucketCredentials jenkinsToBitbucketCredentials, BitbucketPluginConfiguration pluginConfiguration, BitbucketSCMRepositoryHelper scmRunHelper) {
        this.bitbucketClientFactoryProvider = bitbucketClientFactoryProvider;
        this.bitbucketDeploymentFactory = bitbucketDeploymentFactory;
        this.jenkinsToBitbucketCredentials = jenkinsToBitbucketCredentials;
        this.pluginConfiguration = pluginConfiguration;
        this.scmRunHelper = scmRunHelper;
    }

    public void onCheckout(Run<?, ?> build, SCM scm, FilePath workspace, TaskListener listener, @CheckForNull File changelogFile, @CheckForNull SCMRevisionState pollingBaseline) {
        String revisionSha1;
        DeploymentNotifier deploymentPublisher = this.getDeploymentPublisher(build);
        if (deploymentPublisher == null) {
            return;
        }
        BitbucketDeploymentEnvironment environment = deploymentPublisher.getEnvironment(build, listener);
        BitbucketDeployment deployment = this.bitbucketDeploymentFactory.createDeployment(build, environment);
        BitbucketSCMRepository repo = this.scmRunHelper.getRepository(build, scm);
        if (repo == null) {
            listener.getLogger().println("Could not post deployment information: Bitbucket repository information not present on the SCM");
            return;
        }
        try {
            revisionSha1 = (String)build.getEnvironment(listener).get((Object)"GIT_COMMIT");
        }
        catch (IOException | InterruptedException e) {
            listener.getLogger().println("Could not post deployment information: Error reading the environment variables");
            return;
        }
        if (StringUtils.isBlank((CharSequence)revisionSha1)) {
            listener.getLogger().println("Could not post deployment information: Git commit information not present in the environment variables");
            return;
        }
        this.postDeployment(repo, revisionSha1, deployment, build, listener);
    }

    @Override
    public void postDeployment(BitbucketSCMRepository repository, String revisionSha, BitbucketDeployment deployment, Run<?, ?> run, TaskListener taskListener) {
        Optional<BitbucketServerConfiguration> maybeServer = this.pluginConfiguration.getServerById(repository.getServerId());
        if (!maybeServer.isPresent()) {
            taskListener.error(String.format("Could not send deployment notification to Bitbucket Server: Unknown serverId '%s'", repository.getServerId()));
            return;
        }
        BitbucketServerConfiguration server = maybeServer.get();
        Credentials globalAdminCredentials = server.getGlobalCredentialsProvider((Item)run.getParent()).getGlobalAdminCredentials().orElse(null);
        BitbucketCredentials credentials = this.jenkinsToBitbucketCredentials.toBitbucketCredentials(globalAdminCredentials);
        BitbucketClientFactory clientFactory = this.bitbucketClientFactoryProvider.getClient(server.getBaseUrl(), credentials);
        BitbucketDeploymentCapabilities deploymentCapabilities = clientFactory.getCapabilityClient().getDeploymentCapabilities();
        if (!deploymentCapabilities.isDeploymentsSupported()) {
            taskListener.error(String.format("Could not send deployment notification to '%s': The Bitbucket version does not support deployments", server.getServerName()));
            return;
        }
        taskListener.getLogger().println(String.format("Sending notification of '%s' deployment to '%s' on commit '%s'", deployment.getState().name(), server.getServerName(), revisionSha));
        try {
            clientFactory.getProjectClient(repository.getProjectKey()).getRepositoryClient(repository.getRepositorySlug()).getDeploymentClient(revisionSha).post(deployment);
            taskListener.getLogger().println(String.format("Sent notification of '%s' deployment to '%s' on commit '%s'", deployment.getState().name(), server.getServerName(), revisionSha));
        }
        catch (AuthorizationException e) {
            taskListener.error(String.format("The personal access token for the Bitbucket Server instance '%s' is invalid or insufficient to post deployment information: %s", server.getServerName(), e.getMessage()));
        }
        catch (BitbucketClientException e) {
            String errorMsg = String.format("Failed to send notification of deployment to '%s' due to an error: %s", server.getServerName(), e.getMessage());
            taskListener.error(errorMsg);
            LOGGER.log(Level.FINE, "Stacktrace from deployment post failure", e);
        }
    }

    @CheckForNull
    private DeploymentNotifier getDeploymentPublisher(Run<?, ?> build) {
        if (!(build instanceof FreeStyleBuild)) {
            return null;
        }
        FreeStyleBuild freeStyleBuild = (FreeStyleBuild)build;
        return (DeploymentNotifier)((FreeStyleProject)freeStyleBuild.getParent()).getPublishersList().get(DeploymentNotifier.class);
    }
}

