/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.deployments;

import com.atlassian.bitbucket.jenkins.internal.deployments.BitbucketDeploymentFactory;
import com.atlassian.bitbucket.jenkins.internal.model.deployment.BitbucketDeployment;
import com.atlassian.bitbucket.jenkins.internal.model.deployment.BitbucketDeploymentEnvironment;
import com.atlassian.bitbucket.jenkins.internal.model.deployment.DeploymentState;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.CheckForNull;
import jenkins.branch.MultiBranchProject;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;

public class BitbucketDeploymentFactoryImpl
implements BitbucketDeploymentFactory {
    private static final Collection<Result> canceledResults = Arrays.asList(Result.ABORTED, Result.NOT_BUILT);
    private static final Collection<Result> successfulResults = Arrays.asList(Result.SUCCESS, Result.UNSTABLE);
    private final DisplayURLProvider displayURLProvider;

    public BitbucketDeploymentFactoryImpl() {
        this(DisplayURLProvider.get());
    }

    BitbucketDeploymentFactoryImpl(DisplayURLProvider displayURLProvider) {
        this.displayURLProvider = displayURLProvider;
    }

    @Override
    public BitbucketDeployment createDeployment(Run<?, ?> run, BitbucketDeploymentEnvironment environment) {
        return this.createDeployment(run, environment, null);
    }

    @Override
    public BitbucketDeployment createDeployment(Run<?, ?> run, BitbucketDeploymentEnvironment environment, @CheckForNull DeploymentState state) {
        Job job = run.getParent();
        String key = job.getFullName();
        String name = this.getName(job);
        state = state == null ? this.getStateFromRun(run) : state;
        String description = state.getDescriptiveText(name, environment.getName());
        String url = this.displayURLProvider.getRunURL(run);
        return new BitbucketDeployment(run.getNumber(), description, name, environment, key, state, url);
    }

    private String getName(Job<?, ?> job) {
        if (job.getParent() instanceof MultiBranchProject) {
            return job.getParent().getDisplayName() + " \u00bb " + job.getDisplayName();
        }
        return job.getDisplayName();
    }

    private DeploymentState getStateFromRun(Run<?, ?> run) {
        if (run.hasntStartedYet()) {
            return DeploymentState.PENDING;
        }
        Result result = run.getResult();
        if (result == null) {
            return DeploymentState.IN_PROGRESS;
        }
        if (canceledResults.contains(result)) {
            return DeploymentState.CANCELLED;
        }
        if (successfulResults.contains(result)) {
            return DeploymentState.SUCCESSFUL;
        }
        return DeploymentState.FAILED;
    }
}

