/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.config;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactory;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactoryProvider;
import com.atlassian.bitbucket.jenkins.internal.client.exception.AuthorizationException;
import com.atlassian.bitbucket.jenkins.internal.client.exception.BitbucketClientException;
import com.atlassian.bitbucket.jenkins.internal.client.exception.ConnectionFailureException;
import com.atlassian.bitbucket.jenkins.internal.client.exception.NotFoundException;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketTokenCredentials;
import com.atlassian.bitbucket.jenkins.internal.credentials.GlobalCredentialsProvider;
import com.atlassian.bitbucket.jenkins.internal.credentials.JenkinsToBitbucketCredentials;
import com.atlassian.bitbucket.jenkins.internal.credentials.JenkinsToBitbucketCredentialsModule;
import com.atlassian.bitbucket.jenkins.internal.model.AtlassianServerCapabilities;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.inject.Guice;
import com.google.inject.Module;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class BitbucketServerConfiguration
extends AbstractDescribableImpl<BitbucketServerConfiguration> {
    private static final Logger log = Logger.getLogger(BitbucketServerConfiguration.class.getName());
    private final String adminCredentialsId;
    private final String id;
    private String baseUrl;
    private String serverName;

    @DataBoundConstructor
    public BitbucketServerConfiguration(String adminCredentialsId, String baseUrl, @Nullable String id) {
        this.adminCredentialsId = Objects.requireNonNull(adminCredentialsId);
        this.baseUrl = Objects.requireNonNull(baseUrl);
        this.id = StringUtils.isBlank((CharSequence)id) ? UUID.randomUUID().toString() : id;
    }

    public GlobalCredentialsProvider getGlobalCredentialsProvider(Item item) {
        return () -> {
            BitbucketTokenCredentials adminCredentials = this.getAdminCredentials();
            return Optional.ofNullable(CredentialsProvider.track((Item)item, (Credentials)adminCredentials));
        };
    }

    public GlobalCredentialsProvider getGlobalCredentialsProvider(String context) {
        if (StringUtils.isBlank((CharSequence)context)) {
            throw new IllegalArgumentException("Please provide a valid non blank context");
        }
        return () -> {
            log.fine(String.format("Using admin credentials for [%s]", context));
            return Optional.ofNullable(this.getAdminCredentials());
        };
    }

    public String getAdminCredentialsId() {
        return this.adminCredentialsId;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @DataBoundSetter
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = StringUtils.trimToEmpty((String)baseUrl);
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getServerName() {
        return this.serverName;
    }

    @DataBoundSetter
    public void setServerName(String serverName) {
        this.serverName = StringUtils.trimToEmpty((String)serverName);
    }

    public FormValidation validate() {
        return FormValidation.aggregate(Arrays.asList(BitbucketServerConfiguration.checkBaseUrl(this.baseUrl), BitbucketServerConfiguration.checkServerName(this.serverName), BitbucketServerConfiguration.checkAdminCredentialsId(this.adminCredentialsId)));
    }

    private static FormValidation checkAdminCredentialsId(String adminCredentialsId) {
        if (StringUtils.isBlank((CharSequence)adminCredentialsId)) {
            return FormValidation.error((String)"Choose a personal access token");
        }
        Credentials creds = CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(BitbucketTokenCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)StringUtils.trimToEmpty((String)adminCredentialsId)));
        if (creds == null) {
            return FormValidation.error((String)"We can't find that personal access token (has it been deleted?). Provide a different token and try again.");
        }
        return FormValidation.ok();
    }

    private static FormValidation checkBaseUrl(String baseUrl) {
        if (StringUtils.isEmpty((CharSequence)baseUrl)) {
            return FormValidation.error((String)"Required");
        }
        try {
            URL base = new URL(baseUrl);
            if (StringUtils.isBlank((CharSequence)base.getHost())) {
                return FormValidation.error((String)"This isn't a valid URL. Check for typos and make sure to include http:// or https://");
            }
            if (base.getHost().endsWith("bitbucket.org")) {
                return FormValidation.error((String)"This plugin does not support connecting to bitbucket.org. It is for Bitbucket Server instances only.");
            }
        }
        catch (MalformedURLException e) {
            return FormValidation.error((String)"This isn't a valid URL. Check for typos and make sure to include http:// or https://");
        }
        return FormValidation.ok();
    }

    private static FormValidation checkServerName(String serverName) {
        return StringUtils.isBlank((CharSequence)serverName) ? FormValidation.error((String)"Required") : FormValidation.ok();
    }

    @Nullable
    private BitbucketTokenCredentials getAdminCredentials() {
        return (BitbucketTokenCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(BitbucketTokenCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)StringUtils.trimToEmpty((String)this.adminCredentialsId)));
    }

    @Symbol(value={"BbS"})
    @Extension
    public static class DescriptorImpl
    extends Descriptor<BitbucketServerConfiguration> {
        @Inject
        private BitbucketClientFactoryProvider clientFactoryProvider;
        private transient JenkinsToBitbucketCredentials jenkinsToBitbucketCredentials;

        @POST
        public FormValidation doCheckAdminCredentialsId(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return BitbucketServerConfiguration.checkAdminCredentialsId(value);
        }

        @POST
        public FormValidation doCheckBaseUrl(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return BitbucketServerConfiguration.checkBaseUrl(value);
        }

        @POST
        public FormValidation doCheckServerName(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return BitbucketServerConfiguration.checkServerName(value);
        }

        @POST
        public ListBoxModel doFillAdminCredentialsIdItems(@QueryParameter String baseUrl, @QueryParameter String credentialsId) {
            Jenkins instance = Jenkins.get();
            instance.checkPermission(Jenkins.ADMINISTER);
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)instance, BitbucketTokenCredentials.class, URIRequirementBuilder.fromUri((String)baseUrl).build(), CredentialsMatchers.always());
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@QueryParameter String baseUrl, @QueryParameter String credentialsId) {
            Jenkins instance = Jenkins.get();
            instance.checkPermission(Jenkins.ADMINISTER);
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)instance, StringCredentials.class, URIRequirementBuilder.fromUri((String)baseUrl).build(), CredentialsMatchers.always()).includeMatchingAs(ACL.SYSTEM, (ItemGroup)instance, StandardUsernamePasswordCredentials.class, URIRequirementBuilder.fromUri((String)baseUrl).build(), CredentialsMatchers.always());
        }

        @POST
        public FormValidation doTestConnection(@QueryParameter String adminCredentialsId, @QueryParameter String baseUrl, @QueryParameter String credentialsId) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            BitbucketServerConfiguration config = new BitbucketServerConfiguration(adminCredentialsId, baseUrl, null);
            if (config.getAdminCredentials() == null) {
                return FormValidation.error((String)"A personal access token with project admin permissions is required.");
            }
            String context = "Test connection in global configuration";
            try {
                BitbucketClientFactory client;
                Optional<String> username;
                if (this.jenkinsToBitbucketCredentials == null) {
                    Guice.createInjector((Module[])new Module[]{new JenkinsToBitbucketCredentialsModule()}).injectMembers((Object)this);
                }
                if (!(username = (client = this.clientFactoryProvider.getClient(config.getBaseUrl(), this.jenkinsToBitbucketCredentials.toBitbucketCredentials((Credentials)config.getAdminCredentials()))).getAuthenticatedUserClient().getAuthenticatedUser()).isPresent()) {
                    return FormValidation.error((String)"We can't connect to Bitbucket Server. Choose a different personal access token with project admin permissions");
                }
                AtlassianServerCapabilities capabilities = client.getCapabilityClient().getServerCapabilities();
                if (capabilities.isBitbucketServer()) {
                    return FormValidation.ok((String)"Jenkins can connect with Bitbucket Server.");
                }
                return FormValidation.error((String)"This is not the URL of a Bitbucket Server instance. Enter a different URL and try again.");
            }
            catch (ConnectionFailureException e) {
                return FormValidation.error((String)"Could not connect to remote server, please ensure url is correct and server is running");
            }
            catch (NotFoundException e) {
                return FormValidation.error((String)"This is not the URL of a Bitbucket Server instance. Enter a different URL and try again.");
            }
            catch (AuthorizationException e) {
                return FormValidation.error((String)"Jenkins can't connect to Bitbucket Server. Choose different credentials or choose 'none'.");
            }
            catch (BitbucketClientException e) {
                Logger.getLogger(DescriptorImpl.class.getName()).log(Level.FINE, "Failed to connect to Bitbucket server", e);
                return FormValidation.error((String)"Connection failure, please try again");
            }
        }

        public String getDisplayName() {
            return "Instance details";
        }

        @Inject
        public void setJenkinsToBitbucketCredentials(JenkinsToBitbucketCredentials jenkinsToBitbucketCredentials) {
            this.jenkinsToBitbucketCredentials = jenkinsToBitbucketCredentials;
        }
    }
}

