/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.client;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketFilePathClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketRequestExecutor;
import com.atlassian.bitbucket.jenkins.internal.client.paging.BitbucketPageStreamUtil;
import com.atlassian.bitbucket.jenkins.internal.client.paging.NextPageFetcher;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketDirectory;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketDirectoryChild;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketFilePage;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketPage;
import com.atlassian.bitbucket.jenkins.internal.scm.filesystem.BitbucketSCMFile;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.scm.api.SCMFile;
import okhttp3.HttpUrl;

public class BitbucketFilePathClientImpl
implements BitbucketFilePathClient {
    private final BitbucketRequestExecutor bitbucketRequestExecutor;
    private final String projectKey;
    private final String repositorySlug;

    public BitbucketFilePathClientImpl(BitbucketRequestExecutor bitbucketRequestExecutor, String projectKey, String repositorySlug) {
        this.bitbucketRequestExecutor = bitbucketRequestExecutor;
        this.projectKey = projectKey;
        this.repositorySlug = repositorySlug;
    }

    @Override
    public List<SCMFile> getDirectoryContent(BitbucketSCMFile directory) {
        HttpUrl url = this.getUrl(directory);
        BitbucketPage<BitbucketDirectoryChild> firstPage = this.bitbucketRequestExecutor.makeGetRequest(url, BitbucketDirectory.class).getBody().getChildren();
        return BitbucketPageStreamUtil.toStream(firstPage, new DirectoryNextPageFetcher(url, this.bitbucketRequestExecutor)).map(BitbucketPage::getValues).flatMap(Collection::stream).map(child -> {
            SCMFile.Type type = "FILE".equals(child.getType()) ? SCMFile.Type.REGULAR_FILE : SCMFile.Type.DIRECTORY;
            return new BitbucketSCMFile(directory, child.getPath().getComponents().get(0), type);
        }).collect(Collectors.toList());
    }

    @Override
    public String getFileContent(BitbucketSCMFile file) {
        HttpUrl url = this.getUrl(file);
        BitbucketFilePage firstPage = this.bitbucketRequestExecutor.makeGetRequest(url, BitbucketFilePage.class).getBody();
        return BitbucketPageStreamUtil.toStream(firstPage, new FileNextPageFetcher(url, this.bitbucketRequestExecutor)).map(page -> ((BitbucketFilePage)page).getLines()).flatMap(Collection::stream).collect(Collectors.joining("\n"));
    }

    private HttpUrl getUrl(BitbucketSCMFile scmFile) {
        HttpUrl.Builder urlBuilder = this.bitbucketRequestExecutor.getCoreRestPath().newBuilder().addPathSegment("projects").addPathSegment(this.projectKey).addPathSegment("repos").addPathSegment(this.repositorySlug).addPathSegment("browse").addPathSegments(scmFile.getFilePath());
        scmFile.getRef().map(ref -> urlBuilder.addQueryParameter("at", ref));
        return urlBuilder.build();
    }

    static class FileNextPageFetcher
    implements NextPageFetcher<String> {
        private final BitbucketRequestExecutor bitbucketRequestExecutor;
        private final HttpUrl url;

        FileNextPageFetcher(HttpUrl url, BitbucketRequestExecutor bitbucketRequestExecutor) {
            this.url = url;
            this.bitbucketRequestExecutor = bitbucketRequestExecutor;
        }

        @Override
        public BitbucketPage<String> next(BitbucketPage<String> previous) {
            if (previous.isLastPage()) {
                throw new IllegalArgumentException("Last page does not have next page");
            }
            return this.bitbucketRequestExecutor.makeGetRequest(this.nextPageUrl(previous), new TypeReference<BitbucketFilePage>(){}).getBody();
        }

        private HttpUrl nextPageUrl(BitbucketPage<String> previous) {
            return this.url.newBuilder().addQueryParameter("start", String.valueOf(previous.getNextPageStart())).build();
        }
    }

    static class DirectoryNextPageFetcher
    implements NextPageFetcher<BitbucketDirectoryChild> {
        private final BitbucketRequestExecutor bitbucketRequestExecutor;
        private final HttpUrl url;

        DirectoryNextPageFetcher(HttpUrl url, BitbucketRequestExecutor bitbucketRequestExecutor) {
            this.url = url;
            this.bitbucketRequestExecutor = bitbucketRequestExecutor;
        }

        @Override
        public BitbucketPage<BitbucketDirectoryChild> next(BitbucketPage<BitbucketDirectoryChild> previous) {
            if (previous.isLastPage()) {
                throw new IllegalArgumentException("Last page does not have next page");
            }
            return this.bitbucketRequestExecutor.makeGetRequest(this.nextPageUrl(previous), new TypeReference<BitbucketPage<BitbucketDirectoryChild>>(){}).getBody();
        }

        private HttpUrl nextPageUrl(BitbucketPage<BitbucketDirectoryChild> previous) {
            return this.url.newBuilder().addQueryParameter("start", String.valueOf(previous.getNextPageStart())).build();
        }
    }
}

