/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.client;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketBuildStatusClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketRequestExecutor;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketBuildStatus;
import java.util.Collections;
import java.util.Objects;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.StringUtils;

public class BitbucketBuildStatusClientImpl
implements BitbucketBuildStatusClient {
    private static final String BUILD_STATUS_VERSION = "1.0";
    private final BitbucketRequestExecutor bitbucketRequestExecutor;
    private final String revisionSha;

    BitbucketBuildStatusClientImpl(BitbucketRequestExecutor bitbucketRequestExecutor, String revisionSha) {
        this.bitbucketRequestExecutor = Objects.requireNonNull(bitbucketRequestExecutor, "bitbucketRequestExecutor");
        this.revisionSha = Objects.requireNonNull(StringUtils.stripToNull((String)revisionSha), "revisionSha");
    }

    @Override
    public void post(BitbucketBuildStatus buildStatus) {
        HttpUrl url = this.bitbucketRequestExecutor.getBaseUrl().newBuilder().addPathSegment("rest").addPathSegment("build-status").addPathSegment(BUILD_STATUS_VERSION).addPathSegment("commits").addPathSegment(this.revisionSha).build();
        this.bitbucketRequestExecutor.makePostRequest(url, buildStatus, Headers.of(Collections.emptyMap()));
    }
}

