/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.applink.oauth.util;

import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;

public class OAuthProblemUtils {
    public static void logOAuthProblem(OAuthMessage message, OAuthProblemException ope, Logger logger) {
        if ("timestamp_refused".equals(ope.getProblem())) {
            logger.log(Level.WARNING, "Rejecting OAuth request for url \"{}\" due to invalid timestamp ({}). This is most likely due to our system clock not being synchronized with the consumer's clock.", new Object[]{message.URL, ope.getParameters()});
        } else if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.WARNING, "Problem encountered authenticating OAuth client request for url \"" + message.URL + "\", error was \"" + ope.getProblem() + "\", with parameters \"" + ope.getParameters() + "\"", ope);
        } else {
            logger.log(Level.WARNING, "Problem encountered authenticating OAuth client for url \"{}\", error was \"{}\", with parameters \"{}\"", new Object[]{message.URL, ope.getProblem(), ope.getParameters()});
        }
    }

    public static void logOAuthRequest(HttpServletRequest request, String message, Logger logger) {
        logger.log(Level.FINE, () -> {
            StringBuffer buffer = new StringBuffer();
            buffer.append(message);
            buffer.append(" Headers: [");
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                buffer.append(headerName);
                buffer.append(" = ");
                buffer.append(request.getHeader(headerName));
                buffer.append(", ");
            }
            buffer.append("]");
            return buffer.toString();
        });
    }
}

