/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.artifactrepo.connectors.impl;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import io.jenkins.plugins.artifactrepo.ArtifactRepoParamDefinition;
import io.jenkins.plugins.artifactrepo.Messages;
import io.jenkins.plugins.artifactrepo.connectors.Connector;
import io.jenkins.plugins.artifactrepo.helper.HttpHelper;
import io.jenkins.plugins.artifactrepo.model.HttpResponse;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.JSONArray;
import org.json.JSONObject;

public class Nexus
implements Connector {
    private static final Logger log = Logger.getLogger(Nexus.class.getName());
    public static final String ID = "nexus";
    private final ArtifactRepoParamDefinition definition;
    private final HttpClientBuilder httpBuilder;
    private HttpClientContext preemptiveContext;

    public Nexus(@Nonnull ArtifactRepoParamDefinition definition) {
        this.definition = definition;
        this.httpBuilder = HttpHelper.getBuilder(definition.getCredentialsId(), definition.getProxy(), definition.isIgnoreCertificate());
    }

    @Override
    public Map<String, String> getResults() {
        switch (this.definition.getParamType()) {
            case "path": {
                return this.getArtifactResult();
            }
            case "version": {
                return this.getVersionResult();
            }
            case "repository": 
            case "test": {
                return this.getRepositoryResult();
            }
        }
        log.info(Messages.log_invalidParameter(this.definition.getParamType()));
        return new HashMap<String, String>();
    }

    private Map<String, String> getArtifactResult() {
        HashMap<String, String> result = new HashMap<String, String>();
        HttpResponse response = this.getArtifactsResponse(null);
        if (response.getRc() == 200) {
            result.putAll(this.parseArtifactsPayload(response.getPayload()));
        } else {
            log.warning(Messages.log_failedRequest(response.getRc()));
        }
        return result;
    }

    private Map<String, String> getVersionResult() {
        HashMap<String, String> result = new HashMap<String, String>();
        Pattern versionPattern = Pattern.compile(this.definition.getVersionRegex());
        Map<String, String> artifacts = this.getArtifactResult();
        for (Map.Entry<String, String> entry : artifacts.entrySet()) {
            Optional<String> version = this.extractVersion(entry.getKey(), versionPattern);
            version.ifPresent(v -> result.put((String)entry.getKey(), (String)v));
        }
        return result;
    }

    private Map<String, String> getRepositoryResult() {
        HashMap<String, String> result = new HashMap<String, String>();
        HttpResponse response = this.getRepositoriesResponse();
        if (response.getRc() != 200) {
            log.warning(Messages.log_failedRequest(response.getRc()));
            return result;
        }
        JSONArray root = new JSONArray(response.getPayload());
        for (int i = 0; i < root.length(); ++i) {
            String value;
            JSONObject repo = root.getJSONObject(i);
            if (!this.isValidRepoType(repo.getString("type")) || !this.isValidFormatType(repo.getString("format"))) continue;
            String key = repo.getString("url");
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key, value = repo.getString("name")})) continue;
            result.put(key, value);
        }
        return result;
    }

    private HttpResponse getArtifactsResponse(String continuationToken) {
        String url = this.definition.getServerUrl() + "/service/rest/v1/search?name=" + this.definition.getArtifactName();
        if (StringUtils.isNotBlank((CharSequence)this.definition.getRepoName())) {
            url = url + "&repository=" + this.definition.getRepoName();
        }
        if (StringUtils.isNotBlank((CharSequence)continuationToken)) {
            url = url + "&continuationToken=" + continuationToken;
        }
        return HttpHelper.get(url, this.httpBuilder, this.getPreemptiveAuthContext());
    }

    private HttpResponse getRepositoriesResponse() {
        return HttpHelper.get(this.definition.getServerUrl() + "/service/rest/v1/repositories", this.httpBuilder, this.getPreemptiveAuthContext());
    }

    private Map<String, String> parseArtifactsPayload(@Nonnull String jsonPayload) {
        String token;
        HashMap<String, String> result = new HashMap<String, String>();
        JSONObject root = new JSONObject(jsonPayload);
        Object tokenObj = root.get("continuationToken");
        if (tokenObj instanceof String && StringUtils.isNotBlank((CharSequence)(token = (String)tokenObj))) {
            HttpResponse response = this.getArtifactsResponse(token);
            if (response.getRc() == 200) {
                result.putAll(this.parseArtifactsPayload(response.getPayload()));
            } else {
                log.warning(Messages.log_failedRequest(response.getRc()));
            }
        }
        JSONArray items = root.getJSONArray("items");
        for (int i = 0; i < items.length(); ++i) {
            JSONObject artifact = items.getJSONObject(i);
            JSONArray assets = artifact.getJSONArray("assets");
            for (int j = 0; j < assets.length(); ++j) {
                String value;
                JSONObject asset = assets.getJSONObject(j);
                String key = asset.getString("downloadUrl");
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key, value = StringUtils.substringAfterLast((String)key, (String)"/")}) || StringUtils.endsWithAny((CharSequence)value, (CharSequence[])new CharSequence[]{"md5", "sha1"})) continue;
                result.put(key, value);
            }
        }
        return result;
    }

    private Optional<String> extractVersion(@Nonnull String path, @Nonnull Pattern pattern) {
        Matcher versionMatcher = pattern.matcher(path);
        if (versionMatcher.matches() && versionMatcher.groupCount() >= 1) {
            return Optional.of(versionMatcher.group(1));
        }
        return Optional.empty();
    }

    private HttpClientContext getPreemptiveAuthContext() {
        if (this.preemptiveContext != null) {
            return this.preemptiveContext;
        }
        HttpClientContext context = HttpClientContext.create();
        Optional<StandardUsernamePasswordCredentials> jenkinsCreds = HttpHelper.getCredentials(this.definition.getCredentialsId());
        jenkinsCreds.ifPresent(creds -> {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(creds.getUsername(), creds.getPassword().getPlainText()));
            BasicAuthCache authCache = new BasicAuthCache();
            try {
                authCache.put(HttpHelper.getHttpHostFromUrl(this.definition.getServerUrl()), (AuthScheme)new BasicScheme());
            }
            catch (MalformedURLException e) {
                log.log(Level.SEVERE, Messages.log_invalidUrl(this.definition.getServerUrl()), e);
            }
            context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            context.setAuthCache((AuthCache)authCache);
        });
        this.preemptiveContext = context;
        return context;
    }

    private boolean isValidRepoType(@Nonnull String value) {
        if (this.definition.getRepoType().isLocal() && "hosted".equals(value)) {
            return true;
        }
        if (this.definition.getRepoType().isRemote() && "proxy".equals(value)) {
            return true;
        }
        return this.definition.getRepoType().isVirtual() && "group".equals(value);
    }

    private boolean isValidFormatType(@Nonnull String value) {
        if (this.definition.getFormatType().isMaven() && "maven2".equals(value)) {
            return true;
        }
        if (this.definition.getFormatType().isNpm() && Arrays.asList("npm", "bower").contains(value)) {
            return true;
        }
        if (this.definition.getFormatType().isPypi() && "pypi".equals(value)) {
            return true;
        }
        if (this.definition.getFormatType().isDocker() && "docker".equals(value)) {
            return true;
        }
        return this.definition.getFormatType().isOther() && Stream.of("maven2", "npm", "bower", "pypi", "docker").noneMatch(s -> s.equals(value));
    }
}

