/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.artifactrepo;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import hudson.model.Item;
import hudson.model.ParameterDefinition;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.artifactrepo.ArtifactRepoParamDefinition;
import io.jenkins.plugins.artifactrepo.Messages;
import io.jenkins.plugins.artifactrepo.connectors.Connector;
import io.jenkins.plugins.artifactrepo.model.ArtifactRepoParamProxy;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class ArtifactRepoParamDescriptor
extends ParameterDefinition.ParameterDescriptor {
    private static final int MAX_RESULT = 50;

    @Nonnull
    public String getDisplayName() {
        return "Artifact Repository Parameter";
    }

    public FormValidation doCheckName(@QueryParameter String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return FormValidation.error((String)Messages.formError_missingName());
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckServerUrl(@QueryParameter String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return FormValidation.error((String)Messages.formError_missingServerUrl());
        }
        try {
            new URI(value).toURL();
        }
        catch (Exception e) {
            return FormValidation.error((String)Messages.formError_invalidServerUrl());
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckCredentialsId(@QueryParameter String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return FormValidation.error((String)Messages.formError_missingCreds());
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckIgnoreCertificate(@QueryParameter String value) {
        if (StringUtils.isBlank((CharSequence)value) || !"true".matches(value)) {
            return FormValidation.ok();
        }
        return FormValidation.warning((String)Messages.formError_invalidCertIgnored());
    }

    public FormValidation doCheckProxyPort(@QueryParameter String value, @QueryParameter String proxyHost) {
        if (StringUtils.isBlank((CharSequence)proxyHost)) {
            return FormValidation.ok();
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            return FormValidation.error((String)Messages.formError_missingProxyPort());
        }
        if (!value.matches("\\d+")) {
            return FormValidation.error((String)Messages.formError_invalidProxyPort());
        }
        int port = Integer.parseInt(value);
        if (port < 1 || port > 65535) {
            return FormValidation.error((String)Messages.formError_invalidProxyRange());
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckParamType(@QueryParameter String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return FormValidation.error((String)Messages.formError_missingParamType());
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckArtifactName(@QueryParameter String value, @QueryParameter String serverType) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return FormValidation.error((String)Messages.formError_missingArtifactName());
        }
        if ("*".equals(value) && "artifactory".equals(serverType)) {
            return FormValidation.error((String)Messages.formError_invalidArtifactName());
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckVersionRegex(@QueryParameter String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return FormValidation.error((String)Messages.formError_missingVersionRegex());
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckResultsCount(@QueryParameter String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return FormValidation.error((String)Messages.formError_missingResultsCount());
        }
        if (!value.matches("-?\\d+")) {
            return FormValidation.error((String)Messages.formError_invalidResultsCount());
        }
        int count = Integer.parseInt(value);
        if (count < 1 || count > 50) {
            return FormValidation.error((String)Messages.formError_invalidResultsCountRange(50));
        }
        return FormValidation.ok();
    }

    @POST
    public FormValidation doTestConnection(@QueryParameter String serverType, @QueryParameter String serverUrl, @QueryParameter String credentialsId, @QueryParameter boolean ignoreCertificate, @QueryParameter String proxyProtocol, @QueryParameter String proxyHost, @QueryParameter String proxyPort, @QueryParameter String proxyCredentialsId, @AncestorInPath Item item) {
        item.checkPermission(Item.CONFIGURE);
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{serverType, serverUrl, credentialsId})) {
            return FormValidation.error((String)Messages.formError_invalidParameter());
        }
        ArtifactRepoParamProxy proxy = new ArtifactRepoParamProxy(proxyProtocol, proxyHost, proxyPort, proxyCredentialsId);
        ArtifactRepoParamDefinition dummyDefinition = new ArtifactRepoParamDefinition(serverType, serverUrl, credentialsId, ignoreCertificate, proxy);
        Map<String, String> result = Connector.getInstance(dummyDefinition).getResults();
        if (MapUtils.isNotEmpty(result)) {
            return FormValidation.okWithMarkup((String)("<span style='color:green'>" + Messages.formError_successfulConnection() + "</span>"));
        }
        return FormValidation.error((String)Messages.formError_failedConnection());
    }

    public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
        return this.fillCredentials(item, credentialsId);
    }

    public ListBoxModel doFillProxyCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
        return this.fillCredentials(item, credentialsId);
    }

    private ListBoxModel fillCredentials(Item item, String credentialsId) {
        StandardListBoxModel result = new StandardListBoxModel();
        if (item == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || item != null && (!item.hasPermission(Item.EXTENDED_READ) || !item.hasPermission(CredentialsProvider.USE_ITEM))) {
            return result.includeCurrentValue(credentialsId);
        }
        return result.includeEmptyValue().includeMatchingAs(ACL.SYSTEM, item, StandardUsernameCredentials.class, Collections.emptyList(), CredentialsMatchers.always()).includeCurrentValue(credentialsId);
    }
}

