/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.pluginmanager.impl;

import io.jenkins.tools.pluginmanager.config.LogOutput;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Clock;
import java.time.Duration;
import org.json.JSONObject;
import org.json.JSONTokener;

public class CacheManager {
    private final Path cache;
    private final LogOutput logOutput;
    private final Clock clock;
    private final boolean expires;

    public CacheManager(Path cache, LogOutput logOutput) {
        this(cache, logOutput, Clock.systemDefaultZone(), true);
    }

    CacheManager(Path cache, LogOutput logOutput, Clock clock, boolean expires) {
        this.cache = cache;
        this.logOutput = logOutput;
        this.clock = clock;
        this.expires = expires;
    }

    void createCache() {
        if (!Files.exists(this.cache, new LinkOption[0])) {
            try {
                Path parent = this.cache.getParent();
                if (parent != null && !Files.exists(parent, new LinkOption[0])) {
                    Files.createDirectory(parent, new FileAttribute[0]);
                }
                Files.createDirectory(this.cache, new FileAttribute[0]);
                this.logOutput.printVerboseMessage("Created cache at: " + this.cache);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    void addToCache(String cacheKey, JSONObject value) {
        Path fileToCache = this.cache.resolve(cacheKey + ".json");
        try (BufferedWriter writer = Files.newBufferedWriter(fileToCache, StandardCharsets.UTF_8, new OpenOption[0]);){
            value.write((Writer)writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    JSONObject retrieveFromCache(String cacheKey) {
        String filename = cacheKey + ".json";
        Path cachedPath = this.cache.resolve(filename);
        try {
            FileTime lastModifiedTime = Files.getLastModifiedTime(cachedPath, new LinkOption[0]);
            Duration between = Duration.between(lastModifiedTime.toInstant(), this.clock.instant());
            long betweenHours = between.toHours();
            if (betweenHours > 0L) {
                this.logOutput.printVerboseMessage("Cache entry expired: " + cacheKey + (this.expires ? ". Will skip it" : ". Will accept it, because expiration is disabled"));
                if (this.expires) {
                    return null;
                }
            }
            JSONTokener tokener = new JSONTokener(Files.newInputStream(cachedPath, new OpenOption[0]));
            return new JSONObject(tokener);
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (RuntimeException e) {
            this.logOutput.printVerboseMessage("Cache ignored invalid file " + filename + ".", e);
            return null;
        }
        catch (IOException e) {
            this.logOutput.printVerboseMessage("Cache ignored file " + filename + " because it cannot be read.", e);
            return null;
        }
    }
}

